Rem
Rem $Header: sdo/admin/sdogru.sql /main/19 2009/01/12 07:29:31 zzhang Exp $
Rem
Rem sdogru.sql
Rem
Rem Copyright (c) 2002, 2009, Oracle and/or its affiliates.
Rem All rights reserved. 
Rem
Rem    NAME
Rem      sdogru.sql - GeoRaster Utility Package
Rem
Rem    DESCRIPTION
Rem      GeoRaster trigger functions and maintenance tools
Rem
Rem    NOTES
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    wexu        07/23/08 - bug 7197832 - revoke exec priv during upgrade
Rem    bgouslin    01/07/07 - New version to fix Windoze format issue caused by
Rem                           some ADE bug
Rem    zzhang      04/18/06 - move functions to sdo_geor_admin package
Rem    zzhang      02/03/06 - add new functions
Rem    wexu        05/19/05 - renameRDT changed 
Rem    wexu        07/12/04 - bug 3703288 
Rem    wexu        06/19/03 - remove createDDLTrigger
Rem    wexu        06/18/03 - split createTriggers
Rem    wexu        06/06/03 - add createTriggers
Rem    qxie        06/06/03 - edits
Rem    qxie        11/15/02 - DML and DDL trigger funcs
Rem    qxie        11/15/02 - Created
Rem

Rem ********************************************************************
Rem This package must not be modified by the customer.  Doing so
Rem could cause internal errors.
Rem ********************************************************************

-- bug 7197832: revoke public execute privilege with grant option
-- this is necessary for upgrade cases
BEGIN
  BEGIN
    EXECUTE IMMEDIATE 'REVOKE EXECUTE ON MDSYS.SDO_GEOR_UTL FROM PUBLIC';
    EXCEPTION WHEN OTHERS THEN NULL;
  END;
END;
/

CREATE OR REPLACE PACKAGE MDSYS.SDO_GEOR_UTL AUTHID CURRENT_USER AS

-- ---------------------------------------------------------------------
--      procedure to create DML triggers on a georaster table 
-- ---------------------------------------------------------------------

PROCEDURE createDMLTrigger
(
    tableName      varchar2,
    columnName     varchar2
);

-- ---------------------------------------------------------------------
-- NAME
--   renameRDT
--
-- DESCRIPTION
--   This routine renames raster data table(s) owned by the current user.
--   It will update all related GeoRaster objects and GeoRaster system
--   data coorespondingly.
--
-- ARGUMENTS
--   oldRDTs - name(s) of existing raster data table(s) to be renamed
--   newRDTs - name(s) of new raster data table(s)
--
-- NOTES
--
--   This routine renames RDTs owned by the current user.
--
--   The RDT names in the strings are seperated with ','.
--   If an oldRDT does not appear in the GeoRaster sysdata, it is ignored.
--   If a newRDT is not unique in the GeoRaster sysdata, ORA-13403 is raised. 
--   If a newRDT is NULL, a unique RDT name is automatically generated.
-- ---------------------------------------------------------------------
PROCEDURE renameRDT
(
   oldRDTs VARCHAR2,
   newRDTs VARCHAR2 DEFAULT NULL
);



-- ---------------------------------------------------------------------
-- NAME
--   makeRDTnamesUnique
--
-- DESCRIPTION
--   This routine resolves conflicting raster data table names by 
--   automatically renaming some of them so that all raster data tables 
--   are uniquely named afterwards.
--
-- ARGUMENTS
--   None.
--
-- NOTES
--   This routine is part of the fix for bug 3703288. In addition to applying
--   the necessary patchset that fixes this bug, an Oracle database of
--   version 10.1.0.2 or 10.1.0.3 needs to run this routine to resolve
--   potential RDT name conflicts. User may choose to run the above 
--   renameRDT() to explicitly rename existing RDTs before run this
--   routine.
--
--   This routine should be run while connected as a user with the DBA role.
--
-- ---------------------------------------------------------------------
PROCEDURE makeRDTnamesUnique;


-- ---------------------------------------------------------------------
-- NAME
--   calcRasterNominalSize
--
-- DESCRIPTION
--   This routine calculates the total length of the raster blocks of
--   a GeoRaster object as if it is uncompressed and not sparse.
--
-- ARGUMENTS
--   geor       - the GeoRaster object
--   padding    - indicates whether to consider padding in the blocks
--   pyramid    - indicates whether to consider pyramids
--   bitmapMask - indicates whether to consider associated bitmap masks
--
-- NOTES
--   All the argument are case insensitive. 
--   The result is in bytes.
--    
-- ---------------------------------------------------------------------
FUNCTION calcRasterNominalSize
(
  geor       IN SDO_GEORASTER,
  padding    IN VARCHAR2 DEFAULT 'TRUE',
  pyramid    IN VARCHAR2 DEFAULT 'TRUE',
  bitmapMask IN VARCHAR2 DEFAULT 'TRUE'
)
RETURN NUMBER DETERMINISTIC; 

-- ---------------------------------------------------------------------
-- NAME
--   calcRasterStorageSize
-- DESCRIPTION
--   This routine calculates the actual length of the raster blocks of 
--   a GeoRaster object.
--
-- ARGUMENTS
--   geor - the GeoRaster object
--
-- NOTES
--   The result is in bytes.
--
-- ---------------------------------------------------------------------
FUNCTION calcRasterStorageSize
(
  geor       IN SDO_GEORASTER
)
RETURN NUMBER DETERMINISTIC;

-- ---------------------------------------------------------------------
-- NAME
--   calcOptimizedBlockSize
-- DESCRIPTION
--   This routine calculates the optimized blockSize based on dimensionSize and--   user input seed blockSize. 
--
-- ARGUMENTS
--   dimensionSize - dimension size array, whose length must be 3. 
--   blockSize - block size array, whose length must be 3.
--   pyramidLevel - pyramid level, default value is 0.
--
-- NOTES
--
-- ---------------------------------------------------------------------
PROCEDURE calcOptimizedBlockSize
(
  dimensionSize       IN MDSYS.SDO_NUMBER_ARRAY,
  blockSize           IN OUT MDSYS.SDO_NUMBER_ARRAY,
  pyramidLevel        IN number default 0
);

END SDO_GEOR_UTL;
/
show errors;

