Rem
Rem $Header: sdo/admin/sdonetmemh.sql /main/13 2008/07/23 11:16:07 ningan Exp $
Rem
Rem sdonetmemh.sql
Rem
Rem Copyright (c) 2005, 2008, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      sdonetmemh.sql - sdo_net_mem package header file 
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    ningan      07/16/08 - Bug 7135481 fix: modify add_lrs_link
Rem    ningan	   11/27/07 - Bug 6653556 fix: chnage DO NOT USE to DEPRECATED
Rem    ningan      05/15/07 - Bug 6036757 fix
Rem    ningan      05/14/07 - Bug 6036857 fix
Rem    ningan      05/14/07 - Bug 6036980 fix
Rem    hgong       01/09/07 - deprecate register_constraint and
Rem                           deregister_constraint
Rem    hgong       10/12/06 - mark DO NOT USE for external reference methods
Rem    hgong       07/19/06 - add read_network with MBR 
Rem    ningan      04/11/06 - Add alter type compile for SDO_NETWORK_MANAGER_T
Rem    jcwang      03/30/06 - use alter type for new functions 
Rem    ningan      02/05/06 - Add get_lock_info in SDO_NETWORK_MANAGER_I
Rem    ningan      01/27/06 - Add lock_rows_wm in SDO_NETWORK_MANAGER_*
Rem    ningan      01/26/06 - Add unlock_rows_wm in SDO_NETWORK_MANAGER_*
Rem    ningan      01/26/06 - Add enable_versioning_wm in SDO_NETWORK_MANAGER_*
Rem    ningan      01/25/06 - Add disable_versioning_wm in SDO_NETWORK_MANAGER_*
Rem    ningan      01/25/06 - Add is_versioned_wm in SDO_NETWORK_MANAGER_*
Rem    ningan      05/19/05 - Modified two of add_link interfaces to more 
Rem                           meaningful names as add_lrs_link and 
Rem                           add_sdo_link
Rem    jcwang      05/05/05 - add getDegree function 
Rem    ningan      03/15/05 - following new guidelines, put "create type" SQL
Rem                           inside a PL/SQL block to avoid errors during
Rem                           upgrade
Rem    ningan      02/24/05 - ningan_ndm_class_load0214
Rem    ningan      02/18/05 - Created
Rem                           The following log is inherited from sdonetmem.sql
Rem    ningan      02/15/05 - Change load_constraint to read_constraint to
Rem                           be consistent with Java API;
Rem                           Set default value for constraint parameters of
Rem                           Network Analysis functions to be NULL 
Rem    ningan      02/07/05 - Change load_constraint return value from Boolean
Rem                           to class_name
Rem    ningan      02/02/05 - Add constraint component to network analysis 
Rem                           functions
Rem    ningan      01/14/05 - Change *_dynamic_* functions name to *_temporary_*
Rem    ningan      01/03/04 - Add make_dynamic* member functions to LINK_T and
Rem                           LINK_I
Rem    ningan      12/30/04 - Remove get_parent_id* member functions from
Rem                           PATH_T and PATH_I object types since there is
Rem                           no corresponding function in Java API
Rem    ningan      12/27/04 - Add underscore in the parameter list of 
Rem                           create_logical_network(...), 
Rem                           create_lrs_network(...), create_sdo_network(...) 
Rem    ningan      12/21/04 - Add tsp_path sdo SDO_NETWORK_MANAGER_...
Rem    ningan      12/20/04 - ningan_ndm_plsql_new: merge to the main label
Rem    ningan      12/19/04 - Resolve the NUMBER issue in the 
Rem                           create_..._network_functions
Rem    ningan      12/18/04 - Add create_..._network_... functions to 
Rem                           SDO_NETWORK_...
Rem    ningan      12/17/04 - Resolve the invoker right issue
Rem    ningan      12/16/04 - Add TYPE SDO_NETWORK_T and SDO_NETWORK_I
Rem    ningan      12/15/04 - Add Type SDO_NODE_T and SDO_NODE_I; Type
Rem                           SDO_LINK_T and SDO_LINK_I
Rem    ningan      12/14/04 - Add TYPE SDO_NETWORK_MANAGER_T and 
Rem                           SDO_NETWORK_MANAGER_I
Rem    ningan      12/13/04 - Created
Rem

BEGIN
  EXECUTE IMMEDIATE
'CREATE OR REPLACE TYPE SDO_NETWORK_MANAGER_T 
  AUTHID current_user
AS OBJECT(
  object_id INTEGER,
  
  NOT INSTANTIABLE MEMBER FUNCTION all_paths(
    net_mem         VARCHAR2, 
    start_node_id   NUMBER, 
    goal_node_id    NUMBER, 
    depth_limit     NUMBER,
    cost_limit      NUMBER, 
    no_of_solutions NUMBER,
    constraint      VARCHAR2 := NULL
  ) RETURN SDO_NUMBER_ARRAY DETERMINISTIC,
  
  NOT INSTANTIABLE MEMBER FUNCTION find_connected_components(
    net_mem   VARCHAR2    
  ) RETURN NUMBER DETERMINISTIC,

  NOT INSTANTIABLE MEMBER FUNCTION find_reachable_nodes(
    net_mem          VARCHAR2,
    source_node_id   NUMBER,
    constraint       VARCHAR2 := NULL
  ) RETURN SDO_NUMBER_ARRAY DETERMINISTIC,
 
  NOT INSTANTIABLE MEMBER FUNCTION find_reaching_nodes(
    net_mem VARCHAR2, target_node_id NUMBER, constraint VARCHAR2 := NULL
  ) RETURN SDO_NUMBER_ARRAY DETERMINISTIC,
  
  -- parameter lists
  --   constraint: the name of the Network Constraint.  Set to NULL if no
  --               constraint is desired.
  NOT INSTANTIABLE MEMBER FUNCTION is_reachable(
    net_mem          VARCHAR2,
    source_node_id   NUMBER,
    target_node_id   NUMBER,
    constraint       VARCHAR2 := NULL    
  ) 
  RETURN VARCHAR2 DETERMINISTIC,
  
  NOT INSTANTIABLE MEMBER FUNCTION mcst_link(
    net_mem   VARCHAR2
  ) RETURN SDO_NUMBER_ARRAY DETERMINISTIC,

  
  NOT INSTANTIABLE MEMBER FUNCTION nearest_neighbors(
    net_mem         VARCHAR2, 
    start_node_id   NUMBER, 
    no_of_neighbors NUMBER,
    constraint      VARCHAR2 := NULL
  ) RETURN SDO_NUMBER_ARRAY DETERMINISTIC,
   
  NOT INSTANTIABLE MEMBER FUNCTION shortest_path(
    net_mem       VARCHAR2,
    start_node_id NUMBER, 
    goal_node_id  NUMBER,
    constraint    VARCHAR2 := NULL
  ) RETURN NUMBER DETERMINISTIC,

  NOT INSTANTIABLE MEMBER FUNCTION shortest_path_dijkstra(
    net_mem         VARCHAR2,
    start_node_id   NUMBER, 
    goal_node_id    NUMBER, 
    constraint      VARCHAR2 := NULL
  ) RETURN NUMBER DETERMINISTIC,

  NOT INSTANTIABLE MEMBER FUNCTION tsp_path(
    net_mem          VARCHAR2,
    nd_array         SDO_NUMBER_ARRAY,
    is_closed        VARCHAR2,
    use_exact_cost   VARCHAR2,
    constraint       VARCHAR2 := NULL
  ) RETURN NUMBER DETERMINISTIC,  

  NOT INSTANTIABLE MEMBER FUNCTION within_cost(
    net_mem         VARCHAR2, 
    start_node_id   NUMBER, 
    cost_limit      NUMBER,
    constraint      VARCHAR2 := NULL
  ) RETURN SDO_NUMBER_ARRAY DETERMINISTIC,
  
  NOT INSTANTIABLE MEMBER FUNCTION list_networks RETURN VARCHAR2 DETERMINISTIC,


  NOT INSTANTIABLE MEMBER PROCEDURE create_logical_network(network_name VARCHAR2,
    no_of_hierarchy_levels NUMBER,   is_directed           VARCHAR2, 
    node_table_name VARCHAR2,        node_cost_column      VARCHAR2, 
    link_table_name VARCHAR2,        link_cost_column      VARCHAR2, 
    path_table_name VARCHAR2,        path_link_table_name  VARCHAR2, 
    is_complex VARCHAR2  
  ),

  NOT INSTANTIABLE MEMBER PROCEDURE create_lrs_network(network_name VARCHAR2, 
    no_of_hierarchy_levels NUMBER, is_directed VARCHAR2,  srid NUMBER, 
    no_of_dims NUMBER, node_table_name VARCHAR2, node_cost_column VARCHAR2, 
    link_table_name VARCHAR2, link_cost_column VARCHAR2,  
    lrs_table_name  VARCHAR2, lrs_geom_column VARCHAR2, 
    path_table_name VARCHAR2, path_geom_column VARCHAR2, 
    path_link_table_name VARCHAR2, is_complex VARCHAR2),

  NOT INSTANTIABLE MEMBER PROCEDURE create_sdo_network(network_name VARCHAR2, 
    no_of_hierarchy_levels NUMBER, is_directed VARCHAR2, srid NUMBER,
    no_of_dims NUMBER, node_table_name VARCHAR2, node_geom_column VARCHAR2, 
    node_cost_column VARCHAR2, link_table_name VARCHAR2, 
    link_geom_column VARCHAR2, link_cost_column VARCHAR2, 
    path_table_name VARCHAR2, path_geom_column VARCHAR2, 
    path_link_table_name VARCHAR2, is_complex VARCHAR2),

  NOT INSTANTIABLE MEMBER PROCEDURE read_network(
    net_mem        VARCHAR2,
    allow_updates  VARCHAR2
  ),

  NOT INSTANTIABLE MEMBER PROCEDURE write_network(net_mem VARCHAR2),

  NOT INSTANTIABLE MEMBER PROCEDURE drop_network(net_mem VARCHAR2),

  --- register given network constraint into user_sdo_network_constraints
  --- directory_name must be the name of a valid Oracle directory object
  --- class_name should be given without suffix ".class"
  --- Deprecated. Use SDO_NET.REGISTER_CONSTRAINT instead.
  NOT INSTANTIABLE MEMBER PROCEDURE register_constraint(
    constraint_name VARCHAR2, class_name  VARCHAR2, 
    directory_name VARCHAR2,  description VARCHAR2),

  --- deregister given constraint from user_sdo_network_constraints
  --- Deprecated. Use SDO_NET.DEREGISTER_CONSTRAINT instead.
  NOT INSTANTIABLE MEMBER PROCEDURE deregister_constraint(
    constraint_name  VARCHAR2),

  NOT INSTANTIABLE MEMBER FUNCTION validate_network_schema(network VARCHAR2)
      RETURN VARCHAR2 DETERMINISTIC,
      
  NOT INSTANTIABLE MEMBER PROCEDURE create_ref_constraints(network VARCHAR2),

  NOT INSTANTIABLE MEMBER PROCEDURE enable_ref_constraints(network VARCHAR2),

  NOT INSTANTIABLE MEMBER PROCEDURE disable_ref_constraints(network VARCHAR2)

) NOT INSTANTIABLE NOT FINAL';
EXCEPTION 
  WHEN OTHERS THEN NULL;
END;
/
show errors;

-- revalidate SDO_NETWORK_MANAGER_T 
BEGIN  
  EXECUTE IMMEDIATE 'ALTER TYPE SDO_NETWORK_MANAGER_T COMPILE';
EXCEPTION
  WHEN OTHERS THEN NULL;
END;
/
show errors;


BEGIN
  EXECUTE IMMEDIATE
'CREATE OR REPLACE TYPE SDO_NETWORK_MANAGER_I 
  AUTHID current_user
  UNDER SDO_NETWORK_MANAGER_T 
(
  ------------
  -- all_paths
  ------------
  STATIC FUNCTION all_paths_s(
    net_mem         VARCHAR2, 
    start_node_id   NUMBER, 
    goal_node_id    NUMBER, 
    depth_limit     NUMBER,
    cost_limit      NUMBER, 
    no_of_solutions NUMBER,
    constraint      VARCHAR2
  ) RETURN SDO_NUMBER_ARRAY DETERMINISTIC
    AS LANGUAGE JAVA NAME
    ''oracle.spatial.type.NetworkWrapper.allPaths(
     java.lang.String,  oracle.sql.NUMBER, oracle.sql.NUMBER, 
     oracle.sql.NUMBER, oracle.sql.NUMBER, oracle.sql.NUMBER, java.lang.String) 
     return oracle.spatial.type.SdoNumberArray'',
  
  OVERRIDING MEMBER FUNCTION all_paths(
    net_mem         VARCHAR2, 
    start_node_id   NUMBER, 
    goal_node_id    NUMBER, 
    depth_limit     NUMBER,
    cost_limit      NUMBER, 
    no_of_solutions NUMBER,
    constraint      VARCHAR2 :=NULL
  ) RETURN SDO_NUMBER_ARRAY DETERMINISTIC,
  
  ----------------------------
  -- find_connected_components
  ----------------------------
  STATIC FUNCTION find_connected_components_s(
    net_mem   VARCHAR2    
  ) 
    RETURN NUMBER DETERMINISTIC
    AS LANGUAGE JAVA NAME
    ''oracle.spatial.type.NetworkWrapper.findConnectedComponents(
     java.lang.String) return oracle.sql.NUMBER'',  

  OVERRIDING MEMBER FUNCTION find_connected_components(
    net_mem   VARCHAR2    
  ) 
    RETURN NUMBER DETERMINISTIC,

  -----------------------
  -- find_reachable_nodes
  -----------------------
  STATIC FUNCTION find_reachable_nodes_s(
    net_mem         VARCHAR2,
    source_node_id  NUMBER,
    constraint      VARCHAR2
  ) 
    RETURN SDO_NUMBER_ARRAY DETERMINISTIC
    AS LANGUAGE JAVA NAME
    ''oracle.spatial.type.NetworkWrapper.findReachableNodes(
     java.lang.String, oracle.sql.NUMBER, java.lang.String) 
     return oracle.spatial.type.SdoNumberArray'',

  OVERRIDING MEMBER FUNCTION find_reachable_nodes(
    net_mem   VARCHAR2, source_node_id NUMBER, constraint VARCHAR2 := NULL    
  ) RETURN SDO_NUMBER_ARRAY DETERMINISTIC,
  
  ------------------------
  -- find_reaching_nodes_s
  ------------------------
  STATIC FUNCTION find_reaching_nodes_s(
    net_mem VARCHAR2, target_node_id NUMBER, constraint VARCHAR2
  ) 
    RETURN SDO_NUMBER_ARRAY DETERMINISTIC
    AS LANGUAGE JAVA NAME
    ''oracle.spatial.type.NetworkWrapper.findReachingNodes(
     java.lang.String, oracle.sql.NUMBER, java.lang.String) 
     return oracle.spatial.type.SdoNumberArray'',
     
  OVERRIDING MEMBER FUNCTION find_reaching_nodes(
    net_mem  VARCHAR2,  target_node_id   NUMBER, constraint VARCHAR2 := NULL
  ) RETURN SDO_NUMBER_ARRAY DETERMINISTIC,
  
  ---------------
  -- is_reachable
  ---------------
  STATIC FUNCTION is_reachable_s(
    net_mem          VARCHAR2,
    source_node_id   NUMBER,
    target_node_id   NUMBER,
    constraint       VARCHAR2
  )
    RETURN VARCHAR2 DETERMINISTIC
    AS LANGUAGE JAVA NAME
      ''oracle.spatial.type.NetworkWrapper.isReachable(
     java.lang.String, oracle.sql.NUMBER, oracle.sql.NUMBER, java.lang.String) 
     return java.lang.String'',  

  OVERRIDING MEMBER FUNCTION is_reachable(
    net_mem          VARCHAR2,
    source_node_id   NUMBER,
    target_node_id   NUMBER,
    constraint       VARCHAR2 := NULL
  ) RETURN VARCHAR2 DETERMINISTIC,
  
  -------------------------------------------------------------
  -- mcst_link: Minimal Cost Spanning Tree in the form of links 
  -------------------------------------------------------------
  STATIC FUNCTION mcst_link_s(
    net_mem VARCHAR2
  ) RETURN SDO_NUMBER_ARRAY DETERMINISTIC
    AS LANGUAGE JAVA NAME
    ''oracle.spatial.type.NetworkWrapper.mcstLinkArray(java.lang.String)	
     return oracle.spatial.type.SdoNumberArray'',

  OVERRIDING MEMBER FUNCTION mcst_link(
    net_mem   VARCHAR2
  ) RETURN SDO_NUMBER_ARRAY DETERMINISTIC,
  
  --------------------
  -- nearest_meighbors
  --------------------
  STATIC FUNCTION nearest_neighbors_s(
    net_mem         VARCHAR2, 
    start_node_id   NUMBER, 
    no_of_neighbors NUMBER,
    constraint      VARCHAR2
  ) RETURN SDO_NUMBER_ARRAY DETERMINISTIC
    AS LANGUAGE JAVA NAME
    ''oracle.spatial.type.NetworkWrapper.nearestNeighbors(
     java.lang.String, oracle.sql.NUMBER, oracle.sql.NUMBER, java.lang.String)  
     return oracle.spatial.type.SdoNumberArray'',

  OVERRIDING MEMBER FUNCTION nearest_neighbors(
    net_mem         VARCHAR2, 
    start_node_id   NUMBER, 
    no_of_neighbors NUMBER,
    constraint      VARCHAR2 := NULL
  ) RETURN SDO_NUMBER_ARRAY DETERMINISTIC,

  ----------------
  -- shortest_path
  ----------------
  STATIC FUNCTION shortest_path_s(net_map VARCHAR2,
    start_node_id NUMBER, goal_node_id NUMBER, constraint VARCHAR2
    ) RETURN NUMBER DETERMINISTIC
    AS LANGUAGE JAVA NAME
    ''oracle.spatial.type.NetworkWrapper.shortestPath(
     java.lang.String, oracle.sql.NUMBER, oracle.sql.NUMBER, java.lang.String) 
     return oracle.sql.NUMBER'',
  
  OVERRIDING MEMBER FUNCTION shortest_path(net_mem VARCHAR2,
      start_node_id NUMBER, goal_node_id NUMBER, constraint VARCHAR2 := NULL
    ) RETURN NUMBER DETERMINISTIC,

  -------------------------
  -- shortest_path_dijkstra
  -------------------------
  STATIC FUNCTION shortest_path_dijkstra_s(
    net_mem         VARCHAR2,
    start_node_id   NUMBER, 
    goal_node_id    NUMBER,
    constraint      VARCHAR2
  ) RETURN NUMBER DETERMINISTIC
    AS LANGUAGE JAVA NAME
    ''oracle.spatial.type.NetworkWrapper.shortestPathDijkstra(
     java.lang.String, oracle.sql.NUMBER, oracle.sql.NUMBER, java.lang.String) 
     return oracle.sql.NUMBER'',

  OVERRIDING MEMBER FUNCTION shortest_path_dijkstra(
    net_mem         VARCHAR2,
    start_node_id   NUMBER, 
    goal_node_id    NUMBER,
    constraint      VARCHAR2 := NULL
  ) RETURN NUMBER DETERMINISTIC,  

  STATIC FUNCTION tsp_path_s(
    net_mem     VARCHAR2,  nd_array SDO_NUMBER_ARRAY,
    is_closed   VARCHAR2,  use_exact_cost   VARCHAR2, constraint VARCHAR2
  ) RETURN NUMBER DETERMINISTIC
    AS LANGUAGE JAVA NAME
    ''oracle.spatial.type.NetworkWrapper.tspPath(
     java.lang.String, oracle.spatial.type.SdoNumberArray, java.lang.String,
     java.lang.String, java.lang.String)  return oracle.sql.NUMBER'',

  OVERRIDING MEMBER FUNCTION tsp_path(
    net_mem   VARCHAR2,  nd_array  SDO_NUMBER_ARRAY,
    is_closed VARCHAR2,  use_exact_cost   VARCHAR2, constraint VARCHAR2 := NULL
  ) RETURN NUMBER DETERMINISTIC,     

  --------------
  -- within_cost
  --------------
  STATIC FUNCTION within_cost_s(
    net_mem         VARCHAR2, 
    start_node_id   NUMBER, 
    cost_limit      NUMBER,
    constraint      VARCHAR2    
  ) RETURN SDO_NUMBER_ARRAY DETERMINISTIC
    AS LANGUAGE JAVA NAME
    ''oracle.spatial.type.NetworkWrapper.withinCost(
     java.lang.String, oracle.sql.NUMBER, oracle.sql.NUMBER, java.lang.String) 
     return oracle.spatial.type.SdoNumberArray'',

  OVERRIDING MEMBER FUNCTION within_cost(
    net_mem         VARCHAR2, 
    start_node_id   NUMBER, 
    cost_limit      NUMBER,
    constraint      VARCHAR2 := NULL
  ) RETURN SDO_NUMBER_ARRAY DETERMINISTIC,

  STATIC PROCEDURE create_logical_network_s(network_name VARCHAR2,
    no_of_hierarchy_levels NUMBER,   is_directed           VARCHAR2, 
    node_table_name VARCHAR2,        node_cost_column      VARCHAR2, 
    link_table_name VARCHAR2,        link_cost_column      VARCHAR2, 
    path_table_name VARCHAR2,        path_link_table_name  VARCHAR2, 
    is_complex VARCHAR2  
  )
    AS LANGUAGE JAVA NAME
    ''oracle.spatial.type.NetworkWrapper.createLogicalNetwork(java.lang.String,
     oracle.sql.NUMBER, java.lang.String,
     java.lang.String, java.lang.String, 
     java.lang.String, java.lang.String, 
     java.lang.String, java.lang.String, 
     java.lang.String)'',
  
  OVERRIDING MEMBER PROCEDURE create_logical_network(network_name VARCHAR2,
    no_of_hierarchy_levels NUMBER,   is_directed           VARCHAR2, 
    node_table_name VARCHAR2,        node_cost_column      VARCHAR2, 
    link_table_name VARCHAR2,        link_cost_column      VARCHAR2, 
    path_table_name VARCHAR2,        path_link_table_name  VARCHAR2, 
    is_complex VARCHAR2  
  ),
  
  STATIC PROCEDURE create_lrs_network_s(network_name VARCHAR2, 
    no_of_hierarchy_levels NUMBER, is_directed VARCHAR2,  srid NUMBER, 
    no_of_dims NUMBER, node_table_name VARCHAR2, node_cost_column VARCHAR2, 
    link_table_name VARCHAR2, link_cost_column VARCHAR2,  
    lrs_table_name  VARCHAR2, lrs_geom_column VARCHAR2, 
    path_table_name VARCHAR2, path_geom_column VARCHAR2, 
    path_link_table_name VARCHAR2, is_complex VARCHAR2)
    AS LANGUAGE JAVA NAME  
    ''oracle.spatial.type.NetworkWrapper.createLRSNetwork(java.lang.String,
     oracle.sql.NUMBER, java.lang.String, oracle.sql.NUMBER,
     oracle.sql.NUMBER, java.lang.String, java.lang.String, 
     java.lang.String, java.lang.String, 
     java.lang.String, java.lang.String,
     java.lang.String, java.lang.String, java.lang.String,
     java.lang.String)'',

  OVERRIDING MEMBER PROCEDURE create_lrs_network(network_name VARCHAR2, 
    no_of_hierarchy_levels NUMBER, is_directed VARCHAR2,  srid NUMBER, 
    no_of_dims NUMBER, node_table_name VARCHAR2, node_cost_column VARCHAR2, 
    link_table_name VARCHAR2, link_cost_column VARCHAR2,  
    lrs_table_name  VARCHAR2, lrs_geom_column VARCHAR2, 
    path_table_name VARCHAR2, path_geom_column VARCHAR2, 
    path_link_table_name VARCHAR2, is_complex VARCHAR2),   

  STATIC PROCEDURE create_sdo_network_s(network_name VARCHAR2, 
    no_of_hierarchy_levels NUMBER, is_directed VARCHAR2, srid NUMBER,
    no_of_dims NUMBER, node_table_name VARCHAR2, node_geom_column VARCHAR2, 
    node_cost_column VARCHAR2, link_table_name VARCHAR2, 
    link_geom_column VARCHAR2, link_cost_column VARCHAR2, 
    path_table_name VARCHAR2, path_geom_column VARCHAR2, 
    path_link_table_name VARCHAR2, is_complex VARCHAR2)
    AS LANGUAGE JAVA NAME
    ''oracle.spatial.type.NetworkWrapper.createSDONetwork(java.lang.String,
     oracle.sql.NUMBER, java.lang.String, oracle.sql.NUMBER, oracle.sql.NUMBER,
     java.lang.String, java.lang.String, java.lang.String,
     java.lang.String, java.lang.String, java.lang.String,
     java.lang.String, java.lang.String, java.lang.String,
     java.lang.String)'',

  OVERRIDING MEMBER PROCEDURE create_sdo_network(network_name VARCHAR2, 
    no_of_hierarchy_levels NUMBER, is_directed VARCHAR2, srid NUMBER,
    no_of_dims NUMBER, node_table_name VARCHAR2, node_geom_column VARCHAR2, 
    node_cost_column VARCHAR2, link_table_name VARCHAR2, 
    link_geom_column VARCHAR2, link_cost_column VARCHAR2, 
    path_table_name VARCHAR2, path_geom_column VARCHAR2, 
    path_link_table_name VARCHAR2, is_complex VARCHAR2),
  
  ---------------
  -- read_network
  ---------------
  STATIC PROCEDURE read_network_s(
    net_mem  VARCHAR2, 
    allow_updates VARCHAR2)
    AS LANGUAGE JAVA NAME
    ''oracle.spatial.type.NetworkWrapper.readMap(
     java.lang.String, java.lang.String)'',
  
  OVERRIDING MEMBER PROCEDURE read_network(
    net_mem   VARCHAR2,
    allow_updates  VARCHAR2
  ),
  
  
  ------------
  -- list_networks
  ------------    
  STATIC FUNCTION list_networks_s RETURN VARCHAR2 DETERMINISTIC
   AS LANGUAGE JAVA NAME
   ''oracle.spatial.type.NetworkWrapper.listMaps() 
    return java.lang.String'',
    
  OVERRIDING MEMBER FUNCTION list_networks
   RETURN VARCHAR2 DETERMINISTIC,
  
  STATIC PROCEDURE write_network_s(net_mem VARCHAR2)
    AS LANGUAGE JAVA NAME
    ''oracle.spatial.type.NetworkWrapper.writeMap(java.lang.String)'',

  OVERRIDING MEMBER PROCEDURE write_network(net_mem VARCHAR2),


  STATIC PROCEDURE drop_network_s(net_mem VARCHAR2)
    AS LANGUAGE JAVA NAME
    ''oracle.spatial.type.NetworkWrapper.dropMap(java.lang.String)'',

  OVERRIDING MEMBER PROCEDURE drop_network(
    net_mem VARCHAR2),

  STATIC FUNCTION validate_network_schema_s(network VARCHAR2)
    RETURN VARCHAR2 DETERMINISTIC AS LANGUAGE JAVA NAME
    ''oracle.spatial.type.NetworkWrapper.validateNetworkSchema(
     java.lang.String)
    return java.lang.String'',

  OVERRIDING MEMBER FUNCTION validate_network_schema(network VARCHAR2)
    RETURN VARCHAR2 DETERMINISTIC,

  STATIC PROCEDURE create_ref_constraints_s(network VARCHAR2)
    AS LANGUAGE JAVA NAME
    ''oracle.spatial.type.NetworkWrapper.createRefConstraints(
     java.lang.String)'',

  OVERRIDING MEMBER PROCEDURE create_ref_constraints(network VARCHAR2),


  STATIC PROCEDURE enable_ref_constraints_s(network VARCHAR2)
    AS LANGUAGE JAVA NAME
    ''oracle.spatial.type.NetworkWrapper.enableRefConstraints(java.lang.String)'',

  OVERRIDING MEMBER PROCEDURE enable_ref_constraints(network VARCHAR2),


  STATIC PROCEDURE disable_ref_constraints_s(network VARCHAR2)
    AS LANGUAGE JAVA NAME
    ''oracle.spatial.type.NetworkWrapper.disableRefConstraints(
     java.lang.String)'',

  OVERRIDING MEMBER PROCEDURE disable_ref_constraints(network VARCHAR2),
  
  --- register given network constraint into user_sdo_network_constraints
  OVERRIDING MEMBER PROCEDURE register_constraint(
    constraint_name VARCHAR2, class_name VARCHAR2, 
    directory_name VARCHAR2,  description VARCHAR2),
  
  --- deregister given constraint from user_sdo_network_constraints
  OVERRIDING MEMBER PROCEDURE deregister_constraint(constraint_name VARCHAR2),
  
  MEMBER FUNCTION read_constraint(constraint_name VARCHAR2)
    RETURN VARCHAR2 DETERMINISTIC

)';
EXCEPTION 
  WHEN OTHERS THEN NULL;
END;
/
show errors;


-----------------------------
--- workspace manager support
-----------------------------

BEGIN


--
-- need to alter the dependent type or compilation errors will occur
--

  EXECUTE IMMEDIATE
  ' ALTER TYPE SDO_NETWORK_MANAGER_I NOT INSTANTIABLE NOT FINAL CASCADE';
  
  -- Workspace Manager Support
  EXECUTE IMMEDIATE
  'ALTER  TYPE SDO_NETWORK_MANAGER_T ADD
   NOT INSTANTIABLE MEMBER FUNCTION is_versioned_wm(net_mem IN VARCHAR2) 
      RETURN BOOLEAN DETERMINISTIC CASCADE';

  EXECUTE IMMEDIATE
  'ALTER  TYPE SDO_NETWORK_MANAGER_T ADD
   NOT INSTANTIABLE MEMBER PROCEDURE enable_versioning_wm(net_mem IN VARCHAR2) CASCADE';

  EXECUTE IMMEDIATE
  'ALTER  TYPE SDO_NETWORK_MANAGER_T ADD
   NOT INSTANTIABLE MEMBER PROCEDURE disable_versioning_wm(net_mem IN VARCHAR2) CASCADE' ;

  EXECUTE IMMEDIATE
  'ALTER  TYPE SDO_NETWORK_MANAGER_T ADD
   NOT INSTANTIABLE MEMBER FUNCTION lock_rows_wm(net_mem IN VARCHAR2, 
    wspace_name IN VARCHAR2, sql_node_filter IN VARCHAR2 DEFAULT NULL, 
    sql_link_filter IN VARCHAR2 DEFAULT NULL, 
    sql_path_filter IN VARCHAR2 DEFAULT NULL)
    RETURN NUMBER DETERMINISTIC CASCADE';

  EXECUTE IMMEDIATE
  'ALTER  TYPE SDO_NETWORK_MANAGER_T ADD
   NOT INSTANTIABLE MEMBER PROCEDURE unlock_rows_wm(net_mem IN VARCHAR2, 
    wspace_name IN VARCHAR2, lock_id IN NUMBER) CASCADE';

EXCEPTION 
  WHEN OTHERS THEN NULL;
END;
/
show errors;

BEGIN
EXECUTE IMMEDIATE
 ' ALTER  TYPE SDO_NETWORK_MANAGER_I ADD ' || 
 ' STATIC PROCEDURE get_net_tab_names(net_mem IN VARCHAR2,
    link_tab_name OUT VARCHAR2, node_tab_name OUT VARCHAR2,
    path_tab_name OUT VARCHAR2, plink_tab_name OUT VARCHAR2) CASCADE';

EXECUTE IMMEDIATE
 ' ALTER  TYPE SDO_NETWORK_MANAGER_I ADD ' || 
 ' STATIC FUNCTION is_versioned_tab(tab_name IN VARCHAR2)
    RETURN BOOLEAN CASCADE';

EXECUTE IMMEDIATE
 ' ALTER  TYPE SDO_NETWORK_MANAGER_I ADD ' ||
 ' STATIC FUNCTION is_versioned_s(net_mem IN VARCHAR2)
    RETURN BOOLEAN DETERMINISTIC CASCADE';

EXECUTE IMMEDIATE
 ' ALTER  TYPE SDO_NETWORK_MANAGER_I ADD ' ||
 ' STATIC FUNCTION adjust_node_filter(tab_name IN VARCHAR2,
    sql_node_filter IN VARCHAR2, lock_id IN NUMBER)
  RETURN VARCHAR2 CASCADE';

EXECUTE IMMEDIATE
 ' ALTER  TYPE SDO_NETWORK_MANAGER_I ADD ' ||
 ' STATIC FUNCTION adjust_link_filter(tab_name IN VARCHAR2,
    node_filter IN VARCHAR2, sql_link_filter IN VARCHAR2, lock_id IN NUMBER)
  RETURN VARCHAR2 CASCADE';

EXECUTE IMMEDIATE
 ' ALTER  TYPE SDO_NETWORK_MANAGER_I ADD ' ||
 ' STATIC FUNCTION adjust_path_filter(path_tab IN VARCHAR2, 
    plink_tab IN VARCHAR2, link_filter IN VARCHAR2, 
    sql_path_filter IN VARCHAR2, lock_id IN NUMBER)
  RETURN VARCHAR2 CASCADE';

EXECUTE IMMEDIATE
 ' ALTER  TYPE SDO_NETWORK_MANAGER_I ADD ' ||
 ' STATIC PROCEDURE register_lock(lock_id IN NUMBER, net_mem IN VARCHAR2,
    wspace_name IN VARCHAR2, original_node_filter IN VARCHAR2,
    original_link_filter IN VARCHAR2, original_path_filter IN VARCHAR2,
    adjusted_node_filter IN VARCHAR2, adjusted_link_filter IN VARCHAR2,
    adjusted_path_filter IN VARCHAR2) CASCADE';

EXECUTE IMMEDIATE
 ' ALTER  TYPE SDO_NETWORK_MANAGER_I ADD ' ||
 ' STATIC PROCEDURE deregister_lock(lock_id IN NUMBER) CASCADE';

EXECUTE IMMEDIATE
 ' ALTER  TYPE SDO_NETWORK_MANAGER_I ADD ' ||
 ' STATIC FUNCTION get_lock_id
    RETURN NUMBER CASCADE';

EXECUTE IMMEDIATE
 ' ALTER  TYPE SDO_NETWORK_MANAGER_I ADD ' ||
 ' STATIC PROCEDURE get_lock_info(lock_id IN NUMBER,
    net_mem OUT VARCHAR2, wspace_name OUT VARCHAR2, 
    original_node_filter OUT VARCHAR2,
    original_link_filter OUT VARCHAR2, original_path_filter OUT VARCHAR2,
    adjusted_node_filter OUT VARCHAR2, adjusted_link_filter OUT VARCHAR2,
    adjusted_path_filter OUT VARCHAR2) CASCADE';

EXECUTE IMMEDIATE
 ' ALTER  TYPE SDO_NETWORK_MANAGER_I ADD ' ||
 ' OVERRIDING  MEMBER FUNCTION is_versioned_wm(net_mem IN VARCHAR2) 
      RETURN BOOLEAN DETERMINISTIC CASCADE';

EXECUTE IMMEDIATE
 ' ALTER  TYPE SDO_NETWORK_MANAGER_I ADD ' ||
 ' OVERRIDING  MEMBER PROCEDURE enable_versioning_wm(net_mem IN VARCHAR2) CASCADE';

EXECUTE IMMEDIATE
 ' ALTER  TYPE SDO_NETWORK_MANAGER_I ADD ' ||
 ' OVERRIDING  MEMBER PROCEDURE disable_versioning_wm(net_mem IN VARCHAR2) CASCADE';

EXECUTE IMMEDIATE
 ' ALTER  TYPE SDO_NETWORK_MANAGER_I ADD ' ||
 ' OVERRIDING  MEMBER FUNCTION lock_rows_wm(net_mem IN VARCHAR2, 
    wspace_name IN VARCHAR2, sql_node_filter IN VARCHAR2 DEFAULT NULL, 
    sql_link_filter IN VARCHAR2 DEFAULT NULL, 
    sql_path_filter IN VARCHAR2 DEFAULT NULL)
    RETURN NUMBER DETERMINISTIC CASCADE';

EXECUTE IMMEDIATE
 ' ALTER  TYPE SDO_NETWORK_MANAGER_I ADD ' ||
 ' OVERRIDING  MEMBER PROCEDURE unlock_rows_wm(net_mem IN VARCHAR2, 
    wspace_name IN VARCHAR2, lock_id IN NUMBER) CASCADE';

--
-- need to make it instantiable for sdo_net_mem to instantiate it
--

EXECUTE IMMEDIATE
  ' ALTER TYPE SDO_NETWORK_MANAGER_I INSTANTIABLE  CASCADE';

EXCEPTION 
  WHEN OTHERS THEN NULL;
END;
/
show errors;


-- add one more signature for read_network
BEGIN

  -- need to alter the dependent type or compilation errors will occur    
  EXECUTE IMMEDIATE
    ' ALTER TYPE SDO_NETWORK_MANAGER_I NOT INSTANTIABLE NOT FINAL CASCADE';

  EXECUTE IMMEDIATE
    'ALTER  TYPE SDO_NETWORK_MANAGER_T ADD
       NOT INSTANTIABLE MEMBER PROCEDURE read_network(
         net_mem        VARCHAR2,
         network         VARCHAR2,
         xmin           NUMBER,
         ymin           NUMBER,
         xmax           NUMBER,
         ymax           NUMBER,
         allow_updates  VARCHAR2) CASCADE';   

  EXECUTE IMMEDIATE
    ' ALTER  TYPE SDO_NETWORK_MANAGER_I ADD ' || 
    ' OVERRIDING MEMBER PROCEDURE read_network(
        net_mem         VARCHAR2,
        network         VARCHAR2,
        xmin            NUMBER, 
        ymin            NUMBER,
        xmax            NUMBER,
        ymax            NUMBER,
        allow_updates   VARCHAR2) CASCADE';

  EXECUTE IMMEDIATE
    ' ALTER  TYPE SDO_NETWORK_MANAGER_I ADD ' || 
    ' STATIC PROCEDURE read_network_s(
        net_mem         VARCHAR2,
        network         VARCHAR2,
        xmin            NUMBER, 
        ymin            NUMBER,
        xmax            NUMBER,
        ymax            NUMBER,
        allow_updates   VARCHAR2)
      AS LANGUAGE JAVA NAME
      ''oracle.spatial.type.NetworkWrapper.readMap(
       java.lang.String, java.lang.String, oracle.sql.NUMBER, oracle.sql.NUMBER, 
      oracle.sql.NUMBER, oracle.sql.NUMBER, java.lang.String)'' CASCADE';
  
  -- need to make it instantiable for sdo_net_mem to instantiate it
  EXECUTE IMMEDIATE
    ' ALTER TYPE SDO_NETWORK_MANAGER_I INSTANTIABLE  CASCADE';


EXCEPTION 
  WHEN OTHERS THEN NULL;
END;
/
show errors;  

GRANT EXECUTE ON sdo_network_manager_t TO PUBLIC;
CREATE OR REPLACE PUBLIC SYNONYM sdo_network_manager_t 
  FOR mdsys.sdo_network_manager_t;

BEGIN
  EXECUTE IMMEDIATE
'
CREATE OR REPLACE TYPE SDO_NODE_T
  AUTHID current_user
  AS OBJECT(
  object_id INTEGER,  
  
  NOT INSTANTIABLE MEMBER FUNCTION get_cost(
    net_mem   VARCHAR2, node_id   NUMBER
  ) RETURN NUMBER DETERMINISTIC,

  NOT INSTANTIABLE MEMBER FUNCTION get_hierarchy_level(
   net_mem   VARCHAR2, node_id   NUMBER
  ) RETURN NUMBER DETERMINISTIC,
  
  NOT INSTANTIABLE MEMBER FUNCTION get_state(
   net_mem   VARCHAR2, node_id   NUMBER
  ) RETURN VARCHAR2 DETERMINISTIC,
  
  NOT INSTANTIABLE MEMBER FUNCTION get_type(
   net_mem   VARCHAR2, node_id   NUMBER
  ) RETURN VARCHAR2 DETERMINISTIC,
  
  NOT INSTANTIABLE MEMBER FUNCTION get_name(
    net_mem VARCHAR2, node_id NUMBER)
    RETURN VARCHAR2 DETERMINISTIC,

  NOT INSTANTIABLE MEMBER FUNCTION get_partition_id(
    net_mem VARCHAR2, node_id NUMBER)
    RETURN NUMBER DETERMINISTIC,

  NOT INSTANTIABLE MEMBER FUNCTION get_component_no(
    net_mem VARCHAR2, node_id NUMBER)
    RETURN NUMBER DETERMINISTIC,

  NOT INSTANTIABLE MEMBER FUNCTION get_in_link_ids(
    net_mem VARCHAR2, node_id NUMBER)
    RETURN SDO_NUMBER_ARRAY DETERMINISTIC,

  NOT INSTANTIABLE MEMBER FUNCTION get_out_link_ids(
    net_mem VARCHAR2, node_id NUMBER)
    RETURN SDO_NUMBER_ARRAY DETERMINISTIC,

  NOT INSTANTIABLE MEMBER FUNCTION get_incident_link_ids(
    net_mem VARCHAR2, node_id NUMBER)
    RETURN SDO_NUMBER_ARRAY DETERMINISTIC,

  NOT INSTANTIABLE MEMBER FUNCTION get_child_node_ids(
    net_mem VARCHAR2, node_id NUMBER)
    RETURN SDO_NUMBER_ARRAY DETERMINISTIC,

  NOT INSTANTIABLE MEMBER FUNCTION get_adjacent_node_ids(
    net_mem VARCHAR2, node_id NUMBER)
    RETURN SDO_NUMBER_ARRAY DETERMINISTIC,

  NOT INSTANTIABLE MEMBER FUNCTION get_sibling_node_ids(
    net_mem VARCHAR2, id NUMBER)
    RETURN SDO_NUMBER_ARRAY DETERMINISTIC,

  NOT INSTANTIABLE MEMBER FUNCTION get_geometry(
    net_mem VARCHAR2, node_id NUMBER)
    RETURN SDO_GEOMETRY DETERMINISTIC,

  NOT INSTANTIABLE MEMBER FUNCTION get_geom_id(
    net_mem VARCHAR2, node_id NUMBER)
    RETURN NUMBER DETERMINISTIC,

  ----------------
  -- DEPRECATED --
  ----------------
  NOT INSTANTIABLE MEMBER FUNCTION get_external_node_id(
    net_mem VARCHAR2, id NUMBER)
    RETURN NUMBER DETERMINISTIC,

  ----------------
  -- DEPRECATED --
  ----------------
  NOT INSTANTIABLE MEMBER FUNCTION get_external_network_id(
    net_mem VARCHAR2, node_id NUMBER)
    RETURN NUMBER DETERMINISTIC,

  ----------------
  -- DEPRECATED --
  ----------------
  NOT INSTANTIABLE MEMBER FUNCTION get_external_network_name(
    net_mem VARCHAR2, node_id NUMBER)
    RETURN VARCHAR2 DETERMINISTIC,

  NOT INSTANTIABLE MEMBER FUNCTION get_parent_node_id(
    net_mem VARCHAR2, node_id NUMBER)
    RETURN NUMBER DETERMINISTIC,

  NOT INSTANTIABLE MEMBER FUNCTION get_measure(
    net_mem VARCHAR2, node_id NUMBER)
    RETURN NUMBER DETERMINISTIC,

  NOT INSTANTIABLE MEMBER PROCEDURE set_cost(
    net_mem VARCHAR2, node_id NUMBER, cost NUMBER),

  NOT INSTANTIABLE MEMBER PROCEDURE set_hierarchy_level(
    net_mem VARCHAR2, node_id NUMBER,    level NUMBER),

  NOT INSTANTIABLE MEMBER PROCEDURE set_type(
    net_mem VARCHAR2, node_id NUMBER, type VARCHAR2),

  NOT INSTANTIABLE MEMBER PROCEDURE set_name(
    net_mem VARCHAR2, node_id NUMBER, node_name VARCHAR2),

  NOT INSTANTIABLE MEMBER PROCEDURE set_state(
    net_mem VARCHAR2, node_id NUMBER, state VARCHAR2),

  NOT INSTANTIABLE MEMBER PROCEDURE set_component_no(
    net_mem VARCHAR2, node_id NUMBER,    no NUMBER),

  NOT INSTANTIABLE MEMBER PROCEDURE set_parent_node(
    net_mem VARCHAR2, node_id NUMBER,    parent_node_id NUMBER),

  ----------------
  -- DEPRECATED --
  ----------------
  NOT INSTANTIABLE MEMBER PROCEDURE set_external_node_id(
    net_mem VARCHAR2, node_id NUMBER,    external_node_id NUMBER),

  ----------------
  -- DEPRECATED --
  ----------------
  NOT INSTANTIABLE MEMBER PROCEDURE set_external_network_id(
    net_mem VARCHAR2, node_id NUMBER,    external_network_id NUMBER),

  NOT INSTANTIABLE MEMBER PROCEDURE set_geometry(
    net_mem VARCHAR2, node_id NUMBER,    geom SDO_GEOMETRY),

  NOT INSTANTIABLE MEMBER PROCEDURE set_geom_id(
    net_mem VARCHAR2, node_id NUMBER,    geom_id NUMBER),

  NOT INSTANTIABLE MEMBER PROCEDURE set_measure(
    net_mem VARCHAR2, node_id NUMBER,    measure NUMBER),

  NOT INSTANTIABLE MEMBER PROCEDURE make_temporary(
    net_mem VARCHAR2, node_id NUMBER),

  NOT INSTANTIABLE MEMBER FUNCTION is_temporary(
    net_mem VARCHAR2, node_id NUMBER)
    RETURN VARCHAR2 DETERMINISTIC,

  NOT INSTANTIABLE MEMBER FUNCTION is_active(
    net_mem VARCHAR2, node_id NUMBER)
    RETURN VARCHAR2 DETERMINISTIC,

  NOT INSTANTIABLE MEMBER FUNCTION is_logical(
    net_mem VARCHAR2, node_id NUMBER)
    RETURN VARCHAR2 DETERMINISTIC,

  NOT INSTANTIABLE MEMBER FUNCTION link_exists(
    net_mem VARCHAR2, node_id1 NUMBER, node_id2 NUMBER)
    RETURN VARCHAR2 DETERMINISTIC,

  ----------------
  -- DEPRECATED --
  ----------------
  NOT INSTANTIABLE MEMBER FUNCTION is_external_node(
    net_mem VARCHAR2, node_id NUMBER)
    RETURN VARCHAR2 DETERMINISTIC,

  NOT INSTANTIABLE MEMBER FUNCTION get_in_degree(
    net_mem VARCHAR2, node_id NUMBER)
    RETURN NUMBER DETERMINISTIC,

  NOT INSTANTIABLE MEMBER FUNCTION get_out_degree(
    net_mem VARCHAR2, node_id NUMBER)
    RETURN NUMBER DETERMINISTIC,

  NOT INSTANTIABLE MEMBER FUNCTION get_degree(
    net_mem VARCHAR2, node_id NUMBER)
    RETURN NUMBER DETERMINISTIC


) NOT INSTANTIABLE NOT FINAL';

EXCEPTION 
  WHEN OTHERS THEN NULL;
END;
/
show errors;


BEGIN
  EXECUTE IMMEDIATE 
'CREATE OR REPLACE TYPE SDO_NODE_I 
  AUTHID current_user
  UNDER SDO_NODE_T
(
 STATIC FUNCTION get_cost_s(net_mem VARCHAR2, node_id NUMBER)
   RETURN NUMBER DETERMINISTIC AS LANGUAGE JAVA NAME
   ''oracle.spatial.type.NetworkWrapper.getNodeCost(
    java.lang.String, oracle.sql.NUMBER) return oracle.sql.NUMBER'',

 OVERRIDING MEMBER FUNCTION get_cost(
    net_mem   VARCHAR2,
    node_id   NUMBER
 )  RETURN NUMBER DETERMINISTIC,
 
 STATIC FUNCTION get_hierarchy_level_s(net_mem VARCHAR2, node_id NUMBER)
   RETURN NUMBER DETERMINISTIC AS LANGUAGE JAVA NAME
   ''oracle.spatial.type.NetworkWrapper.getNodeHierarchyLevel(
    java.lang.String, oracle.sql.NUMBER) return oracle.sql.NUMBER'',

 OVERRIDING MEMBER FUNCTION get_hierarchy_level(
   net_mem   VARCHAR2,
   node_id   NUMBER
 ) RETURN NUMBER DETERMINISTIC,

 STATIC FUNCTION get_state_s(net_mem VARCHAR2, node_id NUMBER)
   RETURN VARCHAR2 DETERMINISTIC AS LANGUAGE JAVA NAME
   ''oracle.spatial.type.NetworkWrapper.getNodeState(
    java.lang.String, oracle.sql.NUMBER) return java.lang.String'',

 OVERRIDING MEMBER FUNCTION get_state(net_mem VARCHAR2, node_id NUMBER)
   RETURN VARCHAR2 DETERMINISTIC,  

 STATIC FUNCTION get_type_s(net_mem VARCHAR2, node_id NUMBER)
   RETURN VARCHAR2 DETERMINISTIC AS LANGUAGE JAVA NAME
   ''oracle.spatial.type.NetworkWrapper.getNodeType(
    java.lang.String, oracle.sql.NUMBER) return java.lang.String'',

 OVERRIDING MEMBER FUNCTION get_type(net_mem VARCHAR2, node_id NUMBER)
   RETURN VARCHAR2 DETERMINISTIC,

  STATIC FUNCTION get_name_s(net_mem VARCHAR2, node_id NUMBER)
   RETURN VARCHAR2 DETERMINISTIC AS LANGUAGE JAVA NAME
   ''oracle.spatial.type.NetworkWrapper.getNodeName(
    java.lang.String, oracle.sql.NUMBER)
    return java.lang.String'',

  OVERRIDING MEMBER FUNCTION get_name(
    net_mem VARCHAR2, node_id NUMBER)
    RETURN VARCHAR2 DETERMINISTIC,


  STATIC FUNCTION get_partition_id_s(net_mem VARCHAR2, node_id NUMBER)
   RETURN NUMBER DETERMINISTIC AS LANGUAGE JAVA NAME
   ''oracle.spatial.type.NetworkWrapper.getNodePartitionId(
    java.lang.String, oracle.sql.NUMBER)
    return oracle.sql.NUMBER'',

  OVERRIDING MEMBER FUNCTION get_partition_id(
    net_mem VARCHAR2, node_id NUMBER)
    RETURN NUMBER DETERMINISTIC,


  STATIC FUNCTION get_component_no_s(net_mem VARCHAR2, node_id NUMBER)
   RETURN NUMBER DETERMINISTIC AS LANGUAGE JAVA NAME
   ''oracle.spatial.type.NetworkWrapper.getNodeComponentNo(
    java.lang.String, oracle.sql.NUMBER)
    return oracle.sql.NUMBER'',

  OVERRIDING MEMBER FUNCTION get_component_no(
    net_mem VARCHAR2, node_id NUMBER)
    RETURN NUMBER DETERMINISTIC,


  STATIC FUNCTION get_in_link_ids_s(net_mem VARCHAR2, node_id NUMBER)
   RETURN SDO_NUMBER_ARRAY DETERMINISTIC AS LANGUAGE JAVA NAME
   ''oracle.spatial.type.NetworkWrapper.getNodeInLinkIds(
    java.lang.String, oracle.sql.NUMBER)
        return oracle.spatial.type.SdoNumberArray'',

  OVERRIDING MEMBER FUNCTION get_in_link_ids(
    net_mem VARCHAR2, node_id NUMBER)
    RETURN SDO_NUMBER_ARRAY DETERMINISTIC,


  STATIC FUNCTION get_out_link_ids_s(net_mem VARCHAR2, node_id NUMBER)
   RETURN SDO_NUMBER_ARRAY DETERMINISTIC AS LANGUAGE JAVA NAME
   ''oracle.spatial.type.NetworkWrapper.getNodeOutLinkIds(
    java.lang.String, oracle.sql.NUMBER)
        return oracle.spatial.type.SdoNumberArray'',

  OVERRIDING MEMBER FUNCTION get_out_link_ids(
    net_mem VARCHAR2, node_id NUMBER)
    RETURN SDO_NUMBER_ARRAY DETERMINISTIC,


  STATIC FUNCTION get_incident_link_ids_s(net_mem VARCHAR2, node_id NUMBER)
   RETURN SDO_NUMBER_ARRAY DETERMINISTIC AS LANGUAGE JAVA NAME
   ''oracle.spatial.type.NetworkWrapper.getNodeIncidentLinkIds(
    java.lang.String, oracle.sql.NUMBER)
        return oracle.spatial.type.SdoNumberArray'',

  OVERRIDING MEMBER FUNCTION get_incident_link_ids(
    net_mem VARCHAR2, node_id NUMBER)
    RETURN SDO_NUMBER_ARRAY DETERMINISTIC,


  STATIC FUNCTION get_child_node_ids_s(net_mem VARCHAR2, node_id NUMBER)
   RETURN SDO_NUMBER_ARRAY DETERMINISTIC AS LANGUAGE JAVA NAME
   ''oracle.spatial.type.NetworkWrapper.getNodeChildNodeIds(
    java.lang.String, oracle.sql.NUMBER)
        return oracle.spatial.type.SdoNumberArray'',

  OVERRIDING MEMBER FUNCTION get_child_node_ids(
    net_mem VARCHAR2, node_id NUMBER)
    RETURN SDO_NUMBER_ARRAY DETERMINISTIC,


  STATIC FUNCTION get_adjacent_node_ids_s(net_mem VARCHAR2, node_id NUMBER)
   RETURN SDO_NUMBER_ARRAY DETERMINISTIC AS LANGUAGE JAVA NAME
   ''oracle.spatial.type.NetworkWrapper.getNodeAdjacentNodeIds(
    java.lang.String, oracle.sql.NUMBER)
        return oracle.spatial.type.SdoNumberArray'',

  OVERRIDING MEMBER FUNCTION get_adjacent_node_ids(
    net_mem VARCHAR2, node_id NUMBER)
    RETURN SDO_NUMBER_ARRAY DETERMINISTIC,


  STATIC FUNCTION get_sibling_node_ids_s(net_mem VARCHAR2, id NUMBER)
   RETURN SDO_NUMBER_ARRAY DETERMINISTIC AS LANGUAGE JAVA NAME
   ''oracle.spatial.type.NetworkWrapper.getNodeSiblingNodeIds(
    java.lang.String, oracle.sql.NUMBER)
        return oracle.spatial.type.SdoNumberArray'',

  OVERRIDING MEMBER FUNCTION get_sibling_node_ids(
    net_mem VARCHAR2, id NUMBER)
    RETURN SDO_NUMBER_ARRAY DETERMINISTIC,

  STATIC FUNCTION get_geometry_s(net_mem VARCHAR2, node_id NUMBER)
   RETURN SDO_GEOMETRY DETERMINISTIC AS LANGUAGE JAVA NAME
   ''oracle.spatial.type.NetworkWrapper.getNodeGeometry(
    java.lang.String, oracle.sql.NUMBER)
    return     oracle.spatial.type.SdoGeometry'',

  OVERRIDING MEMBER FUNCTION get_geometry(
    net_mem VARCHAR2, node_id NUMBER)
    RETURN SDO_GEOMETRY DETERMINISTIC,


  STATIC FUNCTION get_geom_id_s(net_mem VARCHAR2, node_id NUMBER)
   RETURN NUMBER DETERMINISTIC AS LANGUAGE JAVA NAME
   ''oracle.spatial.type.NetworkWrapper.getNodeGeomId(
    java.lang.String, oracle.sql.NUMBER)
    return oracle.sql.NUMBER'',

  OVERRIDING MEMBER FUNCTION get_geom_id(
    net_mem VARCHAR2, node_id NUMBER)
    RETURN NUMBER DETERMINISTIC,

  ----------------
  -- DEPRECATED --
  ----------------
  STATIC FUNCTION get_external_node_id_s(net_mem VARCHAR2, id NUMBER)
   RETURN NUMBER DETERMINISTIC AS LANGUAGE JAVA NAME
   ''oracle.spatial.type.NetworkWrapper.getNodeExternalNodeId(
    java.lang.String, oracle.sql.NUMBER)
    return oracle.sql.NUMBER'',

  ----------------
  -- DEPRECATED --
  ----------------
  OVERRIDING MEMBER FUNCTION get_external_node_id(
    net_mem VARCHAR2, id NUMBER)
    RETURN NUMBER DETERMINISTIC,

  ----------------
  -- DEPRECATED --
  ----------------
  STATIC FUNCTION get_external_network_id_s(net_mem VARCHAR2, node_id NUMBER)
   RETURN NUMBER DETERMINISTIC AS LANGUAGE JAVA NAME
   ''oracle.spatial.type.NetworkWrapper.getNodeExternalNetworkId(
    java.lang.String, oracle.sql.NUMBER)
    return oracle.sql.NUMBER'',

  ----------------
  -- DEPRECATED --
  ----------------
  OVERRIDING MEMBER FUNCTION get_external_network_id(
    net_mem VARCHAR2, node_id NUMBER)
    RETURN NUMBER DETERMINISTIC,

  ----------------
  -- DEPRECATED --
  ----------------
  STATIC FUNCTION get_external_network_name_s(net_mem VARCHAR2, node_id NUMBER)
   RETURN VARCHAR2 DETERMINISTIC AS LANGUAGE JAVA NAME
   ''oracle.spatial.type.NetworkWrapper.getNodeExternalNetworkName(
    java.lang.String, oracle.sql.NUMBER)
    return java.lang.String'',

  ----------------
  -- DEPRECATED --
  ----------------
  OVERRIDING MEMBER FUNCTION get_external_network_name(
    net_mem VARCHAR2, node_id NUMBER)
    RETURN VARCHAR2 DETERMINISTIC,


  STATIC FUNCTION get_parent_node_id_s(net_mem VARCHAR2, node_id NUMBER)
   RETURN NUMBER DETERMINISTIC AS LANGUAGE JAVA NAME
   ''oracle.spatial.type.NetworkWrapper.getNodeParentNodeId(
    java.lang.String, oracle.sql.NUMBER)
    return oracle.sql.NUMBER'',

  OVERRIDING MEMBER FUNCTION get_parent_node_id(
    net_mem VARCHAR2, node_id NUMBER)
    RETURN NUMBER DETERMINISTIC,


  STATIC FUNCTION get_measure_s(net_mem VARCHAR2, node_id NUMBER)
   RETURN NUMBER DETERMINISTIC AS LANGUAGE JAVA NAME
   ''oracle.spatial.type.NetworkWrapper.getNodeMeasure(
    java.lang.String, oracle.sql.NUMBER)
    return oracle.sql.NUMBER'',

  OVERRIDING MEMBER FUNCTION get_measure(
    net_mem VARCHAR2, node_id NUMBER)
    RETURN NUMBER DETERMINISTIC,


  STATIC PROCEDURE set_cost_s(net_mem VARCHAR2, node_id NUMBER, cost NUMBER)
   AS LANGUAGE JAVA NAME
   ''oracle.spatial.type.NetworkWrapper.setNodeCost(
    java.lang.String, oracle.sql.NUMBER, oracle.sql.NUMBER)'',

  OVERRIDING MEMBER PROCEDURE set_cost(
    net_mem VARCHAR2, node_id NUMBER, cost NUMBER),
    

  STATIC PROCEDURE set_hierarchy_level_s(net_mem VARCHAR2, node_id NUMBER,    
    level NUMBER)
    AS LANGUAGE JAVA NAME
   ''oracle.spatial.type.NetworkWrapper.setNodeHierarchyLevel(
    java.lang.String, oracle.sql.NUMBER, oracle.sql.NUMBER)'',

  OVERRIDING MEMBER PROCEDURE set_hierarchy_level(
    net_mem VARCHAR2, node_id NUMBER,    level NUMBER),


  STATIC PROCEDURE set_type_s(net_mem VARCHAR2, node_id NUMBER, type VARCHAR2)
   AS LANGUAGE JAVA NAME
   ''oracle.spatial.type.NetworkWrapper.setNodeType(
    java.lang.String, oracle.sql.NUMBER, java.lang.String)'',

  OVERRIDING MEMBER PROCEDURE set_type(
    net_mem VARCHAR2, node_id NUMBER, type VARCHAR2),


  STATIC PROCEDURE set_name_s(net_mem VARCHAR2, node_id NUMBER,
   node_name VARCHAR2)
   AS LANGUAGE JAVA NAME
   ''oracle.spatial.type.NetworkWrapper.setNodeName(
    java.lang.String, oracle.sql.NUMBER, java.lang.String)'',

  OVERRIDING MEMBER PROCEDURE set_name(
    net_mem VARCHAR2, node_id NUMBER, node_name VARCHAR2),


  STATIC PROCEDURE set_state_s(net_mem VARCHAR2, node_id NUMBER, state VARCHAR2)
   AS LANGUAGE JAVA NAME
   ''oracle.spatial.type.NetworkWrapper.setNodeState(
    java.lang.String, oracle.sql.NUMBER, java.lang.String)'',

  OVERRIDING MEMBER PROCEDURE set_state(
    net_mem VARCHAR2, node_id NUMBER, state VARCHAR2),


  STATIC PROCEDURE set_component_no_s(net_mem VARCHAR2,node_id NUMBER,no NUMBER)
   AS LANGUAGE JAVA NAME
   ''oracle.spatial.type.NetworkWrapper.setNodeComponentNo(
    java.lang.String, oracle.sql.NUMBER, oracle.sql.NUMBER)'',

  OVERRIDING MEMBER PROCEDURE set_component_no(
    net_mem VARCHAR2, node_id NUMBER,    no NUMBER),


  STATIC PROCEDURE set_parent_node_s(net_mem VARCHAR2, node_id NUMBER,    
   parent_node_id NUMBER)
   AS LANGUAGE JAVA NAME
   ''oracle.spatial.type.NetworkWrapper.setNodeParentNode(
    java.lang.String, oracle.sql.NUMBER, oracle.sql.NUMBER)'',

  OVERRIDING MEMBER PROCEDURE set_parent_node(
    net_mem VARCHAR2, node_id NUMBER,    parent_node_id NUMBER),

  ----------------
  -- DEPRECATED --
  ----------------
  STATIC PROCEDURE set_external_node_id_s(net_mem VARCHAR2, node_id NUMBER,    
   external_node_id NUMBER)
   AS LANGUAGE JAVA NAME
   ''oracle.spatial.type.NetworkWrapper.setNodeExternalNodeId(
    java.lang.String, oracle.sql.NUMBER, oracle.sql.NUMBER)'',

  ----------------
  -- DEPRECATED --
  ----------------
  OVERRIDING MEMBER PROCEDURE set_external_node_id(
    net_mem VARCHAR2, node_id NUMBER,    external_node_id NUMBER),

  ----------------
  -- DEPRECATED --
  ----------------
  STATIC PROCEDURE set_external_network_id_s(net_mem VARCHAR2, node_id NUMBER,    
   external_network_id NUMBER)
   AS LANGUAGE JAVA NAME
   ''oracle.spatial.type.NetworkWrapper.setNodeExternalNetworkId(
    java.lang.String, oracle.sql.NUMBER, oracle.sql.NUMBER)'',

  ----------------
  -- DEPRECATED --
  ----------------
  OVERRIDING MEMBER PROCEDURE set_external_network_id(
    net_mem VARCHAR2, node_id NUMBER,    external_network_id NUMBER),


  STATIC PROCEDURE set_geometry_s(net_mem VARCHAR2, node_id NUMBER,    
   geom SDO_GEOMETRY)
   AS LANGUAGE JAVA NAME
   ''oracle.spatial.type.NetworkWrapper.setNodeGeometry(
    java.lang.String, oracle.sql.NUMBER, oracle.spatial.type.SdoGeometry)'',

  OVERRIDING MEMBER PROCEDURE set_geometry(
    net_mem VARCHAR2, node_id NUMBER,    geom SDO_GEOMETRY),


  STATIC PROCEDURE set_geom_id_s(net_mem VARCHAR2, node_id NUMBER,    
   geom_id NUMBER)
   AS LANGUAGE JAVA NAME
   ''oracle.spatial.type.NetworkWrapper.setNodeGeomId(
    java.lang.String, oracle.sql.NUMBER, oracle.sql.NUMBER)'',

  OVERRIDING MEMBER PROCEDURE set_geom_id(
    net_mem VARCHAR2, node_id NUMBER,    geom_id NUMBER),


  STATIC PROCEDURE set_measure_s(net_mem VARCHAR2, node_id NUMBER,    
   measure NUMBER)
   AS LANGUAGE JAVA NAME
   ''oracle.spatial.type.NetworkWrapper.setNodeMeasure(
    java.lang.String, oracle.sql.NUMBER, oracle.sql.NUMBER)'',

  OVERRIDING MEMBER PROCEDURE set_measure(
    net_mem VARCHAR2, node_id NUMBER,    measure NUMBER),


  STATIC PROCEDURE make_temporary_s(net_mem VARCHAR2, node_id NUMBER)
   AS LANGUAGE JAVA NAME
   ''oracle.spatial.type.NetworkWrapper.nodeMakeTemporary(
    java.lang.String, oracle.sql.NUMBER)'',

  OVERRIDING MEMBER PROCEDURE make_temporary(
    net_mem VARCHAR2, node_id NUMBER),


  STATIC FUNCTION is_temporary_s(net_mem VARCHAR2, node_id NUMBER)
   RETURN VARCHAR2 DETERMINISTIC AS LANGUAGE JAVA NAME
   ''oracle.spatial.type.NetworkWrapper.nodeIsTemporary(
    java.lang.String, oracle.sql.NUMBER)
    return java.lang.String'',

  OVERRIDING MEMBER FUNCTION is_temporary(
    net_mem VARCHAR2, node_id NUMBER)
    RETURN VARCHAR2 DETERMINISTIC,


  STATIC FUNCTION is_active_s(net_mem VARCHAR2, node_id NUMBER)
   RETURN VARCHAR2 DETERMINISTIC AS LANGUAGE JAVA NAME
   ''oracle.spatial.type.NetworkWrapper.nodeIsActive(
    java.lang.String, oracle.sql.NUMBER)
    return java.lang.String'',

  OVERRIDING MEMBER FUNCTION is_active(
    net_mem VARCHAR2, node_id NUMBER)
    RETURN VARCHAR2 DETERMINISTIC,


  STATIC FUNCTION is_logical_s(net_mem VARCHAR2, node_id NUMBER)
   RETURN VARCHAR2 DETERMINISTIC AS LANGUAGE JAVA NAME
   ''oracle.spatial.type.NetworkWrapper.nodeIsLogical(
    java.lang.String, oracle.sql.NUMBER)
    return java.lang.String'',

  OVERRIDING MEMBER FUNCTION is_logical(
    net_mem VARCHAR2, node_id NUMBER)
    RETURN VARCHAR2 DETERMINISTIC,


  STATIC FUNCTION link_exists_s(net_mem VARCHAR2, node_id1 NUMBER, node_id2 NUMBER)
   RETURN VARCHAR2 DETERMINISTIC AS LANGUAGE JAVA NAME
   ''oracle.spatial.type.NetworkWrapper.linkExists(
    java.lang.String, oracle.sql.NUMBER, oracle.sql.NUMBER)
       return java.lang.String'',

  OVERRIDING MEMBER FUNCTION link_exists(
    net_mem VARCHAR2, node_id1 NUMBER, node_id2 NUMBER)
    RETURN VARCHAR2 DETERMINISTIC,

  ----------------
  -- DEPRECATED --
  ----------------
  STATIC FUNCTION is_external_node_s(net_mem VARCHAR2, node_id NUMBER)
   RETURN VARCHAR2 DETERMINISTIC AS LANGUAGE JAVA NAME
   ''oracle.spatial.type.NetworkWrapper.nodeIsExternalNode(
    java.lang.String, oracle.sql.NUMBER)
    return java.lang.String'',

  ----------------
  -- DEPRECATED --
  ----------------
  OVERRIDING MEMBER FUNCTION is_external_node(
    net_mem VARCHAR2, node_id NUMBER)
    RETURN VARCHAR2 DETERMINISTIC,

  STATIC FUNCTION get_in_degree_s(net_mem VARCHAR2, node_id NUMBER)
   RETURN NUMBER DETERMINISTIC AS LANGUAGE JAVA NAME
   ''oracle.spatial.type.NetworkWrapper.getNodeInDegree(
    java.lang.String, oracle.sql.NUMBER)
    return oracle.sql.NUMBER'',

  OVERRIDING MEMBER FUNCTION get_in_degree(
    net_mem VARCHAR2, node_id NUMBER)
    RETURN NUMBER DETERMINISTIC,


  STATIC FUNCTION get_out_degree_s(net_mem VARCHAR2, node_id NUMBER)
   RETURN NUMBER DETERMINISTIC AS LANGUAGE JAVA NAME
   ''oracle.spatial.type.NetworkWrapper.getNodeOutDegree(
    java.lang.String, oracle.sql.NUMBER)
    return oracle.sql.NUMBER'',

  OVERRIDING MEMBER FUNCTION get_out_degree(
    net_mem VARCHAR2, node_id NUMBER)
    RETURN NUMBER DETERMINISTIC,

  STATIC FUNCTION get_degree_s(net_mem VARCHAR2, node_id NUMBER)
   RETURN NUMBER DETERMINISTIC AS LANGUAGE JAVA NAME
   ''oracle.spatial.type.NetworkWrapper.getNodeDegree(
    java.lang.String, oracle.sql.NUMBER)
    return oracle.sql.NUMBER'',

  OVERRIDING MEMBER FUNCTION get_degree(
    net_mem VARCHAR2, node_id NUMBER)
    RETURN NUMBER DETERMINISTIC

)';

EXCEPTION 
  WHEN OTHERS THEN NULL;
END;
/
show errors;

GRANT EXECUTE ON sdo_node_t TO PUBLIC;
CREATE OR REPLACE PUBLIC SYNONYM sdo_node_t 
  FOR mdsys.sdo_node_t;

BEGIN
  EXECUTE IMMEDIATE
'CREATE OR REPLACE TYPE SDO_LINK_T 
  AUTHID current_user
  AS OBJECT(
  object_id INTEGER,
  
  NOT INSTANTIABLE MEMBER FUNCTION get_cost(
    net_mem VARCHAR2, link_id NUMBER)
    RETURN NUMBER DETERMINISTIC,

  NOT INSTANTIABLE MEMBER FUNCTION get_level(
    net_mem VARCHAR2, link_id NUMBER)
    RETURN NUMBER DETERMINISTIC,

  NOT INSTANTIABLE MEMBER FUNCTION get_state(
    net_mem VARCHAR2, link_id NUMBER)
    RETURN VARCHAR2 DETERMINISTIC,

  NOT INSTANTIABLE MEMBER FUNCTION get_type(
    net_mem VARCHAR2, link_id NUMBER)
    RETURN VARCHAR2 DETERMINISTIC,

  NOT INSTANTIABLE MEMBER FUNCTION get_name(
    net_mem VARCHAR2, link_id NUMBER)
    RETURN VARCHAR2 DETERMINISTIC,

  NOT INSTANTIABLE MEMBER FUNCTION get_start_node_id(
    net_mem VARCHAR2, link_id NUMBER)
    RETURN NUMBER DETERMINISTIC,

  NOT INSTANTIABLE MEMBER FUNCTION get_end_node_id(
    net_mem VARCHAR2, link_id NUMBER)
    RETURN NUMBER DETERMINISTIC,

  NOT INSTANTIABLE MEMBER FUNCTION get_parent_link_id(
    net_mem VARCHAR2, link_id NUMBER)
    RETURN NUMBER DETERMINISTIC,

  NOT INSTANTIABLE MEMBER FUNCTION get_child_links(
    net_mem VARCHAR2, link_id NUMBER)
    RETURN SDO_NUMBER_ARRAY DETERMINISTIC,

  NOT INSTANTIABLE MEMBER FUNCTION get_co_link_ids(
    net_mem VARCHAR2, link_id NUMBER)
    RETURN SDO_NUMBER_ARRAY DETERMINISTIC,

  NOT INSTANTIABLE MEMBER FUNCTION get_sibling_link_ids(
    net_mem VARCHAR2, link_id NUMBER)
    RETURN SDO_NUMBER_ARRAY DETERMINISTIC,

  NOT INSTANTIABLE MEMBER FUNCTION get_geometry(
    net_mem VARCHAR2, link_id NUMBER)
    RETURN SDO_GEOMETRY DETERMINISTIC,

  NOT INSTANTIABLE MEMBER FUNCTION get_geom_id(
    net_mem VARCHAR2, link_id NUMBER)
    RETURN NUMBER DETERMINISTIC,

  NOT INSTANTIABLE MEMBER FUNCTION get_end_measure(
    net_mem VARCHAR2, link_id NUMBER)
    RETURN NUMBER DETERMINISTIC,

  NOT INSTANTIABLE MEMBER FUNCTION get_start_measure(
    net_mem VARCHAR2, link_id NUMBER)
    RETURN NUMBER DETERMINISTIC,

  NOT INSTANTIABLE MEMBER PROCEDURE make_temporary(
    net_mem VARCHAR2, link_id NUMBER),
  
  NOT INSTANTIABLE MEMBER PROCEDURE set_cost(
    net_mem VARCHAR2, link_id NUMBER, cost NUMBER),

  NOT INSTANTIABLE MEMBER PROCEDURE set_level(
    net_mem VARCHAR2, link_id NUMBER,    level NUMBER),

  NOT INSTANTIABLE MEMBER PROCEDURE set_type(
    net_mem VARCHAR2, link_id NUMBER, type VARCHAR2),

  NOT INSTANTIABLE MEMBER PROCEDURE set_name(
    net_mem VARCHAR2, link_id NUMBER, link_name VARCHAR2),

  NOT INSTANTIABLE MEMBER PROCEDURE set_state(
    net_mem VARCHAR2, link_id NUMBER, state VARCHAR2),

  NOT INSTANTIABLE MEMBER PROCEDURE set_start_node(
    net_mem VARCHAR2, link_id NUMBER,    start_node_id NUMBER),

  NOT INSTANTIABLE MEMBER PROCEDURE set_end_node(
    net_mem VARCHAR2, link_id NUMBER,    end_node_id NUMBER),

  NOT INSTANTIABLE MEMBER PROCEDURE set_parent_link(
    net_mem VARCHAR2, link_id NUMBER,    parent_link_id NUMBER),

  NOT INSTANTIABLE MEMBER PROCEDURE set_geometry(
    net_mem VARCHAR2, link_id NUMBER,    geom SDO_GEOMETRY),

  NOT INSTANTIABLE MEMBER PROCEDURE set_geom_id(
    net_mem VARCHAR2, link_id NUMBER,    geom_id NUMBER),

  NOT INSTANTIABLE MEMBER PROCEDURE set_measure(
    net_mem VARCHAR2, link_id NUMBER, start_measure NUMBER, end_measure NUMBER),

  NOT INSTANTIABLE MEMBER FUNCTION is_temporary(
    net_mem VARCHAR2, link_id NUMBER)
    RETURN VARCHAR2 DETERMINISTIC,

  NOT INSTANTIABLE MEMBER FUNCTION is_active(
    net_mem VARCHAR2, link_id NUMBER)
    RETURN VARCHAR2 DETERMINISTIC,

  NOT INSTANTIABLE MEMBER FUNCTION is_logical(
    net_mem VARCHAR2, link_id NUMBER)
    RETURN VARCHAR2 DETERMINISTIC,

  ----------------
  -- DEPRECATED --
  ----------------
  NOT INSTANTIABLE MEMBER FUNCTION is_external_link(
    net_mem VARCHAR2, link_id NUMBER)
    RETURN VARCHAR2 DETERMINISTIC

) NOT INSTANTIABLE NOT FINAL';
EXCEPTION 
  WHEN OTHERS THEN NULL;
END;
/
show errors;

BEGIN
  EXECUTE IMMEDIATE
'CREATE OR REPLACE TYPE SDO_LINK_I 
  AUTHID current_user
  UNDER SDO_LINK_T(

  STATIC FUNCTION get_cost_s(net_mem VARCHAR2, link_id NUMBER)
   RETURN NUMBER DETERMINISTIC AS LANGUAGE JAVA NAME
   ''oracle.spatial.type.NetworkWrapper.getLinkCost(
    java.lang.String, oracle.sql.NUMBER)
    return oracle.sql.NUMBER'',

  OVERRIDING MEMBER FUNCTION get_cost(
    net_mem VARCHAR2, link_id NUMBER)
    RETURN NUMBER DETERMINISTIC,


  STATIC FUNCTION get_level_s(net_mem VARCHAR2, link_id NUMBER)
   RETURN NUMBER DETERMINISTIC AS LANGUAGE JAVA NAME
   ''oracle.spatial.type.NetworkWrapper.getLinkLevel(
    java.lang.String, oracle.sql.NUMBER)
    return oracle.sql.NUMBER'',

  OVERRIDING MEMBER FUNCTION get_level(
    net_mem VARCHAR2, link_id NUMBER)
    RETURN NUMBER DETERMINISTIC,


  STATIC FUNCTION get_state_s(net_mem VARCHAR2, link_id NUMBER)
   RETURN VARCHAR2 DETERMINISTIC AS LANGUAGE JAVA NAME
   ''oracle.spatial.type.NetworkWrapper.getLinkState(
    java.lang.String, oracle.sql.NUMBER)
    return java.lang.String'',

  OVERRIDING MEMBER FUNCTION get_state(
    net_mem VARCHAR2, link_id NUMBER)
    RETURN VARCHAR2 DETERMINISTIC,


  STATIC FUNCTION get_type_s(net_mem VARCHAR2, link_id NUMBER)
   RETURN VARCHAR2 DETERMINISTIC AS LANGUAGE JAVA NAME
   ''oracle.spatial.type.NetworkWrapper.getLinkType(
    java.lang.String, oracle.sql.NUMBER)
    return java.lang.String'',

  OVERRIDING MEMBER FUNCTION get_type(
    net_mem VARCHAR2, link_id NUMBER)
    RETURN VARCHAR2 DETERMINISTIC,


  STATIC FUNCTION get_name_s(net_mem VARCHAR2, link_id NUMBER)
   RETURN VARCHAR2 DETERMINISTIC AS LANGUAGE JAVA NAME
   ''oracle.spatial.type.NetworkWrapper.getLinkName(
    java.lang.String, oracle.sql.NUMBER)
    return java.lang.String'',

  OVERRIDING MEMBER FUNCTION get_name(
    net_mem VARCHAR2, link_id NUMBER)
    RETURN VARCHAR2 DETERMINISTIC,


  STATIC FUNCTION get_start_node_id_s(net_mem VARCHAR2, link_id NUMBER)
   RETURN NUMBER DETERMINISTIC AS LANGUAGE JAVA NAME
   ''oracle.spatial.type.NetworkWrapper.getLinkStartNodeId(
    java.lang.String, oracle.sql.NUMBER)
    return oracle.sql.NUMBER'',

  OVERRIDING MEMBER FUNCTION get_start_node_id(
    net_mem VARCHAR2, link_id NUMBER)
    RETURN NUMBER DETERMINISTIC,


  STATIC FUNCTION get_end_node_id_s(net_mem VARCHAR2, link_id NUMBER)
   RETURN NUMBER DETERMINISTIC AS LANGUAGE JAVA NAME
   ''oracle.spatial.type.NetworkWrapper.getLinkEndNodeId(
    java.lang.String, oracle.sql.NUMBER)
    return oracle.sql.NUMBER'',

  OVERRIDING MEMBER FUNCTION get_end_node_id(
    net_mem VARCHAR2, link_id NUMBER)
    RETURN NUMBER DETERMINISTIC,


  STATIC FUNCTION get_parent_link_id_s(net_mem VARCHAR2, link_id NUMBER)
   RETURN NUMBER DETERMINISTIC AS LANGUAGE JAVA NAME
   ''oracle.spatial.type.NetworkWrapper.getLinkParentLinkId(
    java.lang.String, oracle.sql.NUMBER)
    return oracle.sql.NUMBER'',

  OVERRIDING MEMBER FUNCTION get_parent_link_id(
    net_mem VARCHAR2, link_id NUMBER)
    RETURN NUMBER DETERMINISTIC,


  STATIC FUNCTION get_child_links_s(net_mem VARCHAR2, link_id NUMBER)
   RETURN SDO_NUMBER_ARRAY DETERMINISTIC AS LANGUAGE JAVA NAME
   ''oracle.spatial.type.NetworkWrapper.getLinkChildLinkIds(
    java.lang.String, oracle.sql.NUMBER)
        return oracle.spatial.type.SdoNumberArray'',

  OVERRIDING MEMBER FUNCTION get_child_links(
    net_mem VARCHAR2, link_id NUMBER)
    RETURN SDO_NUMBER_ARRAY DETERMINISTIC,


  STATIC FUNCTION get_co_link_ids_s(net_mem VARCHAR2, link_id NUMBER)
   RETURN SDO_NUMBER_ARRAY DETERMINISTIC AS LANGUAGE JAVA NAME
   ''oracle.spatial.type.NetworkWrapper.getLinkCoLinkIds(
    java.lang.String, oracle.sql.NUMBER)
        return oracle.spatial.type.SdoNumberArray'',

  OVERRIDING MEMBER FUNCTION get_co_link_ids(
    net_mem VARCHAR2, link_id NUMBER)
    RETURN SDO_NUMBER_ARRAY DETERMINISTIC,


  STATIC FUNCTION get_sibling_link_ids_s(net_mem VARCHAR2, link_id NUMBER)
   RETURN SDO_NUMBER_ARRAY DETERMINISTIC AS LANGUAGE JAVA NAME
   ''oracle.spatial.type.NetworkWrapper.getLinkSiblingLinkIds(
    java.lang.String, oracle.sql.NUMBER)
        return oracle.spatial.type.SdoNumberArray'',

  OVERRIDING MEMBER FUNCTION get_sibling_link_ids(
    net_mem VARCHAR2, link_id NUMBER)
    RETURN SDO_NUMBER_ARRAY DETERMINISTIC,


  STATIC FUNCTION get_geometry_s(net_mem VARCHAR2, link_id NUMBER)
   RETURN SDO_GEOMETRY DETERMINISTIC AS LANGUAGE JAVA NAME
   ''oracle.spatial.type.NetworkWrapper.getLinkGeometry(
    java.lang.String, oracle.sql.NUMBER)
    return     oracle.spatial.type.SdoGeometry'',

  OVERRIDING MEMBER FUNCTION get_geometry(
    net_mem VARCHAR2, link_id NUMBER)
    RETURN SDO_GEOMETRY DETERMINISTIC,


  STATIC FUNCTION get_geom_id_s(net_mem VARCHAR2, link_id NUMBER)
   RETURN NUMBER DETERMINISTIC AS LANGUAGE JAVA NAME
   ''oracle.spatial.type.NetworkWrapper.getLinkGeomId(
    java.lang.String, oracle.sql.NUMBER)
    return oracle.sql.NUMBER'',

  OVERRIDING MEMBER FUNCTION get_geom_id(
    net_mem VARCHAR2, link_id NUMBER)
    RETURN NUMBER DETERMINISTIC,


  STATIC FUNCTION get_end_measure_s(net_mem VARCHAR2, link_id NUMBER)
   RETURN NUMBER DETERMINISTIC AS LANGUAGE JAVA NAME
   ''oracle.spatial.type.NetworkWrapper.getLinkEndMeasure(
    java.lang.String, oracle.sql.NUMBER)
    return oracle.sql.NUMBER'',

  OVERRIDING MEMBER FUNCTION get_end_measure(
    net_mem VARCHAR2, link_id NUMBER)
    RETURN NUMBER DETERMINISTIC,


  STATIC FUNCTION get_start_measure_s(net_mem VARCHAR2, link_id NUMBER)
   RETURN NUMBER DETERMINISTIC AS LANGUAGE JAVA NAME
   ''oracle.spatial.type.NetworkWrapper.getLinkStartMeasure(
    java.lang.String, oracle.sql.NUMBER)
    return oracle.sql.NUMBER'',

  OVERRIDING MEMBER FUNCTION get_start_measure(
    net_mem VARCHAR2, link_id NUMBER)
    RETURN NUMBER DETERMINISTIC,

  STATIC PROCEDURE make_temporary_s(net_mem VARCHAR2, link_id NUMBER)
   AS LANGUAGE JAVA NAME
   ''oracle.spatial.type.NetworkWrapper.linkMakeTemporary(java.lang.String, 
    oracle.sql.NUMBER)'',  

  OVERRIDING MEMBER PROCEDURE make_temporary(
    net_mem VARCHAR2, link_id NUMBER),

  STATIC PROCEDURE set_cost_s(net_mem VARCHAR2, link_id NUMBER, cost NUMBER)
   AS LANGUAGE JAVA NAME
   ''oracle.spatial.type.NetworkWrapper.setLinkCost(
    java.lang.String, oracle.sql.NUMBER, oracle.sql.NUMBER)'',

  OVERRIDING MEMBER PROCEDURE set_cost(
    net_mem VARCHAR2, link_id NUMBER, cost NUMBER),


  STATIC PROCEDURE set_level_s(net_mem VARCHAR2,link_id NUMBER,level NUMBER)
   AS LANGUAGE JAVA NAME
   ''oracle.spatial.type.NetworkWrapper.setLinkLevel(
    java.lang.String, oracle.sql.NUMBER, oracle.sql.NUMBER)'',

  OVERRIDING MEMBER PROCEDURE set_level(
    net_mem VARCHAR2, link_id NUMBER,    level NUMBER),


  STATIC PROCEDURE set_type_s(net_mem VARCHAR2, link_id NUMBER, type VARCHAR2)
   AS LANGUAGE JAVA NAME
   ''oracle.spatial.type.NetworkWrapper.setLinkType(
    java.lang.String, oracle.sql.NUMBER, java.lang.String)'',

  OVERRIDING MEMBER PROCEDURE set_type(
    net_mem VARCHAR2, link_id NUMBER, type VARCHAR2),


  STATIC PROCEDURE set_name_s(
   net_mem VARCHAR2,link_id NUMBER,link_name VARCHAR2)
   AS LANGUAGE JAVA NAME
   ''oracle.spatial.type.NetworkWrapper.setLinkName(
    java.lang.String, oracle.sql.NUMBER, java.lang.String)'',

  OVERRIDING MEMBER PROCEDURE set_name(
    net_mem VARCHAR2, link_id NUMBER, link_name VARCHAR2),


  STATIC PROCEDURE set_state_s(net_mem VARCHAR2, link_id NUMBER, state VARCHAR2)
   AS LANGUAGE JAVA NAME
   ''oracle.spatial.type.NetworkWrapper.setLinkState(
    java.lang.String, oracle.sql.NUMBER, java.lang.String)'',

  OVERRIDING MEMBER PROCEDURE set_state(
    net_mem VARCHAR2, link_id NUMBER, state VARCHAR2),


  STATIC PROCEDURE set_start_node_s(
    net_mem VARCHAR2, link_id NUMBER, start_node_id NUMBER)
   AS LANGUAGE JAVA NAME
   ''oracle.spatial.type.NetworkWrapper.setLinkStartNode(
    java.lang.String, oracle.sql.NUMBER, oracle.sql.NUMBER)'',

  OVERRIDING MEMBER PROCEDURE set_start_node(
    net_mem VARCHAR2, link_id NUMBER,    start_node_id NUMBER),


  STATIC PROCEDURE set_end_node_s(
   net_mem VARCHAR2, link_id NUMBER, end_node_id NUMBER)
  AS LANGUAGE JAVA NAME
   ''oracle.spatial.type.NetworkWrapper.setLinkEndNode(
    java.lang.String, oracle.sql.NUMBER, oracle.sql.NUMBER)'',

  OVERRIDING MEMBER PROCEDURE set_end_node(
    net_mem VARCHAR2, link_id NUMBER,    end_node_id NUMBER),


  STATIC PROCEDURE set_parent_link_s(
   net_mem VARCHAR2, link_id NUMBER,    parent_link_id NUMBER)
   AS LANGUAGE JAVA NAME
   ''oracle.spatial.type.NetworkWrapper.setLinkParentLink(
    java.lang.String, oracle.sql.NUMBER, oracle.sql.NUMBER)'',

  OVERRIDING MEMBER PROCEDURE set_parent_link(
    net_mem VARCHAR2, link_id NUMBER,    parent_link_id NUMBER),


  STATIC PROCEDURE set_geometry_s(
   net_mem VARCHAR2, link_id NUMBER,    geom SDO_GEOMETRY)
   AS LANGUAGE JAVA NAME
   ''oracle.spatial.type.NetworkWrapper.setLinkGeometry(
    java.lang.String, oracle.sql.NUMBER,     oracle.spatial.type.SdoGeometry)'',

  OVERRIDING MEMBER PROCEDURE set_geometry(
    net_mem VARCHAR2, link_id NUMBER,    geom SDO_GEOMETRY),


  STATIC PROCEDURE set_geom_id_s(
   net_mem VARCHAR2, link_id NUMBER,    geom_id NUMBER)
   AS LANGUAGE JAVA NAME
   ''oracle.spatial.type.NetworkWrapper.setLinkGeomId(
    java.lang.String, oracle.sql.NUMBER, oracle.sql.NUMBER)'',

  OVERRIDING MEMBER PROCEDURE set_geom_id(
    net_mem VARCHAR2, link_id NUMBER,    geom_id NUMBER),


  STATIC PROCEDURE set_measure_s(
   net_mem VARCHAR2, link_id NUMBER, start_measure NUMBER, end_measure NUMBER)
   AS LANGUAGE JAVA NAME
   ''oracle.spatial.type.NetworkWrapper.setLinkMeasure(
    java.lang.String, oracle.sql.NUMBER, oracle.sql.NUMBER,oracle.sql.NUMBER)'',

  OVERRIDING MEMBER PROCEDURE set_measure(
    net_mem VARCHAR2, link_id NUMBER, start_measure NUMBER, end_measure NUMBER),


  STATIC FUNCTION is_temporary_s(net_mem VARCHAR2, link_id NUMBER)
   RETURN VARCHAR2 DETERMINISTIC AS LANGUAGE JAVA NAME
   ''oracle.spatial.type.NetworkWrapper.linkIsTemporary(
    java.lang.String, oracle.sql.NUMBER)
    return java.lang.String'',

  OVERRIDING MEMBER FUNCTION is_temporary(
    net_mem VARCHAR2, link_id NUMBER)
    RETURN VARCHAR2 DETERMINISTIC,


  STATIC FUNCTION is_active_s(net_mem VARCHAR2, link_id NUMBER)
   RETURN VARCHAR2 DETERMINISTIC AS LANGUAGE JAVA NAME
   ''oracle.spatial.type.NetworkWrapper.linkIsActive(
    java.lang.String, oracle.sql.NUMBER)
    return java.lang.String'',

  OVERRIDING MEMBER FUNCTION is_active(
    net_mem VARCHAR2, link_id NUMBER)
    RETURN VARCHAR2 DETERMINISTIC,


  STATIC FUNCTION is_logical_s(net_mem VARCHAR2, link_id NUMBER)
   RETURN VARCHAR2 DETERMINISTIC AS LANGUAGE JAVA NAME
   ''oracle.spatial.type.NetworkWrapper.linkIsLogical(
    java.lang.String, oracle.sql.NUMBER)
    return java.lang.String'',

  OVERRIDING MEMBER FUNCTION is_logical(
    net_mem VARCHAR2, link_id NUMBER)
    RETURN VARCHAR2 DETERMINISTIC,

  ----------------
  -- DEPRECATED --
  ----------------
  STATIC FUNCTION is_external_link_s(net_mem VARCHAR2, link_id NUMBER)
   RETURN VARCHAR2 DETERMINISTIC AS LANGUAGE JAVA NAME
   ''oracle.spatial.type.NetworkWrapper.linkIsExternalLink(
    java.lang.String, oracle.sql.NUMBER)
    return java.lang.String'',

  ----------------
  -- DEPRECATED --
  ----------------
  OVERRIDING MEMBER FUNCTION is_external_link(
    net_mem VARCHAR2, link_id NUMBER)
    RETURN VARCHAR2 DETERMINISTIC
)';
EXCEPTION 
  WHEN OTHERS THEN NULL;
END;
/
show errors;

GRANT EXECUTE ON sdo_link_t TO PUBLIC;
CREATE OR REPLACE PUBLIC SYNONYM sdo_link_t 
  FOR mdsys.sdo_link_t;

BEGIN
  EXECUTE IMMEDIATE
'CREATE OR REPLACE TYPE SDO_PATH_T 
  AUTHID current_user
  AS OBJECT(

  object_id   INTEGER,
  
  NOT INSTANTIABLE MEMBER FUNCTION get_cost(
    net_mem VARCHAR2, path_id NUMBER)
    RETURN NUMBER DETERMINISTIC,

  NOT INSTANTIABLE MEMBER FUNCTION get_no_of_links(
    net_mem VARCHAR2, path_id NUMBER)
    RETURN NUMBER DETERMINISTIC,

  NOT INSTANTIABLE MEMBER FUNCTION get_type(
    net_mem VARCHAR2, path_id NUMBER)
    RETURN VARCHAR2 DETERMINISTIC,

  NOT INSTANTIABLE MEMBER FUNCTION get_name(
    net_mem VARCHAR2, path_id NUMBER)
    RETURN VARCHAR2 DETERMINISTIC,

  NOT INSTANTIABLE MEMBER FUNCTION get_start_node_id(
    net_mem VARCHAR2, path_id NUMBER)
    RETURN NUMBER DETERMINISTIC,

  NOT INSTANTIABLE MEMBER FUNCTION get_end_node_id(
    net_mem VARCHAR2, path_id NUMBER)
    RETURN NUMBER DETERMINISTIC,

  NOT INSTANTIABLE MEMBER FUNCTION get_geometry(
    net_mem VARCHAR2, path_id NUMBER)
    RETURN SDO_GEOMETRY DETERMINISTIC,

  NOT INSTANTIABLE MEMBER FUNCTION get_node_ids(
    net_mem VARCHAR2, path_id NUMBER)
    RETURN SDO_NUMBER_ARRAY DETERMINISTIC,

  NOT INSTANTIABLE MEMBER FUNCTION get_link_ids(
    net_mem VARCHAR2, path_id NUMBER)
    RETURN SDO_NUMBER_ARRAY DETERMINISTIC,

  NOT INSTANTIABLE MEMBER PROCEDURE set_type(
    net_mem VARCHAR2, path_id NUMBER, type VARCHAR2),

  NOT INSTANTIABLE MEMBER PROCEDURE set_name(
    net_mem VARCHAR2, path_id NUMBER, path_name VARCHAR2),

  NOT INSTANTIABLE MEMBER PROCEDURE set_path_id(
    net_mem VARCHAR2, path_id NUMBER, new_path_id NUMBER),

  NOT INSTANTIABLE MEMBER PROCEDURE set_geometry(
    net_mem VARCHAR2, path_id NUMBER,    geom SDO_GEOMETRY),

  NOT INSTANTIABLE MEMBER FUNCTION is_closed(
    net_mem VARCHAR2, path_id NUMBER)
    RETURN VARCHAR2 DETERMINISTIC,

  NOT INSTANTIABLE MEMBER FUNCTION is_connected(
    net_mem VARCHAR2, path_id NUMBER)
    RETURN VARCHAR2 DETERMINISTIC,

  NOT INSTANTIABLE MEMBER FUNCTION is_simple(
    net_mem VARCHAR2, path_id NUMBER)
    RETURN VARCHAR2 DETERMINISTIC,

  NOT INSTANTIABLE MEMBER FUNCTION is_temporary(
    net_mem VARCHAR2, path_id NUMBER)
    RETURN VARCHAR2 DETERMINISTIC,

  NOT INSTANTIABLE MEMBER FUNCTION is_logical(
    net_mem VARCHAR2, path_id NUMBER)
    RETURN VARCHAR2 DETERMINISTIC,

  NOT INSTANTIABLE MEMBER FUNCTION is_active(
    net_mem VARCHAR2, path_id NUMBER)
    RETURN VARCHAR2 DETERMINISTIC,

  NOT INSTANTIABLE MEMBER PROCEDURE compute_geometry(
    net_mem VARCHAR2, path_id NUMBER,    tolerance NUMBER)
) NOT INSTANTIABLE NOT FINAL';
EXCEPTION 
  WHEN OTHERS THEN NULL;
END;
/
show errors;

BEGIN
  EXECUTE IMMEDIATE
'CREATE OR REPLACE TYPE SDO_PATH_I 
  AUTHID current_user
  UNDER SDO_PATH_T(

  STATIC FUNCTION get_cost_s(net_mem VARCHAR2, path_id NUMBER)
   RETURN NUMBER DETERMINISTIC AS LANGUAGE JAVA NAME
   ''oracle.spatial.type.NetworkWrapper.getPathCost(
    java.lang.String, oracle.sql.NUMBER)
    return oracle.sql.NUMBER'',

  OVERRIDING MEMBER FUNCTION get_cost(
    net_mem VARCHAR2, path_id NUMBER)
    RETURN NUMBER DETERMINISTIC,


  STATIC FUNCTION get_no_of_links_s(net_mem VARCHAR2, path_id NUMBER)
   RETURN NUMBER DETERMINISTIC AS LANGUAGE JAVA NAME
   ''oracle.spatial.type.NetworkWrapper.getPathNoOfLinks(
    java.lang.String, oracle.sql.NUMBER)
    return oracle.sql.NUMBER'',

  OVERRIDING MEMBER FUNCTION get_no_of_links(
    net_mem VARCHAR2, path_id NUMBER)
    RETURN NUMBER DETERMINISTIC,


  STATIC FUNCTION get_type_s(net_mem VARCHAR2, path_id NUMBER)
   RETURN VARCHAR2 DETERMINISTIC AS LANGUAGE JAVA NAME
   ''oracle.spatial.type.NetworkWrapper.getPathType(
    java.lang.String, oracle.sql.NUMBER)
    return java.lang.String'',

  OVERRIDING MEMBER FUNCTION get_type(
    net_mem VARCHAR2, path_id NUMBER)
    RETURN VARCHAR2 DETERMINISTIC,


  STATIC FUNCTION get_name_s(net_mem VARCHAR2, path_id NUMBER)
   RETURN VARCHAR2 DETERMINISTIC AS LANGUAGE JAVA NAME
   ''oracle.spatial.type.NetworkWrapper.getPathName(
    java.lang.String, oracle.sql.NUMBER)
    return java.lang.String'',

  OVERRIDING MEMBER FUNCTION get_name(
    net_mem VARCHAR2, path_id NUMBER)
    RETURN VARCHAR2 DETERMINISTIC,


  STATIC FUNCTION get_start_node_id_s(net_mem VARCHAR2, path_id NUMBER)
   RETURN NUMBER DETERMINISTIC AS LANGUAGE JAVA NAME
   ''oracle.spatial.type.NetworkWrapper.getPathStartNodeId(
    java.lang.String, oracle.sql.NUMBER)
    return oracle.sql.NUMBER'',

  OVERRIDING MEMBER FUNCTION get_start_node_id(
    net_mem VARCHAR2, path_id NUMBER)
    RETURN NUMBER DETERMINISTIC,


  STATIC FUNCTION get_end_node_id_s(net_mem VARCHAR2, path_id NUMBER)
   RETURN NUMBER DETERMINISTIC AS LANGUAGE JAVA NAME
   ''oracle.spatial.type.NetworkWrapper.getPathEndNodeId(
    java.lang.String, oracle.sql.NUMBER)
    return oracle.sql.NUMBER'',

  OVERRIDING MEMBER FUNCTION get_end_node_id(
    net_mem VARCHAR2, path_id NUMBER)
    RETURN NUMBER DETERMINISTIC,


  STATIC FUNCTION get_geometry_s(net_mem VARCHAR2, path_id NUMBER)
   RETURN SDO_GEOMETRY DETERMINISTIC AS LANGUAGE JAVA NAME
   ''oracle.spatial.type.NetworkWrapper.getPathGeometry(
    java.lang.String, oracle.sql.NUMBER)
    return     oracle.spatial.type.SdoGeometry'',

  OVERRIDING MEMBER FUNCTION get_geometry(
    net_mem VARCHAR2, path_id NUMBER)
    RETURN SDO_GEOMETRY DETERMINISTIC,

  STATIC FUNCTION get_node_ids_s(net_mem VARCHAR2, path_id NUMBER)
   RETURN SDO_NUMBER_ARRAY DETERMINISTIC AS LANGUAGE JAVA NAME
   ''oracle.spatial.type.NetworkWrapper.getPathNodeIds(
    java.lang.String, oracle.sql.NUMBER)
        return oracle.spatial.type.SdoNumberArray'',

  OVERRIDING MEMBER FUNCTION get_node_ids(
    net_mem VARCHAR2, path_id NUMBER)
    RETURN SDO_NUMBER_ARRAY DETERMINISTIC,


  STATIC FUNCTION get_link_ids_s(net_mem VARCHAR2, path_id NUMBER)
   RETURN SDO_NUMBER_ARRAY DETERMINISTIC AS LANGUAGE JAVA NAME
   ''oracle.spatial.type.NetworkWrapper.getPathLinkIds(
    java.lang.String, oracle.sql.NUMBER)
        return oracle.spatial.type.SdoNumberArray'',

  OVERRIDING MEMBER FUNCTION get_link_ids(
    net_mem VARCHAR2, path_id NUMBER)
    RETURN SDO_NUMBER_ARRAY DETERMINISTIC,


  STATIC PROCEDURE set_type_s(net_mem VARCHAR2, path_id NUMBER, type VARCHAR2)
   AS LANGUAGE JAVA NAME
   ''oracle.spatial.type.NetworkWrapper.setPathType(
    java.lang.String, oracle.sql.NUMBER, java.lang.String)'',

  OVERRIDING MEMBER PROCEDURE set_type(
    net_mem VARCHAR2, path_id NUMBER, type VARCHAR2),


  STATIC PROCEDURE set_name_s(net_mem VARCHAR2, path_id NUMBER, 
   path_name VARCHAR2)
   AS LANGUAGE JAVA NAME
   ''oracle.spatial.type.NetworkWrapper.setPathName(
    java.lang.String, oracle.sql.NUMBER, java.lang.String)'',

  OVERRIDING MEMBER PROCEDURE set_name(
    net_mem VARCHAR2, path_id NUMBER, path_name VARCHAR2),


  STATIC PROCEDURE set_path_id_s(net_mem VARCHAR2, path_id NUMBER, 
   new_path_id NUMBER)
   AS LANGUAGE JAVA NAME
   ''oracle.spatial.type.NetworkWrapper.setPathPathId(
    java.lang.String, oracle.sql.NUMBER, oracle.sql.NUMBER)'',

  OVERRIDING MEMBER PROCEDURE set_path_id(
    net_mem VARCHAR2, path_id NUMBER, new_path_id NUMBER),


  STATIC PROCEDURE set_geometry_s(
   net_mem VARCHAR2, path_id NUMBER, geom SDO_GEOMETRY)
   AS LANGUAGE JAVA NAME
   ''oracle.spatial.type.NetworkWrapper.setPathGeometry(
    java.lang.String, oracle.sql.NUMBER,     oracle.spatial.type.SdoGeometry)'',

  OVERRIDING MEMBER PROCEDURE set_geometry(
    net_mem VARCHAR2, path_id NUMBER,    geom SDO_GEOMETRY),


  STATIC FUNCTION is_closed_s(net_mem VARCHAR2, path_id NUMBER)
   RETURN VARCHAR2 DETERMINISTIC AS LANGUAGE JAVA NAME
   ''oracle.spatial.type.NetworkWrapper.pathIsClosed(
    java.lang.String, oracle.sql.NUMBER)
    return java.lang.String'',

  OVERRIDING MEMBER FUNCTION is_closed(
    net_mem VARCHAR2, path_id NUMBER)
    RETURN VARCHAR2 DETERMINISTIC,


  STATIC FUNCTION is_connected_s(net_mem VARCHAR2, path_id NUMBER)
   RETURN VARCHAR2 DETERMINISTIC AS LANGUAGE JAVA NAME
   ''oracle.spatial.type.NetworkWrapper.pathIsConnected(
    java.lang.String, oracle.sql.NUMBER)
    return java.lang.String'',

  OVERRIDING MEMBER FUNCTION is_connected(
    net_mem VARCHAR2, path_id NUMBER)
    RETURN VARCHAR2 DETERMINISTIC,


  STATIC FUNCTION is_simple_s(net_mem VARCHAR2, path_id NUMBER)
   RETURN VARCHAR2 DETERMINISTIC AS LANGUAGE JAVA NAME
   ''oracle.spatial.type.NetworkWrapper.pathIsSimple(
    java.lang.String, oracle.sql.NUMBER)
    return java.lang.String'',

  OVERRIDING MEMBER FUNCTION is_simple(
    net_mem VARCHAR2, path_id NUMBER)
    RETURN VARCHAR2 DETERMINISTIC,


  STATIC FUNCTION is_temporary_s(net_mem VARCHAR2, path_id NUMBER)
   RETURN VARCHAR2 DETERMINISTIC AS LANGUAGE JAVA NAME
   ''oracle.spatial.type.NetworkWrapper.pathIsTemporary(
    java.lang.String, oracle.sql.NUMBER)
    return java.lang.String'',

  OVERRIDING MEMBER FUNCTION is_temporary(
    net_mem VARCHAR2, path_id NUMBER)
    RETURN VARCHAR2 DETERMINISTIC,


  STATIC FUNCTION is_logical_s(net_mem VARCHAR2, path_id NUMBER)
   RETURN VARCHAR2 DETERMINISTIC AS LANGUAGE JAVA NAME
   ''oracle.spatial.type.NetworkWrapper.pathIsLogical(
    java.lang.String, oracle.sql.NUMBER)
    return java.lang.String'',

  OVERRIDING MEMBER FUNCTION is_logical(
    net_mem VARCHAR2, path_id NUMBER)
    RETURN VARCHAR2 DETERMINISTIC,


  STATIC FUNCTION is_active_s(net_mem VARCHAR2, path_id NUMBER)
   RETURN VARCHAR2 DETERMINISTIC AS LANGUAGE JAVA NAME
   ''oracle.spatial.type.NetworkWrapper.pathIsActive(
    java.lang.String, oracle.sql.NUMBER)
    return java.lang.String'',

  OVERRIDING MEMBER FUNCTION is_active(
    net_mem VARCHAR2, path_id NUMBER)
    RETURN VARCHAR2 DETERMINISTIC,


  STATIC PROCEDURE compute_geometry_s(
   net_mem VARCHAR2, path_id NUMBER, tolerance NUMBER)
   AS LANGUAGE JAVA NAME
   ''oracle.spatial.type.NetworkWrapper.computeGeometry(
    java.lang.String, oracle.sql.NUMBER, oracle.sql.NUMBER)'',

  OVERRIDING MEMBER PROCEDURE compute_geometry(
    net_mem VARCHAR2, path_id NUMBER,    tolerance NUMBER)
)';
EXCEPTION 
  WHEN OTHERS THEN NULL;
END;
/
show errors;

GRANT EXECUTE ON sdo_path_t TO PUBLIC;
CREATE OR REPLACE PUBLIC SYNONYM sdo_path_t 
  FOR mdsys.sdo_path_t;

BEGIN
  EXECUTE IMMEDIATE
'CREATE OR REPLACE TYPE SDO_NETWORK_T 
  AUTHID current_user
  AS OBJECT(

  object_id  INTEGER,
  
  --NOT INSTANTIABLE MEMBER PROCEDURE add_node(
  --  net_mem VARCHAR2, node_id NUMBER),

  --NOT INSTANTIABLE MEMBER PROCEDURE add_node(
  --  net_mem VARCHAR2, node_id NUMBER, node_name String),

  -----------------------------------------------------
  -- external_network_id: not used. can be any value --
  -- external_node_id:    not used. can be any value --
  -----------------------------------------------------
  NOT INSTANTIABLE MEMBER PROCEDURE add_node(
    net_mem VARCHAR2, node_id NUMBER, node_name String,    
    external_network_id NUMBER, external_node_id NUMBER),

  -- NOT INSTANTIABLE MEMBER PROCEDURE add_node(
  --  net_mem VARCHAR2, node_id NUMBER, x NUMBER, y NUMBER,    
  --  external_network_id NUMBER, external_node_id NUMBER),

  -----------------------------------------------------
  -- external_network_id: not used. can be any value --
  -- external_node_id:    not used. can be any value --
  -----------------------------------------------------
  NOT INSTANTIABLE MEMBER PROCEDURE add_sdo_node(
      net_mem VARCHAR2, node_id NUMBER, node_name VARCHAR2, x NUMBER, y NUMBER, 
      external_network_id NUMBER, external_node_id NUMBER),

  --NOT INSTANTIABLE MEMBER PROCEDURE add_sdo_node(
  --  net_mem VARCHAR2, node_id NUMBER, x NUMBER, y NUMBER),

  --NOT INSTANTIABLE MEMBER PROCEDURE add_sdo_node(
  --  net_mem VARCHAR2, node_id NUMBER, node_name VARCHAR2, x NUMBER, y NUMBER),

  -----------------------------------------------------
  -- external_network_id: not used. can be any value --
  -- external_node_id:    not used. can be any value --
  -----------------------------------------------------
  NOT INSTANTIABLE MEMBER PROCEDURE add_lrs_node(
    net_mem VARCHAR2, node_id NUMBER, node_name VARCHAR2, geom_id NUMBER, 
    measure NUMBER, geom SDO_GEOMETRY, external_network_id NUMBER, 
    external_node_id NUMBER),

  --NOT INSTANTIABLE MEMBER PROCEDURE add_lrs_node(
  --  net_mem VARCHAR2, node_id NUMBER, node_name VARCHAR2, geom_id NUMBER, 
  --  measure NUMBER, geom SDO_GEOMETRY),

  NOT INSTANTIABLE MEMBER PROCEDURE delete_node(
    net_mem VARCHAR2, node_id NUMBER),

  NOT INSTANTIABLE MEMBER PROCEDURE add_link(
    net_mem VARCHAR2, link_id NUMBER, link_name VARCHAR2, start_node_id NUMBER, 
    end_node_id NUMBER, cost NUMBER),

  NOT INSTANTIABLE MEMBER PROCEDURE add_lrs_link(
    net_mem VARCHAR2, link_id NUMBER, link_name VARCHAR2, start_node_id NUMBER, 
    end_node_id NUMBER, cost NUMBER, geom_id NUMBER, start_measure NUMBER, 
    end_measure NUMBER),

  NOT INSTANTIABLE MEMBER PROCEDURE add_sdo_link(
    net_mem VARCHAR2, link_id NUMBER, link_name VARCHAR2, start_node_id NUMBER, 
    end_node_id NUMBER, geom SDO_GEOMETRY,    cost NUMBER),

  NOT INSTANTIABLE MEMBER PROCEDURE delete_link(
    net_mem VARCHAR2, link_id NUMBER),

  NOT INSTANTIABLE MEMBER PROCEDURE add_path(
    net_mem VARCHAR2, path_id NUMBER),

  NOT INSTANTIABLE MEMBER PROCEDURE add_path(
    net_mem VARCHAR2, path_ids SDO_NUMBER_ARRAY),

  NOT INSTANTIABLE MEMBER PROCEDURE delete_path(
    net_mem VARCHAR2, path_id NUMBER)
) NOT INSTANTIABLE NOT FINAL';
EXCEPTION
  WHEN OTHERS THEN NULL;
END;
/
show errors;

BEGIN
  EXECUTE IMMEDIATE
'CREATE OR REPLACE TYPE SDO_NETWORK_I 
  AUTHID current_user
  UNDER SDO_NETWORK_T(

  -- STATIC PROCEDURE add_node_s(net_mem VARCHAR2, node_id NUMBER)
  -- AS LANGUAGE JAVA NAME
  -- ''oracle.spatial.type.NetworkWrapper.addNode(
  --  java.lang.String, oracle.sql.NUMBER)'',

  -- OVERRIDING MEMBER PROCEDURE add_node(net_mem VARCHAR2, node_id NUMBER),


  -- STATIC PROCEDURE add_node_s(net_mem VARCHAR2,node_id NUMBER,node_name String)
  -- AS LANGUAGE JAVA NAME
  -- ''oracle.spatial.type.NetworkWrapper.addNode(
  --  java.lang.String, oracle.sql.NUMBER, java.lang.String)'',

  -- OVERRIDING MEMBER PROCEDURE add_node(
  --  net_mem VARCHAR2, node_id NUMBER, node_name String),

  -----------------------------------------------------
  -- external_network_id: not used. can be any value --
  -- external_node_id:    not used. can be any value --
  -----------------------------------------------------
  STATIC PROCEDURE add_node_s(net_mem VARCHAR2,node_id NUMBER,node_name String,    
   external_network_id NUMBER, external_node_id NUMBER)
   AS LANGUAGE JAVA NAME
   ''oracle.spatial.type.NetworkWrapper.addNode(
    java.lang.String, oracle.sql.NUMBER, java.lang.String, oracle.sql.NUMBER, 
    oracle.sql.NUMBER)'',

  -----------------------------------------------------
  -- external_network_id: not used. can be any value --
  -- external_node_id:    not used. can be any value --
  -----------------------------------------------------
  OVERRIDING MEMBER PROCEDURE add_node(
    net_mem VARCHAR2, node_id NUMBER, node_name String, 
    external_network_id NUMBER, external_node_id NUMBER),


  -- STATIC PROCEDURE add_node_s(net_mem VARCHAR2, node_id NUMBER, x NUMBER, 
  -- y NUMBER, external_network_id NUMBER, external_node_id NUMBER)
  -- AS LANGUAGE JAVA NAME
  -- ''oracle.spatial.type.NetworkWrapper.addNode(
  --  java.lang.String, oracle.sql.NUMBER, oracle.sql.NUMBER,    
  --  oracle.sql.NUMBER, oracle.sql.NUMBER, oracle.sql.NUMBER)'',

  -- OVERRIDING MEMBER PROCEDURE add_node(
  --  net_mem VARCHAR2, node_id NUMBER, x NUMBER, y NUMBER, 
  --  external_network_id NUMBER, external_node_id NUMBER),

  -----------------------------------------------------
  -- external_network_id: not used. can be any value --
  -- external_node_id:    not used. can be any value --
  -----------------------------------------------------
  STATIC PROCEDURE add_sdo_node_s(net_mem VARCHAR2, node_id NUMBER, 
   node_name VARCHAR2, x NUMBER, y NUMBER,  
   external_network_id NUMBER, external_node_id NUMBER)
   AS LANGUAGE JAVA NAME
   ''oracle.spatial.type.NetworkWrapper.addSdoNode(
    java.lang.String, oracle.sql.NUMBER, java.lang.String, oracle.sql.NUMBER, 
    oracle.sql.NUMBER, oracle.sql.NUMBER, oracle.sql.NUMBER)'',

  -----------------------------------------------------
  -- external_network_id: not used. can be any value --
  -- external_node_id:    not used. can be any value --
  -----------------------------------------------------
  OVERRIDING MEMBER PROCEDURE add_sdo_node(
    net_mem VARCHAR2, node_id NUMBER, node_name VARCHAR2, x NUMBER, y NUMBER, 
    external_network_id NUMBER, external_node_id NUMBER),

  -----------------------------------------------------
  -- external_network_id: not used. can be any value --
  -- external_node_id:    not used. can be any value --
  -----------------------------------------------------
  STATIC PROCEDURE add_lrs_node_s(net_mem VARCHAR2, node_id NUMBER, 
   node_name VARCHAR2, geom_id NUMBER, measure NUMBER, geom SDO_GEOMETRY,    
   external_network_id NUMBER, external_node_id NUMBER)
   AS LANGUAGE JAVA NAME
   ''oracle.spatial.type.NetworkWrapper.addLRSNode(
    java.lang.String, oracle.sql.NUMBER, java.lang.String, oracle.sql.NUMBER, 
    oracle.sql.NUMBER, oracle.spatial.type.SdoGeometry, oracle.sql.NUMBER,     
    oracle.sql.NUMBER)'',

  -----------------------------------------------------
  -- external_network_id: not used. can be any value --
  -- external_node_id:    not used. can be any value --
  -----------------------------------------------------
  OVERRIDING MEMBER PROCEDURE add_lrs_node(
    net_mem VARCHAR2, node_id NUMBER, node_name VARCHAR2, geom_id NUMBER, 
    measure NUMBER, geom SDO_GEOMETRY, external_network_id NUMBER, 
    external_node_id NUMBER),


  -- STATIC PROCEDURE add_lrs_node_s(net_mem VARCHAR2, node_id NUMBER, 
  -- node_name VARCHAR2,    geom_id NUMBER, measure NUMBER, geom SDO_GEOMETRY)
  -- AS LANGUAGE JAVA NAME
  -- ''oracle.spatial.type.NetworkWrapper.addLRSNode(
  --  java.lang.String, oracle.sql.NUMBER, java.lang.String, oracle.sql.NUMBER, 
  --  oracle.sql.NUMBER, oracle.spatial.type.SdoGeometry)'',

  -- OVERRIDING MEMBER PROCEDURE add_lrs_node(
  --  net_mem VARCHAR2, node_id NUMBER, node_name VARCHAR2, geom_id NUMBER, 
  --  measure NUMBER, geom SDO_GEOMETRY),


  STATIC PROCEDURE delete_node_s(net_mem VARCHAR2, node_id NUMBER)
   AS LANGUAGE JAVA NAME
   ''oracle.spatial.type.NetworkWrapper.deleteNode(
    java.lang.String, oracle.sql.NUMBER)'',

  OVERRIDING MEMBER PROCEDURE delete_node(
    net_mem VARCHAR2, node_id NUMBER),


  STATIC PROCEDURE add_link_s(net_mem VARCHAR2, link_id NUMBER, 
   link_name VARCHAR2, start_node_id NUMBER, end_node_id NUMBER, cost NUMBER)
   AS LANGUAGE JAVA NAME
   ''oracle.spatial.type.NetworkWrapper.addLink(
    java.lang.String, oracle.sql.NUMBER, java.lang.String, oracle.sql.NUMBER, 
    oracle.sql.NUMBER, oracle.sql.NUMBER)'',

  OVERRIDING MEMBER PROCEDURE add_link(
    net_mem VARCHAR2, link_id NUMBER, link_name VARCHAR2, start_node_id NUMBER, 
    end_node_id NUMBER, cost NUMBER),


  STATIC PROCEDURE add_lrs_link_s(net_mem VARCHAR2, link_id NUMBER, 
   link_name VARCHAR2, start_node_id NUMBER, end_node_id NUMBER, cost NUMBER,   
   geom_id NUMBER, start_measure NUMBER, end_measure NUMBER)
   AS LANGUAGE JAVA NAME
   ''oracle.spatial.type.NetworkWrapper.addLink(
    java.lang.String, oracle.sql.NUMBER, java.lang.String, oracle.sql.NUMBER, 
    oracle.sql.NUMBER, oracle.sql.NUMBER, oracle.sql.NUMBER, oracle.sql.NUMBER, 
    oracle.sql.NUMBER)'',

  OVERRIDING MEMBER PROCEDURE add_lrs_link(
    net_mem VARCHAR2, link_id NUMBER, link_name VARCHAR2, start_node_id NUMBER, 
    end_node_id NUMBER, cost NUMBER,   geom_id NUMBER, start_measure NUMBER, 
    end_measure NUMBER),


  STATIC PROCEDURE add_sdo_link_s(net_mem VARCHAR2, link_id NUMBER,
   link_name VARCHAR2,    start_node_id NUMBER, end_node_id NUMBER, 
   geom SDO_GEOMETRY,    cost NUMBER)
   AS LANGUAGE JAVA NAME
   ''oracle.spatial.type.NetworkWrapper.addLink(
    java.lang.String, oracle.sql.NUMBER, java.lang.String, oracle.sql.NUMBER, 
    oracle.sql.NUMBER, oracle.spatial.type.SdoGeometry, oracle.sql.NUMBER)'',

  OVERRIDING MEMBER PROCEDURE add_sdo_link(
    net_mem VARCHAR2, link_id NUMBER, link_name VARCHAR2, start_node_id NUMBER, 
    end_node_id NUMBER, geom SDO_GEOMETRY, cost NUMBER),
    

  STATIC PROCEDURE delete_link_s(net_mem VARCHAR2, link_id NUMBER)
   AS LANGUAGE JAVA NAME
   ''oracle.spatial.type.NetworkWrapper.deleteLink(
    java.lang.String, oracle.sql.NUMBER)'',

  OVERRIDING MEMBER PROCEDURE delete_link(
    net_mem VARCHAR2, link_id NUMBER),


  STATIC PROCEDURE add_path_s(net_mem VARCHAR2, path_id NUMBER)
   AS LANGUAGE JAVA NAME
   ''oracle.spatial.type.NetworkWrapper.addPath(
    java.lang.String, oracle.sql.NUMBER)'',

  OVERRIDING MEMBER PROCEDURE add_path(
    net_mem VARCHAR2, path_id NUMBER),


  STATIC PROCEDURE add_path_s(net_mem VARCHAR2, path_ids SDO_NUMBER_ARRAY)
   AS LANGUAGE JAVA NAME
   ''oracle.spatial.type.NetworkWrapper.addPath(
    java.lang.String, oracle.spatial.type.SdoNumberArray)'',

  OVERRIDING MEMBER PROCEDURE add_path(
    net_mem VARCHAR2, path_ids SDO_NUMBER_ARRAY),


  STATIC PROCEDURE delete_path_s(net_mem VARCHAR2, path_id NUMBER)
   AS LANGUAGE JAVA NAME
   ''oracle.spatial.type.NetworkWrapper.deletePath(
    java.lang.String, oracle.sql.NUMBER)'',

  OVERRIDING MEMBER PROCEDURE delete_path(
    net_mem VARCHAR2, path_id NUMBER)
)';
EXCEPTION
  WHEN OTHERS THEN NULL;
END;
/
show errors;

-- revalidate SDO_NETWORK_MANAGER_T 
BEGIN  
  EXECUTE IMMEDIATE 'ALTER TYPE SDO_NETWORK_T COMPILE';
EXCEPTION
  WHEN OTHERS THEN NULL;
END;
/
show errors;

--- Bug fix 6036980
BEGIN 

  EXECUTE IMMEDIATE 
    ' ALTER TYPE SDO_NETWORK_I NOT INSTANTIABLE NOT FINAL CASCADE';
  
  EXECUTE IMMEDIATE
  'ALTER  TYPE SDO_NETWORK_T ADD
   NOT INSTANTIABLE MEMBER FUNCTION get_max_link_id(net_mem IN VARCHAR2) 
      RETURN NUMBER DETERMINISTIC CASCADE';

  EXECUTE IMMEDIATE
  'ALTER  TYPE SDO_NETWORK_T ADD
   NOT INSTANTIABLE MEMBER FUNCTION get_max_node_id(net_mem IN VARCHAR2) 
      RETURN NUMBER DETERMINISTIC CASCADE';

  EXECUTE IMMEDIATE
  'ALTER  TYPE SDO_NETWORK_T ADD
   NOT INSTANTIABLE MEMBER FUNCTION get_max_path_id(net_mem IN VARCHAR2) 
      RETURN NUMBER DETERMINISTIC CASCADE';

  EXECUTE IMMEDIATE
  'ALTER  TYPE SDO_NETWORK_T ADD
   NOT INSTANTIABLE MEMBER FUNCTION get_max_subpath_id(net_mem IN VARCHAR2) 
      RETURN NUMBER DETERMINISTIC CASCADE';

  EXECUTE IMMEDIATE 'ALTER TYPE SDO_NETWORK_T COMPILE';

  EXECUTE IMMEDIATE
  'ALTER  TYPE SDO_NETWORK_I ADD
   STATIC FUNCTION get_max_link_id_s(net_mem IN VARCHAR2) 
      RETURN NUMBER DETERMINISTIC 
      AS LANGUAGE JAVA NAME
      ''oracle.spatial.type.NetworkWrapper.getMaxLinkID(java.lang.String)
      return oracle.spatial.NUMBER''';

  EXECUTE IMMEDIATE 
  'ALTER TYPE SDO_NETWORK_I ADD
   OVERRIDING MEMBER FUNCTION get_max_link_id(net_mem IN VARCHAR2)
      RETURN NUMBER DETERMINISTIC';

  EXECUTE IMMEDIATE
  'ALTER  TYPE SDO_NETWORK_I ADD
   STATIC FUNCTION get_max_node_id_s(net_mem IN VARCHAR2) 
      RETURN NUMBER DETERMINISTIC
      AS LANGUAGE JAVA NAME
      ''oracle.spatial.type.NetworkWrapper.getMaxNodeID(java.lang.String)
      return oracle.spatial.NUMBER''';

  EXECUTE IMMEDIATE
  'ALTER  TYPE SDO_NETWORK_I ADD
   OVERRIDING MEMBER FUNCTION get_max_node_id(net_mem IN VARCHAR2) 
      RETURN NUMBER DETERMINISTIC';

  EXECUTE IMMEDIATE
  'ALTER  TYPE SDO_NETWORK_I ADD
   STATIC FUNCTION get_max_path_id_s(net_mem IN VARCHAR2) 
      RETURN NUMBER DETERMINISTIC
      AS LANGUAGE JAVA NAME
      ''oracle.spatial.type.NetworkWrapper.getMaxPathID(java.lang.String)
      return oracle.spatial.NUMBER''';

  EXECUTE IMMEDIATE
  'ALTER  TYPE SDO_NETWORK_I ADD
   OVERRIDING MEMBER FUNCTION get_max_path_id(net_mem IN VARCHAR2) 
      RETURN NUMBER DETERMINISTIC';

  EXECUTE IMMEDIATE
  'ALTER  TYPE SDO_NETWORK_I ADD
   STATIC FUNCTION get_max_subpath_id_s(net_mem IN VARCHAR2) 
      RETURN NUMBER DETERMINISTIC
      AS LANGUAGE JAVA NAME
      ''oracle.spatial.type.NetworkWrapper.getMaxSubPathID(java.lang.String)
      return oracle.spatial.NUMBER''';

  EXECUTE IMMEDIATE
  'ALTER  TYPE SDO_NETWORK_I ADD
   OVERRIDING MEMBER FUNCTION get_max_subpath_id(net_mem IN VARCHAR2) 
      RETURN NUMBER DETERMINISTIC';

  -- need to make it instantiable for sdo_net_mem to instantiate it
  EXECUTE IMMEDIATE
    ' ALTER TYPE SDO_NETWORK_I INSTANTIABLE  CASCADE';

EXCEPTION
  WHEN OTHERS THEN BEGIN
    EXECUTE IMMEDIATE
      ' ALTER TYPE SDO_NETWORK_I INSTANTIABLE CASCADE';
    DBMS_OUTPUT.PUT_LINE('Error condition at bug fix 6036980');
  END;
END;
/
show errors

--- End of Bug fix 6036980

--- Bug 6036857 fix
BEGIN 

  EXECUTE IMMEDIATE 
    ' ALTER TYPE SDO_NETWORK_I NOT INSTANTIABLE NOT FINAL CASCADE';

  -- modify add_sdo_node
  EXECUTE IMMEDIATE
  'ALTER  TYPE SDO_NETWORK_I DROP
   OVERRIDING MEMBER PROCEDURE add_sdo_node(
    net_mem VARCHAR2, node_id NUMBER, node_name VARCHAR2, x NUMBER, y NUMBER,
    external_network_id NUMBER, external_node_id NUMBER) CASCADE';
  
  EXECUTE IMMEDIATE
  'ALTER  TYPE SDO_NETWORK_T DROP
   NOT INSTANTIABLE MEMBER PROCEDURE add_sdo_node(
    net_mem VARCHAR2, node_id NUMBER, node_name VARCHAR2, x NUMBER, y NUMBER,
    external_network_id NUMBER, external_node_id NUMBER) CASCADE';

  EXECUTE IMMEDIATE 
  'ALTER TYPE SDO_NETWORK_T ADD NOT INSTANTIABLE MEMBER PROCEDURE add_sdo_node(
    net_mem VARCHAR2, node_id NUMBER, node_name VARCHAR2, x NUMBER, y NUMBER,
    srid NUMBER, external_network_id NUMBER, external_node_id NUMBER) 
    CASCADE';


  EXECUTE IMMEDIATE 
  'ALTER TYPE SDO_NETWORK_I ADD OVERRIDING MEMBER PROCEDURE add_sdo_node(
    net_mem VARCHAR2, node_id NUMBER, node_name VARCHAR2, x NUMBER, y NUMBER,
    srid NUMBER, external_network_id NUMBER, external_node_id NUMBER) 
    CASCADE';

  EXECUTE IMMEDIATE
  'ALTER TYPE SDO_NETWORK_I DROP STATIC PROCEDURE add_sdo_node_s(net_mem VARCHAR2, 
    node_id NUMBER, node_name VARCHAR2, x NUMBER, y NUMBER, external_network_id NUMBER, 
    external_node_id NUMBER) CASCADE';

  EXECUTE IMMEDIATE
  'ALTER TYPE SDO_NETWORK_I ADD STATIC PROCEDURE add_sdo_node_s(net_mem VARCHAR2, 
   node_id NUMBER, node_name VARCHAR2, x NUMBER, y NUMBER, srid NUMBER,
   external_network_id NUMBER, external_node_id NUMBER) AS LANGUAGE JAVA NAME
   ''oracle.spatial.type.NetworkWrapper.addSdoNode(java.lang.String,
    oracle.sql.NUMBER, java.lang.String, oracle.sql.NUMBER, oracle.sql.NUMBER, 
    oracle.sql.NUMBER, oracle.sql.NUMBER,  oracle.sql.NUMBER)''';


  -- modify add_node
  EXECUTE IMMEDIATE
  'ALTER  TYPE SDO_NETWORK_I DROP
   OVERRIDING MEMBER PROCEDURE add_node(
    net_mem VARCHAR2, node_id NUMBER, node_name String,
    external_network_id NUMBER, external_node_id NUMBER) CASCADE';

  EXECUTE IMMEDIATE
  'ALTER  TYPE SDO_NETWORK_T DROP
   NOT INSTANTIABLE MEMBER PROCEDURE add_node(
    net_mem VARCHAR2, node_id NUMBER, node_name String,
    external_network_id NUMBER, external_node_id NUMBER) CASCADE';

  EXECUTE IMMEDIATE
  'ALTER  TYPE SDO_NETWORK_T ADD
   NOT INSTANTIABLE MEMBER PROCEDURE add_node(
    net_mem VARCHAR2, node_id NUMBER,  node_name VARCHAR2, 
    geom SDO_GEOMETRY DEFAULT NULL, external_network_id NUMBER, 
    external_node_id NUMBER) CASCADE';

  EXECUTE IMMEDIATE 
   'ALTER  TYPE SDO_NETWORK_I ADD
    OVERRIDING MEMBER PROCEDURE add_node(
    net_mem VARCHAR2, 
    node_id NUMBER, 
    node_name VARCHAR2, 
    geom SDO_GEOMETRY DEFAULT NULL, 
    external_network_id NUMBER, 
    external_node_id NUMBER) CASCADE';

  EXECUTE IMMEDIATE
   'ALTER TYPE SDO_NETWORK_I DROP
    STATIC PROCEDURE add_node_s(net_mem VARCHAR2,node_id NUMBER,
    node_name String, external_network_id NUMBER, 
    external_node_id NUMBER) CASCADE';

  EXECUTE IMMEDIATE
   'ALTER TYPE SDO_NETWORK_I ADD
    STATIC PROCEDURE add_node_s(net_mem VARCHAR2,node_id NUMBER,
    node_name VARCHAR2, geom SDO_GEOMETRY, external_network_id NUMBER, 
    external_node_id NUMBER) AS LANGUAGE JAVA NAME
   ''oracle.spatial.type.NetworkWrapper.addNode(
    java.lang.String, oracle.sql.NUMBER, java.lang.String, 
    oracle.spatial.type.SdoGeometry,oracle.sql.NUMBER, oracle.sql.NUMBER)''';

  -- need to make it instantiable for sdo_net_mem to instantiate it
  EXECUTE IMMEDIATE
    ' ALTER TYPE SDO_NETWORK_I INSTANTIABLE CASCADE';

EXCEPTION
  WHEN OTHERS THEN BEGIN
    EXECUTE IMMEDIATE
      ' ALTER TYPE SDO_NETWORK_I INSTANTIABLE CASCADE';
    DBMS_OUTPUT.PUT_LINE('Error condition at bug fix 6036857');
  END; 
END;
/
show errors

--- End of Bug 6036857 fix

--- Bug 6036757 fix
BEGIN 

  EXECUTE IMMEDIATE 
    ' ALTER TYPE SDO_NETWORK_MANAGER_I NOT INSTANTIABLE NOT FINAL CASCADE';

  -- modify create_sdo_network
  EXECUTE IMMEDIATE
  'ALTER  TYPE SDO_NETWORK_MANAGER_I DROP
   OVERRIDING MEMBER PROCEDURE create_sdo_network(network_name VARCHAR2, 
    no_of_hierarchy_levels NUMBER, is_directed VARCHAR2, srid NUMBER,
    no_of_dims NUMBER, node_table_name VARCHAR2, node_geom_column VARCHAR2, 
    node_cost_column VARCHAR2, link_table_name VARCHAR2, 
    link_geom_column VARCHAR2, link_cost_column VARCHAR2, 
    path_table_name VARCHAR2, path_geom_column VARCHAR2, 
    path_link_table_name VARCHAR2, is_complex VARCHAR2) CASCADE';  

  EXECUTE IMMEDIATE
  'ALTER  TYPE SDO_NETWORK_MANAGER_T DROP
   NOT INSTANTIABLE MEMBER PROCEDURE create_sdo_network(network_name VARCHAR2, 
    no_of_hierarchy_levels NUMBER, is_directed VARCHAR2, srid NUMBER,
    no_of_dims NUMBER, node_table_name VARCHAR2, node_geom_column VARCHAR2, 
    node_cost_column VARCHAR2, link_table_name VARCHAR2, 
    link_geom_column VARCHAR2, link_cost_column VARCHAR2, 
    path_table_name VARCHAR2, path_geom_column VARCHAR2, 
    path_link_table_name VARCHAR2, is_complex VARCHAR2) CASCADE';

  EXECUTE IMMEDIATE
  'ALTER  TYPE SDO_NETWORK_MANAGER_T ADD
   NOT INSTANTIABLE MEMBER PROCEDURE create_sdo_network(network_name VARCHAR2, 
    no_of_hierarchy_levels NUMBER, is_directed VARCHAR2, srid NUMBER,
    no_of_dims NUMBER, node_table_name VARCHAR2 DEFAULT NULL, 
    node_geom_column VARCHAR2 DEFAULT NULL, 
    node_cost_column VARCHAR2 DEFAULT NULL, 
    link_table_name VARCHAR2  DEFAULT NULL, 
    link_geom_column VARCHAR2 DEFAULT NULL, 
    link_cost_column VARCHAR2 DEFAULT NULL, 
    path_table_name  VARCHAR2 DEFAULT NULL, 
    path_geom_column VARCHAR2 DEFAULT NULL, 
    path_link_table_name VARCHAR2 DEFAULT NULL, 
    sub_path_table_name VARCHAR2 DEFAULT NULL,
    sub_path_geom_column VARCHAR2 DEFAULT NULL,
    is_complex VARCHAR2 DEFAULT ''FALSE'') CASCADE';

  EXECUTE IMMEDIATE
  'ALTER  TYPE SDO_NETWORK_MANAGER_I ADD
   OVERRIDING MEMBER PROCEDURE create_sdo_network(
    network_name VARCHAR2, 
    no_of_hierarchy_levels NUMBER, 
    is_directed VARCHAR2, 
    srid NUMBER,
    no_of_dims NUMBER, 
    node_table_name VARCHAR2 DEFAULT NULL, 
    node_geom_column VARCHAR2 DEFAULT NULL, 
    node_cost_column VARCHAR2 DEFAULT NULL, 
    link_table_name VARCHAR2  DEFAULT NULL, 
    link_geom_column VARCHAR2 DEFAULT NULL, 
    link_cost_column VARCHAR2 DEFAULT NULL, 
    path_table_name  VARCHAR2 DEFAULT NULL, 
    path_geom_column VARCHAR2 DEFAULT NULL, 
    path_link_table_name VARCHAR2 DEFAULT NULL, 
    sub_path_table_name VARCHAR2 DEFAULT NULL,
    sub_path_geom_column VARCHAR2 DEFAULT NULL,
    is_complex VARCHAR2 DEFAULT ''FALSE'') CASCADE';

  EXECUTE IMMEDIATE
  'ALTER TYPE SDO_NETWORK_MANAGER_I DROP STATIC PROCEDURE 
   create_sdo_network_s(network_name VARCHAR2, 
    no_of_hierarchy_levels NUMBER, is_directed VARCHAR2, srid NUMBER,
    no_of_dims NUMBER, node_table_name VARCHAR2, node_geom_column VARCHAR2, 
    node_cost_column VARCHAR2, link_table_name VARCHAR2, 
    link_geom_column VARCHAR2, link_cost_column VARCHAR2, 
    path_table_name VARCHAR2, path_geom_column VARCHAR2, 
    path_link_table_name VARCHAR2, is_complex VARCHAR2) CASCADE';

  EXECUTE IMMEDIATE
  'ALTER TYPE SDO_NETWORK_MANAGER_I ADD STATIC PROCEDURE 
   create_sdo_network_s(network_name VARCHAR2,
    no_of_hierarchy_levels NUMBER,
    is_directed VARCHAR2,
    srid NUMBER,
    no_of_dims NUMBER,
    node_table_name VARCHAR2, node_geom_column VARCHAR2, 
    node_cost_column VARCHAR2, link_table_name VARCHAR2,
    link_geom_column VARCHAR2, link_cost_column VARCHAR2, 
    path_table_name VARCHAR2, path_geom_column VARCHAR2,
    path_link_table_name VARCHAR2, 
    sub_path_table_name VARCHAR2,
    sub_path_geom_column VARCHAR2,
    is_complex VARCHAR2
     ) AS LANGUAGE JAVA NAME
    ''oracle.spatial.type.NetworkWrapper.createSDONetwork(java.lang.String,
      oracle.sql.NUMBER, java.lang.String, oracle.sql.NUMBER,
      oracle.sql.NUMBER,  java.lang.String,
      java.lang.String, java.lang.String,
      java.lang.String, java.lang.String, java.lang.String, 
      java.lang.String, java.lang.String, java.lang.String, 
      java.lang.String, java.lang.String, java.lang.String)''';

  -- modify create_lrs_network
  EXECUTE IMMEDIATE
  'ALTER  TYPE SDO_NETWORK_MANAGER_I DROP
   OVERRIDING MEMBER PROCEDURE create_lrs_network(
    network_name VARCHAR2, 
    no_of_hierarchy_levels NUMBER, is_directed VARCHAR2, srid NUMBER,
    no_of_dims NUMBER, 
    node_table_name VARCHAR2, node_cost_column VARCHAR2, 
    link_table_name VARCHAR2, link_cost_column VARCHAR2,
    lrs_table_name  VARCHAR2, lrs_geom_column VARCHAR2,  
    path_table_name VARCHAR2, path_geom_column VARCHAR2, 
    path_link_table_name VARCHAR2, is_complex VARCHAR2) CASCADE';  

  EXECUTE IMMEDIATE
  'ALTER  TYPE SDO_NETWORK_MANAGER_T DROP
   NOT INSTANTIABLE MEMBER PROCEDURE create_lrs_network(
    network_name VARCHAR2, 
    no_of_hierarchy_levels NUMBER, is_directed VARCHAR2, srid NUMBER,
    no_of_dims NUMBER, 
    node_table_name VARCHAR2, node_cost_column VARCHAR2, 
    link_table_name VARCHAR2, link_cost_column VARCHAR2,
    lrs_table_name  VARCHAR2, lrs_geom_column VARCHAR2,  
    path_table_name VARCHAR2, path_geom_column VARCHAR2, 
    path_link_table_name VARCHAR2, is_complex VARCHAR2
   ) CASCADE';

  EXECUTE IMMEDIATE
  'ALTER  TYPE SDO_NETWORK_MANAGER_T ADD
   NOT INSTANTIABLE MEMBER PROCEDURE create_lrs_network(
    network_name VARCHAR2, 
    no_of_hierarchy_levels NUMBER, is_directed VARCHAR2, 
    srid NUMBER, no_of_dims NUMBER, 
    node_table_name VARCHAR2 DEFAULT NULL, 
    node_cost_column VARCHAR2 DEFAULT NULL, 
    link_table_name VARCHAR2 DEFAULT NULL, 
    link_cost_column VARCHAR2 DEFAULT NULL,
    lrs_table_name  VARCHAR2, 
    lrs_geom_column VARCHAR2,  
    path_table_name VARCHAR2 DEFAULT NULL, 
    path_geom_column VARCHAR2 DEFAULT NULL, 
    path_link_table_name VARCHAR2 DEFAULT NULL, 
    sub_path_table_name VARCHAR2 DEFAULT NULL,
    sub_path_geom_column VARCHAR2 DEFAULT NULL,
    is_complex VARCHAR2 DEFAULT ''FALSE''
   ) CASCADE';

  EXECUTE IMMEDIATE
  'ALTER  TYPE SDO_NETWORK_MANAGER_I ADD
   OVERRIDING MEMBER PROCEDURE create_lrs_network(
    network_name VARCHAR2, 
    no_of_hierarchy_levels NUMBER, 
    is_directed VARCHAR2, 
    srid NUMBER, no_of_dims NUMBER, 
    node_table_name VARCHAR2 DEFAULT NULL, 
    node_cost_column VARCHAR2 DEFAULT NULL, 
    link_table_name VARCHAR2 DEFAULT NULL, 
    link_cost_column VARCHAR2 DEFAULT NULL,
    lrs_table_name  VARCHAR2, 
    lrs_geom_column VARCHAR2,  
    path_table_name VARCHAR2 DEFAULT NULL, 
    path_geom_column VARCHAR2 DEFAULT NULL, 
    path_link_table_name VARCHAR2 DEFAULT NULL, 
    sub_path_table_name VARCHAR2 DEFAULT NULL,
    sub_path_geom_column VARCHAR2 DEFAULT NULL,
    is_complex VARCHAR2 DEFAULT ''FALSE''  
  ) CASCADE';

  EXECUTE IMMEDIATE
  'ALTER TYPE SDO_NETWORK_MANAGER_I DROP STATIC PROCEDURE 
   create_lrs_network_s(
    network_name VARCHAR2, 
    no_of_hierarchy_levels NUMBER, is_directed VARCHAR2, 
    srid NUMBER, no_of_dims NUMBER, 
    node_table_name VARCHAR2, 
    node_cost_column VARCHAR2, 
    link_table_name VARCHAR2, 
    link_cost_column VARCHAR2,
    lrs_table_name  VARCHAR2, 
    lrs_geom_column VARCHAR2,  
    path_table_name VARCHAR2, 
    path_geom_column VARCHAR2, 
    path_link_table_name VARCHAR2, 
    is_complex VARCHAR2  
  ) CASCADE';


  EXECUTE IMMEDIATE
  'ALTER TYPE SDO_NETWORK_MANAGER_I ADD STATIC PROCEDURE    
  create_lrs_network_s(
    network_name VARCHAR2, 
    no_of_hierarchy_levels NUMBER, 
    is_directed VARCHAR2, 
    srid NUMBER, 
    no_of_dims NUMBER, 
    node_table_name VARCHAR2, 
    node_cost_column VARCHAR2, 
    link_table_name VARCHAR2, 
    link_cost_column VARCHAR2,
    lrs_table_name  VARCHAR2, 
    lrs_geom_column VARCHAR2,  
    path_table_name VARCHAR2, 
    path_geom_column VARCHAR2, 
    path_link_table_name VARCHAR2,
    sub_path_table_name VARCHAR2,
    sub_path_geom_column VARCHAR2,
    is_complex VARCHAR2
     ) AS LANGUAGE JAVA NAME
    ''oracle.spatial.type.NetworkWrapper.createLRSNetwork(
      java.lang.String, oracle.sql.NUMBER, java.lang.String, 
      oracle.sql.NUMBER, oracle.sql.NUMBER, java.lang.String, 
      java.lang.String, java.lang.String, java.lang.String, 
      java.lang.String, java.lang.String, java.lang.String, 
      java.lang.String, java.lang.String, java.lang.String, 
      java.lang.String, java.lang.String)''';

  -- modify create_logical_network
  EXECUTE IMMEDIATE
  'ALTER  TYPE SDO_NETWORK_MANAGER_I DROP
   OVERRIDING MEMBER PROCEDURE create_logical_network(network_name VARCHAR2,
    no_of_hierarchy_levels NUMBER,   is_directed           VARCHAR2, 
    node_table_name VARCHAR2,        node_cost_column      VARCHAR2, 
    link_table_name VARCHAR2,        link_cost_column      VARCHAR2, 
    path_table_name VARCHAR2,        path_link_table_name  VARCHAR2, 
    is_complex VARCHAR2  
   ) CASCADE';
 
  EXECUTE IMMEDIATE
  'ALTER  TYPE SDO_NETWORK_MANAGER_T DROP
   NOT INSTANTIABLE MEMBER PROCEDURE create_logical_network(network_name VARCHAR2,
    no_of_hierarchy_levels NUMBER,   is_directed           VARCHAR2, 
    node_table_name VARCHAR2,        node_cost_column      VARCHAR2, 
    link_table_name VARCHAR2,        link_cost_column      VARCHAR2, 
    path_table_name VARCHAR2,        path_link_table_name  VARCHAR2, 
    is_complex VARCHAR2  
  ) CASCADE';


  EXECUTE IMMEDIATE
  'ALTER  TYPE SDO_NETWORK_MANAGER_T ADD
   NOT INSTANTIABLE MEMBER PROCEDURE create_logical_network(
    network_name VARCHAR2, 
    no_of_hierarchy_levels NUMBER, is_directed VARCHAR2,  
    node_table_name VARCHAR2 DEFAULT NULL, 
    node_cost_column VARCHAR2 DEFAULT NULL, 
    link_table_name VARCHAR2 DEFAULT NULL, 
    link_cost_column VARCHAR2 DEFAULT NULL,
    path_table_name VARCHAR2 DEFAULT NULL,  
    path_link_table_name VARCHAR2 DEFAULT NULL, 
    sub_path_table_name VARCHAR2 DEFAULT NULL,
    is_complex VARCHAR2 DEFAULT ''FALSE'' 
   ) CASCADE';

  EXECUTE IMMEDIATE
  'ALTER  TYPE SDO_NETWORK_MANAGER_I ADD
   OVERRIDING MEMBER PROCEDURE create_logical_network(network_name VARCHAR2,
     no_of_hierarchy_levels NUMBER,   
     is_directed VARCHAR2, 
     node_table_name VARCHAR2 DEFAULT NULL,        
     node_cost_column VARCHAR2 DEFAULT NULL,
     link_table_name VARCHAR2 DEFAULT NULL,        
     link_cost_column VARCHAR2  DEFAULT NULL,
     path_table_name VARCHAR2 DEFAULT NULL,        
     path_link_table_name  VARCHAR2 DEFAULT NULL, 
     sub_path_table_name VARCHAR2 DEFAULT NULL,    
     is_complex VARCHAR2 DEFAULT ''FALSE''  
   ) CASCADE';

  EXECUTE IMMEDIATE 
  'ALTER TYPE SDO_NETWORK_MANAGER_I DROP STATIC PROCEDURE
   create_logical_network_s(network_name VARCHAR2,
    no_of_hierarchy_levels NUMBER,   is_directed           VARCHAR2,
    node_table_name VARCHAR2,        node_cost_column      VARCHAR2,
    link_table_name VARCHAR2,        link_cost_column      VARCHAR2,
    path_table_name VARCHAR2,        path_link_table_name  VARCHAR2,
    is_complex VARCHAR2  )
    AS LANGUAGE JAVA NAME
    ''oracle.spatial.type.NetworkWrapper.createLogicalNetwork(java.lang.String,
     oracle.sql.NUMBER, java.lang.String,
     java.lang.String, java.lang.String,
     java.lang.String, java.lang.String,
     java.lang.String, java.lang.String,
     java.lang.String)''';
 

  EXECUTE IMMEDIATE
  'ALTER TYPE SDO_NETWORK_MANAGER_I ADD STATIC PROCEDURE    
   create_logical_network_s(network_name VARCHAR2,
    no_of_hierarchy_levels NUMBER,   is_directed           VARCHAR2, 
    node_table_name VARCHAR2,        node_cost_column      VARCHAR2, 
    link_table_name VARCHAR2,        link_cost_column      VARCHAR2, 
    path_table_name VARCHAR2,        path_link_table_name  VARCHAR2, 
    sub_path_table_name VARCHAR2,    is_complex VARCHAR2  )
    AS LANGUAGE JAVA NAME
    ''oracle.spatial.type.NetworkWrapper.createLogicalNetwork(java.lang.String,
     oracle.sql.NUMBER, java.lang.String,
     java.lang.String, java.lang.String, 
     java.lang.String, java.lang.String, 
     java.lang.String, java.lang.String, 
     java.lang.String, java.lang.String)''';
 
  -- add get_default_value function
  EXECUTE IMMEDIATE
  'ALTER TYPE SDO_NETWORK_MANAGER_I ADD STATIC FUNCTION    
  get_default_value_s(
    parameter   VARCHAR2, 
    default_val VARCHAR2) RETURN VARCHAR2';   

  -- need to make it instantiable for sdo_net_mem to instantiate it
  EXECUTE IMMEDIATE
    ' ALTER TYPE SDO_NETWORK_MANAGER_I INSTANTIABLE  CASCADE';

EXCEPTION
  WHEN OTHERS THEN BEGIN
    EXECUTE IMMEDIATE
      ' ALTER TYPE SDO_NETWORK_MANAGER_I INSTANTIABLE CASCADE';
    DBMS_OUTPUT.PUT_LINE('Error condition at bug fix 6036757');
  END;
END;
/
show errors;

--- End of Bug 6036757 fix

--- Bug 6653556 fix
BEGIN

  EXECUTE IMMEDIATE
    ' ALTER TYPE SDO_NODE_I NOT INSTANTIABLE NOT FINAL CASCADE';

  EXECUTE IMMEDIATE
  'ALTER  TYPE SDO_NODE_I DROP
    STATIC  FUNCTION get_external_network_id_s(
    net_mem VARCHAR2, node_id NUMBER) RETURN NUMBER CASCADE';

  EXECUTE IMMEDIATE
  'ALTER  TYPE SDO_NODE_I DROP
    OVERRIDING MEMBER FUNCTION get_external_network_id(
    net_mem VARCHAR2, node_id NUMBER) RETURN NUMBER CASCADE';


  EXECUTE IMMEDIATE
  'ALTER  TYPE SDO_NODE_T DROP
   NOT INSTANTIABLE MEMBER FUNCTION get_external_network_id(
    net_mem VARCHAR2, node_id NUMBER) RETURN NUMBER CASCADE';

  EXECUTE IMMEDIATE
  'ALTER  TYPE SDO_NODE_I DROP
     STATIC PROCEDURE set_external_network_id_s(net_mem VARCHAR2, node_id NUMBER,
     external_network_id NUMBER) CASCADE';

  EXECUTE IMMEDIATE
  'ALTER  TYPE SDO_NODE_I DROP
     OVERRIDING MEMBER PROCEDURE set_external_network_id(
     net_mem VARCHAR2, node_id NUMBER,    external_network_id NUMBER) CASCADE';

  EXECUTE IMMEDIATE
  'ALTER  TYPE SDO_NODE_T DROP
    NOT INSTANTIABLE MEMBER PROCEDURE set_external_network_id(
    net_mem VARCHAR2, node_id NUMBER,    external_network_id NUMBER) CASCADE';

  EXECUTE IMMEDIATE
  'ALTER  TYPE SDO_NODE_I DROP
    STATIC  FUNCTION get_external_node_id_s(
    net_mem VARCHAR2, id NUMBER) RETURN NUMBER CASCADE';

  EXECUTE IMMEDIATE
  'ALTER  TYPE SDO_NODE_I DROP
    OVERRIDING MEMBER FUNCTION get_external_node_id(
    net_mem VARCHAR2, id NUMBER) RETURN NUMBER CASCADE';
  
  EXECUTE IMMEDIATE
  'ALTER  TYPE SDO_NODE_T DROP
   NOT INSTANTIABLE MEMBER FUNCTION get_external_node_id(
    net_mem VARCHAR2, id NUMBER) RETURN NUMBER CASCADE';

  EXECUTE IMMEDIATE
   'ALTER  TYPE SDO_NODE_I DROP
     STATIC PROCEDURE set_external_node_id_s(net_mem VARCHAR2, node_id NUMBER,
   external_node_id NUMBER) CASCADE';
     
  EXECUTE IMMEDIATE
   'ALTER  TYPE SDO_NODE_I DROP
     OVERRIDING MEMBER PROCEDURE set_external_node_id(
     net_mem VARCHAR2, node_id NUMBER,    external_node_id NUMBER) CASCADE';
     
  EXECUTE IMMEDIATE
  'ALTER  TYPE SDO_NODE_T DROP
    NOT INSTANTIABLE MEMBER PROCEDURE set_external_node_id(
    net_mem VARCHAR2, node_id NUMBER,    external_node_id NUMBER) CASCADE'; 

  EXECUTE IMMEDIATE
  'ALTER  TYPE SDO_NODE_I DROP
     STATIC FUNCTION get_external_network_name_s(net_mem VARCHAR2, node_id NUMBER)
     RETURN VARCHAR2 CASCADE'; 
  
   EXECUTE IMMEDIATE
   'ALTER  TYPE SDO_NODE_I DROP
     OVERRIDING MEMBER FUNCTION get_external_network_name(
        net_mem VARCHAR2, node_id NUMBER) RETURN VARCHAR2 CASCADE'; 
  
  EXECUTE IMMEDIATE
  'ALTER  TYPE SDO_NODE_T DROP
      NOT INSTANTIABLE MEMBER FUNCTION get_external_network_name(
         net_mem VARCHAR2, node_id NUMBER) RETURN VARCHAR2 CASCADE';

  EXECUTE IMMEDIATE
   'ALTER  TYPE SDO_NODE_I DROP
     STATIC FUNCTION is_external_node_s(net_mem VARCHAR2, node_id NUMBER)
     RETURN VARCHAR2  CASCADE';
  
  EXECUTE IMMEDIATE
   'ALTER  TYPE SDO_NODE_I DROP
      OVERRIDING MEMBER FUNCTION is_external_node(
      net_mem VARCHAR2, node_id NUMBER) RETURN VARCHAR2 CASCADE';
    
  EXECUTE IMMEDIATE
  'ALTER  TYPE SDO_NODE_T DROP
     NOT INSTANTIABLE MEMBER FUNCTION is_external_node(
     net_mem VARCHAR2, node_id NUMBER) RETURN VARCHAR2 CASCADE';
   
  EXECUTE IMMEDIATE
    ' ALTER TYPE SDO_NODE_I INSTANTIABLE CASCADE';

  EXECUTE IMMEDIATE
    ' ALTER TYPE SDO_LINK_I NOT INSTANTIABLE NOT FINAL CASCADE';
 
  EXECUTE IMMEDIATE
   'ALTER  TYPE SDO_LINK_I DROP
      STATIC FUNCTION is_external_link_s(net_mem VARCHAR2, link_id NUMBER)
      RETURN VARCHAR2 CASCADE';
      
  EXECUTE IMMEDIATE
   'ALTER  TYPE SDO_LINK_I DROP
       OVERRIDING MEMBER FUNCTION is_external_link(
       net_mem VARCHAR2, link_id NUMBER) RETURN VARCHAR2 CASCADE';
   
  EXECUTE IMMEDIATE
  'ALTER  TYPE SDO_LINK_T DROP
       NOT INSTANTIABLE MEMBER FUNCTION is_external_link(
         net_mem VARCHAR2, link_id NUMBER) RETURN VARCHAR2 CASCADE';

  EXECUTE IMMEDIATE
    ' ALTER TYPE SDO_LINK_I INSTANTIABLE CASCADE';


EXCEPTION
  WHEN OTHERS THEN 
  BEGIN
    EXECUTE IMMEDIATE
     ' ALTER TYPE SDO_NODE_I INSTANTIABLE CASCADE';

    EXECUTE IMMEDIATE
     ' ALTER TYPE SDO_LINK_I INSTANTIABLE CASCADE';

    DBMS_OUTPUT.PUT_LINE('Error condition at line bug fix 6653556');
  END;
END;
/
show errors;
--- End of Bug 6653556 fix

--- Bug 7135481 fix

BEGIN 

  EXECUTE IMMEDIATE
    ' ALTER TYPE SDO_NETWORK_I NOT INSTANTIABLE NOT FINAL CASCADE';
  
  -- modify create_sdo_network
  EXECUTE IMMEDIATE
  'ALTER  TYPE SDO_NETWORK_I DROP
   OVERRIDING MEMBER PROCEDURE add_lrs_link(
    net_mem VARCHAR2, link_id NUMBER, link_name VARCHAR2, start_node_id NUMBER,
    end_node_id NUMBER, cost NUMBER,   geom_id NUMBER, start_measure NUMBER,
    end_measure NUMBER) CASCADE';

  EXECUTE IMMEDIATE
  'ALTER  TYPE SDO_NETWORK_T DROP
   NOT INSTANTIABLE MEMBER PROCEDURE add_lrs_link(
    net_mem VARCHAR2, link_id NUMBER, link_name VARCHAR2, start_node_id NUMBER,
    end_node_id NUMBER, cost NUMBER, geom_id NUMBER, start_measure NUMBER,
    end_measure NUMBER) CASCADE';
  
  EXECUTE IMMEDIATE
  'ALTER  TYPE SDO_NETWORK_T ADD
   NOT INSTANTIABLE MEMBER PROCEDURE add_lrs_link(
    net_mem VARCHAR2, link_id NUMBER, link_name VARCHAR2, start_node_id NUMBER,
    end_node_id NUMBER, cost NUMBER, geom_id NUMBER, start_measure NUMBER,
    end_measure NUMBER, geom SDO_GEOMETRY) CASCADE';

  EXECUTE IMMEDIATE
  'ALTER  TYPE SDO_NETWORK_I ADD
   OVERRIDING MEMBER PROCEDURE add_lrs_link(
    net_mem VARCHAR2, link_id NUMBER, link_name VARCHAR2, start_node_id NUMBER,
    end_node_id NUMBER, cost NUMBER,   geom_id NUMBER, start_measure NUMBER,
    end_measure NUMBER, geom SDO_GEOMETRY) CASCADE';

  EXECUTE IMMEDIATE
  'ALTER TYPE SDO_NETWORK_I DROP 
   STATIC PROCEDURE add_lrs_link_s(net_mem VARCHAR2, link_id NUMBER,
   link_name VARCHAR2, start_node_id NUMBER, end_node_id NUMBER, cost NUMBER,
   geom_id NUMBER, start_measure NUMBER, end_measure NUMBER) CASCADE';

  EXECUTE IMMEDIATE
  'ALTER TYPE SDO_NETWORK_I ADD
   STATIC PROCEDURE add_lrs_link_s(net_mem VARCHAR2, link_id NUMBER,
   link_name VARCHAR2, start_node_id NUMBER, end_node_id NUMBER, cost NUMBER,
   geom_id NUMBER, start_measure NUMBER, end_measure NUMBER, geom SDO_GEOMETRY)
   AS LANGUAGE JAVA NAME
   ''oracle.spatial.type.NetworkWrapper.addLink(
    java.lang.String, oracle.sql.NUMBER, java.lang.String, oracle.sql.NUMBER,
    oracle.sql.NUMBER, oracle.sql.NUMBER, oracle.sql.NUMBER, oracle.sql.NUMBER,
    oracle.sql.NUMBER, oracle.spatial.type.SdoGeometry)''';

  -- need to make it instantiable for sdo_net_mem to instantiate it
  EXECUTE IMMEDIATE
    ' ALTER TYPE SDO_NETWORK_I INSTANTIABLE  CASCADE';

EXCEPTION
  WHEN OTHERS THEN BEGIN
    EXECUTE IMMEDIATE
      ' ALTER TYPE SDO_NETWORK_I INSTANTIABLE CASCADE';
    DBMS_OUTPUT.PUT_LINE('Error condition at bug fix 7135481');
  END;
END;
/
show errors;

--- end of Bug 7135481 fix


GRANT EXECUTE ON sdo_network_t TO PUBLIC;
CREATE OR REPLACE PUBLIC SYNONYM sdo_network_t 
  FOR mdsys.sdo_network_t;





