Rem
Rem $Header: sdo/admin/sdordfctx.sql /st_sdo_11.2.0.1/1 2009/06/10 11:51:46 ayalaman Exp $
Rem
Rem sdordftx.sql
Rem
Rem Copyright (c) 2009, Oracle and/or its affiliates. All rights reserved. 
Rem
Rem    NAME
Rem      sdordftx.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    ayalaman    06/10/09 - XbranchMerge ayalaman_bug-8588089 from main
Rem    ayalaman    06/09/09 - stylesheet for web-service information extractor
Rem    matperry    05/26/09 - remove WHENEVER SQLERROR EXIT
Rem    ayalaman    05/20/09 - add methods set_extractor_param to rdfctx
Rem    ayalaman    05/07/09 - gate nlp integration
Rem    ayalaman    04/14/09 - handling 3rd party license key
Rem    ayalaman    03/19/09 - rename select operator 
Rem    ayalaman    03/10/09 - ctx_entity extractor
Rem    ayalaman    02/27/09 - user ontologies and rule bases
Rem    ayalaman    02/09/09 - domain index implementation
Rem    ayalaman    01/13/09 - RDF text search
Rem    ayalaman    01/13/09 - Created
Rem

--WHENEVER SQLERROR EXIT;

declare
  rc NUMBER;
begin
  select count(*) into rc from all_objects where owner = 'MDSYS' and
    object_name = 'SDO_RDF';
  if (not(dbms_registry.version('SDO') like '11.%') or rc = 0) then
     raise_application_error(-20000, 'RDF Component not installed:'||
        'RDF Component for 11.1 or above must be installed.');
  end if;
end;
/

create role rdfctx_admin; 

WHENEVER SQLERROR CONTINUE;

grant execute on DBMS_NETWORK_ACL_ADMIN to mdsys; 

BEGIN
  DBMS_NETWORK_ACL_ADMIN.create_acl (
    acl          => 'mdsys_rdfctx.xml', 
    description  => 'ACL for web service access from MDSYS',
    principal    => 'MDSYS',
    is_grant     => TRUE, 
    privilege    => 'connect',
    start_date   => SYSTIMESTAMP,
    end_date     => NULL);
  COMMIT;
exception 
  when others then 
    if (SQLCODE != -31003) then
      raise;  
    end if; 
END;
/

alter session set current_schema = MDSYS;

/*****************************************************************************/
/*** Text extractor for semantic searches                                  ***/
/*****************************************************************************/
create or replace type rdfctx_extractor authid current_user as object (

  extr_type  VARCHAR2(32), 

  member procedure startDriver,

  member function getDescription return VARCHAR2, 

  -- 'RDF/XML','RDF/XML-ESC', etc
  member function rdfReturnType return VARCHAR2, 
  -- In some cases, the rdf/xml text has escape sequences for the
  -- XML tags which makes them invalid XML. Hence a generic CLOB type is 
  -- is used. 
  member function extractRdf(document CLOB, 
                             docId    VARCHAR2) return CLOB,

  member procedure closeDriver

) not instantiable not final
/ 

show errors; 

grant execute on rdfctx_extractor to public;

/*****************************************************************************/
/*** Text extractor that is implemented as a web service                   ***/
/*****************************************************************************/
create or replace type rdfctx_ws_extractor under rdfctx_extractor (

  ws_end_point VARCHAR2(1024), 
  ws_soap_act  VARCHAR2(1024), 
  ws_envelope  CLOB,
  ws_xsltrans  sys.XMLType, 

  overriding member function getDescription return VARCHAR2, 

  overriding member function rdfReturnType return VARCHAR2, 

  -- sets the proxy server for the current instance -- 
  overriding member procedure startDriver,

  -- post the http request to the web service end-point and 
  -- returns the response -- 
  overriding member function extractRdf(document CLOB, 
                                        docId    VARCHAR2) return CLOB,

  -- closes the driver -- 
  overriding member procedure closeDriver

) not instantiable not final 
/

show errors; 

grant execute on rdfctx_ws_extractor to public; 

/*****************************************************************************/
/*** SEM_RDFCTX : Package for configuring Semantic search on Text          ***/
/*****************************************************************************/
create or replace package sem_rdfctx authid current_user as

  procedure create_policy (
              policy_name        VARCHAR2, 
              extractor          mdsys.rdfctx_extractor, 
              preferences        sys.XMLType default null); 

  procedure create_policy (
              policy_name        VARCHAR2, 
              base_policy        VARCHAR2, 
              user_models        mdsys.rdf_models default null, 
              rulebases          mdsys.rdf_rulebases default null); 

  procedure drop_policy (
              policy_name        VARCHAR2); 

  procedure set_default_policy (
              index_name         VARCHAR2, 
              policy_name        VARCHAR2); 

  function extract_rdfxml (
              doc                CLOB,
              ext_type           mdsys.rdfctx_extractor) return CLOB;

  procedure maintain_triples (
              index_name         VARCHAR2, 
              where_clause       VARCHAR2,
              rdfxml_content     sys.XMLType,
              policy_name        VARCHAR2 default NULL, 
              action             VARCHAR2 default 'ADD'); 

  procedure set_extractor_param (
              param_key         VARCHAR2, 
              param_value       VARCHAR2, 
              param_desc        VARCHAR2); 

end sem_rdfctx; 
/

show errors; 

create public synonym sem_rdfctx for mdsys.sem_rdfctx; 

grant execute on sem_rdfctx to public; 

/*****************************************************************************/
/*** CALAIS Extractor : web service extractor                              ***/
/*****************************************************************************/
create or replace type calais_extractor under rdfctx_ws_extractor (

  constructor function calais_extractor (
                                  extr_params   sys.XMLType default null)
    return self as result,

  constructor function calais_extractor (
                                  ws_end_point  VARCHAR2,
                                  ws_soap_act   VARCHAR2,
                                  extr_params   sys.XMLType default null)
    return self as result, 

  overriding member function extractRdf(document CLOB, 
                                        docId    VARCHAR2) return CLOB

)
/

grant execute on calais_extractor to public; 

/*****************************************************************************/
/*** CTX_ENTITY_EXTRACTOR : Oracle Context extractor                       ***/ 
/*****************************************************************************/
create or replace type ctx_entity_extractor under rdfctx_extractor (

  epl_policy  VARCHAR2(30),
  xsl_trans   sys.XMLtype, 
  
  constructor function ctx_entity_extractor (
                 epl_policy  VARCHAR2, 
                 base_url    VARCHAR2 default null) return self as result, 
  
  constructor function ctx_entity_extractor (
                 epl_policy  VARCHAR2, 
                 xsl_trans   sys.xmltype) return self as result, 

  overriding member function getDescription return VARCHAR2,

  overriding member function rdfReturnType return VARCHAR2,

  overriding member function extractRdf(document CLOB,
                                        docId    VARCHAR2) return CLOB

)
/

grant execute on ctx_entity_extractor to public; 

create or replace type gatenlp_extractor under mdsys.rdfctx_extractor (

  gate_host  VARCHAR2(100),
  gate_port  NUMBER,
  xsl_trans  sys.XMLtype, 

  constructor function gatenlp_extractor (base_url  VARCHAR2 default null)
                    return self as result,

  constructor function gatenlp_extractor (xsl_trans  sys.xmltype)
                    return self as result,

  overriding member function getDescription return VARCHAR2,

  overriding member function extractRdf (document CLOB,
                                         docId    VARCHAR2) return CLOB

);
/

grant execute on gatenlp_extractor to public; 

@@prvtrdfctx.plb

/*****************************************************************************/
/*** Indextype and Operators                                               ***/
/*****************************************************************************/
create or replace operator sem_contains binding 
  (VARCHAR2, VARCHAR2) return NUMBER 
    WITH INDEX CONTEXT, SCAN CONTEXT  SemContextIndexMethods
    COMPUTE ANCILLARY DATA
    USING mdsys.sem_rdfctx_oper.sem_contains,
  (VARCHAR2, VARCHAR2, mdsys.RDF_ALIASES) return NUMBER 
    WITH INDEX CONTEXT, SCAN CONTEXT  SemContextIndexMethods
    COMPUTE ANCILLARY DATA
    USING mdsys.sem_rdfctx_oper.sem_contains,
  (VARCHAR2, VARCHAR2, VARCHAR2) return NUMBER
    WITH INDEX CONTEXT, SCAN CONTEXT  SemContextIndexMethods
    COMPUTE ANCILLARY DATA
    USING mdsys.sem_rdfctx_oper.sem_contains,
  (VARCHAR2, VARCHAR2, VARCHAR2, mdsys.RDF_ALIASES) return NUMBER
    WITH INDEX CONTEXT, SCAN CONTEXT  SemContextIndexMethods
    COMPUTE ANCILLARY DATA
    USING mdsys.sem_rdfctx_oper.sem_contains,
  (CLOB, VARCHAR2) return NUMBER
    WITH INDEX CONTEXT, SCAN CONTEXT  SemContextIndexMethods
    COMPUTE ANCILLARY DATA
    USING mdsys.sem_rdfctx_oper.sem_contains, 
  (CLOB, VARCHAR2, mdsys.RDF_ALIASES) return NUMBER
    WITH INDEX CONTEXT, SCAN CONTEXT  SemContextIndexMethods
    COMPUTE ANCILLARY DATA
    USING mdsys.sem_rdfctx_oper.sem_contains, 
  (CLOB, VARCHAR2, VARCHAR2) return NUMBER
    WITH INDEX CONTEXT, SCAN CONTEXT  SemContextIndexMethods
    COMPUTE ANCILLARY DATA
    USING mdsys.sem_rdfctx_oper.sem_contains,
  (CLOB, VARCHAR2, VARCHAR2, mdsys.RDF_ALIASES) return NUMBER
    WITH INDEX CONTEXT, SCAN CONTEXT  SemContextIndexMethods
    COMPUTE ANCILLARY DATA
    USING mdsys.sem_rdfctx_oper.sem_contains; 

grant execute on sem_contains to public; 

create or replace public synonym sem_contains for mdsys.sem_contains; 

create or replace operator sem_contains_select binding
   (NUMBER) return CLOB
    ANCILLARY TO mdsys.SEM_CONTAINS (VARCHAR2, VARCHAR2), 
                 mdsys.SEM_CONTAINS (VARCHAR2, VARCHAR2, mdsys.RDF_ALIASES),
                 mdsys.SEM_CONTAINS (VARCHAR2, VARCHAR2, VARCHAR2),
                 mdsys.SEM_CONTAINS (VARCHAR2, VARCHAR2, VARCHAR2, mdsys.RDF_ALIASES),
                 mdsys.SEM_CONTAINS (CLOB, VARCHAR2),
                 mdsys.SEM_CONTAINS (CLOB, VARCHAR2, mdsys.RDF_ALIASES),
                 mdsys.SEM_CONTAINS (CLOB, VARCHAR2, VARCHAR2),
                 mdsys.SEM_CONTAINS (CLOB, VARCHAR2, VARCHAR2, mdsys.RDF_ALIASES)
    USING mdsys.sem_rdfctx_oper.sem_rdfctx_select; 

grant execute on sem_contains_select to public;

create or replace public synonym sem_contains_select for mdsys.sem_contains_select; 

create indextype SemContext for
   SEM_CONTAINS(VARCHAR2, VARCHAR2),
   SEM_CONTAINS(VARCHAR2, VARCHAR2, mdsys.RDF_ALIASES),
   SEM_CONTAINS(VARCHAR2, VARCHAR2, VARCHAR2),
   SEM_CONTAINS(VARCHAR2, VARCHAR2, VARCHAR2, mdsys.RDF_ALIASES),
   SEM_CONTAINS(CLOB, VARCHAR2),
   SEM_CONTAINS(CLOB, VARCHAR2, mdsys.RDF_ALIASES),
   SEM_CONTAINS(CLOB, VARCHAR2, VARCHAR2),
   SEM_CONTAINS(CLOB, VARCHAR2, VARCHAR2, mdsys.RDF_ALIASES)
using SemContextIndexMethods;

grant execute on SemContext to public;

begin
  insert into mdsys.rdf_parameter (namespace, attribute, value, description)
     values ('COMPONENT','RDFCTX','INSTALLED','Semantic (Text) Search component'); 
exception 
  when dup_val_on_index then null;
end;
/
commit; 

