Rem
Rem $Header: sdo/admin/sdordfctx_rm.sql /main/6 2009/05/28 09:16:02 matperry Exp $
Rem
Rem sdordfctx_rm.sql
Rem
Rem Copyright (c) 2009, Oracle and/or its affiliates. All rights reserved. 
Rem
Rem    NAME
Rem      sdordfctx_rm.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    matperry    05/26/09 - remove WHENEVER SQLERROR EXIT
Rem    ayalaman    05/18/09 - remove schema unset
Rem    ayalaman    05/07/09 - remove gate extractor
Rem    ayalaman    03/30/09 - rdfctx_select to contains_select
Rem    ayalaman    03/10/09 - CTX entity extractor
Rem    ayalaman    01/14/09 - uninstall RDF text search
Rem    ayalaman    01/14/09 - Created
Rem

alter session set current_schema = MDSYS; 

--WHENEVER SQLERROR EXIT;
declare
  hasprfs NUMBER; 
begin
  begin
    EXECUTE IMMEDIATE 'select count(*)  from mdsys.rdfctx_index_policies$'
      INTO hasprfs;
  exception 
    when others then 
     if (sqlcode != -942) then
       raise; 
     end if; 
  end; 
  if (hasprfs > 0) then 
    raise_application_error(-20000, 'RDFCTX index exists: '||
          'Drop all indexes before uninstalling RDFCTX component'); 
  end if; 
end;
/

WHENEVER SQLERROR CONTINUE;

declare
  dumvr VARCHAR2(30); 
begin
  select value into dumvr from mdsys.rdf_parameter
     where namespace = 'COMPONENT' and attribute = 'RDFCTX';
  if (dumvr is not null) then
    execute immediate 'begin mdsys.sem_rdfctx_dr.cleanup_rdfctx; end;'; 
  end if;
exception when others then null;
end;
/ 

drop package sem_rdfctx_dr; 

drop package sem_rdfctx_ir; 

drop package sem_rdfctx;

drop public synonym sem_rdfctx;

drop type calais_extractor force; 

drop type rdfctx_ws_extractor force; 

drop type gatenlp_extractor force; 

drop type ctx_entity_extractor force; 

drop type rdfctx_extractor force; 

drop indextype mdsys.SemContext; 

drop public synonym SEM_CONTAINS_SELECT; 

drop operator mdsys.SEM_CONTAINS_SELECT; 

drop public synonym SEM_CONTAINS; 

drop operator mdsys.SEM_CONTAINS; 

drop type mdsys.SemContextIndexMethods; 

drop package mdsys.sem_rdfctx_oper; 

delete from rdf_parameter where namespace = 'RDFCTXOPT'; 

delete from rdf_parameter where namespace = 'COMPONENT' and attribute = 'RDFCTX'; 

begin
   DBMS_NETWORK_ACL_ADMIN.drop_acl (
     acl          => 'mdsys_rdfctx.xml');
end;
/

commit; 

drop role rdfctx_admin; 

