Rem
Rem $Header: sdo/admin/sdordfsa.sql /main/4 2009/05/28 09:16:02 matperry Exp $
Rem
Rem sdordfsa.sql
Rem
Rem Copyright (c) 2008, 2009, Oracle and/or its affiliates. 
Rem All rights reserved. 
Rem
Rem    NAME
Rem      sdordfsa.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    matperry    05/26/09 - remove WHENEVER SQLERROR EXIT
Rem    ayalaman    01/28/09 - dml with rdf vpd
Rem    ayalaman    01/05/09 - capture install status in parameter table
Rem    ayalaman    12/21/08 - move rdf_resource to sdordfty.sql
Rem    ayalaman    09/17/08 - vpd for rdf data
Rem    sdas        07/28/08 - RDF OLS
Rem    sdas        07/28/08 - Created
Rem


--
-- Best practices: 
--  - The meta tags should have sensitivity labels that can only 
--    be read/written by an Application developer. 
--
--WHENEVER SQLERROR EXIT;

declare
  rc NUMBER;
begin
  select count(*) into rc from all_objects where owner = 'MDSYS' and 
    object_name = 'SDO_RDF'; 
  if (not(dbms_registry.version('SDO') like '11.%') or rc = 0) then 
     raise_application_error(-20000, 'RDF Component not installed:'||
        'RDF Component for 11.1 or above must be installed.');
  end if; 
end;
/

-- additional privileges to MDSYS -- 
-- to gather information about policies associated with MDSYS tables -- 
-- Let the RDFSA package installation go through even if OLS is not 
-- installed. -- 
create or replace procedure mdsys.rdf$grant_ols_privs authid current_user  is 
begin
execute immediate 'grant select on lbacsys.DBA_SA_TABLE_POLICIES to mdsys';
execute immediate 'grant select on lbacsys.DBA_SA_LABELS to mdsys'; 
execute immediate 'grant select on lbacsys.DBA_SA_GROUPS to mdsys'; 
execute immediate 'grant select on lbacsys.DBA_SA_LEVELS to mdsys';
execute immediate 'grant select on lbacsys.DBA_SA_COMPARTMENTS to mdsys'; 
execute immediate 'grant execute on lbacsys.NUMERIC_DOMINATES to mdsys'; 
end;
/

begin
  if (dbms_registry.version('OLS') = 'VALID') then 
    mdsys.rdf$grant_ols_privs; 
  end if; 
end;
/

-- used to prevent application table triple access -- 
grant execute on dbms_rls to mdsys; 
-- to get application table names from ids -- 
grant select on DBA_OBJECTS to mdsys; 

-- used for system trigger - already granted -- 
grant administer database trigger to mdsys;
grant execute on dbms_scheduler to mdsys;
grant create job to mdsys; 

-- required for inference and bulk load. Specifically MERGE STMT and EXCH PART -- 
grant exempt access policy to mdsys;

alter session set current_schema = MDSYS; 
--alter session set Plsql_CCFlags = ' Tracing:true'; 

WHENEVER SQLERROR CONTINUE;
--
--- Type and Package specifications 
--
/*****************************************************************************/
/*** Type used for Extensible Label Generator for Inferred data            ***/
/*****************************************************************************/
begin 
execute immediate 
'create or replace type rdfsa_resource as object (
  res_id      VARCHAR2(100), 
  res_type    NUMBER, 
  res_labels  MDSYS.INT_ARRAY, 
  constructor function rdfsa_resource (res_id VARCHAR2, res_type number) 
                                            return self as result, 
  constructor function rdfsa_resource (res_id VARCHAR2, 
         res_type number, res_label number) return self as result, 
  constructor function rdfsa_resource (res_id VARCHAR2, res_type number, 
                res_labels mdsys.int_array) return self as result, 
  member function getResource return VARCHAR2,
  member function getLabelCount return number, 
  member function getLabel(idx number default 1) return number
)'; 
exception 
  when others then 
    if (sqlcode != -2303) then  -- may already exist 
      raise;
    end if; 
end;
/

show errors; 

/*****************************************************************************/
/**** Label generator stub for Extensible implementations                  ***/
/***  This type can be extended for custom label generators                ***/
/*****************************************************************************/
create or replace type mdsys.rdfsa_labelgen authid current_user as object (
  gen_option   NUMBER,

  -- 
  --- SETDEPRESOURCES : to set the dependent resources for the label   
  --- generator. Information about these resources will be passed to the
  --- the getNumericLabel method at runtime                              
  ---                                                                    
  --- Usage:  setDepResources(sem_rdfsa.USE_SUBJECT_LABEL+
  ---                         sem_rdfsa.USE_RULE_LABEL) 
  --
  final member procedure setDepResources(useres number), 

  -- 
  --- FINDOMINATINGOF : Find a clear dominating label out of the labels 
  --- passed in. -1 is returned if a clear dominating label is not found -- 
  final static function findDominatingOf(labels MDSYS.INT_ARRAY) return number, 

  --
  --- GETNUMERICLABEL : Extensible implementations for this type should   
  --- override this method to return a custom label based on the resources 
  --- passed in. The exact list of resources passed in is dependent on    
  --- options passed to the setDepResource method                        
  --
  member function getNumericLabel (subject   rdfsa_resource, 
                                   predicate rdfsa_resource, 
                                   object    rdfsa_resource, 
                                   rule      rdfsa_resource, 
                                   anteced   rdfsa_resource) 
       return number

) not final
/

show errors; 


grant execute on mdsys.rdfsa_resource to public;

create or replace public synonym rdfsa_resource for  mdsys.rdfsa_resource; 

grant execute on mdsys.int_array to public; 

--grant execute on mdsys.rdfsa_labelgen to public;
--grant under on mdsys.rdfsa_labelgen to public;

/*****************************************************************************/
/*** DBMS_RDFSA : Package for enabling fine-grained security for RDF       ***/
/*****************************************************************************/
create or replace package sem_rdfsa authid current_user is 

   --
   --- secure options passed to APPLY_OLS_POLICY API -- 
   --
   SECURE_SUBJECT             CONSTANT SIMPLE_INTEGER := 1; 
   SECURE_PREDICATE           CONSTANT SIMPLE_INTEGER := 2; 
   SECURE_OBJECT              CONSTANT SIMPLE_INTEGER := 4; 

   --
   --- Additional options for OLS enable RDF data --
   --
   -- DEFINE_BEFORE_USE: subject or predicate, when secured should be 
   -- pre-defined with a label (set_resource_label/set_predicate_label) 
   -- before they can be used in a triple - 
   OPT_DEFINE_BEFORE_USE      CONSTANT SIMPLE_INTEGER := 16; 
   -- RELAX_TRIPLE_LABEL: The default behavior is that the Triple's label
   -- dominates the labels associated with each of its components. 
   -- With this option, a triple label is set to user's initial row 
   -- label and the only check performed at the time of triple insertion 
   -- is that the user has READ access to its components. 
   OPT_RELAX_TRIPLE_LABEL     CONSTANT SIMPLE_INTEGER := 32; 

   --
   --- Resource options for Inference Label Generators 
   --
   USE_SUBJECT_LABEL          CONSTANT SIMPLE_INTEGER := 128; 
   USE_PREDICATE_LABEL        CONSTANT SIMPLE_INTEGER := 512; 
   USE_OBJECT_LABEL           CONSTANT SIMPLE_INTEGER := 1024; 
   USE_RULE_LABEL             CONSTANT SIMPLE_INTEGER := 2048; 
   USE_DOMINATING_LABEL       CONSTANT SIMPLE_INTEGER := 4096;
   USE_ANTECED_LABELS         CONSTANT SIMPLE_INTEGER := 8192; 
   CUSTOM_LABELGEN            CONSTANT SIMPLE_INTEGER := 16384;

   --
   ---  Predefined label generators for inference. To be used with 
   ---  create_entailment API. 
   --
   LABELGEN_SUBJECT           CONSTANT mdsys.rdfsa_labelgen := 
                                 mdsys.rdfsa_labelgen(USE_SUBJECT_LABEL);
   LABELGEN_PREDICATE         CONSTANT mdsys.rdfsa_labelgen := 
                                 mdsys.rdfsa_labelgen(USE_PREDICATE_LABEL); 
   LABELGEN_OBJECT            CONSTANT mdsys.rdfsa_labelgen :=
                                 mdsys.rdfsa_labelgen(USE_OBJECT_LABEL); 
   LABELGEN_RULE              CONSTANT mdsys.rdfsa_labelgen :=
                                 mdsys.rdfsa_labelgen(USE_RULE_LABEL); 
   LABELGEN_DOMINATING        CONSTANT mdsys.rdfsa_labelgen :=
                                 mdsys.rdfsa_labelgen(USE_DOMINATING_LABEL); 

   VPD_FULL_ACCESS            CONSTANT VARCHAR2(32) := 'RDFVPD$FULLACCESS'; 
   -- 
   --- APPLY_OLS_POLICY : Apply OLS policy for RDF data. 
   --- See SA_POLICY_ADMIN.APPLY_TABLE_POLICY for details.
   --
   procedure apply_ols_policy (
              policy_name      VARCHAR2, 
              rdfsa_options    NUMBER   default sem_rdfsa.SECURE_SUBJECT, 
              table_options    VARCHAR2 default 'ALL_CONTROL', 
              label_function   VARCHAR2 default null,
              predicate        VARCHAR2 default null); 

   --
   --- REMOVE_OLS_POLICY : Remove the OLS policy for RDF data
   --- Only a security administrator can execute this command. 
   --
   procedure remove_ols_policy; 

   --
   --- DISABLE_OLS_POLICY : Disable OLS policy for RDF data. 
   --- set_resource_label/set_predicate_label can still be used to set labels
   --- for specific tags. 
   --- Only a security administrator can execute this command. 
   -- 
   procedure disable_ols_policy; 

   --
   --- ENABLE_OLS_POLICY : Enable OLS policy after disabling. 
   --- Only a security administrator can execute this command. 
   --
   procedure enable_ols_policy; 

   --
   --- RESET_MODEL_LABELS : Reset the labels for all triples in a model. 
   --- Only the user with FULL access on the OLS policy can execute this 
   --- command. The model must be empty (of triples) for this operation 
   --- to succeed. 
   -- 
   procedure reset_model_labels (
              model_name       VARCHAR2); 

   --  
   --- SET_RESOURCE_LABEL : Set a label for a resource (URI) which may 
   --- be used as a Subject or an Object. The resource position is 
   --- defaulted to 'S' (Subject) and 'S,O' may be specified to secure 
   --- the resource in the Object position as well. 
   --- Model Name RDF$GLOBAL can be used to set the label for a resource 
   --- across models. 
   --
   procedure set_resource_label (
              model_name       VARCHAR2,
              resource_uri     VARCHAR2, 
              label_string     VARCHAR2, 
              resource_pos     VARCHAR2 default 'S'); 

   --
   --- SET_PREDICATE_LABEL : Set a label for predicate in a specific 
   --- model or across all models (RDF$GLOBAL) in the instance. 
   --- 
   procedure set_predicate_label (
              model_name       VARCHAR2, 
              predicate        VARCHAR2, 
              label_string     VARCHAR2); 

   --
   --- SET_RDFS_LABEL : The RDFS Vocabulary elements such as Class,  
   --- subPropertyOf, may be assigned a specfic label to restrict 
   --- the users from creating new classes and properties. The 
   --- inference override label is used by the label generator to 
   --- determine the appropriate labels for the inferred triples. 
   ---
   procedure set_rdfs_label (
              label_string     VARCHAR2,
              inf_override     VARCHAR2 default null);  

   --
   --- SET_RULE_LABEL : Set label for rule. The rule's label 
   --- can be used as the default label for the triples inferred 
   --- by this rule. (PARTIAL SUPPORT with RDFs rules and no 
   --- support for User defined rules)
   --
   procedure set_rule_label (
              rule_base        VARCHAR2, 
              rule_name        VARCHAR2, 
              label_string     VARCHAR2); 

   -- VPD interfaces --- 
   -- The VPD policy will be implicitly created in the current 
   -- schema. An RDF VPD policy may be used to enforce constraints
   -- on one or more RDF models. 
   procedure create_vpd_policy (
              policy_name      VARCHAR2, 
              namespace_map    RDF_ALIASES default null, 
              policy_context   VARCHAR2 default null); 

   -- Drop the VPD policy defined in the current schema. -- 
   procedure drop_vpd_policy (
              policy_name      VARCHAR2); 

   -- Apply a VPD policy to a model -- 
   procedure apply_vpd_policy (
              policy_name      VARCHAR2, 
              model_name       VARCHAR2, 
              oper_type        VARCHAR2 default 'ALL'); 

   -- Remove the VPD policy from a model -- 
   procedure remove_vpd_policy (
              policy_name      VARCHAR2, 
              model_name       VARCHAR2); 

   -- Maintain the VPD metadata in the form of RDF scehma statements
   -- associated with policy. Only a fixed set of predicate types are 
   -- recognized and accepted by the VPD metadata. 
   procedure maint_vpd_metadata (
              policy_name      VARCHAR2, 
              t_subject        VARCHAR2, 
              t_predicate      VARCHAR2,
              t_object         VARCHAR2,
              action           VARCHAR2 default 'ADD');  

   -- Add a constraint to the VPD policy -- 
   procedure add_vpd_constraint (
              policy_name      VARCHAR2, 
              constr_name      VARCHAR2, 
              match_pattern    VARCHAR2, 
              apply_pattern    VARCHAR2, 
              constr_group     VARCHAR2 default null);

   -- Delete a constraint from the VPD policy -- 
   procedure delete_vpd_constraint (
              policy_name      VARCHAR2, 
              constr_name      VARCHAR2); 
  
end;
/

show errors; 

@@pvtrdfsa.plb

create or replace public synonym sem_rdfsa for mdsys.sem_rdfsa;

begin
  EXECUTE IMMEDIATE 
   'insert into mdsys.rdf_parameter(namespace, attribute, value, description)
     values (:1,:2,:3,:4)' USING 'COMPONENT','RDFOLS','INSTALLED',
                                 'RDF Optional component for OLS support'; 
exception when dup_val_on_index then 
  null; 
end;
/

begin
  EXECUTE IMMEDIATE
   'insert into mdsys.rdf_parameter(namespace, attribute, value, description)
     values (:1,:2,:3,:4)' USING 'COMPONENT','RDFVPD','INSTALLED',
                                 'RDF Optional component for VPD support';
exception when dup_val_on_index then 
  null; 
end;
/

commit; 
 
