Rem
Rem $Header: sdo/admin/sdordfsa_rm.sql /main/6 2009/05/28 09:16:02 matperry Exp $
Rem
Rem sdordfsa_rm.sql
Rem
Rem Copyright (c) 2008, 2009, Oracle and/or its affiliates. 
Rem All rights reserved. 
Rem
Rem    NAME
Rem      sdordfsa_rm.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    matperry    05/26/09 - remove WHENEVER SQLERROR EXIT
Rem    matperry    05/12/09 - remove connect as sysdba
Rem    ayalaman    01/28/09 - dml vpd policy for RDF
Rem    sdas        07/28/08 - RDF OLS
Rem    sdas        07/28/08 - Created
Rem

--WHENEVER SQLERROR EXIT;

declare
  hasplcy number; 
begin
  select count(*) into hasplcy from dba_policies where 
     object_owner = 'MDSYS' and object_name in 
       ('RDF_LINK$','RDF_SECVALUE$'); 
  if (hasplcy > 0) then 
    raise_application_error(-20000, 'RDF-OLS policy in use : '||
        'Remove OLS policy before uninstalling RDF-OLS support');
  end if; 
  begin
    EXECUTE IMMEDIATE 'select count(*) from mdsys.RDFVPD_POLICIES$' 
       into hasplcy; 
    if (hasplcy > 0) then 
      raise_application_error(-20000, 'RDF-VPD policy exists : '||
        'Drop all VPD policies before uninstalling RDF-VPD support '); 
    end if; 
  exception when others then null;
  end; 
end;
/

WHENEVER SQLERROR CONTINUE; 

alter session set current_schema = MDSYS; 

declare
  dumvr VARCHAR2(20);  
begin
  begin
    select value into dumvr from mdsys.rdf_parameter
        where namespace = 'COMPONENT' and attribute = 'RDFOLS';
    if (dumvr = 'ENABLED') then
     execute immediate 'begin mdsys.sem_rdfsa_dr.drop_secureaccess_objs(''TRUE''); end;'; 
    end if;
    exception when others then null;
  end;
  begin
    select value into dumvr from mdsys.rdf_parameter
       where namespace = 'COMPONENT' and attribute = 'RDFVPD';
    if (dumvr = 'ENABLED') then
      execute immediate 'begin mdsys.sem_rdfsa_dr.cleanup_vpd_objects; end;'; 
    end if;
  exception when others then null;
  end;
end;
/

begin
  execute immediate 'drop package mdsys.sem_rdfsa'; 
exception when others then null;
end;
/

begin
  execute immediate 'drop public synonym sem_rdfsa'; 
exception when others then null;
end;
/

begin
  execute immediate 'drop package mdsys.sem_rdfsa_dr'; 
exception when others then null;
end;
/

begin
  execute immediate 'drop package mdsys.sem_rdfsa_priv'; 
exception when others then null;
end;
/

begin
  execute immediate 'drop package mdsys.rdf$lbaclab'; 
exception when others then null;
end;
/

begin
  execute immediate 'drop type mdsys.rdf$domsalabel'; 
exception when others then null;
end;
/

begin
  execute immediate 'drop function mdsys.RDFSA_DOMLBL'; 
exception when others then null;
end;
/

begin
  execute immediate 'drop procedure mdsys.RDF$GRANT_OLS_PRIVS';
  exception when others then null;
end;
/

-- Dummy type implementation: actual type body will be installed when OLS 
-- is enabled for RDF using sdordfsa.sql 
create or replace type body mdsys.rdfsa_resource as
  constructor function rdfsa_resource (res_id VARCHAR2, res_type number)
                                            return self as result is
  begin
    null;
  end;

  constructor function rdfsa_resource (res_id VARCHAR2, res_type number,
            res_label number) return self as result is
  begin
    null;
  end;

  constructor function rdfsa_resource (res_id VARCHAR2, res_type number,
            res_labels mdsys.int_array) return self as result is
  begin
    null;
  end;

  member function getResource return VARCHAR2 is
  begin
    null;
  end;

  member function getLabelCount return number is
  begin
    null;
  end;

  member function getLabel(idx number default 1) return number is
  begin
    null;
  end;
end;
/

show errors;

-- dummy implementation for label gen -- 
create or replace type body mdsys.rdfsa_labelgen is

  final member procedure setDepResources(useres number) is
  begin
    null;
  end;

  final static function findDominatingOf(labels MDSYS.INT_ARRAY)
       return number is
  begin
    null;
  end;

  member function getNumericLabel (subject   rdfsa_resource,
                                   predicate rdfsa_resource,
                                   object    rdfsa_resource,
                                   rule      rdfsa_resource,
                                   anteced   rdfsa_resource)
       return number is
  begin
    null;
  end;
end;
/

create or replace package body sem_rdfsa_ir as

   procedure create_entailment (
              index_name_in    VARCHAR2,
              models_in        RDF_MODELS,
              rulebases_in     RDF_RULEBASES,
              passes           NUMBER default 0,
              inf_components_in  VARCHAR2 default null,
              options          VARCHAR2 default null,
              delta_in         mdsys.rdf_models default null,
              label_gen        RDFSA_LABELGEN default null) is
   begin
     -- actual implementation loaded with RDFSA install -- 
     MDERR.RAISE_MD_ERROR('MD','SDO',-13199,
          'RDF Secure Access (OLS/VPD) option not installed');
   end create_entailment;

   procedure bulk_load_from_staging_table (
              model_name       VARCHAR2,
              table_owner      VARCHAR2,
              table_name       VARCHAR2,
              flags            VARCHAR2 default null,
              debug            PLS_INTEGER default null,
              start_comment  IN  varchar2 default NULL,
              end_comment    IN  varchar2 default NULL) is
   begin
     -- actual implementation loaded with RDFSA install -- 
     MDERR.RAISE_MD_ERROR('MD','SDO',-13199,
          'RDF Secure Access (OLS/VPD) option not installed');
   end bulk_load_from_staging_table;

end sem_rdfsa_ir;
/

show errors; 

begin
  EXECUTE IMMEDIATE 
   'delete from mdsys.rdf_parameter where namespace = :1 and 
         attribute = :2 ' USING 'COMPONENT','RDFOLS';
  EXECUTE IMMEDIATE
   'delete from mdsys.rdf_parameter where namespace = :1 and 
         attribute = :2 ' USING 'COMPONENT','RDFVPD';
  commit; 
end;
/

alter session set current_schema = SYS; 
