Rem $Header: sdo/admin/sdordfwm.sql /main/2 2009/01/22 12:34:28 ayalaman Exp $
Rem
Rem sdordfwm.sql
Rem
Rem Copyright (c) 2008, 2009, Oracle and/or its affiliates.
Rem All rights reserved. 
Rem
Rem    NAME
Rem      sdordfwm.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    ayalaman   01/16/09 - parameters table
Rem    ayalaman   11/24/08 - Created
Rem

--
--- Install time checks for RDF-OWM integration
--
WHENEVER SQLERROR EXIT;
grant select on wmsys.wm$workspaces_table to MDSYS; 
grant execute on dbms_rls to mdsys;
grant execute on wmsys.ltutil to mdsys; 
alter session set current_schema = MDSYS; 

begin
  IF (dbms_registry.version('OWM') is null) THEN
    raise_application_error(-20000, 'OWM component not found: '||
        'OWM should be installed prior to Version enabling RDF');
  END IF;
end;
/

declare
  rc NUMBER;
begin
  select count(*) into rc from all_objects where owner = 'MDSYS' and 
    object_name = 'SDO_RDF'; 
  if (not(dbms_registry.version('SDO') like '11.%') or rc = 0) then 
     raise_application_error(-20000, 'RDF Component not installed:'||
        'RDF Component for 11.1 or above must be installed.');
  end if; 
end;
/

show errors; 

WHENEVER SQLERROR CONTINUE;

@@prvtrdfwm.plb

-- install the RDF versioning objects -- 
exec sem_rdfwm_dr.install_rdf_versioning; 

begin
  EXECUTE IMMEDIATE
   'insert into mdsys.rdf_parameter(namespace, attribute, value, description)
     values (:1,:2,:3,:4)' USING 'COMPONENT','RDFOWM','INSTALLED',
                                 'RDF Optional component for Workspace Manager support';
exception when dup_val_on_index then
  null;
end;
/

