Rem
Rem $Header: sdo/admin/sdordfwm_rm.sql /main/5 2009/05/28 09:16:02 matperry Exp $
Rem
Rem sdordfwm_rm.sql
Rem
Rem Copyright (c) 2008, 2009, Oracle and/or its affiliates. 
Rem All rights reserved. 
Rem
Rem    NAME
Rem      sdordfwm_rm.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    matperry    05/26/09 - remove WHENEVER SQLERROR EXIT
Rem    matperry    05/20/09 - add commit
Rem    matperry    05/12/09 - remove connect as sysdba
Rem    ayalaman    01/16/09 - parameters table
Rem    ayalaman    12/02/08 - uninstall workspace manager support for RDF
Rem    ayalaman    12/02/08 - Created
Rem

--WHENEVER SQLERROR EXIT;

declare
  hasvrsdm number;
begin
  execute immediate 
  'select count(*) 
  from  all_wm_versioned_tables wvt, mdsys.rdf_model$ rmd
  where wvt.owner = rmd.owner and wvt.table_name = rmd.table_name' 
     into hasvrsdm; 

  if (hasvrsdm > 0) then
    raise_application_error(-20000, 
    'One or more RDF Models is Version enabled: Disable versioning'); 
  end if; 
exception 
  when others then 
    if (SQLCODE = -942) then 
      null; -- one of the options is not installed; go head with the
            -- rest of the script
    else
      raise;
    end if; 
end; 
/   

WHENEVER SQLERROR CONTINUE; 

-- fix the view definitions to use the default definitions etc.,
exec mdsys.sem_rdfwm_dr.uninstall_rdf_versioning; 

drop trigger mdsys.rdf_verenb_listener; 

drop package mdsys.sem_rdfwm_dr; 

begin
  EXECUTE IMMEDIATE 
   'delete from mdsys.rdf_parameter where namespace = :1 and 
         attribute = :2 ' USING 'COMPONENT','RDFOWM';
end;
/

commit;
