Rem
Rem $Header: sdo/admin/sdoseminfhh.sql /main/18 2009/03/30 20:14:56 alwu Exp $
Rem
Rem sdoseminfhh.sql
Rem
Rem Copyright (c) 2006, 2009, Oracle and/or its affiliates. 
Rem All rights reserved. 
Rem
Rem    NAME
Rem      sdoseminfhh.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    alwu        03/27/09 - add two more aximatic triples regarding RDF plain
Rem                           literals
Rem    alwu        03/24/09 - change S16 based on the latest SKOS SPEC CR
Rem    alwu        03/17/09 - add property disjointWith related rules
Rem    alwu        03/16/09 - add skos axioms
Rem    alwu        02/04/09 - pass incremental inference flag to steph function
Rem    alwu        01/05/09 - three column design
Rem    alwu        01/08/07 - add rdfp9, rdfp10 from pD* semantics
Rem    alwu        07/28/06 - comment out stmt_disjsco 
Rem    alwu        07/26/06 - add disj optimization 
Rem    alwu        07/21/06 - add axioms 
Rem    alwu        07/07/06 - Add equivalent property type propagation 
Rem    alwu        06/29/06 - add PROOF for schema realted rules 
Rem    alwu        06/12/06 - add INV2SPH rule 
Rem    alwu        06/06/06 - implement inv of TP and SP rule 
Rem    alwu        06/01/06 - implement rule: (C1 :comp C2, C1 :disj C3 => C3 
Rem                           sco C2) 
Rem    alwu        06/01/06 - add reverse flag for build_propagate 
Rem    alwu        05/25/06 - remove invh as it is covered by SYMM 
Rem    alwu        05/23/06 - add RDFS ext 3 and ext 4 
Rem    alwu        05/18/06 - fix RDFS12 to include rdf:_1 rdf:type 
Rem                           ContainerMembershipProperty as well 
Rem    alwu        05/17/06 - add RDFS12 rule rdfs:member 
Rem    alwu        05/11/06 - add spih support 
Rem    alwu        05/10/06 - add new language constructs: dom, ran, etc. 
Rem    alwu        05/04/06 - add logic to support option COPYRD 
Rem    alwu        05/02/06 - start
Rem    alwu        05/02/06 - start
Rem    alwu        05/02/06 - Created
Rem


/** 
 * Hierachy related inference including class, role subsumptions, etc
 */
create or replace package sdo_sem_infh authid current_user as
  /** 
   * @param vcMarker can be something that identifies a query
   *
   * domh, scoi, etc are all something like
   * X  rp   Y
   * Y  rs  Z =>  X rp Z
   */
  function build_propagate(models            mdsys.rdf_models,
                           rulebases         mdsys.rdf_rulebases,
                           vcTabName         varchar2,
                           vcViewName        varchar2,
                           vcModelsUnion     varchar2,
                           iRolePropagate    int,
                           iRoleSource       int,
                           vcMarker          varchar2,
                           bReverse          boolean default false) 
  return varchar2;


  /** 
   * @param vcMarker can be something like: SCOH, SPOH, EQCH, ... etc.
   */
  function build_trans_stmt(models            mdsys.rdf_models,
                            rulebases         mdsys.rdf_rulebases,
                            vcTabName         varchar2,
                            vcViewName        varchar2,
                            vcModelsUnion     varchar2,
                            iRoleID           int,
                            vcMarker          varchar2
                            )
  return varchar2;


  /**
   * ?X er ?Y => ?X sr ?Y,  ?Y sr ?X
   */
  function build_eq_to_sub_stmt(
                            models            mdsys.rdf_models,
                            rulebases         mdsys.rdf_rulebases,
                            vcTabName         varchar2,
                            vcViewName        varchar2,
                            vcModelsUnion     varchar2,
                            iEqRoleID         int,
                            iSubRoleID        int,
                            vcMarker          varchar2) 
  return varchar2;


  /**
   * ?X sr ?Y,  ?Y sr ?X => ?X er ?Y 
   */
  function build_sub_to_eq_stmt(
                            models            mdsys.rdf_models,
                            rulebases         mdsys.rdf_rulebases,
                            vcTabName         varchar2,
                            vcViewName        varchar2,
                            vcModelsUnion     varchar2,
                            iSubRoleID        int,
                            iEqRoleID         int,
                            vcMarker          varchar2) 
  return varchar2;


  /**
   * The inverse of fp should be ipf and vice versa.
   */
  function build_stmt_inv_fp_ifp_h(models            mdsys.rdf_models,
                                   rulebases         mdsys.rdf_rulebases,
                                   vcTabName         varchar2,
                                   vcViewName        varchar2,
                                   vcModelsUnion     varchar2,
                                   iIdType           int,
                                   iIdFP             int,
                                   iIdIFP            int,
                                   iIdIo             int)
  return varchar2;


  /**
   * Rules: RDFS5 : http://www.w3.org/TR/rdf-mt/#RDFRules
   */
  function build_stmt_spoh(models            mdsys.rdf_models,
                           rulebases         mdsys.rdf_rulebases,
                           vcTabName         varchar2,
                           vcViewName        varchar2,
                           vcModelsUnion     varchar2,
                           iIdSpo            int
                           )
  return varchar2;


  /**
   * Rules: RDFS11 : http://www.w3.org/TR/rdf-mt/#RDFRules
   */
  function build_stmt_scoh(models            mdsys.rdf_models,
                           rulebases         mdsys.rdf_rulebases,
                           vcTabName         varchar2,
                           vcViewName        varchar2,
                           vcModelsUnion     varchar2,
                           iIdSco            int
                           )
  return varchar2;


  /**
   * Extention-based (if and only if) rule:
   *   p :domain  C1,  C1 :subClassOf C2 => p :domain C2
   */
  function build_stmt_dom_range_h(
                           models            mdsys.rdf_models,
                           rulebases         mdsys.rdf_rulebases,
                           vcTabName         varchar2,
                           vcViewName        varchar2,
                           vcModelsUnion     varchar2,
                           iRoleID           int,
                           iIdSco            int)
  return varchar2;


  /**
   * Build statement for rule with the following shape (step like and hence
   * the name):
   *             b --- b1
   *               |
   *               |
   *        a1  ___| a
   *
   * Two applications of this rule so far:
   * g spo f, g inv g', f' inv f => g' spo f'
   * 
   * When @param bReverse is true, 
   * h sco g, h comp h', g comp g' => g' sco h'
   */
  function build_stmt_steph(models            mdsys.rdf_models,
                            rulebases         mdsys.rdf_rulebases,
                            vcTabName         varchar2,
                            vcViewName        varchar2,
                            vcModelsUnion     varchar2,
                            iIdVertical       int,
                            iIdHorizontal     int,
                            vcMarker          varchar2,
                            bReverse          boolean default false,
                            bDoIncremental    boolean default false
                            )
  return varchar2;


  /**
   * RDFS12 rule rdfs:member 
   * It is very unlikely that we will see the following in a model
   *   rdf:_n rdf:type rdfs:ContainerMembershipProperty .
   * We therefore generate directly (the meaningful portion):
   *   rdf:_n rdfs:subPropertyOf rdfs:member
   * which in turn will be picked up by SPO rule to make rdf bag
   * search easier. 
   *
   * Note that this cannot help rdf list search, which is a hierachically
   * constructed data. We may need a special API for that.
   */
  function build_stmt_mbrh(models            mdsys.rdf_models,
                           rulebases         mdsys.rdf_rulebases,
                           vcTabName         varchar2,
                           vcViewName        varchar2,
                           vcModelsUnion     varchar2,
                           iIdSpo            int,
                           iIdMbr            int,
                           iIdCMP            int,
                           iIdType           int
                           )
  return varchar2;


  /**
   *    C1 owl:disjointWith C2,  Cs sco C1, Cs sco C2 => Cs sco owl:Nothing
   * or 
   *    C1 owl:complementOf C2,  Cs sco C1, Cs sco C2 => Cs sco owl:Nothing
   */
  function build_stmt_disj_unsat(
                            models            mdsys.rdf_models,
                            rulebases         mdsys.rdf_rulebases,
                            vcTabName         varchar2,
                            vcViewName        varchar2,
                            vcModelsUnion     varchar2,
                            iIdDisj           int,
                            iIdSco            int,
                            iIdNothing        int)
  return varchar2;


  /**
   * Extension-based (if and only if) rule:
   *  -- RDFS ext 3: u :domain V, w spo u => w :domain V
   *  -- RDFS ext 4: u :range V, w spo u => w :range V
   */
  function build_stmt_spo_dom_range_h(
                           models            mdsys.rdf_models,
                           rulebases         mdsys.rdf_rulebases,
                           vcTabName         varchar2,
                           vcViewName        varchar2,
                           vcModelsUnion     varchar2,
                           iIdDomRan         int,
                           iIdSpo            int,
                           vcMarker          varchar2
                           ) 
  return varchar2;


  /**
   * Build statement for the following rule: 
   *  p1 inv p2, p2 inv p3 => p1 eqp p3
   */
  function build_stmt_inv_eq(models            mdsys.rdf_models,
                             rulebases         mdsys.rdf_rulebases,
                             vcTabName         varchar2,
                             vcViewName        varchar2,
                             vcModelsUnion     varchar2,
                             iIdIo             int,
                             iIdEqup           int)
  return varchar2;


  /**
   * Build statement for the following rules:
   *    p1 inv p2, p1 :domain C => p2 :range C
   *    p1 inv p2, p1 :range  C => p2 :domain C
   *
   * Note this is very similar to build_stmt_inv_fp_ifp_h but not exactly the
   * same.
   */
  function build_stmt_inv_dom_ran_h(models           mdsys.rdf_models,
                                   rulebases         mdsys.rdf_rulebases,
                                   vcTabName         varchar2,
                                   vcViewName        varchar2,
                                   vcModelsUnion     varchar2,
                                   iIdIo             int,
                                   iIdDom            int,
                                   iIdRan            int
                                   )
  return varchar2;


  /**
   * Build statement for the following rules:
   *   -- (C1 :comp C2, C1 :disj C3 => C3 sco C2)
   */
  function build_stmt_comp_disj_to_sco(models           mdsys.rdf_models,
                                       rulebases         mdsys.rdf_rulebases,
                                       vcTabName         varchar2,
                                       vcViewName        varchar2,
                                       vcModelsUnion     varchar2,
                                       iIdComp           int,
                                       iIdDisj           int,
                                       iIdSco            int
                                       )
  return varchar2;


  /** 
   * C1 :complementOf  C2, C2 :complementOf C3 => C1 :equivalentClass C3
   */
  function build_stmt_comp_to_eq(models            mdsys.rdf_models,
                                 rulebases         mdsys.rdf_rulebases,
                                 vcTabName         varchar2,
                                 vcViewName        varchar2,
                                 vcModelsUnion     varchar2,
                                 iIdComp           int,
                                 iIdEqc            int
                                 ) 
  return varchar2;


  /** 
   * ?a  :pSrc  ?b =>  ?a  : pDst  ?b
   * An example is 
   *   C1 :complementOf  C2 =>  C1 :disjointWith C2
   */
  function build_stmt_prop_change(models            mdsys.rdf_models,
                                  rulebases         mdsys.rdf_rulebases,
                                  vcTabName         varchar2,
                                  vcViewName        varchar2,
                                  vcModelsUnion     varchar2,
                                  iIdSrc            int,
                                  iIdDst            int,
                                  vcMarker          varchar2
                                  ) 
  return varchar2;

  /**
   * Build statmenet for the following rule:
   *   p1 spo p2,  p2 type owl:FunctionalProperty => p1 type owl:FunctionalProperty
   *   Same thing for owl:InverseFunctionalProperty
   * or
   *   p eqp p2, p2 type owl:TransitiveProperty => p type TransitiveProperty
   *   Same thing for owl:SymmetricProperty
   * 
   * To generalize,
   *   p iIdRoleCond p2, p2 type iIdClass => p type iIdClass 
   */
  function build_stmt_type_propagate(
                            models            mdsys.rdf_models,
                            rulebases         mdsys.rdf_rulebases,
                            vcTabName         varchar2,
                            vcViewName        varchar2,
                            vcModelsUnion     varchar2,
                            iIdRoleCond       int,
                            iIdType           int,
                            iIdClass          int,
                            vcMarker          varchar2) 
  return varchar2;


  /** 
   * Build statment for rule:
   *    SYMMH: p type SymmetricProperty => p inv p
   */
  function build_stmt_symmh(models            mdsys.rdf_models,
                            rulebases         mdsys.rdf_rulebases,
                            vcTabName         varchar2,
                            vcViewName        varchar2,
                            vcModelsUnion     varchar2,
                            iIdSymP           int,
                            iIdIo             int,
                            iIdType           int
                            ) 
  return varchar2;


  /**
   * Build statement for the following rule:
   *   p1 inv TP (TransitiveProperty) => p1 type TP
   *   p1 inv SP (SymmetricProperty)  => p1 type SP
   */
  function build_stmt_inv_tp_sp(models            mdsys.rdf_models,
                                rulebases         mdsys.rdf_rulebases,
                                vcTabName         varchar2,
                                vcViewName        varchar2,
                                vcModelsUnion     varchar2,
                                iIdIo             int,
                                iIdType           int,
                                iIdTP             int,
                                iIdSymP           int
                                )
  return varchar2;


  /**
   * Build statement for the following rule:
   *   p inv p => p type SymmetricProperty
   */
  function build_stmt_inv2sp(models            mdsys.rdf_models,
                             rulebases         mdsys.rdf_rulebases,
                             vcTabName         varchar2,
                             vcViewName        varchar2,
                             vcModelsUnion     varchar2,
                             iIdIo             int,
                             iIdType           int,
                             iIdSymP           int
                             )
  return varchar2;


  /**
   * Build statement for the following rule 
   *  g comp h, g sco C, h sco C => C eqc owl:Thing
   */
  function build_stmt_comp2universe(models           mdsys.rdf_models,
                                    rulebases         mdsys.rdf_rulebases,
                                    vcTabName         varchar2,
                                    vcViewName        varchar2,
                                    vcModelsUnion     varchar2,
                                    iIdSco            int,
                                    iIdComp           int,
                                    iIdEqc            int,
                                    iIdThing          int
                                    )
  return varchar2;


  function build_stmt_add_skos_axioms(models                     mdsys.rdf_models,
                                      rulebases                  mdsys.rdf_rulebases,
                                      vcTabName                  varchar2,
                                      vcViewName                 varchar2,
                                      vcModelsUnion              varchar2,
                                      iIdType                    int,
                                      iIdDom                     int,
                                      iIdRan                     int,
                                      iIdSpo                     int,
                                      iIdSco                     int,
                                      iIdCls                     int, -- owl class
                                      iIdObjProp                 int, -- owl Object property
                                      iIdIo                      int, -- owl inverse of
                                      iIdDisj                    int, -- owl disjoint with
                                      iIdDatatypeProp            int, -- owl datatype property
                                      iIdRdfsLbl                 int, -- rdfs label
                                      iIdPropDisj                int, -- owl 2 propertyDisjointWith
                                      iIdSymP                    int, -- owl symmetric property
                                      iIdTP                      int, -- owl transitive property
                                      iIdRdfLst                  int, -- rdf:List
                                      iIdFP                      int, -- owl functional property
                                      iIdSkosConcept             int,
                                      iIdSkosConceptScheme       int,
                                      iIdSkosInScheme            int,
                                      iIdSkosHasTopConcept       int,
                                      iIdSkosTopConceptOf        int,
                                      iIdSkosAltLabel            int,
                                      iIdSkosHiddenLabel         int,
                                      iIdSkosPrefLabel           int,
                                      iIdSkosNotation            int,
                                      iIdSkosChangeNote          int,
                                      iIdSkosDefinition          int,
                                      iIdSkosEditorialNote       int,
                                      iIdSkosExample             int,
                                      iIdSkosHistoryNote         int,
                                      iIdSkosNote                int,
                                      iIdSkosScopeNote           int,
                                      iIdSkosBroader             int,
                                      iIdSkosBroaderTransitive   int,
                                      iIdSkosNarrower            int,
                                      iIdSkosNarrowerTransitive  int,
                                      iIdSkosRelated             int,
                                      iIdSkosSemanticRelation    int,
                                      iIdSkosCollection          int,
                                      iIdSkosOrderedCollection   int,
                                      iIdSkosMember              int,
                                      iIdSkosMemberList          int,
                                      iIdSkosBroadMatch          int,
                                      iIdSkosCloseMatch          int,
                                      iIdSkosExactMatch          int,
                                      iIdSkosMappingRelation     int,
                                      iIdSkosNarrowMatch         int,
                                      iIdSkosRelatedMatch        int,
                                      iIdSkosxlLabel             int, -- extension
                                      iIdSkosxlLiteralForm       int,
                                      iIdSkosxlPrefLabel         int,
                                      iIdSkosxlAltLabel          int,
                                      iIdSkosxlHiddenLabel       int,
                                      iIdSkosxlLabelRelation     int,
                                      iIdAp                      int,
                                      iIdRdfsLit                 int
                                      )
  return varchar2;


  /** 
   * Add RDF/RDFS axioms if there are not in the model or index.
   *
   */
  function build_stmt_add_axioms(models          mdsys.rdf_models,
                                 rulebases       mdsys.rdf_rulebases,
                                 vcTabName       varchar2,
                                 vcViewName      varchar2,
                                 vcModelsUnion   varchar2,
                                 iIdType         int,
                                 iIdDom          int,
                                 iIdRan          int,
                                 iIdSpo          int,
                                 iIdSco          int,
                                 iIdMbr          int,
                                 iIdRdfProp      int,
                                 iIdRdfSub       int,
                                 iIdRdfStm       int,
                                 iIdRdfPre       int,
                                 iIdRdfObj       int,
                                 iIdRdfFst       int,
                                 iIdRdfRst       int,
                                 iIdRdfNil       int,
                                 iIdRdfVal       int,
                                 iIdRdfLst       int,
                                 iIdRdfsRes      int,
                                 iIdRdfsSA       int,
                                 iIdRdfsIDB      int,
                                 iIdRdfsCom      int,
                                 iIdRdfsLbl      int,
                                 iIdRdfsLit      int,
                                 iIdRdfAlt       int,
                                 iIdRdfBag       int,
                                 iIdRdfSeq       int,
                                 iIdRdfXL        int,
                                 iIdCMP          int,
                                 iIdRdfsCon      int,
                                 iIdRdfsDt       int,
                                 iIdRdfsCls      int
                                 ) 
  return varchar2;


  -- /**
  --  * Build statement for the following rule:
  --  *    C1 disj C2, C11 sco C1 => C11 disj C2
  --  * and
  --  *    C1 disj C2, C22 sco C2 => C1 disj C22 (due to symmetricity, it is
  --  *                                           covered by the first one)
  --  * and
  --  *    C1 disj C2, C22 sco C2, C11 sco C1 => C11 disj C22
  --  */
  -- function build_stmt_disjsco(models          mdsys.rdf_models,
  --                           rulebases         mdsys.rdf_rulebases,
  --                           vcTabName         varchar2,
  --                           vcViewName        varchar2,
  --                           vcModelsUnion     varchar2,
  --                           iIdDisj           int,
  --                           iIdSco            int
  --                           )
  -- return varchar2;


  function build_stmt_rdfp9(
                           models            mdsys.rdf_models,
                           rulebases         mdsys.rdf_rulebases,
                           vcTabName         varchar2,
                           vcViewName        varchar2,
                           vcModelsUnion     varchar2,
                           iIdType           int,
                           iIdObj            int,
                           iIdSam            int,
                           iIdInferredProp   int,
                           vcMarker          varchar2
                           ) return varchar2;


  function build_stmt_rdfp10(
                           models            mdsys.rdf_models,
                           rulebases         mdsys.rdf_rulebases,
                           vcTabName         varchar2,
                           vcViewName        varchar2,
                           vcModelsUnion     varchar2,
                           iIdType           int,
                           iIdObj            int,
                           iIdSam            int,
                           iIdInferredProp   int,
                           vcMarker          varchar2
                           ) return varchar2;


  function build_stmt_propdisjh(
                            models            mdsys.rdf_models,
                            rulebases         mdsys.rdf_rulebases,
                            vcTabName         varchar2,
                            vcViewName        varchar2,
                            vcModelsUnion     varchar2,
                            iIdSpo            int,
                            iIdPropDisj       int
                            ) 
  return varchar2;
end;
/
show errors;

