Rem
Rem $Header: sdo/admin/sdoseminfih.sql /st_sdo_11.2.0.1/1 2009/06/12 12:37:16 vkolovsk Exp $
Rem
Rem sdoseminfih.sql
Rem
Rem Copyright (c) 2006, 2009, Oracle and/or its affiliates. 
Rem All rights reserved. 
Rem
Rem    NAME
Rem      sdoseminfih.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    vkolovsk    06/10/09 - procedural RAN optimization, non procedural ran
Rem                           fix
Rem    vkolovsk    06/09/09 - add fpDifHint
Rem    alwu        05/15/09 - add same optimization as in
Rem                           match_intersect_inst_dist
Rem    alwu        05/05/09 - revert property chain api
Rem    alwu        03/30/09 - fix property chain axiom: should not have bNode
Rem                           as predicate
Rem    vkolovsk    03/19/09 - move process owlthing rules here
Rem    alwu        03/17/09 - add chain instance rule
Rem    alwu        03/09/09 - drop svf_spo
Rem    vkolovsk    02/26/09 - simplify el_r3 rule
Rem    vkolovsk    02/19/09 - add svf_spo
Rem    alwu        02/19/09 - add build_stmt_chain
Rem    alwu        02/11/09 - increase CUT_MARKER size
Rem    vkolovsk    02/07/09 - refactoring 2-step rules
Rem    vkolovsk    02/06/09 - refactoring two-step rpocedural rules
Rem    alwu        01/05/09 - three column design
Rem    vkolovsk    01/02/09 - build_stmt for svf_plsql, svfh_plsql, avf_plsql
Rem    vkolovsk    12/16/08 - fp and ifp related fixes for incremental
Rem    alwu        11/19/08 - add intersection support
Rem    alwu        02/27/07 - improve SVF for lubm1000
Rem    alwu        01/02/07 - add build_stmt_hva
Rem    alwu        07/18/06 - optimize FP_DIF 
Rem    alwu        07/14/06 - more RDFS rules 
Rem    alwu        06/28/06 - factor out get/set proof from sdo_sem_infi 
Rem                           package 
Rem    alwu        06/27/06 - add new APIs for passing proof parameter 
Rem    alwu        06/23/06 - start adding proof 
Rem    alwu        06/13/06 - remove get_hint_hash_unique 
Rem    alwu        06/07/06 - add fp_circle_dif rule:a dif b, a fp b, c fp c => a dif c 
Rem    alwu        06/01/06 - move COMPH related APIs to sdoseminfh package 
Rem    alwu        05/23/06 - add FP/IFP caused differentFrom 
Rem    alwu        05/19/06 - add disjointWith rule for instances 
Rem    alwu        05/16/06 - add symmetricity 
Rem    alwu        05/12/06 - add API for hash unique hint 
Rem    alwu        05/10/06 - add new language constructs: dom, ran, etc. 
Rem    alwu        05/02/06 - start
Rem    alwu        05/02/06 - start
Rem    alwu        05/02/06 - Created
Rem

/** 
 * Individual (instance) related inference including classification etc. 
 */
create or replace package sdo_sem_infi authid current_user as
  CUT_MARKER constant varchar2(20) := ' /* CUT */ ';

  /** 
   * RDFS9: Expand instance classifications based on class subsumption hierachy.
   */
  function build_stmt_scoi(models            mdsys.rdf_models,
                           rulebases         mdsys.rdf_rulebases,
                           vcTabName         varchar2,
                           vcViewName        varchar2,
                           vcModelsUnion     varchar2,
                           iIdType           int,
                           iIdSco            int
                           )
  return varchar2;


  /** 
   * RDFS7: Expand role assertions based on role hierachy.
   */
  function build_stmt_spoi(models            mdsys.rdf_models,
                           rulebases         mdsys.rdf_rulebases,
                           vcTabName         varchar2,
                           vcViewName        varchar2,
                           vcModelsUnion     varchar2,
                           iIdSpo            int
                           )
  return varchar2;


  /**
   * Rules: RDFS2 : http://www.w3.org/TR/rdf-mt/#RDFRules
   */
  function build_stmt_dom( models            mdsys.rdf_models,
                           rulebases         mdsys.rdf_rulebases,
                           vcTabName         varchar2,
                           vcViewName        varchar2,
                           vcModelsUnion     varchar2,
                           iIdDom            int,
                           iIdType           int) return varchar2;

  /**
   * Rules: RDFS3 : http://www.w3.org/TR/rdf-mt/#RDFRules
   * aaa rdfs:range xxx .
   * uuu aaa vvv .             ==> vvv rdf:type xxx .
   *
   * Note when @bRDFS is true, we have to skip those objects
   * that are not URIs.
   * A motivating example is: 
   *    xyz   rdfs:label "10.1"
   *    rdfs:label rdfs:range rdfs:Literal, 
   * we don't want to infer "10.1" type rdfs:Literal
   */
  function build_stmt_ran( models            mdsys.rdf_models,
                           rulebases         mdsys.rdf_rulebases,
                           vcTabName         varchar2,
                           vcViewName        varchar2,
                           vcModelsUnion     varchar2,
                           iIdRan            int,
                           iIdType           int,
                           bRDFS             boolean default false,
                           vcXMLSchemaList   varchar2)
    return varchar2;


  /**
   * p1 inv p2, a p1 b => b p2 a
   */
  function build_stmt_inv(models            mdsys.rdf_models,
                          rulebases         mdsys.rdf_rulebases,
                          vcTabName         varchar2,
                          vcViewName        varchar2,
                          vcModelsUnion     varchar2,
                          iIdIo             int
                          ) return varchar2; 


  /**
   * Note: due to pD* semantics, we need to add  
   *       p1 inv p2, a p2 b => b p1 a explictly.
   */
  function build_stmt_inv_reverse(models            mdsys.rdf_models,
                                  rulebases         mdsys.rdf_rulebases,
                                  vcTabName         varchar2,
                                  vcViewName        varchar2,
                                  vcModelsUnion     varchar2,
                                  iIdIo             int
                                  ) 
  return varchar2;


  /**
   * FP rule: p1 :type owl:FunctionalProperty,  x p1 a, x p1 b =>
   * a owl:sameAs b   and b owl:sameAs a (through the beauty of Joins)
   */
  function build_stmt_fp(models            mdsys.rdf_models,
                         rulebases         mdsys.rdf_rulebases,
                         vcTabName         varchar2,
                         vcViewName        varchar2,
                         vcModelsUnion     varchar2,
                         vcFPTabName       varchar2,
                         iIdType           int,
                         iIdFP             int,
                         iIdSam            int,
                         iPreds    IN OUT  int
                         ) return varchar2;

  /**
   * IFP rule: p1 :type owl:InverseFunctionalProperty,  a p1 x, b p1 x =>
   * a owl:sameAs b   and b owl:sameAs a (through the beauty of Joins)
   */
  function build_stmt_ifp(models           mdsys.rdf_models,
                         rulebases         mdsys.rdf_rulebases,
                         vcTabName         varchar2,
                         vcViewName        varchar2,
                         vcModelsUnion     varchar2,
                         vcIFPTabName      varchar2,
                         iIdType           int,
                         iIdIFP            int,
                         iIdSam            int,
                         iPreds  IN OUT    int
                         ) return varchar2;

 /**
   * SAM/SAMH rule: 
   *  a) i1 owl:sameAs i2, i1 p o  => i2 p o
   *  b) i1 owl:sameAs i2, s  p i1 => s  p i2
   * Symmetricity will take care the other half.
   */
  function build_stmt_sam(models           mdsys.rdf_models,
                         rulebases         mdsys.rdf_rulebases,
                         vcTabName         varchar2,
                         vcViewName        varchar2,
                         vcModelsUnion     varchar2,
                         iIdSam            int
                         ) return varchar2;

  /**
   * SYMM rule: a symmetricprop b => b symmetricprop a  for a 
   * particular symmetric role.
   */
  function build_stmt_symm(models            mdsys.rdf_models,
                           rulebases         mdsys.rdf_rulebases,
                           vcTabName         varchar2,
                           vcViewName        varchar2,
                           vcModelsUnion     varchar2,
                           iIdSymmRole       int,
                           vcMarker          varchar2
                           ) 
  return varchar2;


  /**
   * ALL_SYMM rule: a symmetricprop b => b symmetricprop a  for 
   * all symmetric roles.
   */
  function build_stmt_allsymm(models            mdsys.rdf_models,
                              rulebases         mdsys.rdf_rulebases,
                              vcTabName         varchar2,
                              vcViewName        varchar2,
                              vcModelsUnion     varchar2,
                              iIdSymP           int,
                              iIdType           int
                              ) 
  return varchar2;


  /**
   * ALL_TRANS rule: a transp b, b transp c => a transp c
   * for all transitive roles.
   * Note that those default transtive properties like rdfs:subClassOf,
   * subPropertyOf, equivalentClass, sameAs, etc may not be covered by this method
   * if there is no explicit definition like:
   *    owl:equivalentClass rdf:type owl:TransitiveProperty .
   */
  function build_stmt_alltrans(models            mdsys.rdf_models,
                               rulebases         mdsys.rdf_rulebases,
                               vcTabName         varchar2,
                               vcViewName        varchar2,
                               vcModelsUnion     varchar2,
                               iIdTP             int,
                               iIdType           int
                               ) 
  return varchar2;


  /**
   * Build statement for rule:
   *   C1 :disjointWith C2, i1 :type C1, i2 :type C2 => i1 :differentFrom :i2
   */
  function build_stmt_disj(models            mdsys.rdf_models,
                           rulebases         mdsys.rdf_rulebases,
                           vcTabName         varchar2,
                           vcViewName        varchar2,
                           vcModelsUnion     varchar2,
                           iIdDisj           int,
                           iIdType           int,
                           iIdDif            int
                           ) return varchar2;




  /**
   * Build statement for rule:
   *     a fp b, a1 fp b1, b dif b1 (or b1 dif b) => a dif a1
   */
  function build_stmt_fp_dif(models            mdsys.rdf_models,
                             rulebases         mdsys.rdf_rulebases,
                             vcTabName         varchar2,
                             vcViewName        varchar2,
                             vcModelsUnion     varchar2,
                             iIdType           int,
                             iIdFP             int,
                             iIdDif            int
                             ) 
  return varchar2;


  /**
   * Build statement for rule:
   *     a ifp b, a1 ifp b1, a dif a1 (or a1 dif a) => b dif b1
   */
  function build_stmt_ifp_dif(models            mdsys.rdf_models,
                              rulebases         mdsys.rdf_rulebases,
                              vcTabName         varchar2,
                              vcViewName        varchar2,
                              vcModelsUnion     varchar2,
                              iIdType           int,
                              iIdIFP            int,
                              iIdDif            int
                              ) 
  return varchar2;


  /**
   * Build statement for rule:
   *     a dif b, a fp b, c fp c => a dif c 
   * Note: this rule is different from fp_dif 
   *     which is "a dif b, a fp b, c fp a => a dif c"
   */
  function build_stmt_fp_circle_dif(models            mdsys.rdf_models,
                                    rulebases         mdsys.rdf_rulebases,
                                    vcTabName         varchar2,
                                    vcViewName        varchar2,
                                    vcModelsUnion     varchar2,
                                    vcFPTabName       varchar2,
                                    iIdType           int,
                                    iIdFP             int,
                                    iIdDif            int,
                                    iPreds IN OUT     int
                                    ) 
  return varchar2;

  function build_stmt_fp_circle_dif_org(models            mdsys.rdf_models,
                                    rulebases         mdsys.rdf_rulebases,
                                    vcTabName         varchar2,
                                    vcViewName        varchar2,
                                    vcModelsUnion     varchar2,
                                    iIdType           int,
                                    iIdFP             int,
                                    iIdDif            int
                                    ) 
  return varchar2;


  /**
   * Build statement for rule:
   *     a dif b, b ifp a, c ifp c => a diff c
   */
  function build_stmt_ifp_circle_dif(models            mdsys.rdf_models,
                                     rulebases         mdsys.rdf_rulebases,
                                     vcTabName         varchar2,
                                     vcViewName        varchar2,
                                     vcModelsUnion     varchar2,
                                     vcIFPTabName      varchar2,
                                     iIdType           int,
                                     iIdIFP            int,
                                     iIdDif            int,
                                     iPreds     IN OUT int
                                     ) 
  return varchar2;

  function build_stmt_ifp_circle_dif_org(models            mdsys.rdf_models,
                                     rulebases         mdsys.rdf_rulebases,
                                     vcTabName         varchar2,
                                     vcViewName        varchar2,
                                     vcModelsUnion     varchar2,
                                     iIdType           int,
                                     iIdIFP            int,
                                     iIdDif            int
                                     ) 
  return varchar2;


  /**
   * RDFS4A: 
    -- RDFS4a uuu aaa xxx. => UUU rdf:type rdfs:Resource
   */
  function build_stmt_rdfs4a(models            mdsys.rdf_models,
                             rulebases         mdsys.rdf_rulebases,
                             vcTabName         varchar2,
                             vcViewName        varchar2,
                             vcModelsUnion     varchar2,
                             iIdType           int,
                             iIdResource       int,
                             vcMarker          varchar2
                             ) 
  return varchar2;


  /**
   * RDF1: 
   *  uuu aaa yyy. => aaa rdf:type rdf:Property 
   */
  function build_stmt_rdf1(models            mdsys.rdf_models,
                           rulebases         mdsys.rdf_rulebases,
                           vcTabName         varchar2,
                           vcViewName        varchar2,
                           vcModelsUnion     varchar2,
                           iIdType           int,
                           iIdPro            int,
                           vcMarker          varchar2
                           ) 
  return varchar2;


  /**
   * RDFS4B: 
   * uuu aaa VVV. => VVV rdf:type rdfs:Resource
   */
  function build_stmt_rdfs4b(models            mdsys.rdf_models,
                             rulebases         mdsys.rdf_rulebases,
                             vcTabName         varchar2,
                             vcViewName        varchar2,
                             vcModelsUnion     varchar2,
                             iIdType           int,
                             iIdResource       int,
                             vcMarker          varchar2
                             ) 
  return varchar2;


  /**
   * RDFS8 uuu rdf:type rdfs:Class => UUU rdfs:subClassOf rdfs:Resource
   * or
   * RDFS13 uuu rdf:type rdfs:Datatype => UUU rdfs:subClassOf rdfs:Literal
   */
  function build_stmt_rdfs_sco(models            mdsys.rdf_models,
                               rulebases         mdsys.rdf_rulebases,
                               vcTabName         varchar2,
                               vcViewName        varchar2,
                               vcModelsUnion     varchar2,
                               iIdType           int,
                               iIdRdfsCls        int,
                               iIdSco            int,
                               iIdObj            int,
                               vcMarker          varchar2
                               ) 
  return varchar2;


  /**
   *    RDFS6  uuu rdf:type rdf:Property => UUU rdfs:subPropertyOf UUU.
   * or
   *    RDFS10 uuu rdf:type rdfs:Class => UUU rdfs:subClassOf UUU
   */
  function build_stmt_rdfs_reflex(models            mdsys.rdf_models,
                                  rulebases         mdsys.rdf_rulebases,
                                  vcTabName         varchar2,
                                  vcViewName        varchar2,
                                  vcModelsUnion     varchar2,
                                  iIdType           int,
                                  iIdObj            int,
                                  iIdRole           int,
                                  vcMarker          varchar2
                                  ) 
  return varchar2;


  /**
   * Build statement for rule:
   *     a fp b, a1 fp b1, b dif b1 (or b1 dif b) => a dif a1
   */
  function build_stmt_single_fp_dif(models            mdsys.rdf_models,
                                    rulebases         mdsys.rdf_rulebases,
                                    vcTabName         varchar2,
                                    vcViewName        varchar2,
                                    vcModelsUnion     varchar2,
                                    iIdOneFP          int,
                                    iIdDif            int,
                                    bFpDifHint        boolean
                                    ) return varchar2;

  /**
   * Build statement for rule:
   *     a ifp b, a1 ifp b1, a dif a1 (or a1 dif a) => b dif b1
   */
  function build_stmt_single_ifp_dif(models            mdsys.rdf_models,
                                     rulebases         mdsys.rdf_rulebases,
                                     vcTabName         varchar2,
                                     vcViewName        varchar2,
                                     vcModelsUnion     varchar2,
                                     iIdOneIFP         int,
                                     iIdDif            int
                                     ) return varchar2;


  /** 
   * RDFP14a: v hasValue w, v onProperty p, u p w ==> u type v
   */
  function build_stmt_hva(models            mdsys.rdf_models,
                          rulebases         mdsys.rdf_rulebases,
                          vcTabName         varchar2,
                          vcViewName        varchar2,
                          vcModelsUnion     varchar2,
                          iIdType           int,
                          iIdHV             int,
                          iIdOP             int
                          ) return varchar2;


  /** 
   * RDFP14b: v hasValue w, v onProperty p, u type v ==> u p w 
   */
  function build_stmt_hvb(models            mdsys.rdf_models,
                          rulebases         mdsys.rdf_rulebases,
                          vcTabName         varchar2,
                          vcViewName        varchar2,
                          vcModelsUnion     varchar2,
                          iIdType           int,
                          iIdHV             int,
                          iIdOP             int
                          ) return varchar2;

  function build_stmt_avf_plsql(outputtab       varchar2,
                                iIDType         number,
                                nRCClass        number,
                                nRCBnode        number,
                                nRCOnp          number,
                                vcModelsUnion   varchar2,
                                bHintAvfNoMerge boolean) return varchar2;


  function build_stmt_svf_plsql(outputtab varchar2,
                                iIdType int, 
                                nRCBnode number,
                                nRCClass number,
                                nRCOnp   number,
                                vcModelsUnion varchar2,
                                bDoIncremental boolean,
                                bHintSvfNoMerge boolean) return varchar2;

  function build_stmt_svf_query(vcModelsUnion varchar2, 
                                iIdSVF        number,
                                iIdOP         number,
                                vcDeltaTab    varchar2,
                                bDoIncremental boolean) return varchar2 ;

  function build_stmt_avf_query(vcModelsUnion varchar2, 
                                iIdAVF        number,
                                iIdOP         number,
                                vcDeltaTab    varchar2,
                                bDoIncremental boolean) return varchar2;

  function build_stmt_ifp_dif_query(vcModelsUnion varchar2, 
                                    iIdType       number,
                                    iIdIFP        number) return varchar2;

  function build_stmt_trans_query(vcModelsUnion varchar2,
                                  iIdType number,
                                  iIdTP   number,
                                  iIdSco  number,
                                  iIdSpo  number,
                                  iIdEqup number,
                                  iIdEquc number,
                                  iIdSam  number) return varchar2;
  
  function build_stmt_intersecth(vcModelsUnion       varchar2, 
                                 vcBatch1            varchar2, 
                                 vcBatch2            varchar2,
                                 iIdSco              number,
                                 vcPartitionedTmpTab varchar2) return varchar2;


 
  function build_stmt_svfh_query(vcModelsUnion  varchar2, 
                                 iIdOP          number,
                                 vcDeltaTab     varchar2,
                                 bDoIncremental boolean) return varchar2;

  function  build_stmt_ran_plsql(outputTab       varchar, 
                                 vcModelsUnion   varchar2, 
                                 nProp           number,
                                 nClass          number,
                                 iIdTYpe         number) return varchar2;

  function build_stmt_ran_query(vcModelsUnion  varchar2, 
                                iIDRan         number,
                                iIdSco         number) return varchar2;

  function build_stmt_proc_svf_outer(vcModelsUnion    varchar2,
                                     vcDeltaTab       varchar2,
                                     iIdSVF           number,
                                     iIdOP            number,
                                     bDoIncremental   boolean) return varchar2;

  function build_stmt_svfh_plsql(outputTab varchar2,
                                 nRCBnode1 number,
                                 iIDSco  number,
                                 nRCBnode2 number,
                                 iIDSvf  number,
                                 vcModelsUnion varchar2) return varchar2;

 /** 
   * RDFP15: v svf w, v onProperty p, u p x, x type w => u type v
   */
  function build_stmt_svf(models            mdsys.rdf_models,
                          rulebases         mdsys.rdf_rulebases,
                          vcTabName         varchar2,
                          vcViewName        varchar2,
                          vcModelsUnion     varchar2,
                          iIdType           int,
                          iIdSVF            int,
                          iIdOP             int,
                          bHintSvf          boolean
                          ) return varchar2;


  /** 
   * RDFP16: v avf w, v onProperty p, u type v, u p x => x type w
   */
  function build_stmt_avf(models            mdsys.rdf_models,
                          rulebases         mdsys.rdf_rulebases,
                          vcTabName         varchar2,
                          vcViewName        varchar2,
                          vcModelsUnion     varchar2,
                          iIdType           int,
                          iIdAVF            int,
                          iIdOP             int,
                          bHintAvf          boolean,
                          vcXMLSchemaList   varchar2
                          ) return varchar2;


             
  /**
   * Set a flag to denote whether we are in performance tracking/tuning
   * mode so that some execution plans can be dumped.
   */
  procedure set_perf_tune_mode(b boolean);


  /** 
   * Intersection rule.
   */
  function build_stmt_intersecti(models            mdsys.rdf_models,
                                 rulebases         mdsys.rdf_rulebases,
                                 vcTabName         varchar2,
                                 vcViewName        varchar2,
                                 vcModelsUnion     varchar2,
                                 iIdType           int,
                                 iIdSco            int,
                                 vcCurrentBatch    varchar2
                                 )
  return varchar2;


  function build_stmt_scothingi(models            mdsys.rdf_models,
                           rulebases         mdsys.rdf_rulebases,
                           vcTabName         varchar2,
                           vcViewName        varchar2,
                           vcModelsUnion     varchar2,
                           iRolePropagate    int, -- type
                           iRoleSource       int, -- sco
                           iIdThing          int
                           ) return varchar2;

  function build_stmt_el_init_r(vcModelsUnion varchar2,
                                vcELRTab      varchar2, 
                                iIdOP         integer,
                                iIdSVF        integer) return varchar2;
 
  --EL+ rule 2: X sco A, A sco some(r, B) => R(r,X,B)
  --expanded: X sco A, A sco b, b svf B, b onProp r => R(r,X,B)
  --optimized: X sco A, A sco b, L(b,r,B) => R(r,X,B)
  function build_stmt_el_r2(vcModelsUnion varchar2,
                            vcOutputTab   varchar2,
                            vcELRTab      varchar2,
                            vcELLTab      varchar2,
                            iIdSCO        number) return varchar2;


  --EL+ rule3: R(r,X,Y), Y sco A, some(r,A) sco B => X sco B 
  --expanded: R(r,X,Y), Y sco A, b sco B, b svf A, b onProp r => X sco B
  function build_stmt_el_r3(vcModelsUnion varchar2,
                            vcOutputTab   varchar2,
                            vcELRTab      varchar2,
                            vcELLTab      varchar2,
                            iIdSCO        number) return varchar2 ;


  --R4: R(r,x,y), r spo p => R(p,x,y) 
   function build_stmt_el_r4(vcModelsUnion    varchar2,
                            vcELRTab         varchar2,
                            vcOutputTab      varchar2,
                            vcNotExistsTab   varchar2,
                            iIdSPO        number) return varchar2;

  --R5: R(r,x,y), R(s,y,z), r chain s spo p => R(p,x,z)
  function build_stmt_el_r5(vcModelsUnion   varchar2,
                            vcELRTab        varchar2,
                            vcOutputTab     varchar2,
                            vcCurrentBatch  varchar2) return varchar2;
  
  function build_stmt_match_intersectscoh(vcModels      varchar2,
                                    vcModelsUnion       varchar2, 
                                    vcIntersectScohTab  varchar2,
                                    vcIntersectTab      varchar2,
                                    vcOutputTab         varchar2,
                                    iDist               int,
                                    iIdType             int,
                                    iIdCls              int,
                                    iIdRdfNil           int,
                                    iIdRdfFst           int,
                                    iIDSco              int) return varchar2;

  function build_stmt_el_r3_alt(vcModelsUnion varchar2,
                            vcELRTab      varchar2,
                            vcOutputTab   varchar2,
                            vcNotExistTab varchar2,
                            iIdSCO        number) return varchar2;

--  L(r,x,y,),L(r,x1,y1), y sco y1 => x sco x1
  function build_stmt_svfh_el(vcModelsUnion varchar2, 
                              vcOutputTab   varchar2,
                              vcELLTab      varchar2,
                              iIdSco        integer) return varchar2;


  function build_stmt_chain(models            mdsys.rdf_models,
                            rulebases         mdsys.rdf_rulebases,
                            vcTabName         varchar2,
                            vcViewName        varchar2,
                            vcModelsUnion     varchar2,
                            vcCurrentBatch    varchar2
                            )
  return varchar2;


  function build_owlthing_stmt(vcOutputTab   varchar2, 
                                      vcModelsUnion varchar2,
                                      iIdCls        integer,
                                      iIdSco        integer,
                                      iIdType       integer,
                                      iIdThing      integer)
  return varchar2;
  function build_owlthing_sameas_stmt(vcOutputTab   varchar2, 
                                      vcModelsUnion varchar2,
                                      iIdSam        integer,
                                      iIdType       integer,
                                      iIdThing      integer)
  return varchar2;
 
end;
/

show errors;
