begin
  execute immediate 'drop type sem_vars_table force';
  execute immediate 'drop type sem_pred_array force';
  execute immediate 'drop type sem_predicate force';
  execute immediate 'drop type sem_rule force';
  execute immediate 'drop type sem_node force';
  execute immediate 'drop type sem_nodes_array force';
  execute immediate 'drop type sem_rule_node force';
  execute immediate 'drop type sem_goal_node force';
  execute immediate 'drop type sem_rules_table force';
  execute immediate 'drop type sem_graph force';
  execute immediate 'drop type sem_terms_table';
  execute immediate 'drop type sem_term';
exception
  when others then null;
end;
/
show errors;
create or replace TYPE sem_vars_table AS table OF varchar2(100);
/
create or replace package sdo_sem_const wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
9
ff be
5iNwJE+ocMxn/u8SFWpbm0jAKsswg5m49TOf9b9cFtz60Jbc1/Cu/3LV0cy4dIsJaedSspvw
KPR0uPAox3QJaWm4M/6Zy1LSmcylNuDVukQd9o7pyt5Z6UDK6WeOL1384czB/AZG2XxGZq7Y
GHTMlEQHOXDMkUblhbGzpG1mC/bR6iQf9jmmvT81jA==

/
show errors;
create or replace type sem_term wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
d
b2 d6
QpbcmVWO1SCjl3wxqvoMPh0MdcQwgypKmMsVfHTpWPiUv1kaywIkWtbVrJtnStbbiSYLH4+1
6eY4wuLQEPVDUu80PDu8scE5t/eL1ZM3q6ZJpGGIAaLZv4aZXL9gVjgbGb/f7GeQLe0EIiaG
Id5wfoXodQJtjdtU8qAGCaLoaQJXTUz5XLV2qgJInaa3jrn+PykNo/+V2Q4oLAZdVtY=

/
show errors;
create or replace type body sem_term wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
e
c9c 394
2dNMM1DjiTsg/xe6sh3YxczXsVEwgzuxNSATfI6mj5A6lKfAEdU7N8kHJvAjDtugQayQN949
XtvjoXFEWq95p6ok/U1hyET0U62ifQAZ2Qev32tygue5hV2IiVaQmSsa3cupOKaPL3ZpJPUW
CDf94AdmrDWm7a0CvL9KTcWidT9E0MthAOcceZpCS3OzRMiV3Qch0j06Xuoq0jgv3D5nN5eo
IfvXgN8EClCkQK7QMyFGm8jIPqAtnpqvEkZcRfyC2KpOi2/DW4ad9GDKgoGztHzlFMCvQreY
RBdtegAdm+AzZk4BlIIiZ7WR6uZ+SFnHmFXLxJpAQi0hgKcBWDyNk1bx2WWHLSGrhW/zcv/R
phCpUykJE3c9R0ON8lx8qMcqwKiQy+2+NOS9CCcibjn4hWaXo1qIs+mXbww8sX2x/o8k1MC3
xF9lUfZWmj/XGM9qni3voQ/2fO/G2Ag3Kvl0CgNKl5s2Tcd0xZ/9PPHlUPsN/RIyEBB5o+/H
IUXYNJhZop2WA8BpDbv0O8lYe4GFUGDeulaEAK/A9YDogVVHxB43JxGc7Qd3M3vImUGgSQCu
IV/CezhE2Ua6hUMau6CASFuNF7ti5V8RaQEq1fI8tajpGh7iuyUzZeXmq/9np4LMpc4L+f4/
4UHtkwdUhUNkfq5ilOt8XlxyRKoXsFHeH60xoDT6YB0evAEtj0JvO66VRUxUPw5Do3HDJMSS
J3f6yWR5YV8RSzEe/arQPMDeVz2ZqkBVj86mdqqeU4NH3FB7pINXrgWGCuarh1y8ySbSMw8l
diW+olYwOsBLLomWo/iiOvFOWXpSLfydLjYke0uT0St6umE0LsPWXxO8AA11UFtGu/7dL3bV
xNTXoTBmD3I9bUUjXHj8nZlc3MnUQJKSm1sZ4oB6

/
show errors;
create or replace type sem_terms_table as table of sem_term
/
show errors;
/
create or replace TYPE sem_predicate wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
d
1e8 14c
Wp7xvEoOFJzZL1Eh+fjnvpN+p+0wg5DInUjbynQH2sE+ehsJQJi8+6j/pFyphXVakFFeE+5A
t+Vhu2ThOgqgXu03qotOW52f5w+GC87Odpq7IMS780Yduu0OkYWoHamHq2vz6PxE+goOweTP
e5QB/ANNBKGYd79NB/WrFTJtAXQWSsi+ie7eWYziyA7v1S0zRmd9fgWGL95D0bMw75OTHX6k
t2WcyJGuyVVDcqVErdJV8fASlU5IYt4uMHIMYZgtdR7n9mxECyIKZA7XgX1YiW89j1R+j2H0
D6uBz9m1G/5mKXZ6G3Bh5IqW/DbXGLAsDTgQIg==

/
show errors;
create or replace type body sem_predicate wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
e
1d31 65a
/LjZCHtslIMNizvC6Ua7ELwIl/Mwg0OTuiAGVwRVFz8CYyIUWmJpkkv8DkLnr97XG3+3V0cz
PpclfNfjBcigfmM6CPbav1rKNnVtYeXd9M1yT3KtItx0Qqs1UMbWSY+YxxINn0/t9LZTZ2U1
jPvdPJ05DSIh3YXdZXZUOTY5IS17QGHR3i/Kt9/7pvv5Jrcc7YpqWxoHkCkARHVpXKOi/LYR
Eei0eWHUZbv493hwqhUML9gioAUT1+gNvvZisQ+DVdyw67loYbFy6/2qmwb/kNW1gSxCi84i
QZ6peuYA/Idv+WqAys63Y1DZYQXqnPA35x3034JbtN9rydlUeKFtPQXYlxwMYN7BLRqjUGDW
fqptTWLXYBFwl3WfXUxrJ0EfQbMjvsCxr/h/5zs/y57vcZcM8bNCCEKH/6QgzIgEg+Rf3cOy
NB+g+zzR+0eDk89S1YbmurV0rwTxhzkR7LO9U2gZmprE2lWfxBJqa0IPNv+deJm1xTAPXFsH
eOJ4NTmulmXXgtXRtz3elylh2qphnBMxjcQwx7G8EkZyUBwqNzXO5ksaPgJN42NLdqxqv4vi
XZnXl+gedw2mXiXRRmDs6/vwqaIUWwGbii6wuYNMNpfs7IcBwYHoMrLTPpwtileMYL16vw2P
qHe+z5alGWgwhv84w1e3mDSaS+dscFWkZW7M3p23RxvyKVtTQ/rDnJftHE+L+M+5OfYgCVrB
IhwQgwMb8Iu3n4hmjG4/QhxyipO5xOq711jM6+Xd4Bxb/gXlG3SltypF48djPkzhqPl7nzZ6
t5KlhR+sF2ZxFb2JsZUUpaeZF5+glFnqKvBnrVU5P1ty0XD3hG8tMCLLzM5fEuGNh3nRs/qR
+ejDI72cFyHY+sC87L7HJ1SANEtL3Cqz9wg8p3GtfjJ9/zrIuapMI22PAx80dghfuao7c8hI
y9ksoJO0xzSPac9wjmOlPdFfwxzjTMEZwWeeKf/vli6t5ZFqrJ4AfhffDKXWkqbbINHeWKcR
tNKipxcRVGWvOWlWTBvnHqljImWPpvrTN+Ah4UQ1P4lfuSpis8L6ui2sLvNp7iptb/8sKRq9
dFpWhMGtwoJwn932JhStgyrusEfu0aYLvtBi7AF6GDAFKSGGxZWpL45ca+f0FEcPBXj1jRHv
QD23MRUdiClv2jAr91itw0iOqYinI/Ckr7iQUFhObbj84PGyHoWv3j6FfIyOIiRmlOHzs6Ed
pLYOuuWDNsXUjGY1YY+aRvfDFjzPDFxlPlBYz9sA4UretswDiFtyG9jrUt5M5R+ncMn5+mY1
ay5O7MhdVOrw7CPyDlUVgbUUJlPPegazrj69tCjIpUNYDo1MY39UNEQsFur93j7t72+M07UE
tqEWltkLGp0eUX1LbSXSYVmJ1VeduBUTZmT0H/LJ+IOIIdncGXqZSb4XvqLdA/f+CKJ8TBZa
qoWgwaORVJTVUlMQC1YH8lmRz4ABR8SsMLt9x2V9eNTFifXiIWqsQss1GwSxPtXPtUHrlu2O
oqj/jOHBau1uB0J5LQRsDNbV01UII1hVlmwySQzuoxbJO5HmvSlqRtKKYXtW7iNT14Ecj0bo
yLriOC7FOTM6xqo2oITz

/
show errors;
create or replace type sem_pred_array AS varray(1000) of sem_predicate;
/
create or replace type sem_rule wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
d
f4 eb
G7gufkpZ0f7WbPy/46sb2K5DNPYwgzLwLcvWfHSi2k6UHPR3+y2fZfSZw9v0dlv09PTw0TuS
tY0O9ScgEP659Rg2ckMiJIce4XXKIXjCngH7pvP3Kq9Boj9K5khg827/2rvnVaoio2CuLCJR
tMtj0R7lZf0zXf3TU8lhg1tAykoUQ+iyVxQWgG3R5xLgAkGdvPuo1xUFa103P0jeWsUAxIA6
S5nHre37yw0ARA==

/
show errors;
create or replace type body sem_rule wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
e
eaa 5a7
PZsRLYaoM1Bq5dstVc3obLNyuJkwg5DqLiCGV3RVA6oCSPctoch0fJw5Yg7b8uXdp+GTM2Gw
cFu6dG91VfujR3k/5Anxefdh6+Arc1pZzHfvOlr6uTpmMRmOcorNQ08eHtAglll3iAuGD84K
kQ2cp6T9ELiXEYtZzdglSclj9tjJO0sHgDgkf0OyfOhUdvKYTC9uxqwzj+VttYorm3ITLrwL
OLnALcKpcqMr6rVcpEa3UjH5TX7Nj+t1CZ7XublYAy51aNm3JZNo+YUwYtmGkmZGn4GScKvN
tB0FXUcA8pDpVoAL+00ldApg+B4q86fhkWN/nEgBaKjgqBvzomefjgFV7jOEFbYlbfOmDc5D
wa5hVMJECbFEfrdBsJLnZuo6Ra6ecvjpGUYHpE8tr/QtRLoAzlXGCBKJUQTGlqtyi3Bswz+o
mtzMOI4AEuTyljetZ6n6eBtBLQKgMgMkiONihs01jtT88uF6jRF1/qcA1n5el0GcH/N0hRXG
fo+xXFTVQZjd44QL/o9kSXBQpoyBPfQQMWMJf3o55m1CUtqWInJtlH6H9LD0BJHyH5v0GP4C
Jl+NALvgofUqGkMp5dJ/DigMzxgrT3hV8rPlo75pAThvB3CWT8Oy7mvJ7y9Vw4DVQ3Aq9IRH
rHY9MAs1JU54GwcgEGsHQoUjIdvJ4NdA8RyFQMAd/2lzQYchapCj8mUseaSO5w+uJTpYhy2y
YhsnxosvQ6p6xQ5cmdvgg1foE8LbpGb9gzbIlJ6mgjIx0cQ6cwbZrJ9KXVWjIr5pnus+SqDP
6pfzehnxFQdmDOkY7VBwP1AuYmaVrS0dK7JdjxNDXcb9qMOic1PQzCQCUdagodB2RGTVOVAV
fhlrM2L5F/joEDS/nG1uVYyE4SoedB/V5fvdYTHwG15sXxew2JntullUeLcq2+1X4PWta3Dc
VdvpV9m30aRMr67Q2LTlz8euoBOmiA5uJKnTavCFzzMIuabc/7O9YaLYIdQHXXpd3c5OhR7z
Tr3vRS6YMEfm/euperX/YdrYWXjo/qmTg2k3eJwQXTPNq6rGD7tiSRM7S++tdpJMiP82+5QW
lZhmsw5865M52dsEyjL8PEwRI+2hc6f+TRxasQSvT83qkdmK1lGk5HVihyPDa7C9r4ZN7CUm
o3s8EarXPqk/nuJ6eKDaWha3ah/A+S7L02XZJrm4bkcSWF8aP1jJc0XNfdL6SBx87j+TdQok
EwzHowqDwfpxYzOAQq/H8WJRvSfPLazzGeq8nfmBm5L+nQ+7b2oQUwARzPq4kLwjPkUkKEml
j0d30gXQlg+dtTrNzUjzjSPgN6ohcRqyn7Jp7eumF+3nS94Jj2aq60R6GwqPq10aOyeq9IhW
5AYlrnMJiUiVG7wHuVGSsQ3+GYJg/rjyvmy8EmJSkpvued21+M0kHG5X8g==

/
show errors;
create type sem_node wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
d
92 ba
Awdw4ocGNnA6wXfsTqdbmeWfny8wg5n0dLhcFtzX8HLZrqFcuHQrpb+bwDLLzFCPCWmlx/Uy
Ur+yK6n7rp3IMMYOysZapA4aF3UXSxfjCpnxFFpXRzFys7GU4umoR3+FMWp/hVpqtN1nttiW
tCp8dz1yMZRr0G0MXq9yJKKv1+tyswf7pv48yqA=

/
show errors;
create or replace type sem_nodes_array AS varray(500) of sem_node;
/
create or replace type sem_rule_node wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
d
13b ff
HDQ7I74oz8p4F2pJgPs574/Gq24wgzLQcp4VfHQHALs+wGjdnBHEw54qPSGkMPyVVeQdGLsg
2oBbUQBsOlqdD131ZzDcsdIwTOj1mE9J4yHKhN0QZiTKoLKmfIAHSzSs8p1ikcODwfCNXxiE
02PVeF/nqr6yzLs0wILEFE5L/o5GC5ZBr6L8lSPlg60r+KHDjHd2DxiVmuQlZLkG16QcDD37
jKLR5hdnAs8AQH0UtbP1Z4fdVAlITjlXhGkj

/
show errors;
create or replace type body sem_rule_node wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
e
390 20f
gPURxxV+loQU/FzRzSwubEQi004wg40J2UjWfC+KWGS0/aLlURbGYAAEAxRvSpDONdn0DMce
hCc9/SwPnVrK3iiB+/AXpYqKg+jayonC/I8e0jyqP51Bkv7QnLYvkAGmw555iWNgxU07DkCh
+6v+7cJ2EqjVRuZCzxu7a2xjoFGeWQyJubI+7w/VoheeeNPrYWjyFTe9hr8w0hH7nvBcvMpk
TMrEPaf9sIS43t5WXW59Sk0yLYc7bxMUOqOlE9vK0erK09duFlLZoqfgmyOIBRIwRqbfHziK
66G9/9svyhEcLhrHA9x2CMkJaS/YYU3WVlmuiWZMLXWroFmC1mubxZtev3qjjo6MABy3gVdW
xos6flq26FghA9hYJd6irtqLyVDO+pneZ1T/NwxChQZdYLu4e+44BPAYGwKdmx/Ofv+rRe8Z
UqdqxvjqXzApqOmpqEaAxIis/izz4mCDCTUzONycW3/x4hXkCQeoPb6TQk/4moaQNhsiIJ01
tTDkwblbvot34g==

/
show errors;
create or replace type sem_goal_node wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
d
6c a6
y499pqobWXj5qdzTOKgS6/O05v0wg5n0dLhcFtzX8K5yrkf0ctmuoVzngcdSsgnnn4Hw/k6/
UlxQjwlpaefn58AyzKnhyI7juymKBAblHfHLx5/1CCibTjKBmfvAdtZuAHbWXyF0siG+IZTk
5ISOaHpzdhAEpupN/SY=

/
show errors;
create or replace type sem_rules_table AS table of sem_rule;
/
create or replace type sem_graph wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
d
702 2c1
RBQr/OADuT0FXCMwDcOzj1dbsTIwg5BcLiAFfHRVvp3mgFt9AUy1pmKCSisQjVFoQ46KafWc
+2oztTcp71J2d1KQniJaFE9BzhQlNP4W+e35IjRzczrBnKnKcfikbG2L3OcBTAclwoWEk7yu
35kxBBihNiEHwnqm84oDJBA2SsOuzMFLdgnoW0ArhhAI/X2N2PuCPw9zQUsK+XragjDns+qw
dVIMFx1eiYpafoyN2G5iOAA3mmyfXVoxUcStVaDLzLB303cO3vdGSUktbUZR8PK/C2Uuo1v1
liOZaycle7DzfuhzuJFW+XCgqKTn0r2YWBdA4tXCIT5MS3Zgvpa3TAQcn+dVzVM1o3xUsGfA
W9K4UtTM62bcMeqhcH5AwAvvznQP73LKhH62j35TvW5GTrbSeY/SBiTZ2MCXbvZ9kUs089Wp
xupXhy73S3z/JBWbMMFzQdMprJ2AbYmfJB9VwHGu0ZJk9h0sPDk/uv3OUy8EiQijef4sQ/GX
wa1mzcfHJ/IDWnjvcV0Mr3jqs4iF4k2DtDQEElUyX6EQ2x2C8ZDIanYSO9vVuvOreHAxYgKn
OxljeytrUP8A6Q9KtLQRZV5CRgtPCsZBW/6F7R1MULZnYWJR/DKk+EtXxRobfqxW/SQu2rBp
RHo8xkYgYeEZTvCdApPU+wlDQLdich6WAfS7SE5DJKN+Cng=

/
show errors;
create or replace type body sem_graph wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
e
b441 22ce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/
grant execute on mdsys.sem_predicate to public
/
grant execute on mdsys.sem_term to public
/
grant execute on mdsys.sem_terms_table to public
/
grant execute on mdsys.sem_pred_array to public
/
show errors;
