Rem
Rem $Header: sdosemlogh.sql 27-apr-2006.10:10:42 alwu Exp $
Rem
Rem sdosemlogh.sql
Rem
Rem Copyright (c) 2006, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      sdosemlogh.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    alwu        04/27/06 - add debug_nh: no header 
Rem    alwu        04/21/06 - add NEWLINE constant 
Rem    alwu        04/14/06 - start
Rem    alwu        04/14/06 - start
Rem    alwu        04/14/06 - Created
Rem

create or replace package sdo_sem_log as

  NEWLINE      constant char(1) := chr(10);

  DEFAULT_LOG_LEVEL constant integer := 0;

  /**
   * m_iLogLevel can take the following values, with increasing verbosity 
   * (and decresing severity)
   * 0 FATAL ERROR
   * 1 ERROR
   * 2 ASSERTION
   * 3 WARNING
   * 4 INFO
   * 5 DEBUG
   */
  m_iLogLevel  integer := DEFAULT_LOG_LEVEL;

  m_vcPrevLogSetting varchar2(32767) := null;

  -- tried sysdate. not enough precision
  m_tsStartTime timestamp := systimestamp;

  -- Users can choose to dump info using DBMS_OUTPUT or TRACE files
  -- by default is trace
  m_vcLogOutput varchar2(100) := 'TRACE';

  --
  -- By default, log goes to trace files
  --
  procedure set_log_output(vcDest varchar2);
  procedure set_log_level(i integer);
  function  get_log_level return integer;

  function is_fatal_enabled     return boolean;
  function is_error_enabled     return boolean;
  function is_warning_enabled   return boolean;
  function is_assertion_enabled return boolean;
  function is_info_enabled      return boolean;
  function is_debug_enabled     return boolean;

  function get_caller_info return varchar2;


  /** 
   * The following two methods (fatal, error) will un-ambiguously record 
   * the error message, plus line number for this method call,
   * plus exception location if applicable,
   * plus call stack trace.
   * e.g.
   *
   * Case 1: there is no exception. Just an unexpected error condition.
   *    if (...) then
   *      sdo_sem_log.error('test3: should never be true');
   *    end if;
   *  ==> 
   *    "110015, MDSYS" @time: 0  [error] test3: should never be true
   *    Line# 349 in package body MDSYS.SDO_SEM_LOG
   *    Line# 358 in package body MDSYS.SDO_SEM_LOG
   *    Line# 367 in package body MDSYS.SDO_SEM_LOG
   *    Line# 1 in anonymous block
   *
   * Case 2: there is exception caught in the exception block
   *    begin
   *      ...
   *    exception
   *      when others then
   *        sdo_sem_log.error('test1: Caught exception');
   *        raise;
   *    end;
   *  ==> 
   *
   *    "110015, MDSYS" @time: 0  [error] test1: Caught exception
   *    ORA-20000: test2 error happened
   *    ORA-06512: at "MDSYS.SDO_SEM_LOG", line 342
   *    ORA-06512: at "MDSYS.SDO_SEM_LOG", line 352
   *    ORA-06512: at "MDSYS.SDO_SEM_LOG", line 358
   *    Line# 361 in package body MDSYS.SDO_SEM_LOG
   *    Line# 367 in package body MDSYS.SDO_SEM_LOG
   *    Line# 1 in anonymous block
   */
  procedure fatal(vcMsg varchar2);
  procedure error(vcMsg varchar2);

  procedure warning(vcMsg varchar2) ;
  procedure info   (vcMsg varchar2) ;

  procedure debug   (vcMsg varchar2) ;
  procedure debug_nh(vcMsg varchar2) ;

  procedure assert(b boolean, vcMsg varchar2);

  /** Testing (Unit Testing) Code Starts Next. TODO: to be removed before
      production **/
  procedure test;
end;
/


show errors;


