BEGIN
EXECUTE IMMEDIATE
'CREATE OR REPLACE OPERATOR SEM_RELATED
  BINDING
  (VARCHAR2, VARCHAR2, VARCHAR2, MDSYS.RDF_Models,
  MDSYS.RDF_Rulebases, VARCHAR2) RETURN NUMBER
  WITH INDEX CONTEXT, SCAN CONTEXT sem_indextype_im COMPUTE ANCILLARY DATA
  USING SDO_SEM_OPERATOR.sem_related_func,
  (VARCHAR2, VARCHAR2, VARCHAR2, MDSYS.RDF_Models,
  MDSYS.RDF_Rulebases, INTEGER, INTEGER) RETURN NUMBER
  WITH INDEX CONTEXT, SCAN CONTEXT sem_indextype_im COMPUTE ANCILLARY DATA
  USING SDO_SEM_OPERATOR.sem_related_func,
  (VARCHAR2, VARCHAR2, VARCHAR2, MDSYS.RDF_Models,
  MDSYS.RDF_Rulebases, VARCHAR2, INTEGER, INTEGER) RETURN NUMBER
  WITH INDEX CONTEXT, SCAN CONTEXT sem_indextype_im COMPUTE ANCILLARY DATA
  USING SDO_SEM_OPERATOR.sem_related_func,
  (VARCHAR2, VARCHAR2, VARCHAR2, MDSYS.RDF_Models,
  MDSYS.RDF_Rulebases) RETURN NUMBER
  WITH INDEX CONTEXT, SCAN CONTEXT sem_indextype_im COMPUTE ANCILLARY DATA
  USING SDO_SEM_OPERATOR.sem_related_func';
EXCEPTION 
  WHEN OTHERS THEN
    
    IF (SQLCODE != -29809) THEN
      RAISE;
    END IF;
END;
/
show errors;
GRANT EXECUTE on MDSYS.SEM_RELATED TO PUBLIC;
CREATE OR REPLACE PUBLIC SYNONYM SEM_RELATED FOR MDSYS.SEM_RELATED;
BEGIN
EXECUTE IMMEDIATE
'CREATE OR REPLACE OPERATOR SEM_DISTANCE
  BINDING
  (NUMBER) RETURN NUMBER
  ANCILLARY TO SEM_RELATED (VARCHAR2, VARCHAR2, VARCHAR2, MDSYS.RDF_Models,
                            MDSYS.RDF_Rulebases, VARCHAR2),
               SEM_RELATED (VARCHAR2, VARCHAR2, VARCHAR2, MDSYS.RDF_Models,
                            MDSYS.RDF_Rulebases, INTEGER, INTEGER),
               SEM_RELATED (VARCHAR2, VARCHAR2, VARCHAR2, MDSYS.RDF_Models,
                            MDSYS.RDF_Rulebases, VARCHAR2, INTEGER, INTEGER),
               SEM_RELATED (VARCHAR2, VARCHAR2, VARCHAR2, MDSYS.RDF_Models,
                            MDSYS.RDF_Rulebases)
  USING  SDO_SEM_OPERATOR.sem_distance_func';
EXCEPTION 
  WHEN OTHERS THEN
    
    IF (SQLCODE != -29809) THEN
      RAISE;
    END IF;
END;
/
show errors;
GRANT EXECUTE ON SEM_DISTANCE TO PUBLIC;
CREATE OR REPLACE PUBLIC SYNONYM SEM_DISTANCE FOR MDSYS.SEM_DISTANCE;
BEGIN
EXECUTE IMMEDIATE
'CREATE OR REPLACE OPERATOR SEM_PATH
  BINDING
  (NUMBER) RETURN VARCHAR2
  ANCILLARY TO SEM_RELATED (VARCHAR2, VARCHAR2, VARCHAR2, MDSYS.RDF_Models,
                            MDSYS.RDF_Rulebases, VARCHAR2),
               SEM_RELATED (VARCHAR2, VARCHAR2, VARCHAR2, MDSYS.RDF_Models,
                            MDSYS.RDF_Rulebases, INTEGER, INTEGER),
               SEM_RELATED (VARCHAR2, VARCHAR2, VARCHAR2, MDSYS.RDF_Models,
                            MDSYS.RDF_Rulebases, VARCHAR2, INTEGER, INTEGER),
               SEM_RELATED (VARCHAR2, VARCHAR2, VARCHAR2, MDSYS.RDF_Models,
                            MDSYS.RDF_Rulebases)
  USING  SDO_SEM_OPERATOR.sem_path_func';
EXCEPTION 
  WHEN OTHERS THEN
    
    IF (SQLCODE != -29809) THEN
      RAISE;
    END IF;
END;
/
show errors;
BEGIN
EXECUTE IMMEDIATE
'CREATE OR REPLACE INDEXTYPE sem_indextype
 FOR
  sem_related(VARCHAR2, VARCHAR2,VARCHAR2, MDSYS.RDF_Models, 
              MDSYS.RDF_Rulebases, VARCHAR2),
  sem_related(VARCHAR2, VARCHAR2,VARCHAR2, MDSYS.RDF_Models, 
              MDSYS.RDF_Rulebases, INTEGER, INTEGER),
  sem_related(VARCHAR2, VARCHAR2,VARCHAR2, MDSYS.RDF_Models, 
              MDSYS.RDF_Rulebases, VARCHAR2, INTEGER, INTEGER),
  sem_related(VARCHAR2, VARCHAR2,VARCHAR2, MDSYS.RDF_Models, 
              MDSYS.RDF_Rulebases)
 USING sem_indextype_im
 WITH ORDER BY SEM_DISTANCE (NUMBER)';
EXCEPTION 
  WHEN OTHERS THEN
    
    IF (SQLCODE != -29832) THEN
      RAISE;
    END IF;
END;
/
show errors;
GRANT EXECUTE ON sem_indextype TO PUBLIC;
