Rem
Rem $Header: sdo/admin/sdosemvalh.sql /main/5 2009/05/18 13:16:46 alwu Exp $
Rem
Rem sdosemvalh.sql
Rem
Rem Copyright (c) 2006, 2009, Oracle and/or its affiliates. 
Rem All rights reserved. 
Rem
Rem    NAME
Rem      sdosemvalh.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    alwu        05/14/09 - add NegativePropertyAssertion checking based on
Rem                           the recent W3C OWL 2 profile change
Rem    alwu        03/27/09 - add more validation logic for SKOS integrity
Rem    alwu        03/27/09 - add more IDs for SKOS integrity conditions
Rem    alwu        09/07/06 - bring back sdo_sem_validate to public for passing tst
Rem    alwu        09/07/06 - sync up 11g document and proposed APIs
Rem    alwu        06/01/06 - hook up with stats gathering 
Rem    alwu        05/26/06 - Add implementation 
Rem    alwu        05/19/06 - start
Rem    alwu        05/19/06 - start
Rem    alwu        05/19/06 - Created
Rem

create or replace package sdo_sem_validate authid current_user as

  -- List of error code for validation entry
  ERR_CODE_UNSAT           constant int := 10001;
  ERR_CODE_INST            constant int := 10002;
  ERR_CODE_SAM_DIF         constant int := 10003;
  ERR_CODE_SELF_DIF        constant int := 10004;
  ERR_CODE_EMPTY           constant int := 10005;
  ERR_CODE_SYNTAX_P        constant int := 10006;
  ERR_CODE_SYNTAX_S        constant int := 10007;
  ERR_CODE_PROPDISJ        constant int := 10008;
  ERR_CODE_SKOSXL_LBLCARD  constant int := 10009;
  ERR_CODE_NOPA            constant int := 10010;
  ERR_CODE_NDPA            constant int := 10011;

  function get_err_mesg(code int) return varchar2;

  /**
   * This function validates a set of models (and their rules index
   * if rulebase is provided) against certain criteria. Pay attention
   * that inference will not be done on the fly for validation. All
   * relevant conflicts must exist explicitly in the graph before they
   * can be reported.
   *
   * Two most important criteria are:
   *  - UNSAT: unsatisfiable class which is denoted in the graph by
   *
   *           C1   rdfs:subClassOf  owl:Nothing
   *
   *  - INST: instance classification conflict is denoted in the grpah by
   *           I1   rdf:type  C1
   *           I1   rdf:type  C2
   *           C1   owl:disjiontWith C2
   *
   * More criteria are listed as follows:
   *  - SAM_DIF: two instances are claimed to the same and DIFerent
   *           at the same time
   *          I1    owl:sameAs        I2
   *          I1    owl:DIFerentFrom I2
   *  
   *  - SELF_DIF: an instance is claimed to be DIFerent from itself
   *          I1 owl:DIFerentFrom I2
   *
   *  - EMPTY: an individual is claimed to be an instance of an unsatisfiable 
   *          class.
   *          I1 rdf:type owl:Nothing
   *
   * Return value from this function is an array of strings. 
   * If return value is NULL, then there is no conflicts detected
   * based on the criteria chosen.
   * Otherwise, each string is of the following format:
   *
   *   num_triples error_code triple_1 ... triple_n error_msg
   * 
   * Each triple has three value IDs inside a pair or parenthesis.
   *
   * An example which involves only 1 triple is as follows:
   *
   *    1  1099 (100 120 354) Unsatisfiable class
   * 
   * A more complex example that involves two triples looks like:
   *    2  1210 (453 108  567) (453 109 567) Instances are same/DIFerent
   *                                    at the same time
   *
   * If max_conflict is 0, then the validation process will continue
   * until all conflicts are found.
   */
  function validate(models_in         mdsys.rdf_models,
                    rulebases_in      mdsys.rdf_rulebases,
                    criteria_in       varchar2 default null,
                    max_conflict      int default 100,
                    options           varchar2 default null
                    )
  return mdsys.rdf_longVarcharArray;


  /**
   * Get the limit for bulk collect fetching.
   */
  function get_bulkload_limit return int;

    
  /**
   * Set the limit for bulk collect fetching.
   */
  procedure set_bulkload_limit(i int);
end;
/

show errors;

create or replace public synonym sdo_sem_validate for mdsys.sdo_sem_validate;
grant execute on sdo_sem_validate to public;

