Rem
Rem $Header: sdo/admin/sdowfslh.sql /main/11 2009/02/21 08:53:16 sravada Exp $
Rem
Rem sdowfslh.sql
Rem
Rem Copyright (c) 2006, 2009, Oracle and/or its affiliates.
Rem All rights reserved. 
Rem
Rem    NAME
Rem      sdowfslh.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    sravada     02/18/09 - enable short txns
Rem    rchatter    03/28/06 - Created
Rem


declare
begin
 begin
  execute immediate
   ' drop table MDSYS.SDO_WFS_LOCAL_TXNS ';
   exception when others then NULL;
  end;
end;
/

CREATE GLOBAL TEMPORARY TABLE MDSYS.SDO_WFS_LOCAL_TXNS (
   SessionID    VARCHAR2(30) )  on commit preserve rows;

GRANT select, insert ON MDSYS.SDO_WFS_LOCAL_TXNS TO PUBLIC;


CREATE OR REPLACE PACKAGE MDSYS.SDO_WFS_LOCK authid current_user AS

cleanup number := 1;
ROWCNT_THRESHOLD number := 100;

procedure registerFeatureTable(userName IN varchar2, tableName IN varchar2) ;
procedure unRegisterFeatureTable(userName IN varchar2, tableName IN varchar2) ;
function lockRowsById(userName IN VARCHAR2, 
		  tableName IN varchar2, 
		  tableAlias varchar2,  
		  expiryTime IN number, 
		  rowsLocked OUT mdsys.RowPointerList, 
		  rowsNotLocked OUT mdsys.RowPointerList, 
		  lockAll varchar2, 
		  pkeyCols mdsys.StringList, 
		  autoCommit varchar2, 
		  rowsToBeLocked IN  mdsys.RowPointerList, 
		  orderClause varchar2, 
		  indexClause varchar2, 
		  maxcnt number) return number;
procedure lockRowsById(pTokenId IN varchar2, 
		userName IN VARCHAR2, 
		tableName IN varchar2, 
		tableAlias varchar2,  
		expiryTime IN number, 
		rowsLocked OUT mdsys.RowPointerList, 
		rowsNotLocked OUT mdsys.RowPointerList, 
		lockAll varchar2, 
		pkeyCols mdsys.StringList, 
		autoCommit varchar2, 
		rowsToBeLocked IN  mdsys.RowPointerList, 
		orderClause varchar2, 
		indexClause varchar2, 
		maxcnt number) ;
procedure unlockRowsById(pTokenId IN varchar2, 
		userName IN VARCHAR2, 
		tableName IN varchar2, 
		tableAlias IN varchar2,  
		pkeyCols IN mdsys.StringList, 
		autoCommit IN varchar2, 
		rowsToBeUnLocked IN  mdsys.RowPointerList);
procedure transferTokenById (pTokenId IN varchar2) ;

procedure updateTokenSessionMap(tId varchar2, sId varchar2) ;

procedure deleteTokenSessionMap(tId varchar2) ;

function queryTokenSessionMap (tId varchar2) return varchar2 ;

procedure resetTokenExpiry(tId varchar2) ;

function generateTokenId return varchar2;

procedure enableDBTxns;
end;
/

show errors;

create or replace public synonym SDO_WFS_LOCK for mdsys.SDO_WFS_LOCK;

show errors;


