declare
  stmt VARCHAR2(10000);
  rec_count NUMBER;
begin
  select count(*) into rec_count from ALL_TABLES where owner = 'MDSYS' and table_name = 'CURRENTSESSIONTOKENMAP_T$';
  if(rec_count = 0) then
     stmt := ' create table MDSYS.CurrentSessionTokenMap_t$ (sessionId varchar2(30), tokenId varchar2(100) , primary key(sessionId, tokenId))';
   execute immediate stmt;
  end if;

     stmt := ' create or replace view MDSYS.CurrentSessionTokenMap$ as select sessionId , tokenId from MDSYS.CurrentSessionTokenMap_t$ where sessionId in (select dbms_session.unique_session_id from dual)';
   execute immediate stmt;

  select count(*) into rec_count from ALL_TABLES where owner = 'MDSYS' and table_name = 'TOKENSESSIONMAP_T$';
  if(rec_count = 0) then
     stmt := ' create table MDSYS.TokenSessionMap_t$ (sessionId varchar2(30), tokenId varchar2(100) unique, expiryTime timestamp(6), expiryOffset number, primary key(sessionId, tokenId))';
   execute immediate stmt;
  end if;

  stmt := ' create or replace view MDSYS.TokenSessionMap$ as select sessionId , tokenId , expiryTime, expiryOffset from MDSYS.TokenSessionMap_t$ where (tokenId in (select tokenId from MDSYS.CurrentSessionTokenMap$ where sessionId in (select dbms_session.unique_session_id from dual))) or expiryTime < sysdate';
  execute immediate stmt;
end;
/
show errors;
declare 
  stmt VARCHAR2(10000);
  rec_count NUMBER;
begin
  select count(*) into rec_count from ALL_TABLES where owner = 'MDSYS' and table_name = 'ROWTOKENMAP_T$';
  if(rec_count = 0) then
     stmt := ' create table MDSYS.RowTokenMap_t$ (tokenId varchar2(100) references TokenSessionMap_t$(tokenId) on delete cascade, tableName varchar2(61), rpointer ROWID, markedDeleted varchar2(1) default NULL)';
   execute immediate stmt;
   begin
    stmt := ' alter table  MDSYS.RowTokenMap_t$  add constraint unique_rowtokenmap_cond UNIQUE (tableName, rpointer) ';
    execute immediate stmt;
    exception when others then null; end;
  end if;
   stmt := ' create or replace view MDSYS.RowTokenMap$ as select tokenId , tableName , rpointer , markedDeleted from  MDSYS.RowTokenMap_t$  where tokenId in (select tokenId from mdsys.TokenSessionMap$) ';
   execute immediate stmt;
end;
/
show errors;
declare
  stmt VARCHAR2(10000);
  rec_count NUMBER;
begin
  select count(*) into rec_count from ALL_SEQUENCES where  SEQUENCE_OWNER= 'MDSYS' and sequence_name = 'TOKEN_SQ$';
  if(rec_count = 0) then
    stmt := ' CREATE SEQUENCE MDSYS.token_sq$ START WITH 1 NOCACHE';
    execute immediate stmt;
  else
     stmt := ' drop sequence MDSYS.token_sq$ ';
     execute immediate stmt;
     stmt := ' CREATE SEQUENCE MDSYS.token_sq$ START WITH 1 NOCACHE';
     execute immediate stmt;
  end if;
end;
/
show errors;
declare
  stmt VARCHAR2(10000);
  rec_count NUMBER;
begin
  select count(*) into rec_count from ALL_SEQUENCES where SEQUENCE_OWNER = 'MDSYS' and sequence_name = 'FT_SQ$';
  if(rec_count = 0) then
    stmt := ' CREATE SEQUENCE MDSYS.ft_sq$ START WITH 1 NOCACHE';
    execute immediate stmt;
  else
     stmt := ' drop sequence MDSYS.ft_sq$  ';
     execute immediate stmt;
     stmt := ' CREATE SEQUENCE MDSYS.ft_sq$ START WITH 1 NOCACHE ';
     execute immediate stmt;
  end if;
end;
/
show errors;
declare
  stmt VARCHAR2(10000);
  rec_count NUMBER;
begin
  select count(*) into rec_count from ALL_SEQUENCES where SEQUENCE_OWNER = 'MDSYS' and sequence_name = 'XMLINFO_SQ$';
  if(rec_count = 0) then
    stmt := ' CREATE SEQUENCE MDSYS.xmlinfo_sq$ START WITH 1 NOCACHE';
    execute immediate stmt;
  else
     stmt := ' drop sequence MDSYS.xmlinfo_sq$  ';
     execute immediate stmt;
     stmt := 'CREATE SEQUENCE MDSYS.xmlinfo_sq$ START WITH 1 NOCACHE ';
     execute immediate stmt;
  end if;
end;
/
show errors;
declare
  stmt VARCHAR2(10000);
  rec_count NUMBER;
begin
  select count(*) into rec_count from ALL_SEQUENCES where SEQUENCE_OWNER = 'MDSYS' and sequence_name = 'WFS_PROC_SQ$';
  if(rec_count = 0) then
    stmt := ' CREATE SEQUENCE MDSYS.wfs_proc_sq$ START WITH 1 NOCACHE';
    execute immediate stmt;
  else
     stmt := ' drop sequence MDSYS.wfs_proc_sq$  ';
     execute immediate stmt;
     stmt := ' CREATE SEQUENCE MDSYS.wfs_proc_sq$ START WITH 1 NOCACHE ';
     execute immediate stmt;
  end if;
end;
/
show errors;
grant select, alter on mdsys.token_sq$ to spatial_wfs_admin;
grant select, alter on MDSYS.ft_sq$ to spatial_wfs_admin;
grant select, alter on MDSYS.xmlinfo_sq$ to spatial_wfs_admin;
grant select, alter on MDSYS.wfs_proc_sq$ to spatial_wfs_admin;
grant all on mdsys.RowTokenMap$ to spatial_wfs_admin;
grant all on mdsys.TokenSessionMap$ to spatial_wfs_admin;
grant all on mdsys.CurrentSessionTokenMap$ to spatial_wfs_admin;
grant all on mdsys.RowTokenMap_t$ to spatial_wfs_admin;
grant all on mdsys.TokenSessionMap_t$ to spatial_wfs_admin;
grant all on mdsys.CurrentSessionTokenMap_t$ to spatial_wfs_admin;
grant select, alter on mdsys.token_sq$ to spatial_wfs_admin_usr;
grant select, alter on MDSYS.ft_sq$ to spatial_wfs_admin_usr;
grant select, alter on MDSYS.xmlinfo_sq$ to spatial_wfs_admin_usr;
grant select, alter on MDSYS.wfs_proc_sq$ to spatial_wfs_admin_usr;
grant all on mdsys.RowTokenMap$ to spatial_wfs_admin_usr;
grant all on mdsys.TokenSessionMap$ to spatial_wfs_admin_usr;
grant all on mdsys.CurrentSessionTokenMap$ to spatial_wfs_admin_usr;
grant all on mdsys.RowTokenMap_t$ to spatial_wfs_admin_usr;
grant all on mdsys.TokenSessionMap_t$ to spatial_wfs_admin_usr;
grant all on mdsys.CurrentSessionTokenMap_t$ to spatial_wfs_admin_usr;
grant all on mdsys.RowTokenMap$ to wfs_usr_role;
grant all on mdsys.TokenSessionMap$ to wfs_usr_role;
grant all on mdsys.CurrentSessionTokenMap$ to wfs_usr_role;
declare
  stmt VARCHAR2(10000);
  rec_count NUMBER;
begin
  select count(*) into rec_count from ALL_TABLES where owner = 'MDSYS' and table_name = 'WFS_TRG_TABLE_TEMP$';
  if(rec_count = 0) then
    stmt := 'create table wfs_trg_table_temp$ (r rowid)' ;
    execute immediate stmt;
  end if;
end;
/
show errors;
grant all on MDSYS.WFS_TRG_TABLE_TEMP$ to spatial_wfs_admin;
grant all on MDSYS.WFS_TRG_TABLE_TEMP$ to spatial_wfs_admin_usr;
grant all on MDSYS.WFS_TRG_TABLE_TEMP$ to wfs_usr_role;
CREATE OR REPLACE PACKAGE MDSYS.SDO_WFS_PROCESS_UTIL wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
9
7c 92
mCKsDXN1w7Nq2h2nekDmlOqWFecwg3lHf8upynSmZxcPs6p8XBZG42JhbEUItQ9XrSk/vkpS
xuZwoYuNeZ+NWsnHMHmpYYuvswp8juAJ9UXQK63ZoLaJzxYd0Avvsg+SPySnVwJD+xrmZrM=


/
show errors
CREATE OR REPLACE PACKAGE BODY MDSYS.SDO_WFS_PROCESS wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
b
3b146 8ac2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/
show errors;
CREATE OR REPLACE PACKAGE BODY MDSYS.SDO_WFS_PROCESS_UTIL wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
b
157 eb
jM+N0ZQyENiyWtD+tOdnhNJegwswg2NKDMsVfHSik8GOh0u5REWXxiZm05jby6AKaLVvjswi
09ql4FYMQVh4uqrCtqyGS6w2ubEWEOKKzBp4LjFUfxvfm+x1cOYVJ5Sc8bbpucBAGIPF+w0G
SxUzkBU/X9TuiYXdIqyI7ea9wpel3FfLRm2HfkCil0sxC0PhazF6vDQSDJ6Mf1q/c+Aj8bX7
gfMI7z0LLEiDHitb

/
show errors;
grant execute on mdsys.sdo_wfs_process to public;
show errors;
