Rem
Rem $Header: sdowso.sql 15-feb-2007.11:39:51 mhorhamm Exp $
Rem
Rem sdowso.sql
Rem
Rem Copyright (c) 2005, 2007, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      sdowso.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    mhorhamm    02/15/07 - Add param
Rem    mhorhamm    01/27/06 - Move definitions of user OpenLS to user MDSYS 
Rem    mhorhamm    05/18/05 - Add signature 
Rem    mhorhamm    05/17/05 - Add error handler function 
Rem    mhorhamm    03/28/05 - Created
Rem

CREATE OR REPLACE PACKAGE mdsys.sdo_ols AUTHID current_user AS

  FUNCTION generate_error(
    openls_version  VARCHAR2,
    message         VARCHAR2,
    requestId       VARCHAR2)
      RETURN XMLTYPE;

  FUNCTION generate_error(
    openls_version VARCHAR2,
    requestId      VARCHAR2)
      RETURN XMLTYPE;

  FUNCTION PostClob(
    url       IN VARCHAR2,
    payload   IN CLOB)
      RETURN CLOB;

  FUNCTION PostXml(
    url       IN VARCHAR2,
    payload   IN XMLTYPE)
      RETURN XMLTYPE;

  FUNCTION getNS(
    nsShortcut  VARCHAR2,
    openLsVersion   VARCHAR2)
      RETURN VARCHAR2;

  FUNCTION getNS(
    openLsVersion   VARCHAR2)
      RETURN VARCHAR2;

  FUNCTION extractValue(
    xml   XMLTYPE,
    xPath VARCHAR2,
    ns VARCHAR2)
      RETURN VARCHAR2;

  FUNCTION extract(
    xml   XMLTYPE,
    xPath VARCHAR2,
    ns VARCHAR2)
      RETURN XMLTYPE;

  FUNCTION getBasisXml(
    node_name       VARCHAR2,
    openls_version  VARCHAR2)
      RETURN XMLTYPE;

  FUNCTION makeOpenLSClobRequest(
    request         CLOB)
      RETURN CLOB;

  FUNCTION makeOpenLSSoapRequest(
    request XMLTYPE)
      RETURN XMLTYPE;

  FUNCTION makeOpenLSRequest(
    request XMLTYPE)
      RETURN XMLTYPE;

  FUNCTION makeOpenLS10Request(
    request XMLTYPE)
      RETURN XMLTYPE;

  FUNCTION determine_classification(
    openls                    XMLTYPE,
    classification_criterion  VARCHAR2,
    openls_version            VARCHAR2)
      RETURN VARCHAR2;

  PROCEDURE parse_coord_pair(
    coords  IN  VARCHAR2,
    x       OUT NUMBER,
    y       OUT NUMBER);

  PROCEDURE handle_openls_error(
    specific_error_message  VARCHAR2,
    specific_error_code     NUMBER,
    default_error_message   VARCHAR2);

END sdo_ols;
/

show errors;

create or replace public synonym sdo_ols for mdsys.SDO_OLS;
