Rem
Rem $Header: sdo/admin/semrelod111.sql /main/1 2009/05/28 09:16:02 matperry Exp $
Rem
Rem semrelod111.sql
Rem
Rem Copyright (c) 2009, Oracle and/or its affiliates. All rights reserved. 
Rem
Rem    NAME
Rem      semrelod111.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    matperry    05/26/09 - Created
Rem

set echo off
WHENEVER SQLERROR EXIT FAILURE;

---------------------------------------------------------
-- This procedure reloads 11.1 PL/SQL packages.        --
-- It should be run after running seme111 in an 11.2   --
-- database and then downgrading from 11.2 to 11.1     --
---------------------------------------------------------

prompt check privileges
Rem check user
begin
  if ('SYS' = sys_context('userenv', 'current_user') and 
      'TRUE' = sys_context('userenv', 'isdba')) then
    null; -- ok to go ahead
  else
    raise_application_error(-20000, 
    'Cannot proceed. Only SYS with DBA privilege can perform this operation.');
  end if;
end;
/
show errors;

-- Check database and raise appropriate errors --
-- We can only do reload if 11.1 types are present and 10.2 and
-- 11.2 components are not present
declare
  type_102_exists    NUMBER;
  type_11_exists     NUMBER;
  type_112_exists    NUMBER;
begin
  -- see if 10.2 SDO_RDF_TRIPLE_S type is present in DB
  SELECT count(*) INTO type_102_exists FROM ALL_TYPE_ATTRS
   WHERE type_name='SDO_RDF_TRIPLE_S' AND attr_name='RDF_T_ID' 
     AND owner='MDSYS';

  -- see if 11 SDO_RDF_TRIPLE_S type is present in DB
  SELECT count(*) INTO type_11_exists FROM ALL_TYPE_ATTRS
   WHERE type_name='SDO_RDF_TRIPLE_S' AND attr_name='RDF_C_ID' 
     AND owner='MDSYS';

  -- see if 11.2 components are present --
  SELECT count(*) INTO type_112_exists FROM ALL_OBJECTS
   WHERE object_name='RDF_PARAMETER' AND owner='MDSYS';

  if (type_102_exists > 0) then
    raise_application_error(-20000, 
      'Cannot proceed. Types exist from Semantic Technologies Release 10.2. ' ||
      'Please use catsem10i.sql to upgrade to Semantic Technologies Release 11.1.');
  elsif (type_11_exists = 0) then
    raise_application_error(-20000, 
      'Cannot proceed. Semantic Technologies has not been installed. ' ||
      'Please use catsem11i.sql to install Semantic Technologies Release 11.1.');
  elsif (type_112_exists > 0) then
    raise_application_error(-20000, 
      'Cannot proceed. Semantic Technologies Release 11.2 components exist.');
  end if;
end;
/
show errors;



set echo off
alter session set current_schema=MDSYS;

WHENEVER SQLERROR CONTINUE;

prompt Reload 11.1 Semantic Technologies ...

Rem RDF Match stuff
@@sdordfa.sql

Rem Load RDF types and packages
@@sdordfh.sql
@@sdordfxh.sql
-- do not reload types
-- @@sdordfty.sql
@@prvrdftp.plb


Rem Load SEM context 
@@sdosemctxh.sql

Rem Load SEM log 
@@sdosemlogh.sql

Rem Load SEM utility 
@@sdosemutlh.sql

Rem Load SEM owlfast inference 
@@sdoseminfh.sql
@@sdoseminfhh.sql
@@sdoseminfih.sql

Rem Load SEM owlfast validation 
@@sdosemvalh.sql

Rem MS related
prompt sdoseminfmh
@@sdoseminfmh.plb

prompt sdordfai
@@sdordfai.plb

Rem MS related
prompt sdoseminfmr
@@sdoseminfmr.plb

show errors;

prompt sdordfm
@@sdordfm.plb

show errors;

prompt sdordfrb
@@sdordfrb.sql

Rem Load RDF package body
@@sdordfb.plb
@@sdordfxb.plb

Rem Add context: 
CREATE OR REPLACE CONTEXT SDO_SEM_CTX using MDSYS.SDO_SEM_CTX accessed globally;


Rem Load context implementations
@@sdosemctxb.plb

Rem Load Log implementations
@@sdosemlogb.plb

Rem Load SEM implementations
@@sdosemutlb.plb
@@sdoseminfb.plb
@@sdoseminfhb.plb
@@sdoseminfib.plb
@@sdosemvalb.plb

Rem SEM operators
@@sdosemopih.plb
@@sdosemopib.plb
@@sdosemop.plb
@@sdosemopst.plb

Rem SEM Triggers
@@sdosemtrig.plb

REM RDF upgrade and data migration
@@sdosemdmh.sql
@@sdosemdmb.plb

REM RDF/OWL downgrade preparation package
@@sdosemdgh.sql
@@sdosemdgb.plb
@@sdosemdgu.plb

alter session set current_schema=SYS;

-- load sdordf
call dbms_java.loadjava(
  '-resolve -force -synonym -schema MDSYS -grant PUBLIC md/jlib/sdordf.jar');

-- recompile any invalid objects --
alter session set current_schema=MDSYS;

declare
  obj   varchar2(32);
  otype varchar2(19);
  type       cursor_type is REF CURSOR;
  query_crs  cursor_type ;
  stmt varchar2(2000);
begin

  -- try to compile any invalid objects --
  stmt :=
    'select
       OBJECT_NAME, OBJECT_TYPE
     from
       all_objects
     where OWNER = ''MDSYS'' 
       and status=''INVALID''
       and ( 
           object_name like ''RDF_%''     or
           object_name like ''SDO_RDF%''  or
           object_name like ''SDO_SEM%''  or
           object_name like ''SEM_%''     or
           object_name like ''SEMR_%''    or
           object_name like ''RDFR_%''     
       )';

  open query_crs for stmt;
  loop 
  begin
    fetch query_crs into  obj, otype;
    exit when query_crs%NOTFOUND ;

    begin
      if (otype = 'PACKAGE BODY') then
        obj := sys.dbms_assert.enquote_name(obj,FALSE);
        execute immediate ' alter package '|| obj ||' compile body';
      elsif (otype = 'TYPE BODY') then
        obj := sys.dbms_assert.enquote_name(obj,FALSE);
        execute immediate ' alter type '|| obj ||' compile body';
      elsif (otype = 'TRIGGER') then
        obj := sys.dbms_assert.enquote_name(obj,FALSE);
        execute immediate ' alter trigger '|| obj ||' compile';
      elsif (otype = 'VIEW') then
        obj := sys.dbms_assert.enquote_name(obj,FALSE);
        execute immediate ' alter view '|| obj ||' compile';
      else
        null; -- no action for now
      end if;
    exception
      when others then
        null;
    end;
    commit;
  end;
  end loop;
  close query_crs;
end;
/
show errors;

alter session set current_schema=SYS;

prompt Reload 11.1 Semantic Technologies ... DONE
