#
# Copyright (c) 2001, 2009, Oracle and/or its affiliates. All rights reserved. 
#
#  $Id: Common.pm /st_emdbsa_11.2/9 2009/06/20 15:57:01 pardutta Exp $ 
#
#
# NAME  
#	 Common.pm
#
# DESC 
#	 Register and invoke the subroutines 
#
#
# FUNCTIONS
# AUTOLOADER
#
# NOTES
#
#
# MODIFIED	(MM/DD/YY)
# ajdsouza       10/19/07 - created 
#
#
package has::Common;


use Exporter;
use strict;
use warnings;
use locale;
use File::Spec::Functions;
use File::Path;
use has::HasCluster;
require "emd_common.pl";
require "semd_common.pl";

our @ISA = qw(Exporter);
our @EXPORT = qw( 
                   EMD_PERL_DEBUG 
                   EMD_PERL_ERROR EMD_PERL_TRACE EMD_PERL_WARN EMD_PERL_INFO
                );


#------------------------------------------------------------------------------
# global package variables 
#-----------------------------------------------------------------------------
our %hasClusterConfig;
our @oldOH;
our @oldCRSHome;
our @oldEMCRSHome;


# Global package variable to hold sub name
our $AUTOLOAD;

# Global package variables for REGRESSION or CAPTURE mode execution
# to cache the execution mode REGRESSION or CAPTURE 
# test(name) directory 
# parent directory for location of test files
# counter for function invocation
our %regression_fn_count;
our %regression_subs;

# variables for saving and reading the system command  output for regression tests
our $has_test_res_ref;
our $has_test_res_filen = 'has.out';
our @iface = qw ( IFACE_UNKNOWN );

# list of subs to be regressed
$regression_subs{hasIsReadable}=1;
$regression_subs{hasIsWriteable}=1;
$regression_subs{hasIsDir}=1;
$regression_subs{hasReturnFileContents}=1;
$regression_subs{hasWriteToFile}=1;
$regression_subs{getInventoryXmlPath}=1;
$regression_subs{hasCheckForEmcrsp}=1;
$regression_subs{get_error_stack}=1;
$regression_subs{get_stdinvars}=1;
$regression_subs{hasGetEnv}=1;
$regression_subs{getClusterCacheRef}=1;
$regression_subs{hasGetSQLResults}=1;
$regression_subs{hasGetOSLocalHostName}=1;

our %has_metric_config;
#resources
$has::Common::has_metric_config{basic_fields}{resources}= 
{
  1 => 'EM_TARGET_GUID',
  2 => 'CLUSTER_NAME',
  3 => 'NAME',
  4 => 'TYPE'
};

$has::Common::has_metric_config{key_fields}{resources}{1}=
{
  1 => 'EM_TARGET_GUID',
  2 => 'NAME'
};

#server groups
$has::Common::has_metric_config{basic_fields}{server_groups}= 
{
 0.1 => 'EM_TARGET_GUID',
  1 => 'CLUSTER_NAME',
  2 => 'NAME',
  3 => 'SERVER_NAMES',
  4 => 'ACTIVE_SERVERS',
  5 => 'MIN_SIZE',
  6 => 'MAX_SIZE',
  7 => 'IMPORTANCE',
  8 => 'PARENT_GROUPS',
  9 => 'OVERLAPPING_GROUPS',
  10=> 'EXCLUSIVE_GROUPS'
};

# indicate only the boolean and number as they need to be validated 
$has::Common::has_metric_config{data_type}{server_groups}=
{
 MIN_SIZE => 'number',
 MAX_SIZE => 'number',
 IMPORTANCE => 'number'
};


$has::Common::has_metric_config{key_fields}{server_groups}{1}=
{
 0.1 => 'EM_TARGET_GUID',
  1 => 'CLUSTER_NAME',
  2 => 'NAME'
};

$has::Common::has_metric_config{key_fields}{server_groups}{2}=
{
 0.1 => 'EM_TARGET_GUID',
  2 => 'NAME'
};


# css_nodes_metric 
$has::Common::has_metric_config{basic_fields}{crs_servers}= 
{
  1 => 'GENERATED_KEY_2',
  1.1 => 'METRIC_SOURCE',
  2 => 'EONS_EVENT_NAME',
  3 => 'TIMESTAMP',
  4 => 'ENTITY_TYPE',
  6 => 'NODE_NAME',
  9 => 'NODE_NUM',
 10 => 'HOST_NAME',
 10.5 => 'SOFTWARE_VERSION',
 11 => 'STATE',
 12 => 'NODE_STATE',
 13 => 'NODE_TYPE'
};

$has::Common::has_metric_config{data_type}{crs_servers}=
{
 NODE_NUM => 'number'
};

$has::Common::has_metric_config{build_key}{crs_servers}=1;
$has::Common::has_metric_config{build_key_cols}{crs_servers}=
{
  4 => 'NAME'
};

$has::Common::has_metric_config{key_fields}{crs_servers}{1}=
{
  1 => 'GENERATED_KEY_2'
};

#servers
$has::Common::has_metric_config{basic_fields}{servers}=
{
 0.1 => 'EM_TARGET_GUID',
  1 => 'CLUSTER_NAME',
  3 => 'NAME',
  5 => 'ENABLED',
  6 => 'ACTIVE_GROUPS'
};

# indicate only the boolean and number as they need to be validated 
$has::Common::has_metric_config{data_type}{servers}=
{
 ENABLED => 'boolean'
};

$has::Common::has_metric_config{key_fields}{servers}{1}=
{
 0.1 => 'EM_TARGET_GUID',
  1 => 'CLUSTER_NAME',
  4 => 'NAME'
};

$has::Common::has_metric_config{key_fields}{servers}{2}=
{
 0.1 => 'EM_TARGET_GUID',
  2 => 'NAME'
};


#servergroup to server association
$has::Common::has_metric_config{basic_fields}{server_group_members}= 
{
 0.1 => 'EM_TARGET_GUID',
 0.2 => 'EM_TARGET_GUID',
  2 => 'NAME',
  4=> '#SERVER_NAME',
  11=> '#ACTIVE_SERVER'
};

$has::Common::has_metric_config{key_fields}{server_group_members}{1}= 
{
 0.1 => 'EM_TARGET_GUID',
  2 => 'NAME',
  10=> '#SERVER_NAME'
};

$has::Common::has_metric_config{data_type}{server_group_members}=
{
 ACTIVE_SERVER => 'number'
};

#nodes
$has::Common::has_metric_config{basic_fields}{nodes}=
{
  1 => 'CLUSTER_NAME',
  2 => 'NAME',
  3 => 'HOST_NAME',
  4 => 'TYPE',
  5 => 'SOFTWARE_VERSION',
  6 => 'NODE_STATE',
  7 => 'CRS_HOME'
};

#nodes
$has::Common::has_metric_config{key_fields}{nodes}{1}=
{
  1 => 'CLUSTER_NAME',
  2 => 'NAME',
  3 => 'HOST_NAME'
};


# cluster_health_check metric 
$has::Common::has_metric_config{basic_fields}{cluster_health_check}= 
{
  1 => 'GENERATED_KEY_1',
  2 => 'CRS_COMPONENT',
  3 => 'COMPONENT_DESCRIPTION',
  6 => 'COMPONENT_STATUS',
  7 => 'COMPONENT_STATUS_MESSAGE',
 10 => 'NODE_NAME',
 10.5 => 'ERROR_MESSAGE'
};

$has::Common::has_metric_config{key_fields}{cluster_health_check}{1}=
{
  1 => 'GENERATED_KEY_1'
};

#resource types
$has::Common::has_metric_config{basic_fields}{resource_types}= 
{
  1 => 'CLUSTER_NAME',
  2 => 'ENTITY_NAME',
  4 => 'BASE_TYPE',
  5 => 'ROOT_TYPE',
  6 => 'BASE_TYPE_CHAIN'
};

$has::Common::has_metric_config{key_fields}{resource_types}{1}=
{
  1 => 'CLUSTER_NAME',
  2 => 'ENTITY_NAME'
};

$has::Common::has_metric_config{key_fields}{resource_types}{2}=
{
  2 => 'ENTITY_NAME'
};

$has::Common::has_metric_config{basic_fields}{resource_attributes}= 
{
  1 => 'CLUSTER_NAME',
  2 => 'NAME',
  3 => 'TYPE',
  4 => '#name', 
  5 => '#VALUE'
};

$has::Common::has_metric_config{key_fields}{resource_attributes}{1}=
{
  1 => 'CLUSTER_NAME',
  2 => 'NAME',
  3 => 'TYPE',
  4 => '#name'
};

$has::Common::has_metric_config{key_fields}{resource_attributes}{2}=
{
  2 => 'NAME',
  3 => 'TYPE',
  4 => '#name'
};

# # indicates to pic the attrib element name
$has::Common::has_metric_config{basic_fields}{resource_type_attributes}= 
{
  1 => 'CLUSTER_NAME',
  2 => 'ENTITY_NAME',
  3 => '#name',
  4 => '#default_value',
  5 => '#mandatory',
  6 => '#editable',
  7 => '#type',
  8 => '#dynamic',
  9 => '#resource_type',
 10 => '#base_attrib_value'
};


# indicate only the boolean and number as they need to be validated 
$has::Common::has_metric_config{data_type}{resource_type_attributes}=
{
 '#mandatory' => 'boolean',
 '#editable' => 'boolean',
 '#dynamic' => 'boolean',
};


$has::Common::has_metric_config{key_fields}{resource_type_attributes}{1}=
{
  1 => 'CLUSTER_NAME',
  2 => 'ENTITY_NAME',
  3 => '#name'
};

$has::Common::has_metric_config{key_fields}{resource_type_attributes}{2}=
{
  2 => 'ENTITY_NAME',
  3 => '#name'
};

# resource instance attributes
$has::Common::has_metric_config{basic_fields}{resource_instance_attributes}= 
{
  1 => 'CLUSTER_NAME',
  2 => 'ID',
  3 => 'NAME',
  4 => '#name', 
  5 => '#VALUE'
};

$has::Common::has_metric_config{key_fields}{resource_instance_attributes}{1}=
{
  1 => 'CLUSTER_NAME',
  2 => 'ID',
  3 => 'NAME',
  4 => '#name'
};

$has::Common::has_metric_config{key_fields}{resource_instance_attributes}{2}=
{
  2 => 'ID',
  3 => 'NAME',
  4 => '#name'
};

# resource instances
$has::Common::has_metric_config{basic_fields}{resource_instances}= 
{
  1 => 'CLUSTER_NAME',
  2 => 'NAME',
  4 => 'ID',
  5 => 'TYPE',
  6 => 'LAST_SERVER',
  7 => 'CARDINALITY_ID',
  8 => 'DEGREE_ID',
  9 => 'STATE',
  10 => 'TARGET'
};

$has::Common::has_metric_config{key_fields}{resource_instances}{1}=
{
  1 => 'CLUSTER_NAME',
  2 => 'NAME',
  4 => 'ID'
};

$has::Common::has_metric_config{key_fields}{resource_instances}{2}=
{
  2 => 'NAME',
  4 => 'ID'
};

# resource_instance_status_metric 
$has::Common::has_metric_config{basic_fields}{resource_instance_status_metric}= 
{
  1 => 'GENERATED_KEY_2',
  1.1 => 'METRIC_SOURCE',
  2 => 'EONS_EVENT_NAME',
  3 => 'TIMESTAMP',
  4 => 'ENTITY_TYPE',
  5 => 'TYPE',
  6 => 'NAME',
  9 => 'COMPOSITE_STATE',
 10 => 'CARDINALITY',
 10.5 => 'DEGREE',
 10.6 => 'TOTAL_COUNT',
 11 => 'ONLINE_COUNT',
 12 => 'OFFLINE_COUNT',
 13 => 'UNKNOWN_COUNT',
 14 => 'INTERMEDIATE_COUNT',
 15 => 'ALERT_STATE',
 16 => 'NULLSTRING_ALERT_COUNT',
 17 => 'ADDITIONAL_ALERT_MESSAGE'
};

$has::Common::has_metric_config{data_type}{resource_instance_status_metric}=
{
 TOTAL_COUNT => 'number',
 ONLINE_COUNT => 'number',
 OFFLINE_COUNT => 'number',
 UNKNOWN_COUNT => 'number',
 INTERMEDIATE_COUNT => 'number'
};

$has::Common::has_metric_config{aggregate_computation}{resource_instance_status_metric}=1;
$has::Common::has_metric_config{build_key}{resource_instance_status_metric}=1;
$has::Common::has_metric_config{build_key_cols}{resource_instance_status_metric}=
{
  2 => 'ENTITY_TYPE',
  3 => 'TYPE',
  4 => 'NAME'
};

$has::Common::has_metric_config{key_fields}{resource_instance_status_metric}{1}=
{
  1 => 'GENERATED_KEY_2'
};

# crs_event metric 
$has::Common::has_metric_config{basic_fields}{resource_instance_alert_metric}= 
{
  1 => 'GENERATED_KEY_1',
  1.1 => 'METRIC_SOURCE',
  2 => 'EONS_EVENT_NAME',
  3 => 'TIMESTAMP',
  4 => 'ENTITY_TYPE',
  5 => 'TYPE',
  6 => 'NAME',
 6.1 => 'ID',
  7 => 'STATE',
  9 => 'COMPOSITE_STATE',
  12 => 'LAST_SERVER'
};

$has::Common::has_metric_config{aggregate_computation}{resource_instance_alert_metric}=1;
$has::Common::has_metric_config{build_key}{resource_instance_alert_metric}=1;
$has::Common::has_metric_config{build_key_cols}{resource_instance_alert_metric}=
{
  2 => 'ENTITY_TYPE',
  3 => 'TYPE',
  4 => 'NAME',
  5 => 'ID'
};

$has::Common::has_metric_config{key_fields}{resource_instance_alert_metric}{1}=
{
  1 => 'GENERATED_KEY_1'
};


# gpnp_alert_metric 
$has::Common::has_metric_config{basic_fields}{gpnp_alert_metric}= 
{
  1 => 'GENERATED_KEY_1',
  1.1 => 'METRIC_SOURCE',
  2 => 'EONS_EVENT_NAME',
  3 => 'TIMESTAMP',
  4 => 'ENTITY_TYPE',
  5 => 'TYPE',
  6 => 'NAME',
 6.1 => 'ID',
  7 => 'STATE',
  8 => 'STATE',
  9 => 'COMPOSITE_STATE',
  12 => 'LAST_SERVER',
  15 => 'ATTRIB_BODY',
  16 => 'ATTRIB_BODY1',
  17 => 'ATTRIB_BODY2'
};

$has::Common::has_metric_config{aggregate_computation}{gpnp_alert_metric}=1;
$has::Common::has_metric_config{build_key}{gpnp_alert_metric}=1;
$has::Common::has_metric_config{build_key_cols}{gpnp_alert_metric}=
{
  1 => 'EONS_EVENT_NAME',
 1.1 => 'TIMESTAMP',
  2 => 'ENTITY_TYPE',
  3 => 'TYPE',
  4 => 'NAME',
  5 => 'ID'
};

$has::Common::has_metric_config{key_fields}{gpnp_alert_metric}{1}=
{
  1 => 'GENERATED_KEY_1'
};


# gpnp_server_alert_metric 
$has::Common::has_metric_config{basic_fields}{gpnp_server_alert_metric}= 
{
  1 => 'GENERATED_KEY_1',
  1.1 => 'METRIC_SOURCE',
  2 => 'EONS_EVENT_NAME',
  3 => 'TIMESTAMP',
  4 => 'ENTITY_TYPE',
  5 => 'ENTITY_TYPE',
  6 => 'NAME',
 6.1 => 'NAME',
  7 => 'STATE',
  8 => 'STATE',
  9 => 'STATE',
  12 => 'HOST_NAME',
  15 => 'CSS_NODE_LIST',
  16 => 'CSS_NODE_LIST1',
  17 => 'CSS_NODE_LIST2'
};

$has::Common::has_metric_config{aggregate_computation}{gpnp_server_alert_metric}=1;
$has::Common::has_metric_config{build_key}{gpnp_server_alert_metric}=1;
$has::Common::has_metric_config{build_key_cols}{gpnp_server_alert_metric}=
{
  1 => 'EONS_EVENT_NAME',
 1.1 => 'TIMESTAMP',
  2 => 'ENTITY_TYPE',
  3 => 'ENTITY_TYPE',
  4 => 'NAME',
  5 => 'NAME'
};

$has::Common::has_metric_config{key_fields}{gpnp_server_alert_metric}{1}=
{
  1 => 'GENERATED_KEY_1'
};

# resource dependencies
$has::Common::has_metric_config{basic_fields}{resource_dependencies}=
{
  1 => 'CLUSTER_NAME',
  2 => 'NAME',
  3 => '#DEPENDENCY_TYPE',
  4 => '#DEPENDENT_NAME',
  4.1 => '#DEPENDENCY_ATTRIB1',
  4.2 => '#DEPENDENCY_ATTRIB2',
  5 => '#HARD', 
  6 => '#WEAK', 
  7 => '#ATTRACTION', 
  8 => '#DISPERSION', 
  9 => '#PULLUP',
  10 => '#GLOBAL'
};

$has::Common::has_metric_config{key_fields}{resource_dependencies}{1}=
{
  1 => 'CLUSTER_NAME',
  2 => 'NAME',
  3 => '#DEPENDENCY_TYPE',
  4 => '#DEPENDENT_NAME',
  5 => '#DEPENDENCY_ATTRIB1',
  6 => '#DEPENDENCY_ATTRIB2'
};

$has::Common::has_metric_config{key_fields}{resource_dependencies}{2}=
{
  2 => 'NAME',
  3 => '#DEPENDENCY_TYPE',
  4 => '#DEPENDENT_NAME',
  5 => '#DEPENDENCY_ATTRIB1',
  6 => '#DEPENDENCY_ATTRIB2'
};

#resource instance dependencies
$has::Common::has_metric_config{basic_fields}{resource_instance_dependencies}=
{
  1 => 'CLUSTER_NAME',
  2 => 'ID',
  3 => '#DEPENDENCY_TYPE',
  4 => '#DEPENDENT_NAME',
  5 => '#HARD', 
  6 => '#WEAK', 
  7 => '#ATTRACTION', 
  8 => '#DISPERSION', 
  9 => '#PULLUP',
  10 => '#GLOBAL'
};

$has::Common::has_metric_config{key_fields}{resource_instance_dependencies}{1}=
{
  1 => 'CLUSTER_NAME',
  2 => 'ID',
  3 => '#DEPENDENCY_TYPE',
  4 => '#DEPENDENT_NAME'
};

$has::Common::has_metric_config{key_fields}{resource_instance_dependencies}{2}=
{
  2 => 'ID',
  3 => '#DEPENDENCY_TYPE',
  4 => '#DEPENDENT_NAME'
};

$has::Common::has_metric_config{basic_fields}{resource_type_dependencies}=$has::Common::has_metric_config{basic_fields}{resource_dependencies};
$has::Common::has_metric_config{key_fields}{resource_type_dependencies}{1}=$has::Common::has_metric_config{key_fields}{resource_dependencies}{1};

#servergroup to resource association
$has::Common::has_metric_config{basic_fields}{server_group_resource}= 
{
 0.1 => 'EM_TARGET_GUID',
  2 => '#SERVER_GROUP_NAME',
  3=> 'NAME'
};

$has::Common::has_metric_config{key_fields}{server_group_resource}{1}= 
{
 0.1 => 'EM_TARGET_GUID',
  2 => '#SERVER_GROUP_NAME',
  3 => 'NAME'
};

#crs_metric
$has::Common::has_metric_config{basic_fields}{crs_metric}= 
{
  1 => 'NODE_NAME',
  2 => 'TYPE',
  3 => 'HOST_NAME'
};

$has::Common::has_metric_config{key_fields}{crs_metric}{1}=
{
  1 => 'NODE_NAME'
};

#css_metric
$has::Common::has_metric_config{basic_fields}{css_metric}= 
{
  0.5 => 'CLUSTER_NAME',
  1 => 'NODE_NAME',
  2 => 'HOST_NAME'
};

$has::Common::has_metric_config{key_fields}{css_metric}{1}=
{
  1 => 'NODE_NAME'
};


#scan_vip_metric
$has::Common::has_metric_config{basic_fields}{scan_vip_metric}= 
{
  1 => 'CLUSTER_NAME',
  2 => 'SCAN_NAME',
  3 => 'IP',
  4 => 'RESOURCE_NAME'
};

$has::Common::has_metric_config{key_fields}{scan_vip_metric}{1}=
{
  1 => 'CLUSTER_NAME',
  2 => 'SCAN_NAME',
  3 => 'IP',
  4 => 'RESOURCE_NAME'
};

#scan_metric
$has::Common::has_metric_config{basic_fields}{scan_metric}= 
{
  1 => 'CLUSTER_NAME',
  2 => 'SCAN_NAME',
  3 => 'SCAN_PORT'
};

$has::Common::has_metric_config{key_fields}{scan_metric}{1}=
{
  1 => 'CLUSTER_NAME',
  2 => 'SCAN_NAME'
};

# indicate only the boolean and number as they need to be validated 
$has::Common::has_metric_config{data_type}{scan_metric}=
{
 'SCAN_PORT' => 'number'
};


#asm_metric
$has::Common::has_metric_config{basic_fields}{asm_metric}= 
{
  1 => 'NAME',
  2 => 'ACTIVE_VERSION',
  3 => 'RESOURCE_NAME',
  4 => 'CLUSTER_NAME'
};

$has::Common::has_metric_config{key_fields}{asm_metric}{1}=
{
  1 => 'NAME'
};


#asm_instance_metric
$has::Common::has_metric_config{basic_fields}{asm_instance_metric}= 
{
  1 => 'NAME',
  2 => 'ROLE',
  3 => 'USERNAME',
  4 => 'SID',
  5 => 'MACHINE_NAME',
  6 => 'PORT',
  7 => 'VERSION',
  8 => 'ACTIVE_VERSION',
  9 => 'INSTANCE_NAME',
  10 => 'INSTANCE_ID',
  11 => 'INSTANCE_NUMBER',
  12 => 'DISK_DISCOVERY_STRING',
  13 => 'ORACLE_HOME',
  14 => 'HOST_NAME',
  15 => 'RESOURCE_NAME',
  16 => 'CLUSTER_NAME'
};

$has::Common::has_metric_config{key_fields}{asm_instance_metric}{1}=
{
  1 => 'NAME',
  2 => 'SID',
  3 => 'INSTANCE_NAME'
};


# indicate only the boolean and number as they need to be validated 
$has::Common::has_metric_config{data_type}{asm_instance_metric}=
{
 INSTANCE_NUMBER => 'number',
 PORT => 'number'
};

#asm_disk_group
$has::Common::has_metric_config{basic_fields}{asm_diskgroup_metric}= 
{
  1 => 'NAME',
  2 => 'DISKGROUP_NAME',
  3 => 'DISKGROUP_NUMBER',
  4 => 'DISKGROUP_SIZE',
  5 => 'REDUNDANCY',
  6 => 'COMPATIBILITY',
  7 => 'STATE'
};

$has::Common::has_metric_config{key_fields}{asm_diskgroup_metric}{1}=
{
  1 => 'NAME',
  2 => 'DISKGROUP_NAME',
  3 => 'DISKGROUP_NUMBER'
};

# indicate only the boolean and number as they need to be validated 
$has::Common::has_metric_config{data_type}{asm_diskgroup_metric}=
{
 DISKGROUP_NUMBER => 'number',
 DISKGROUP_SIZE => 'number'
};


#asm disk
$has::Common::has_metric_config{basic_fields}{asm_disk_metric}= 
{
  1 => 'NAME',
  2 => 'DISKGROUP_NUMBER',
  3 => 'DISK_NUMBER',
  4 => 'DISK_PATH',
  5 => 'DISK_NAME',
  6 => 'MODE_STATUS'
};

$has::Common::has_metric_config{key_fields}{asm_disk_metric}{1}=
{
  1 => 'NAME',
  2 => 'DISKGROUP_NUMBER',
  3 => 'DISK_NUMBER'
};

# indicate only the boolean and number as they need to be validated 
$has::Common::has_metric_config{data_type}{asm_disk_metric}=
{
 DISKGROUP_NUMBER => 'number',
 DISK_NUMBER => 'number'
};

#asm diskgroup used
$has::Common::has_metric_config{basic_fields}{asm_diskgroupused_metric}= 
{
  1 => 'NAME',
  2 => 'DISKGROUP_NAME',
  3 => 'DATABASE_NAME'
};

$has::Common::has_metric_config{key_fields}{asm_diskgroupused_metric}{1}=
{
  1 => 'NAME',
  2 => 'DISKGROUP_NAME',
  3 => 'DATABASE_NAME'
};


#rac_metric
$has::Common::has_metric_config{basic_fields}{rac_metric}= 
{
  1 => 'VENDOR',
  2 => 'TYPE',
  3 => 'NAME',
  4 => 'DB_DOMAIN',
  5 => 'DB_NAME',
  6 => 'DB_UNIQUE_NAME',
  7 => 'VERSION',
  8 => 'SHORT_VERSION',
  9 => 'VERSION_CATEGORY',
  10 => 'ORACLE_HOME',
  11 => 'USER_NAME',
  11.5 => 'ROLE',
  12 => 'SP_FILE',
  13 => 'OPEN_MODE',
  14 => 'SERVICE_NAME',
  15 => 'RESOURCE_NAME',
  16 => 'CLUSTER_NAME',
  17 => 'MASTER'
};

$has::Common::has_metric_config{key_fields}{rac_metric}{1}=
{
  1 => 'TYPE',
  2 => 'NAME'
};


#database_metric
$has::Common::has_metric_config{basic_fields}{database_metric}= 
{
  1 => 'VENDOR',
  2 => 'TYPE',
  3 => 'NAME',
  4 => 'DB_DOMAIN',
  5 => 'DB_NAME',
  6 => 'DB_UNIQUE_NAME',
  7 => 'VERSION',
  8 => 'SHORT_VERSION',
  9 => 'VERSION_CATEGORY',
  10 => 'ORACLE_HOME',
  11 => 'USER_NAME',
  11.5 => 'ROLE',
  12 => 'SP_FILE',
  13 => 'OPEN_MODE',
  14 => 'SERVICE_NAME',
  15 => 'RESOURCE_NAME'
};

$has::Common::has_metric_config{key_fields}{database_metric}{1}=
{
  1 => 'TYPE',
  2 => 'NAME'
};

#voting disk metric
$has::Common::has_metric_config{basic_fields}{votingdisk_metric}= 
{
  1 => 'CLUSTER_NAME',
  2 => 'LOCATION'
};

$has::Common::has_metric_config{key_fields}{votingdisk_metric}{1}=
{
  1 => 'CLUSTER_NAME',
  2 => 'LOCATION'
};

#vip_metric
$has::Common::has_metric_config{basic_fields}{vip_metric}= 
{
  1 => 'CLUSTER_NAME',
  1.1 => 'NAME',
  2 => 'NODE_NAME',
  3 => 'IP',
  4 => 'RESOURCE_NAME'
};

$has::Common::has_metric_config{key_fields}{vip_metric}{1}=
{
  1 => 'CLUSTER_NAME',
  2 => 'NAME',
  3 => 'NODE_NAME',
  4 => 'RESOURCE_NAME'
};

$has::Common::has_metric_config{key_fields}{vip_metric}{2}=
{
  1 => 'CLUSTER_NAME',
  2 => 'NAME',
  3 => 'IP'
};

#ocr metric
$has::Common::has_metric_config{basic_fields}{ocr_metric}= 
{
  1 => 'CLUSTER_NAME',
  2 => 'LOCATION',
  3 => 'MIRRORS'
};

$has::Common::has_metric_config{key_fields}{ocr_metric}{1}=
{
  1 => 'CLUSTER_NAME',
  2 => 'LOCATION'
};

# indicate only the boolean and number as they need to be validated 
$has::Common::has_metric_config{data_type}{ocr_metric}=
{
 'MIRRORS' => 'number'
};

#eons_metric
$has::Common::has_metric_config{basic_fields}{eons_metric}= 
{
  1 => 'CLUSTER_NAME',
  1.1 => 'NAME',
  2 => 'NODE_NAME',
  3 => 'EONS_PORT',
  4 => 'RESOURCE_NAME'
};

$has::Common::has_metric_config{key_fields}{eons_metric}{1}=
{
  1 => 'CLUSTER_NAME',
  2 => 'NAME',
  3 => 'NODE_NAME',
  4 => 'RESOURCE_NAME'
};

# indicate only the boolean and number as they need to be validated 
$has::Common::has_metric_config{data_type}{eons_metric}=
{
 'EONS_PORT' => 'number'
};


#nodeinfo_metric
$has::Common::has_metric_config{basic_fields}{nodeinfo_metric}= 
{
  1 => 'HOST_NAME',
  2 => 'NODE_NAME',
  3 => 'CLUSTER_NAME',
  4 => 'CRS_HOME',
  5 => 'NODE_LIST'
};

$has::Common::has_metric_config{key_fields}{nodeinfo_metric}{1}=
{
  1 => 'HOST_NAME'
};

# vip relocation metric 
$has::Common::has_metric_config{basic_fields}{vip_relocation_metric}= 
{
  1 => 'NAME',
  1.1 => 'METRIC_SOURCE',
  2 => 'EONS_EVENT_NAME',
  3 => 'TIMESTAMP',
  4 => 'RELOCATED',
  6 => 'LAST_SERVER'
};

$has::Common::has_metric_config{key_fields}{vip_relocation_metric}{1}=
{
  1 => 'NAME'
};


# css_nodes_metric 
$has::Common::has_metric_config{basic_fields}{css_nodes_metric}= 
{
  1 => 'GENERATED_KEY_1',
  1.1 => 'METRIC_SOURCE',
  2 => 'EONS_EVENT_NAME',
  3 => 'TIMESTAMP',
  4 => 'ENTITY_TYPE',
  6 => 'NODE_NAME',
  9 => 'NODE_NUM',
 10 => 'HOST_NAME',
 10.5 => 'SOFTWARE_VERSION',
 11 => 'NODE_STATE',
 12 => 'NODE_TYPE'
};

$has::Common::has_metric_config{data_type}{css_nodes_metric}=
{
 NODE_NUM => 'number'
};

$has::Common::has_metric_config{build_key}{css_nodes_metric}=1;
$has::Common::has_metric_config{build_key_cols}{css_nodes_metric}=
{
  2 => 'ENTITY_TYPE',
  4 => 'NODE_NAME'
};

$has::Common::has_metric_config{key_fields}{css_nodes_metric}{1}=
{
  1 => 'GENERATED_KEY_1'
};


#resource_name
$has::Common::has_metric_config{basic_fields}{resource_name}= 
{
  1 => 'RESOURCE_NAME'
};

$has::Common::has_metric_config{key_fields}{resource_name}{1}=
{
  1 => 'RESOURCE_NAME'
};

#listener_resource_name
$has::Common::has_metric_config{basic_fields}{listener_resource_name}= 
{
  1 => 'RESOURCE_NAME',
  2 => 'IS_SCAN'
};

$has::Common::has_metric_config{key_fields}{listener_resource_name}{1}=
{
  1 => 'RESOURCE_NAME'
};

#listener_cmdb_metric
$has::Common::has_metric_config{basic_fields}{listener_cmdb_metric}= 
{
  1 => 'MACHINE',
  2 => 'PORT',
  3 => 'LISTENER_NAME',
  4 => 'LISTENER_ORA_DIR',
  5 => 'ORACLE_HOME',
  6 => 'HOST_NAME',
  7 => 'RESOURCE_NAME'
};

$has::Common::has_metric_config{key_fields}{listener_cmdb_metric}{1}=
{
  1 => 'MACHINE',
  2 => 'PORT',
  3 => 'LISTENER_NAME'
};

#scan listener_cmdb_metric
$has::Common::has_metric_config{basic_fields}{scan_listener_cmdb_metric}= 
{
  1 => 'MACHINE',
  2 => 'PORT',
  3 => 'LISTENER_NAME',
  4 => 'LISTENER_ORA_DIR',
  5 => 'ORACLE_HOME',
  6 => 'HOST_NAME',
  7 => 'RESOURCE_NAME',
  8 => 'CLUSTER_NAME',
  9 => 'SCAN_NAME'
};

$has::Common::has_metric_config{key_fields}{scan_listener_cmdb_metric}{1}=
{
  1 => 'MACHINE',
  2 => 'PORT',
  3 => 'LISTENER_NAME',
  4 => 'CLUSTER_NAME',
  5 => 'SCAN_NAME'
};

# list of cache file names
$has::Common::has_metric_config{cache_file}{resources}='hasres.txt';
$has::Common::has_metric_config{cache_file}{resource_types}='hasrest.txt';
$has::Common::has_metric_config{cache_file}{server_groups}='hasvrgp.txt';
$has::Common::has_metric_config{cache_file}{servers}='hasrvrs.txt';
$has::Common::has_metric_config{cache_file}{crs_servers}='hacsrvs.txt';
$has::Common::has_metric_config{cache_file}{cluster_health_check}='hachlck.txt';
$has::Common::has_metric_config{cache_file}{resource_attributes}='hasrcatt.txt';
$has::Common::has_metric_config{cache_file}{server_group_members}='hasvgmb.txt';
$has::Common::has_metric_config{cache_file}{server_group_resource}='hasvgrs.txt';
$has::Common::has_metric_config{cache_file}{resource_type_attributes}='hasrstc.txt';
$has::Common::has_metric_config{cache_file}{resource_instances}='hasresin.txt';
$has::Common::has_metric_config{cache_file}{resource_instance_attributes}='hasresas.txt';
$has::Common::has_metric_config{cache_file}{resource_dependencies}='hasresdp.txt';
$has::Common::has_metric_config{cache_file}{resource_type_dependencies}='hasrstdp.txt';
$has::Common::has_metric_config{cache_file}{resource_instance_dependencies}='hasrsidp.txt';
$has::Common::has_metric_config{cache_file}{resource_instance_alert_metric}='hascrsev.txt';
$has::Common::has_metric_config{cache_file}{resource_instance_status_metric}='hasresst.txt';
$has::Common::has_metric_config{cache_file}{gpnp_alert_metric}='hasgpnp.txt';
$has::Common::has_metric_config{cache_file}{gpnp_server_alert_metric}='hasngpn.txt';
$has::Common::has_metric_config{cache_file}{css_nodes_metric}='hascssn.txt';
$has::Common::has_metric_config{cache_file}{vip_relocation_metric}='hasvip.txt';

# list of dependent metrics
$has::Common::has_metric_config{dependent_cached_metrics} = 
 'server_group_resource|server_group_members|resource_attributes|resource_type_attributes|resource_dependencies|resource_type_dependencies|resource_instance_dependencies|resource_instance_attributes|resource_instance_status_metric|crs_servers|gpnp_server_alert_metric';


# parent metrics for dependent metrics
$has::Common::has_metric_config{parent_metric}{resource_attributes} = 'resources';
$has::Common::has_metric_config{parent_metric}{resource_dependencies} = 'resources';
$has::Common::has_metric_config{parent_metric}{server_group_resource} = 'resources';
$has::Common::has_metric_config{parent_metric}{resource_type_attributes} = 'resource_types';
$has::Common::has_metric_config{parent_metric}{resource_type_dependencies} = 'resource_types';
$has::Common::has_metric_config{parent_metric}{server_group_members} = 'server_groups';
$has::Common::has_metric_config{parent_metric}{resource_instance_attributes} = 'resource_instances';
$has::Common::has_metric_config{parent_metric}{resource_instance_dependencies} = 'resource_instances';
$has::Common::has_metric_config{parent_metric}{resource_instance_status_metric} = 'resource_instance_alert_metric';
$has::Common::has_metric_config{parent_metric}{crs_servers} = 'css_nodes_metric';
$has::Common::has_metric_config{parent_metric}{gpnp_server_alert_metric} = 'css_nodes_metric';
$has::Common::has_metric_config{parent_metric}{gpnp_server_pool} = 'gpnp_alert_metric';

# os command to be used for each metric
$has::Common::has_metric_config{command}{resources}="emcrsp";
$has::Common::has_metric_config{arg}{resources}="em config -e resource";
$has::Common::has_metric_config{command}{resource_instances}="emcrsp";
$has::Common::has_metric_config{arg}{resource_instances}="em config -e resource_instance";
$has::Common::has_metric_config{command}{resource_types}="emcrsp";
$has::Common::has_metric_config{arg}{resource_types}="em config -e resource_type -b all";
$has::Common::has_metric_config{command}{servers}="emcrsp";
$has::Common::has_metric_config{arg}{servers}="em config -e server";
$has::Common::has_metric_config{command}{crs_servers}="emcrsp";
$has::Common::has_metric_config{arg}{crs_servers}="em config -e server";
$has::Common::has_metric_config{command}{server_groups}="emcrsp";
$has::Common::has_metric_config{arg}{server_groups}="em config -e server_pool";
$has::Common::has_metric_config{command}{resource_instance_alert_metric}="emcrsp";
$has::Common::has_metric_config{arg}{resource_instance_alert_metric}="em status -e resource";
$has::Common::has_metric_config{command}{gpnp_alert_metric}="emcrsp";
$has::Common::has_metric_config{arg}{gpnp_alert_metric}="em status -e resource";
$has::Common::has_metric_config{command}{gpnp_server_alert_metric}="emcrsp";
$has::Common::has_metric_config{arg}{gpnp_server_alert_metric}="em config -e server";
$has::Common::has_metric_config{command}{css_nodes_metric}="emcrsp";
$has::Common::has_metric_config{arg}{css_nodes_metric}="em config -e node";
$has::Common::has_metric_config{command}{vip_relocation_metric}="emcrsp";
$has::Common::has_metric_config{arg}{vip_relocation_metric}="em config -e resource_instance -p ora.cluster_vip_net1.type";
$has::Common::has_metric_config{command}{gpnp_server_pool}="emcrsp";
$has::Common::has_metric_config{arg}{gpnp_server_pool}="em config -e server_pool";


# entity_name in xml from emcrsp for each metric
$has::Common::has_metric_config{entity_type}{resources}='resource';
$has::Common::has_metric_config{entity_type}{resource_types}='resource_type';
$has::Common::has_metric_config{entity_type}{servers}='server';
$has::Common::has_metric_config{entity_type}{crs_servers}='server';
$has::Common::has_metric_config{entity_type}{server_groups}='server_pool';
$has::Common::has_metric_config{entity_type}{resource_instances}='resource_instance';
$has::Common::has_metric_config{entity_type}{nodes}='node';
$has::Common::has_metric_config{entity_type}{resource_instance_alert_metric}='resource';
$has::Common::has_metric_config{entity_type}{gpnp_alert_metric}='resource';
$has::Common::has_metric_config{entity_type}{gpnp_server_alert_metric}='server';
$has::Common::has_metric_config{entity_type}{css_nodes_metric}='node';
$has::Common::has_metric_config{entity_type}{vip_relocation_metric}='resource_instance';
$has::Common::has_metric_config{entity_type}{gpnp_server_pool}='server_pool';


# value field to be selected, by default is is value 
$has::Common::has_metric_config{resource_types}{value_property}='default_value';


# keep track of the errors to be printed at the end
#my %has_errhash;
my %has_error_stack;
my %has_xml_errors;

our $has_em_targettype = 'UNKNOWN';
our $has_em_targetname = 'UNKNOWN';
our $has_em_targetguid = 'UNKNOWN';

# hash variables to keep track of base resource type, attrrib base type
# resource instance - resource name
# internal resource types
our %hasadm_restype_base;
our %hasadm_restype_attrib;
our %hasadm_resource_type_list;
our %hasadm_resource_list;
our %hasadm_resourceinst_list;
our %hasadm_list_internalresource_types;
#-----------------------------------------------------------------------------
# package level variables
#-----------------------------------------------------------------------------

#-----------------------------------------------------------------------------------------
# FUNCTION : AUTOLOAD
#
# DESC 
# Autoload and execute the sub if sub is registered and defined
#
# ARGUMENTS
# Args to be passed to the sub
#
#-----------------------------------------------------------------------------------------
sub AUTOLOAD
{
    
  my @args = @_;

  my $sub = $AUTOLOAD;
    
  $sub =~ s/.*:://;	

  #print "DEVTRC:has::Common:$sub invoked \n" if $sub;

  warn "ERROR:has::Common::AUTOLOAD Invoked without a subroutine name \n" and return unless $sub;

  # get a ref to the sub 
  my $sub_ref;

  my $sub_path = "has::HasCluster::$sub";

  # If the sub is not defined return with warn
  warn "ERROR:has::Common::AUTOLOAD Function $sub is not found in HasCluster perl modules \n" and return unless defined(&$sub_path);

  $sub_ref = \&$sub_path;

  # execut this subroutine and return if run mode is either regression or capture
  return &$sub_ref(@args) unless $ENV{HAS_TEST_MODE} and $ENV{HAS_TEST_MODE} =~ /regression|capture/i;

  # though mode is capture|regressop if the sub routine is not to be regressed then return actual results
  return &$sub_ref(@args) unless $has::Common::regression_subs{$sub};

  #-----------------------------------------------------------
  # fall thru below this line only for test mode
  # either REGRESSION or CAPTURE
  #-----------------------------------------------------------
  return has::HasCluster::regression_test($sub,$sub_ref,@args);

}


END
{
  has::Common::save_systemcmdoutput() or warn "WARN:has::Common: Failed to save the regression test results\n";
}

1; #Returning a true value at the end of the module

