Rem
Rem Copyright (c) 2004, 2008, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      catmach.sql
Rem
Rem    DESCRIPTION
Rem       Removes privleges from the DVSYS and DVF accounts
Rem       used during the install
Rem
Rem    NOTES
Rem      Run as SYSDBA
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    pknaggs     04/11/08 - bug 6938028: Database Vault protected schema.
Rem    srirasub    11/09/06 - remove the dictionary word inserts
Rem    ayalaman    08/02/06 - hardening: revoke privs
Rem    cchui       07/17/06 - revoke become user from imp_full_database and 
Rem                           dba roles 
Rem    jciminsk    05/02/06 - cleanup embedded file boilerplate 
Rem    jciminsk    05/02/06 - created admin/catmach.sql 
Rem    sgaetjen    08/11/05 - sgaetjen_dvschema
Rem    sgaetjen    08/03/05 - Correct comments 
Rem    sgaetjen    07/30/05 - Created


REVOKE CREATE PUBLIC SYNONYM FROM dvsys
/
REVOKE DROP PUBLIC SYNONYM FROM dvsys
/
REVOKE CREATE ANY PROCEDURE FROM dvsys
/
REVOKE BECOME USER FROM DBA
/
REVOKE BECOME USER FROM IMP_FULL_DATABASE
/

-- bug 5434916 --
REVOKE SELECT ANY TRANSACTION FROM DBA
/

-- bug 5434911 --
REVOKE EXECUTE ON DBMS_LOGMNR FROM EXECUTE_CATALOG_ROLE
/

REVOKE EXECUTE ON DBMS_LOGMNR_D FROM EXECUTE_CATALOG_ROLE
/

REVOKE EXECUTE ON DBMS_LOGMNR_LOGREP_DICT FROM EXECUTE_CATALOG_ROLE
/

REVOKE EXECUTE ON DBMS_LOGMNR_SESSION FROM EXECUTE_CATALOG_ROLE
/

-- bug  5409828 --
REVOKE EXECUTE ON DBMS_FILE_TRANSFER FROM EXECUTE_CATALOG_ROLE
/

declare 
  CURSOR refschs is
    select distinct owner from dba_dependencies
      where referenced_owner = 'PUBLIC' and referenced_name = 'UTL_FILE' and owner != 'SYS';
begin
  for c1 in refschs loop
    EXECUTE IMMEDIATE 'grant execute on UTL_FILE to '||c1.owner;
  end loop;
end;
/

REVOKE EXECUTE ON UTL_FILE FROM PUBLIC
/

-- bug 5401773 --
REVOKE CREATE ANY JOB FROM DBA
/

REVOKE CREATE ANY JOB FROM SCHEDULER_ADMIN
/

REVOKE CREATE EXTERNAL JOB FROM DBA
/

REVOKE CREATE EXTERNAL JOB FROM SCHEDULER_ADMIN
/

REVOKE EXECUTE ANY PROGRAM FROM DBA
/

REVOKE EXECUTE ANY PROGRAM FROM SCHEDULER_ADMIN
/

REVOKE EXECUTE ANY CLASS FROM DBA
/

REVOKE EXECUTE ANY CLASS FROM SCHEDULER_ADMIN
/

REVOKE MANAGE SCHEDULER FROM DBA
/

REVOKE MANAGE SCHEDULER FROM SCHEDULER_ADMIN
/

REVOKE DEQUEUE ANY QUEUE FROM DBA
/

REVOKE ENQUEUE ANY QUEUE FROM DBA
/

REVOKE MANAGE ANY QUEUE FROM DBA
/

REVOKE MANAGE ANY QUEUE FROM IMP_FULL_DATABASE
/

Rem The "CREATE ANY TYPE" privilege (KZSXTY) was used to create the
Rem view ku$_database_vault_realm_view in $SRCHOME/rdbms/admin/catmacc.sql,
Rem required by Datapump for export/import of the Protected Schema metadata.
Rem This privilege is revoked here as it is no longer needed now that the
Rem view has been created.
REVOKE CREATE ANY TYPE FROM dvsys
/

Rem
Rem
Rem
Rem    DESCRIPTION
Rem      DV Hardening script - password profile dictionary table
Rem

CREATE TABLE SYS.db_profile_dict$ (
    pwd_term VARCHAR2 (60) NOT NULL
)
/

ALTER TABLE SYS.db_profile_dict$
ADD CONSTRAINT "DB_PROFILE_DICT$_PK" PRIMARY KEY
(
pwd_term
)
 ENABLE
/

Rem
Rem
Rem    DESCRIPTION
Rem      password profile verification function
Rem
CREATE OR REPLACE FUNCTION SYS.db_profile_function
(username varchar2,
  password varchar2,
  old_password varchar2)
  RETURN boolean IS
   n boolean;
   m integer;
   differ integer;
   isdigit boolean;
   ischar  boolean;
   ispunct boolean;
   digitarray varchar2(20);
   chararray varchar2(52);
   l_search varchar2(255);
   l_count number;
   l_msg_text VARCHAR2(600);
   l_return BINARY_INTEGER;
BEGIN
   IF NOT dvsys.dbms_macutl.is_dv_enabled THEN
       RETURN TRUE;
   END IF;

   digitarray:= '0123456789';
   chararray:= 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';

   -- Check if the password is same as the username
   IF NLS_LOWER(password) = NLS_LOWER(username) THEN
     
    l_return := utl_lms.get_message(
        errnum   => 47985,
        product  => 'rdbms',
        facility => 'ora',
        language => NULL,
        message => l_msg_text);
     raise_application_error(-20001, l_msg_text );
   END IF;

   -- Check for the minimum length of the password
   IF length(password) < 8 THEN
      l_return := utl_lms.get_message(
        errnum   => 47986,
        product  => 'rdbms',
        facility => 'ora',
        language => NULL,
        message => l_msg_text);

      raise_application_error(-20002, l_msg_text );
   END IF;

   -- Check if the password is too simple. A dictionary of words may be
   -- maintained and a check may be made so as not to allow the words
   -- that are too simple for the password.

   l_search := '%' ||  NLS_LOWER(password) || '%';
   SELECT COUNT(*)
   INTO l_count
   FROM sys.db_profile_dict$ a
   WHERE instr( l_search, NLS_LOWER(a.pwd_term) ) > 0 ;

   -- WHERE NLS_LOWER(a.pwd_term) LIKE l_search;
   -- WHERE NLS_LOWER(a.pwd_term) = NLS_LOWER(password);
   IF (( l_count IS NOT NULL ) AND ( l_count > 0 )) THEN
     l_return := utl_lms.get_message(
        errnum   => 47987,
        product  => 'rdbms',
        facility => 'ora',
        language => NULL,
        message => l_msg_text);

      raise_application_error(-20002, l_msg_text);
   END IF;

   -- Check if the password contains at least one letter, one digit
   -- 1. Check for the digit
   isdigit:=FALSE;
   m := length(password);
   FOR i IN 1..10 LOOP
      FOR j IN 1..m LOOP
         IF substr(password,j,1) = substr(digitarray,i,1) THEN
            isdigit:=TRUE;
             GOTO findchar;
         END IF;
      END LOOP;
   END LOOP;
   IF isdigit = FALSE THEN
     l_return := utl_lms.get_message(
        errnum   => 47988,
        product  => 'rdbms',
        facility => 'ora',
        language => NULL,
        message => l_msg_text);

      raise_application_error(-20003, l_msg_text);
   END IF;
   -- 2. Check for the character
   <<findchar>>
   ischar:=FALSE;
   FOR i IN 1..length(chararray) LOOP
      FOR j IN 1..m LOOP
         IF substr(password,j,1) = substr(chararray,i,1) THEN
            ischar:=TRUE;
             GOTO endsearch;
         END IF;
      END LOOP;
   END LOOP;
   IF ischar = FALSE THEN
     l_return := utl_lms.get_message(
        errnum   => 47988,
        product  => 'rdbms',
        facility => 'ora',
        language => NULL,
        message => l_msg_text);

      raise_application_error(-20003, l_msg_text);
   END IF;

   <<endsearch>>
   -- Check if the password differs from the previous password by at least
   -- 3 letters
   IF old_password IS NOT NULL THEN
     differ := length(old_password) - length(password);

     IF abs(differ) < 3 THEN
       IF length(password) < length(old_password) THEN
         m := length(password);
       ELSE
         m := length(old_password);
       END IF;

       differ := abs(differ);
       FOR i IN 1..m LOOP
         IF substr(password,i,1) != substr(old_password,i,1) THEN
           differ := differ + 1;
         END IF;
       END LOOP;

       IF differ < 3 THEN
         l_return := utl_lms.get_message(
           errnum   => 47989,
           product  => 'rdbms',
           facility => 'ora',
           language => NULL,
            message => l_msg_text);

         raise_application_error(-20004, l_msg_text);

       END IF;
     END IF;
   END IF;
   -- Everything is fine; return TRUE ;
   RETURN(TRUE);
END;
/
Rem
Rem
Rem
Rem    DESCRIPTION
Rem      SQL Representation of the audit policy for Data Vault on non-DVSYS schemas and system privileges
Rem
Rem
Rem
Rem

AUDIT EXECUTE ON LBACSYS.BIN_TO_RAW BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT RENAME ON LBACSYS.BIN_TO_RAW BY ACCESS WHENEVER SUCCESSFUL;
AUDIT RENAME ON LBACSYS.BIN_TO_RAW BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.BIN_TO_RAW BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.BIN_TO_RAW BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.BIN_TO_RAW BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.BIN_TO_RAW BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT EXECUTE ON LBACSYS.FROM_BIN_LABEL BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT RENAME ON LBACSYS.FROM_BIN_LABEL BY ACCESS WHENEVER SUCCESSFUL;
AUDIT RENAME ON LBACSYS.FROM_BIN_LABEL BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.FROM_BIN_LABEL BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.FROM_BIN_LABEL BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.FROM_BIN_LABEL BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.FROM_BIN_LABEL BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT EXECUTE ON LBACSYS.FROM_INTERNAL_LABEL BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT RENAME ON LBACSYS.FROM_INTERNAL_LABEL BY ACCESS WHENEVER SUCCESSFUL;
AUDIT RENAME ON LBACSYS.FROM_INTERNAL_LABEL BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.FROM_INTERNAL_LABEL BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.FROM_INTERNAL_LABEL BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.FROM_INTERNAL_LABEL BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.FROM_INTERNAL_LABEL BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT EXECUTE ON LBACSYS.LABELNAMES_TO_CHAR BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT RENAME ON LBACSYS.LABELNAMES_TO_CHAR BY ACCESS WHENEVER SUCCESSFUL;
AUDIT RENAME ON LBACSYS.LABELNAMES_TO_CHAR BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.LABELNAMES_TO_CHAR BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.LABELNAMES_TO_CHAR BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.LABELNAMES_TO_CHAR BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.LABELNAMES_TO_CHAR BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT EXECUTE ON LBACSYS.LABEL_LIST_TO_CHAR BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT RENAME ON LBACSYS.LABEL_LIST_TO_CHAR BY ACCESS WHENEVER SUCCESSFUL;
AUDIT RENAME ON LBACSYS.LABEL_LIST_TO_CHAR BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.LABEL_LIST_TO_CHAR BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.LABEL_LIST_TO_CHAR BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.LABEL_LIST_TO_CHAR BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.LABEL_LIST_TO_CHAR BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT EXECUTE ON LBACSYS.LABEL_LIST_TO_NAMED_CHAR BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT RENAME ON LBACSYS.LABEL_LIST_TO_NAMED_CHAR BY ACCESS WHENEVER SUCCESSFUL;
AUDIT RENAME ON LBACSYS.LABEL_LIST_TO_NAMED_CHAR BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.LABEL_LIST_TO_NAMED_CHAR BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.LABEL_LIST_TO_NAMED_CHAR BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.LABEL_LIST_TO_NAMED_CHAR BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.LABEL_LIST_TO_NAMED_CHAR BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT EXECUTE ON LBACSYS.LBAC_DOMINATED_BY BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT RENAME ON LBACSYS.LBAC_DOMINATED_BY BY ACCESS WHENEVER SUCCESSFUL;
AUDIT RENAME ON LBACSYS.LBAC_DOMINATED_BY BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.LBAC_DOMINATED_BY BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.LBAC_DOMINATED_BY BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.LBAC_DOMINATED_BY BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.LBAC_DOMINATED_BY BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT EXECUTE ON LBACSYS.LBAC_DOMINATES BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT RENAME ON LBACSYS.LBAC_DOMINATES BY ACCESS WHENEVER SUCCESSFUL;
AUDIT RENAME ON LBACSYS.LBAC_DOMINATES BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.LBAC_DOMINATES BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.LBAC_DOMINATES BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.LBAC_DOMINATES BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.LBAC_DOMINATES BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT EXECUTE ON LBACSYS.LBAC_GREATEST_LBOUND BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT RENAME ON LBACSYS.LBAC_GREATEST_LBOUND BY ACCESS WHENEVER SUCCESSFUL;
AUDIT RENAME ON LBACSYS.LBAC_GREATEST_LBOUND BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.LBAC_GREATEST_LBOUND BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.LBAC_GREATEST_LBOUND BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.LBAC_GREATEST_LBOUND BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.LBAC_GREATEST_LBOUND BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT EXECUTE ON LBACSYS.LBAC_LABEL_TAGSEQ_TO_CHAR BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT RENAME ON LBACSYS.LBAC_LABEL_TAGSEQ_TO_CHAR BY ACCESS WHENEVER SUCCESSFUL;
AUDIT RENAME ON LBACSYS.LBAC_LABEL_TAGSEQ_TO_CHAR BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.LBAC_LABEL_TAGSEQ_TO_CHAR BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.LBAC_LABEL_TAGSEQ_TO_CHAR BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.LBAC_LABEL_TAGSEQ_TO_CHAR BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.LBAC_LABEL_TAGSEQ_TO_CHAR BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT EXECUTE ON LBACSYS.LBAC_LABEL_TO_CHAR BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT RENAME ON LBACSYS.LBAC_LABEL_TO_CHAR BY ACCESS WHENEVER SUCCESSFUL;
AUDIT RENAME ON LBACSYS.LBAC_LABEL_TO_CHAR BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.LBAC_LABEL_TO_CHAR BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.LBAC_LABEL_TO_CHAR BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.LBAC_LABEL_TO_CHAR BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.LBAC_LABEL_TO_CHAR BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT EXECUTE ON LBACSYS.LBAC_LABEL_TO_NUMERIC BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT RENAME ON LBACSYS.LBAC_LABEL_TO_NUMERIC BY ACCESS WHENEVER SUCCESSFUL;
AUDIT RENAME ON LBACSYS.LBAC_LABEL_TO_NUMERIC BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.LBAC_LABEL_TO_NUMERIC BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.LBAC_LABEL_TO_NUMERIC BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.LBAC_LABEL_TO_NUMERIC BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.LBAC_LABEL_TO_NUMERIC BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT EXECUTE ON LBACSYS.LBAC_LEAST_UBOUND BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT RENAME ON LBACSYS.LBAC_LEAST_UBOUND BY ACCESS WHENEVER SUCCESSFUL;
AUDIT RENAME ON LBACSYS.LBAC_LEAST_UBOUND BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.LBAC_LEAST_UBOUND BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.LBAC_LEAST_UBOUND BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.LBAC_LEAST_UBOUND BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.LBAC_LEAST_UBOUND BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT EXECUTE ON LBACSYS.LBAC_MERGE_LABEL BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT RENAME ON LBACSYS.LBAC_MERGE_LABEL BY ACCESS WHENEVER SUCCESSFUL;
AUDIT RENAME ON LBACSYS.LBAC_MERGE_LABEL BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.LBAC_MERGE_LABEL BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.LBAC_MERGE_LABEL BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.LBAC_MERGE_LABEL BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.LBAC_MERGE_LABEL BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT EXECUTE ON LBACSYS.LBAC_STRICTLY_DOMINATED_BY BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT RENAME ON LBACSYS.LBAC_STRICTLY_DOMINATED_BY BY ACCESS WHENEVER SUCCESSFUL;
AUDIT RENAME ON LBACSYS.LBAC_STRICTLY_DOMINATED_BY BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.LBAC_STRICTLY_DOMINATED_BY BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.LBAC_STRICTLY_DOMINATED_BY BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.LBAC_STRICTLY_DOMINATED_BY BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.LBAC_STRICTLY_DOMINATED_BY BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT EXECUTE ON LBACSYS.LBAC_STRICTLY_DOMINATES BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT RENAME ON LBACSYS.LBAC_STRICTLY_DOMINATES BY ACCESS WHENEVER SUCCESSFUL;
AUDIT RENAME ON LBACSYS.LBAC_STRICTLY_DOMINATES BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.LBAC_STRICTLY_DOMINATES BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.LBAC_STRICTLY_DOMINATES BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.LBAC_STRICTLY_DOMINATES BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.LBAC_STRICTLY_DOMINATES BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT EXECUTE ON LBACSYS.NUMERIC_DOMINATED_BY BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT RENAME ON LBACSYS.NUMERIC_DOMINATED_BY BY ACCESS WHENEVER SUCCESSFUL;
AUDIT RENAME ON LBACSYS.NUMERIC_DOMINATED_BY BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.NUMERIC_DOMINATED_BY BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.NUMERIC_DOMINATED_BY BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.NUMERIC_DOMINATED_BY BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.NUMERIC_DOMINATED_BY BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT EXECUTE ON LBACSYS.NUMERIC_DOMINATES BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT RENAME ON LBACSYS.NUMERIC_DOMINATES BY ACCESS WHENEVER SUCCESSFUL;
AUDIT RENAME ON LBACSYS.NUMERIC_DOMINATES BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.NUMERIC_DOMINATES BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.NUMERIC_DOMINATES BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.NUMERIC_DOMINATES BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.NUMERIC_DOMINATES BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT EXECUTE ON LBACSYS.NUMERIC_GREATEST_LBOUND BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT RENAME ON LBACSYS.NUMERIC_GREATEST_LBOUND BY ACCESS WHENEVER SUCCESSFUL;
AUDIT RENAME ON LBACSYS.NUMERIC_GREATEST_LBOUND BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.NUMERIC_GREATEST_LBOUND BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.NUMERIC_GREATEST_LBOUND BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.NUMERIC_GREATEST_LBOUND BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.NUMERIC_GREATEST_LBOUND BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT EXECUTE ON LBACSYS.NUMERIC_LABEL_TAGSEQ_TO_CHAR BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT RENAME ON LBACSYS.NUMERIC_LABEL_TAGSEQ_TO_CHAR BY ACCESS WHENEVER SUCCESSFUL;
AUDIT RENAME ON LBACSYS.NUMERIC_LABEL_TAGSEQ_TO_CHAR BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.NUMERIC_LABEL_TAGSEQ_TO_CHAR BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.NUMERIC_LABEL_TAGSEQ_TO_CHAR BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.NUMERIC_LABEL_TAGSEQ_TO_CHAR BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.NUMERIC_LABEL_TAGSEQ_TO_CHAR BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT EXECUTE ON LBACSYS.NUMERIC_LABEL_TO_CHAR BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT RENAME ON LBACSYS.NUMERIC_LABEL_TO_CHAR BY ACCESS WHENEVER SUCCESSFUL;
AUDIT RENAME ON LBACSYS.NUMERIC_LABEL_TO_CHAR BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.NUMERIC_LABEL_TO_CHAR BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.NUMERIC_LABEL_TO_CHAR BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.NUMERIC_LABEL_TO_CHAR BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.NUMERIC_LABEL_TO_CHAR BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT EXECUTE ON LBACSYS.NUMERIC_LABEL_TO_LBAC BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT RENAME ON LBACSYS.NUMERIC_LABEL_TO_LBAC BY ACCESS WHENEVER SUCCESSFUL;
AUDIT RENAME ON LBACSYS.NUMERIC_LABEL_TO_LBAC BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.NUMERIC_LABEL_TO_LBAC BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.NUMERIC_LABEL_TO_LBAC BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.NUMERIC_LABEL_TO_LBAC BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.NUMERIC_LABEL_TO_LBAC BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT EXECUTE ON LBACSYS.NUMERIC_LEAST_UBOUND BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT RENAME ON LBACSYS.NUMERIC_LEAST_UBOUND BY ACCESS WHENEVER SUCCESSFUL;
AUDIT RENAME ON LBACSYS.NUMERIC_LEAST_UBOUND BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.NUMERIC_LEAST_UBOUND BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.NUMERIC_LEAST_UBOUND BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.NUMERIC_LEAST_UBOUND BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.NUMERIC_LEAST_UBOUND BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT EXECUTE ON LBACSYS.NUMERIC_MERGE_LABEL BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT RENAME ON LBACSYS.NUMERIC_MERGE_LABEL BY ACCESS WHENEVER SUCCESSFUL;
AUDIT RENAME ON LBACSYS.NUMERIC_MERGE_LABEL BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.NUMERIC_MERGE_LABEL BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.NUMERIC_MERGE_LABEL BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.NUMERIC_MERGE_LABEL BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.NUMERIC_MERGE_LABEL BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT EXECUTE ON LBACSYS.NUMERIC_STRICTLY_DOMINATED_BY BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT RENAME ON LBACSYS.NUMERIC_STRICTLY_DOMINATED_BY BY ACCESS WHENEVER SUCCESSFUL;
AUDIT RENAME ON LBACSYS.NUMERIC_STRICTLY_DOMINATED_BY BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.NUMERIC_STRICTLY_DOMINATED_BY BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.NUMERIC_STRICTLY_DOMINATED_BY BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.NUMERIC_STRICTLY_DOMINATED_BY BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.NUMERIC_STRICTLY_DOMINATED_BY BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT EXECUTE ON LBACSYS.NUMERIC_STRICTLY_DOMINATES BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT RENAME ON LBACSYS.NUMERIC_STRICTLY_DOMINATES BY ACCESS WHENEVER SUCCESSFUL;
AUDIT RENAME ON LBACSYS.NUMERIC_STRICTLY_DOMINATES BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.NUMERIC_STRICTLY_DOMINATES BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.NUMERIC_STRICTLY_DOMINATES BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.NUMERIC_STRICTLY_DOMINATES BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.NUMERIC_STRICTLY_DOMINATES BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT EXECUTE ON LBACSYS.PRIVS_TO_CHAR BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT RENAME ON LBACSYS.PRIVS_TO_CHAR BY ACCESS WHENEVER SUCCESSFUL;
AUDIT RENAME ON LBACSYS.PRIVS_TO_CHAR BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.PRIVS_TO_CHAR BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.PRIVS_TO_CHAR BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.PRIVS_TO_CHAR BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.PRIVS_TO_CHAR BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT EXECUTE ON LBACSYS.TO_BIN_LABEL BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT RENAME ON LBACSYS.TO_BIN_LABEL BY ACCESS WHENEVER SUCCESSFUL;
AUDIT RENAME ON LBACSYS.TO_BIN_LABEL BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.TO_BIN_LABEL BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.TO_BIN_LABEL BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.TO_BIN_LABEL BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.TO_BIN_LABEL BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT EXECUTE ON LBACSYS.TO_INTERNAL_LABEL BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT RENAME ON LBACSYS.TO_INTERNAL_LABEL BY ACCESS WHENEVER SUCCESSFUL;
AUDIT RENAME ON LBACSYS.TO_INTERNAL_LABEL BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.TO_INTERNAL_LABEL BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.TO_INTERNAL_LABEL BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.TO_INTERNAL_LABEL BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.TO_INTERNAL_LABEL BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT EXECUTE ON LBACSYS.TO_LBAC_DATA_LABEL BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT RENAME ON LBACSYS.TO_LBAC_DATA_LABEL BY ACCESS WHENEVER SUCCESSFUL;
AUDIT RENAME ON LBACSYS.TO_LBAC_DATA_LABEL BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.TO_LBAC_DATA_LABEL BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.TO_LBAC_DATA_LABEL BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.TO_LBAC_DATA_LABEL BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.TO_LBAC_DATA_LABEL BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT EXECUTE ON LBACSYS.TO_LBAC_LABEL BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT RENAME ON LBACSYS.TO_LBAC_LABEL BY ACCESS WHENEVER SUCCESSFUL;
AUDIT RENAME ON LBACSYS.TO_LBAC_LABEL BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.TO_LBAC_LABEL BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.TO_LBAC_LABEL BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.TO_LBAC_LABEL BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.TO_LBAC_LABEL BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT EXECUTE ON LBACSYS.TO_NUMERIC_DATA_LABEL BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT RENAME ON LBACSYS.TO_NUMERIC_DATA_LABEL BY ACCESS WHENEVER SUCCESSFUL;
AUDIT RENAME ON LBACSYS.TO_NUMERIC_DATA_LABEL BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.TO_NUMERIC_DATA_LABEL BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.TO_NUMERIC_DATA_LABEL BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.TO_NUMERIC_DATA_LABEL BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.TO_NUMERIC_DATA_LABEL BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT EXECUTE ON LBACSYS.TO_NUMERIC_LABEL BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT RENAME ON LBACSYS.TO_NUMERIC_LABEL BY ACCESS WHENEVER SUCCESSFUL;
AUDIT RENAME ON LBACSYS.TO_NUMERIC_LABEL BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.TO_NUMERIC_LABEL BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.TO_NUMERIC_LABEL BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.TO_NUMERIC_LABEL BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.TO_NUMERIC_LABEL BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT EXECUTE ON LBACSYS.TO_PRIVS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT RENAME ON LBACSYS.TO_PRIVS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT RENAME ON LBACSYS.TO_PRIVS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.TO_PRIVS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.TO_PRIVS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.TO_PRIVS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.TO_PRIVS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT EXECUTE ON LBACSYS.LBAC_BIN_LABEL BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.LBAC_BIN_LABEL BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.LBAC_BIN_LABEL BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.LBAC_BIN_LABEL BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.LBAC_BIN_LABEL BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT ALTER ON LBACSYS.LBAC_BIN_LABEL BY ACCESS WHENEVER SUCCESSFUL;
AUDIT ALTER ON LBACSYS.LBAC_BIN_LABEL BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT EXECUTE ON LBACSYS.LBAC_COMPS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.LBAC_COMPS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.LBAC_COMPS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.LBAC_COMPS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.LBAC_COMPS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT ALTER ON LBACSYS.LBAC_COMPS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT ALTER ON LBACSYS.LBAC_COMPS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT EXECUTE ON LBACSYS.LBAC_LABEL BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.LBAC_LABEL BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.LBAC_LABEL BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.LBAC_LABEL BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.LBAC_LABEL BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT ALTER ON LBACSYS.LBAC_LABEL BY ACCESS WHENEVER SUCCESSFUL;
AUDIT ALTER ON LBACSYS.LBAC_LABEL BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT EXECUTE ON LBACSYS.LBAC_LABEL_LIST BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.LBAC_LABEL_LIST BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.LBAC_LABEL_LIST BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.LBAC_LABEL_LIST BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.LBAC_LABEL_LIST BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT ALTER ON LBACSYS.LBAC_LABEL_LIST BY ACCESS WHENEVER SUCCESSFUL;
AUDIT ALTER ON LBACSYS.LBAC_LABEL_LIST BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT EXECUTE ON LBACSYS.LBAC_NAME_LIST BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.LBAC_NAME_LIST BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.LBAC_NAME_LIST BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.LBAC_NAME_LIST BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.LBAC_NAME_LIST BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT ALTER ON LBACSYS.LBAC_NAME_LIST BY ACCESS WHENEVER SUCCESSFUL;
AUDIT ALTER ON LBACSYS.LBAC_NAME_LIST BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT EXECUTE ON LBACSYS.LBAC_PRIVS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.LBAC_PRIVS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.LBAC_PRIVS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.LBAC_PRIVS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.LBAC_PRIVS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT ALTER ON LBACSYS.LBAC_PRIVS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT ALTER ON LBACSYS.LBAC_PRIVS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT EXECUTE ON LBACSYS.LDAP_ATTR BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.LDAP_ATTR BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.LDAP_ATTR BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.LDAP_ATTR BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.LDAP_ATTR BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT ALTER ON LBACSYS.LDAP_ATTR BY ACCESS WHENEVER SUCCESSFUL;
AUDIT ALTER ON LBACSYS.LDAP_ATTR BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT EXECUTE ON LBACSYS.LDAP_ATTR_LIST BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.LDAP_ATTR_LIST BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.LDAP_ATTR_LIST BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.LDAP_ATTR_LIST BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.LDAP_ATTR_LIST BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT ALTER ON LBACSYS.LDAP_ATTR_LIST BY ACCESS WHENEVER SUCCESSFUL;
AUDIT ALTER ON LBACSYS.LDAP_ATTR_LIST BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT EXECUTE ON LBACSYS.LDAP_EVENT BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.LDAP_EVENT BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.LDAP_EVENT BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.LDAP_EVENT BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.LDAP_EVENT BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT ALTER ON LBACSYS.LDAP_EVENT BY ACCESS WHENEVER SUCCESSFUL;
AUDIT ALTER ON LBACSYS.LDAP_EVENT BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT EXECUTE ON LBACSYS.LDAP_EVENT_STATUS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.LDAP_EVENT_STATUS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.LDAP_EVENT_STATUS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.LDAP_EVENT_STATUS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.LDAP_EVENT_STATUS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT ALTER ON LBACSYS.LDAP_EVENT_STATUS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT ALTER ON LBACSYS.LDAP_EVENT_STATUS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.LBAC$LAB_SEQUENCE BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.LBAC$LAB_SEQUENCE BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.LBAC$LAB_SEQUENCE BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.LBAC$LAB_SEQUENCE BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT ALTER ON LBACSYS.LBAC$LAB_SEQUENCE BY ACCESS WHENEVER SUCCESSFUL;
AUDIT ALTER ON LBACSYS.LBAC$LAB_SEQUENCE BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.LBAC$TAG_SEQUENCE BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.LBAC$TAG_SEQUENCE BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.LBAC$TAG_SEQUENCE BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.LBAC$TAG_SEQUENCE BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT ALTER ON LBACSYS.LBAC$TAG_SEQUENCE BY ACCESS WHENEVER SUCCESSFUL;
AUDIT ALTER ON LBACSYS.LBAC$TAG_SEQUENCE BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT EXECUTE ON LBACSYS.SA_POLICY_GRANT BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT RENAME ON LBACSYS.SA_POLICY_GRANT BY ACCESS WHENEVER SUCCESSFUL;
AUDIT RENAME ON LBACSYS.SA_POLICY_GRANT BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.SA_POLICY_GRANT BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.SA_POLICY_GRANT BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.SA_POLICY_GRANT BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.SA_POLICY_GRANT BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT EXECUTE ON LBACSYS.LBAC_FRAME_GRANT BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT RENAME ON LBACSYS.LBAC_FRAME_GRANT BY ACCESS WHENEVER SUCCESSFUL;
AUDIT RENAME ON LBACSYS.LBAC_FRAME_GRANT BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.LBAC_FRAME_GRANT BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.LBAC_FRAME_GRANT BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.LBAC_FRAME_GRANT BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.LBAC_FRAME_GRANT BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.LBAC$CACHE_LIBT BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.LBAC$CACHE_LIBT BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT EXECUTE ON LBACSYS.LBAC$CACHE_LIBT BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.LBAC$COMPS_LIBT BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.LBAC$COMPS_LIBT BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT EXECUTE ON LBACSYS.LBAC$COMPS_LIBT BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.LBAC$EVENT_LIBT BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.LBAC$EVENT_LIBT BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT EXECUTE ON LBACSYS.LBAC$EVENT_LIBT BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.LBAC$LABEL_LIBT BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.LBAC$LABEL_LIBT BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT EXECUTE ON LBACSYS.LBAC$LABEL_LIBT BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.LBAC$LABLT_LIBT BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.LBAC$LABLT_LIBT BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT EXECUTE ON LBACSYS.LBAC$LABLT_LIBT BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.LBAC$PRIVS_LIBT BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.LBAC$PRIVS_LIBT BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT EXECUTE ON LBACSYS.LBAC$PRIVS_LIBT BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.LBAC$STD_LIBT BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.LBAC$STD_LIBT BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT EXECUTE ON LBACSYS.LBAC$STD_LIBT BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.LBAC$TYPE_LIBT BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.LBAC$TYPE_LIBT BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT EXECUTE ON LBACSYS.LBAC$TYPE_LIBT BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.LBAC$USER_LIBT BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.LBAC$USER_LIBT BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT EXECUTE ON LBACSYS.LBAC$USER_LIBT BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.SECURE_CONTEXT_LIB BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.SECURE_CONTEXT_LIB BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT EXECUTE ON LBACSYS.SECURE_CONTEXT_LIB BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.LBAC$SA_LABELS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.LBAC$SA_LABELS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.LBAC$SA_LABELS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.LBAC$SA_LABELS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT RENAME ON LBACSYS.LBAC$SA_LABELS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT RENAME ON LBACSYS.LBAC$SA_LABELS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT EXECUTE ON LBACSYS.LBAC$SA_LABELS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.LBAC$SA BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.LBAC$SA BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.LBAC$SA BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.LBAC$SA BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT RENAME ON LBACSYS.LBAC$SA BY ACCESS WHENEVER SUCCESSFUL;
AUDIT RENAME ON LBACSYS.LBAC$SA BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT EXECUTE ON LBACSYS.LBAC$SA BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.LBAC_AUDIT_ADMIN BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.LBAC_AUDIT_ADMIN BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.LBAC_AUDIT_ADMIN BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.LBAC_AUDIT_ADMIN BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT RENAME ON LBACSYS.LBAC_AUDIT_ADMIN BY ACCESS WHENEVER SUCCESSFUL;
AUDIT RENAME ON LBACSYS.LBAC_AUDIT_ADMIN BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT EXECUTE ON LBACSYS.LBAC_AUDIT_ADMIN BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.LBAC_CACHE BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.LBAC_CACHE BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.LBAC_CACHE BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.LBAC_CACHE BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT RENAME ON LBACSYS.LBAC_CACHE BY ACCESS WHENEVER SUCCESSFUL;
AUDIT RENAME ON LBACSYS.LBAC_CACHE BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT EXECUTE ON LBACSYS.LBAC_CACHE BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.LBAC_COMPARE BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.LBAC_COMPARE BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.LBAC_COMPARE BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.LBAC_COMPARE BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT RENAME ON LBACSYS.LBAC_COMPARE BY ACCESS WHENEVER SUCCESSFUL;
AUDIT RENAME ON LBACSYS.LBAC_COMPARE BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT EXECUTE ON LBACSYS.LBAC_COMPARE BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.LBAC_ERRORS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.LBAC_ERRORS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.LBAC_ERRORS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.LBAC_ERRORS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT RENAME ON LBACSYS.LBAC_ERRORS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT RENAME ON LBACSYS.LBAC_ERRORS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT EXECUTE ON LBACSYS.LBAC_ERRORS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.LBAC_EVENTS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.LBAC_EVENTS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.LBAC_EVENTS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.LBAC_EVENTS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT RENAME ON LBACSYS.LBAC_EVENTS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT RENAME ON LBACSYS.LBAC_EVENTS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT EXECUTE ON LBACSYS.LBAC_EVENTS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.LBAC_LABEL_ADMIN BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.LBAC_LABEL_ADMIN BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.LBAC_LABEL_ADMIN BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.LBAC_LABEL_ADMIN BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT RENAME ON LBACSYS.LBAC_LABEL_ADMIN BY ACCESS WHENEVER SUCCESSFUL;
AUDIT RENAME ON LBACSYS.LBAC_LABEL_ADMIN BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT EXECUTE ON LBACSYS.LBAC_LABEL_ADMIN BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.LBAC_POLICY_ADMIN BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.LBAC_POLICY_ADMIN BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.LBAC_POLICY_ADMIN BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.LBAC_POLICY_ADMIN BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT RENAME ON LBACSYS.LBAC_POLICY_ADMIN BY ACCESS WHENEVER SUCCESSFUL;
AUDIT RENAME ON LBACSYS.LBAC_POLICY_ADMIN BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT EXECUTE ON LBACSYS.LBAC_POLICY_ADMIN BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.LBAC_RLS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.LBAC_RLS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.LBAC_RLS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.LBAC_RLS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT RENAME ON LBACSYS.LBAC_RLS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT RENAME ON LBACSYS.LBAC_RLS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT EXECUTE ON LBACSYS.LBAC_RLS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.LBAC_SERVICES BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.LBAC_SERVICES BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.LBAC_SERVICES BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.LBAC_SERVICES BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT RENAME ON LBACSYS.LBAC_SERVICES BY ACCESS WHENEVER SUCCESSFUL;
AUDIT RENAME ON LBACSYS.LBAC_SERVICES BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT EXECUTE ON LBACSYS.LBAC_SERVICES BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.LBAC_SESSION BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.LBAC_SESSION BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.LBAC_SESSION BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.LBAC_SESSION BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT RENAME ON LBACSYS.LBAC_SESSION BY ACCESS WHENEVER SUCCESSFUL;
AUDIT RENAME ON LBACSYS.LBAC_SESSION BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT EXECUTE ON LBACSYS.LBAC_SESSION BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.LBAC_STANDARD BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.LBAC_STANDARD BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.LBAC_STANDARD BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.LBAC_STANDARD BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT RENAME ON LBACSYS.LBAC_STANDARD BY ACCESS WHENEVER SUCCESSFUL;
AUDIT RENAME ON LBACSYS.LBAC_STANDARD BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT EXECUTE ON LBACSYS.LBAC_STANDARD BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.LBAC_SYSDBA BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.LBAC_SYSDBA BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.LBAC_SYSDBA BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.LBAC_SYSDBA BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT RENAME ON LBACSYS.LBAC_SYSDBA BY ACCESS WHENEVER SUCCESSFUL;
AUDIT RENAME ON LBACSYS.LBAC_SYSDBA BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT EXECUTE ON LBACSYS.LBAC_SYSDBA BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.LBAC_USER_ADMIN BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.LBAC_USER_ADMIN BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.LBAC_USER_ADMIN BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.LBAC_USER_ADMIN BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT RENAME ON LBACSYS.LBAC_USER_ADMIN BY ACCESS WHENEVER SUCCESSFUL;
AUDIT RENAME ON LBACSYS.LBAC_USER_ADMIN BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT EXECUTE ON LBACSYS.LBAC_USER_ADMIN BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.LBAC_UTL BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.LBAC_UTL BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.LBAC_UTL BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.LBAC_UTL BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT RENAME ON LBACSYS.LBAC_UTL BY ACCESS WHENEVER SUCCESSFUL;
AUDIT RENAME ON LBACSYS.LBAC_UTL BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT EXECUTE ON LBACSYS.LBAC_UTL BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.OLS_DIP_NTFY BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.OLS_DIP_NTFY BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.OLS_DIP_NTFY BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.OLS_DIP_NTFY BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT RENAME ON LBACSYS.OLS_DIP_NTFY BY ACCESS WHENEVER SUCCESSFUL;
AUDIT RENAME ON LBACSYS.OLS_DIP_NTFY BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT EXECUTE ON LBACSYS.OLS_DIP_NTFY BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.SA$CTX BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.SA$CTX BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.SA$CTX BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.SA$CTX BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT RENAME ON LBACSYS.SA$CTX BY ACCESS WHENEVER SUCCESSFUL;
AUDIT RENAME ON LBACSYS.SA$CTX BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT EXECUTE ON LBACSYS.SA$CTX BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.SA_COMPONENTS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.SA_COMPONENTS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.SA_COMPONENTS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.SA_COMPONENTS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT RENAME ON LBACSYS.SA_COMPONENTS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT RENAME ON LBACSYS.SA_COMPONENTS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT EXECUTE ON LBACSYS.SA_COMPONENTS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.SA_SESSION BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.SA_SESSION BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.SA_SESSION BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.SA_SESSION BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT RENAME ON LBACSYS.SA_SESSION BY ACCESS WHENEVER SUCCESSFUL;
AUDIT RENAME ON LBACSYS.SA_SESSION BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT EXECUTE ON LBACSYS.SA_SESSION BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.SA_SYSDBA BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.SA_SYSDBA BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.SA_SYSDBA BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.SA_SYSDBA BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT RENAME ON LBACSYS.SA_SYSDBA BY ACCESS WHENEVER SUCCESSFUL;
AUDIT RENAME ON LBACSYS.SA_SYSDBA BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT EXECUTE ON LBACSYS.SA_SYSDBA BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.SA_USER_ADMIN BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.SA_USER_ADMIN BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.SA_USER_ADMIN BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.SA_USER_ADMIN BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT RENAME ON LBACSYS.SA_USER_ADMIN BY ACCESS WHENEVER SUCCESSFUL;
AUDIT RENAME ON LBACSYS.SA_USER_ADMIN BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT EXECUTE ON LBACSYS.SA_USER_ADMIN BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.SA_UTL BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.SA_UTL BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.SA_UTL BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.SA_UTL BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT RENAME ON LBACSYS.SA_UTL BY ACCESS WHENEVER SUCCESSFUL;
AUDIT RENAME ON LBACSYS.SA_UTL BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT EXECUTE ON LBACSYS.SA_UTL BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.TO_LABEL_LIST BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.TO_LABEL_LIST BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.TO_LABEL_LIST BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.TO_LABEL_LIST BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT RENAME ON LBACSYS.TO_LABEL_LIST BY ACCESS WHENEVER SUCCESSFUL;
AUDIT RENAME ON LBACSYS.TO_LABEL_LIST BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT EXECUTE ON LBACSYS.TO_LABEL_LIST BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT EXECUTE ON DVF.DBMS_MACSEC_FUNCTION BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT RENAME ON DVF.DBMS_MACSEC_FUNCTION BY ACCESS WHENEVER SUCCESSFUL;
AUDIT RENAME ON DVF.DBMS_MACSEC_FUNCTION BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON DVF.DBMS_MACSEC_FUNCTION BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON DVF.DBMS_MACSEC_FUNCTION BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON DVF.DBMS_MACSEC_FUNCTION BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON DVF.DBMS_MACSEC_FUNCTION BY ACCESS WHENEVER NOT SUCCESSFUL;



AUDIT SELECT ON LBACSYS.LBAC$LAB_SEQUENCE BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT SELECT ON LBACSYS.LBAC$TAG_SEQUENCE BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.ALL_SA_AUDIT_OPTIONS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.ALL_SA_AUDIT_OPTIONS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT RENAME ON LBACSYS.ALL_SA_AUDIT_OPTIONS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT RENAME ON LBACSYS.ALL_SA_AUDIT_OPTIONS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT INSERT ON LBACSYS.ALL_SA_AUDIT_OPTIONS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT INSERT ON LBACSYS.ALL_SA_AUDIT_OPTIONS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.ALL_SA_AUDIT_OPTIONS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.ALL_SA_AUDIT_OPTIONS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT DELETE ON LBACSYS.ALL_SA_AUDIT_OPTIONS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT DELETE ON LBACSYS.ALL_SA_AUDIT_OPTIONS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.ALL_SA_AUDIT_OPTIONS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.ALL_SA_AUDIT_OPTIONS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.ALL_SA_AUDIT_OPTIONS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.ALL_SA_AUDIT_OPTIONS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT SELECT ON LBACSYS.ALL_SA_AUDIT_OPTIONS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.ALL_SA_COMPARTMENTS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.ALL_SA_COMPARTMENTS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT RENAME ON LBACSYS.ALL_SA_COMPARTMENTS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT RENAME ON LBACSYS.ALL_SA_COMPARTMENTS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT INSERT ON LBACSYS.ALL_SA_COMPARTMENTS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT INSERT ON LBACSYS.ALL_SA_COMPARTMENTS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.ALL_SA_COMPARTMENTS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.ALL_SA_COMPARTMENTS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT DELETE ON LBACSYS.ALL_SA_COMPARTMENTS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT DELETE ON LBACSYS.ALL_SA_COMPARTMENTS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.ALL_SA_COMPARTMENTS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.ALL_SA_COMPARTMENTS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.ALL_SA_COMPARTMENTS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.ALL_SA_COMPARTMENTS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT SELECT ON LBACSYS.ALL_SA_COMPARTMENTS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.ALL_SA_DATA_LABELS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.ALL_SA_DATA_LABELS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT RENAME ON LBACSYS.ALL_SA_DATA_LABELS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT RENAME ON LBACSYS.ALL_SA_DATA_LABELS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT INSERT ON LBACSYS.ALL_SA_DATA_LABELS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT INSERT ON LBACSYS.ALL_SA_DATA_LABELS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.ALL_SA_DATA_LABELS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.ALL_SA_DATA_LABELS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT DELETE ON LBACSYS.ALL_SA_DATA_LABELS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT DELETE ON LBACSYS.ALL_SA_DATA_LABELS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.ALL_SA_DATA_LABELS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.ALL_SA_DATA_LABELS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.ALL_SA_DATA_LABELS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.ALL_SA_DATA_LABELS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT SELECT ON LBACSYS.ALL_SA_DATA_LABELS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.ALL_SA_GROUPS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.ALL_SA_GROUPS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT RENAME ON LBACSYS.ALL_SA_GROUPS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT RENAME ON LBACSYS.ALL_SA_GROUPS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT INSERT ON LBACSYS.ALL_SA_GROUPS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT INSERT ON LBACSYS.ALL_SA_GROUPS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.ALL_SA_GROUPS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.ALL_SA_GROUPS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT DELETE ON LBACSYS.ALL_SA_GROUPS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT DELETE ON LBACSYS.ALL_SA_GROUPS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.ALL_SA_GROUPS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.ALL_SA_GROUPS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.ALL_SA_GROUPS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.ALL_SA_GROUPS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT SELECT ON LBACSYS.ALL_SA_GROUPS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.ALL_SA_GROUP_HIERARCHY BY ACCESS WHENEVER SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.ALL_SA_GROUP_HIERARCHY BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT RENAME ON LBACSYS.ALL_SA_GROUP_HIERARCHY BY ACCESS WHENEVER SUCCESSFUL;
AUDIT RENAME ON LBACSYS.ALL_SA_GROUP_HIERARCHY BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT INSERT ON LBACSYS.ALL_SA_GROUP_HIERARCHY BY ACCESS WHENEVER SUCCESSFUL;
AUDIT INSERT ON LBACSYS.ALL_SA_GROUP_HIERARCHY BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.ALL_SA_GROUP_HIERARCHY BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.ALL_SA_GROUP_HIERARCHY BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT DELETE ON LBACSYS.ALL_SA_GROUP_HIERARCHY BY ACCESS WHENEVER SUCCESSFUL;
AUDIT DELETE ON LBACSYS.ALL_SA_GROUP_HIERARCHY BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.ALL_SA_GROUP_HIERARCHY BY ACCESS WHENEVER SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.ALL_SA_GROUP_HIERARCHY BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.ALL_SA_GROUP_HIERARCHY BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.ALL_SA_GROUP_HIERARCHY BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT SELECT ON LBACSYS.ALL_SA_GROUP_HIERARCHY BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.ALL_SA_LABELS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.ALL_SA_LABELS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT RENAME ON LBACSYS.ALL_SA_LABELS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT RENAME ON LBACSYS.ALL_SA_LABELS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT INSERT ON LBACSYS.ALL_SA_LABELS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT INSERT ON LBACSYS.ALL_SA_LABELS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.ALL_SA_LABELS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.ALL_SA_LABELS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT DELETE ON LBACSYS.ALL_SA_LABELS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT DELETE ON LBACSYS.ALL_SA_LABELS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.ALL_SA_LABELS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.ALL_SA_LABELS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.ALL_SA_LABELS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.ALL_SA_LABELS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT SELECT ON LBACSYS.ALL_SA_LABELS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.ALL_SA_LEVELS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.ALL_SA_LEVELS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT RENAME ON LBACSYS.ALL_SA_LEVELS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT RENAME ON LBACSYS.ALL_SA_LEVELS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT INSERT ON LBACSYS.ALL_SA_LEVELS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT INSERT ON LBACSYS.ALL_SA_LEVELS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.ALL_SA_LEVELS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.ALL_SA_LEVELS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT DELETE ON LBACSYS.ALL_SA_LEVELS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT DELETE ON LBACSYS.ALL_SA_LEVELS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.ALL_SA_LEVELS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.ALL_SA_LEVELS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.ALL_SA_LEVELS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.ALL_SA_LEVELS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT SELECT ON LBACSYS.ALL_SA_LEVELS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.ALL_SA_POLICIES BY ACCESS WHENEVER SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.ALL_SA_POLICIES BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT RENAME ON LBACSYS.ALL_SA_POLICIES BY ACCESS WHENEVER SUCCESSFUL;
AUDIT RENAME ON LBACSYS.ALL_SA_POLICIES BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT INSERT ON LBACSYS.ALL_SA_POLICIES BY ACCESS WHENEVER SUCCESSFUL;
AUDIT INSERT ON LBACSYS.ALL_SA_POLICIES BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.ALL_SA_POLICIES BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.ALL_SA_POLICIES BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT DELETE ON LBACSYS.ALL_SA_POLICIES BY ACCESS WHENEVER SUCCESSFUL;
AUDIT DELETE ON LBACSYS.ALL_SA_POLICIES BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.ALL_SA_POLICIES BY ACCESS WHENEVER SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.ALL_SA_POLICIES BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.ALL_SA_POLICIES BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.ALL_SA_POLICIES BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT SELECT ON LBACSYS.ALL_SA_POLICIES BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.ALL_SA_PROGRAMS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.ALL_SA_PROGRAMS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT RENAME ON LBACSYS.ALL_SA_PROGRAMS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT RENAME ON LBACSYS.ALL_SA_PROGRAMS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT INSERT ON LBACSYS.ALL_SA_PROGRAMS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT INSERT ON LBACSYS.ALL_SA_PROGRAMS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.ALL_SA_PROGRAMS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.ALL_SA_PROGRAMS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT DELETE ON LBACSYS.ALL_SA_PROGRAMS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT DELETE ON LBACSYS.ALL_SA_PROGRAMS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.ALL_SA_PROGRAMS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.ALL_SA_PROGRAMS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.ALL_SA_PROGRAMS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.ALL_SA_PROGRAMS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT SELECT ON LBACSYS.ALL_SA_PROGRAMS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.ALL_SA_PROG_PRIVS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.ALL_SA_PROG_PRIVS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT RENAME ON LBACSYS.ALL_SA_PROG_PRIVS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT RENAME ON LBACSYS.ALL_SA_PROG_PRIVS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT INSERT ON LBACSYS.ALL_SA_PROG_PRIVS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT INSERT ON LBACSYS.ALL_SA_PROG_PRIVS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.ALL_SA_PROG_PRIVS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.ALL_SA_PROG_PRIVS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT DELETE ON LBACSYS.ALL_SA_PROG_PRIVS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT DELETE ON LBACSYS.ALL_SA_PROG_PRIVS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.ALL_SA_PROG_PRIVS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.ALL_SA_PROG_PRIVS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.ALL_SA_PROG_PRIVS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.ALL_SA_PROG_PRIVS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT SELECT ON LBACSYS.ALL_SA_PROG_PRIVS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.ALL_SA_SCHEMA_POLICIES BY ACCESS WHENEVER SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.ALL_SA_SCHEMA_POLICIES BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT RENAME ON LBACSYS.ALL_SA_SCHEMA_POLICIES BY ACCESS WHENEVER SUCCESSFUL;
AUDIT RENAME ON LBACSYS.ALL_SA_SCHEMA_POLICIES BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT INSERT ON LBACSYS.ALL_SA_SCHEMA_POLICIES BY ACCESS WHENEVER SUCCESSFUL;
AUDIT INSERT ON LBACSYS.ALL_SA_SCHEMA_POLICIES BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.ALL_SA_SCHEMA_POLICIES BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.ALL_SA_SCHEMA_POLICIES BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT DELETE ON LBACSYS.ALL_SA_SCHEMA_POLICIES BY ACCESS WHENEVER SUCCESSFUL;
AUDIT DELETE ON LBACSYS.ALL_SA_SCHEMA_POLICIES BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.ALL_SA_SCHEMA_POLICIES BY ACCESS WHENEVER SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.ALL_SA_SCHEMA_POLICIES BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.ALL_SA_SCHEMA_POLICIES BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.ALL_SA_SCHEMA_POLICIES BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT SELECT ON LBACSYS.ALL_SA_SCHEMA_POLICIES BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.ALL_SA_TABLE_POLICIES BY ACCESS WHENEVER SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.ALL_SA_TABLE_POLICIES BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT RENAME ON LBACSYS.ALL_SA_TABLE_POLICIES BY ACCESS WHENEVER SUCCESSFUL;
AUDIT RENAME ON LBACSYS.ALL_SA_TABLE_POLICIES BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT INSERT ON LBACSYS.ALL_SA_TABLE_POLICIES BY ACCESS WHENEVER SUCCESSFUL;
AUDIT INSERT ON LBACSYS.ALL_SA_TABLE_POLICIES BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.ALL_SA_TABLE_POLICIES BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.ALL_SA_TABLE_POLICIES BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT DELETE ON LBACSYS.ALL_SA_TABLE_POLICIES BY ACCESS WHENEVER SUCCESSFUL;
AUDIT DELETE ON LBACSYS.ALL_SA_TABLE_POLICIES BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.ALL_SA_TABLE_POLICIES BY ACCESS WHENEVER SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.ALL_SA_TABLE_POLICIES BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.ALL_SA_TABLE_POLICIES BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.ALL_SA_TABLE_POLICIES BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT SELECT ON LBACSYS.ALL_SA_TABLE_POLICIES BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.ALL_SA_USERS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.ALL_SA_USERS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT RENAME ON LBACSYS.ALL_SA_USERS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT RENAME ON LBACSYS.ALL_SA_USERS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT INSERT ON LBACSYS.ALL_SA_USERS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT INSERT ON LBACSYS.ALL_SA_USERS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.ALL_SA_USERS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.ALL_SA_USERS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT DELETE ON LBACSYS.ALL_SA_USERS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT DELETE ON LBACSYS.ALL_SA_USERS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.ALL_SA_USERS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.ALL_SA_USERS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.ALL_SA_USERS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.ALL_SA_USERS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT SELECT ON LBACSYS.ALL_SA_USERS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.ALL_SA_USER_COMPARTMENTS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.ALL_SA_USER_COMPARTMENTS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT RENAME ON LBACSYS.ALL_SA_USER_COMPARTMENTS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT RENAME ON LBACSYS.ALL_SA_USER_COMPARTMENTS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT INSERT ON LBACSYS.ALL_SA_USER_COMPARTMENTS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT INSERT ON LBACSYS.ALL_SA_USER_COMPARTMENTS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.ALL_SA_USER_COMPARTMENTS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.ALL_SA_USER_COMPARTMENTS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT DELETE ON LBACSYS.ALL_SA_USER_COMPARTMENTS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT DELETE ON LBACSYS.ALL_SA_USER_COMPARTMENTS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.ALL_SA_USER_COMPARTMENTS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.ALL_SA_USER_COMPARTMENTS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.ALL_SA_USER_COMPARTMENTS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.ALL_SA_USER_COMPARTMENTS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT SELECT ON LBACSYS.ALL_SA_USER_COMPARTMENTS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.ALL_SA_USER_GROUPS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.ALL_SA_USER_GROUPS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT RENAME ON LBACSYS.ALL_SA_USER_GROUPS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT RENAME ON LBACSYS.ALL_SA_USER_GROUPS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT INSERT ON LBACSYS.ALL_SA_USER_GROUPS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT INSERT ON LBACSYS.ALL_SA_USER_GROUPS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.ALL_SA_USER_GROUPS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.ALL_SA_USER_GROUPS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT DELETE ON LBACSYS.ALL_SA_USER_GROUPS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT DELETE ON LBACSYS.ALL_SA_USER_GROUPS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.ALL_SA_USER_GROUPS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.ALL_SA_USER_GROUPS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.ALL_SA_USER_GROUPS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.ALL_SA_USER_GROUPS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT SELECT ON LBACSYS.ALL_SA_USER_GROUPS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.ALL_SA_USER_LABELS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.ALL_SA_USER_LABELS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT RENAME ON LBACSYS.ALL_SA_USER_LABELS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT RENAME ON LBACSYS.ALL_SA_USER_LABELS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT INSERT ON LBACSYS.ALL_SA_USER_LABELS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT INSERT ON LBACSYS.ALL_SA_USER_LABELS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.ALL_SA_USER_LABELS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.ALL_SA_USER_LABELS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT DELETE ON LBACSYS.ALL_SA_USER_LABELS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT DELETE ON LBACSYS.ALL_SA_USER_LABELS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.ALL_SA_USER_LABELS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.ALL_SA_USER_LABELS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.ALL_SA_USER_LABELS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.ALL_SA_USER_LABELS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT SELECT ON LBACSYS.ALL_SA_USER_LABELS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.ALL_SA_USER_LEVELS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.ALL_SA_USER_LEVELS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT RENAME ON LBACSYS.ALL_SA_USER_LEVELS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT RENAME ON LBACSYS.ALL_SA_USER_LEVELS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT INSERT ON LBACSYS.ALL_SA_USER_LEVELS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT INSERT ON LBACSYS.ALL_SA_USER_LEVELS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.ALL_SA_USER_LEVELS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.ALL_SA_USER_LEVELS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT DELETE ON LBACSYS.ALL_SA_USER_LEVELS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT DELETE ON LBACSYS.ALL_SA_USER_LEVELS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.ALL_SA_USER_LEVELS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.ALL_SA_USER_LEVELS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.ALL_SA_USER_LEVELS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.ALL_SA_USER_LEVELS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT SELECT ON LBACSYS.ALL_SA_USER_LEVELS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.ALL_SA_USER_PRIVS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.ALL_SA_USER_PRIVS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT RENAME ON LBACSYS.ALL_SA_USER_PRIVS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT RENAME ON LBACSYS.ALL_SA_USER_PRIVS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT INSERT ON LBACSYS.ALL_SA_USER_PRIVS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT INSERT ON LBACSYS.ALL_SA_USER_PRIVS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.ALL_SA_USER_PRIVS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.ALL_SA_USER_PRIVS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT DELETE ON LBACSYS.ALL_SA_USER_PRIVS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT DELETE ON LBACSYS.ALL_SA_USER_PRIVS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.ALL_SA_USER_PRIVS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.ALL_SA_USER_PRIVS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.ALL_SA_USER_PRIVS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.ALL_SA_USER_PRIVS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT SELECT ON LBACSYS.ALL_SA_USER_PRIVS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.DBA_LBAC_AUDIT_OPTIONS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.DBA_LBAC_AUDIT_OPTIONS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT RENAME ON LBACSYS.DBA_LBAC_AUDIT_OPTIONS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT RENAME ON LBACSYS.DBA_LBAC_AUDIT_OPTIONS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT INSERT ON LBACSYS.DBA_LBAC_AUDIT_OPTIONS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT INSERT ON LBACSYS.DBA_LBAC_AUDIT_OPTIONS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.DBA_LBAC_AUDIT_OPTIONS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.DBA_LBAC_AUDIT_OPTIONS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT DELETE ON LBACSYS.DBA_LBAC_AUDIT_OPTIONS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT DELETE ON LBACSYS.DBA_LBAC_AUDIT_OPTIONS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.DBA_LBAC_AUDIT_OPTIONS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.DBA_LBAC_AUDIT_OPTIONS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.DBA_LBAC_AUDIT_OPTIONS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.DBA_LBAC_AUDIT_OPTIONS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT SELECT ON LBACSYS.DBA_LBAC_AUDIT_OPTIONS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.DBA_LBAC_DATA_LABELS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.DBA_LBAC_DATA_LABELS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT RENAME ON LBACSYS.DBA_LBAC_DATA_LABELS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT RENAME ON LBACSYS.DBA_LBAC_DATA_LABELS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT INSERT ON LBACSYS.DBA_LBAC_DATA_LABELS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT INSERT ON LBACSYS.DBA_LBAC_DATA_LABELS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.DBA_LBAC_DATA_LABELS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.DBA_LBAC_DATA_LABELS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT DELETE ON LBACSYS.DBA_LBAC_DATA_LABELS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT DELETE ON LBACSYS.DBA_LBAC_DATA_LABELS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.DBA_LBAC_DATA_LABELS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.DBA_LBAC_DATA_LABELS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.DBA_LBAC_DATA_LABELS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.DBA_LBAC_DATA_LABELS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT SELECT ON LBACSYS.DBA_LBAC_DATA_LABELS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.DBA_LBAC_LABELS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.DBA_LBAC_LABELS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT RENAME ON LBACSYS.DBA_LBAC_LABELS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT RENAME ON LBACSYS.DBA_LBAC_LABELS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT INSERT ON LBACSYS.DBA_LBAC_LABELS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT INSERT ON LBACSYS.DBA_LBAC_LABELS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.DBA_LBAC_LABELS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.DBA_LBAC_LABELS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT DELETE ON LBACSYS.DBA_LBAC_LABELS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT DELETE ON LBACSYS.DBA_LBAC_LABELS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.DBA_LBAC_LABELS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.DBA_LBAC_LABELS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.DBA_LBAC_LABELS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.DBA_LBAC_LABELS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT SELECT ON LBACSYS.DBA_LBAC_LABELS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.DBA_LBAC_LABEL_TAGS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.DBA_LBAC_LABEL_TAGS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT RENAME ON LBACSYS.DBA_LBAC_LABEL_TAGS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT RENAME ON LBACSYS.DBA_LBAC_LABEL_TAGS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT INSERT ON LBACSYS.DBA_LBAC_LABEL_TAGS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT INSERT ON LBACSYS.DBA_LBAC_LABEL_TAGS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.DBA_LBAC_LABEL_TAGS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.DBA_LBAC_LABEL_TAGS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT DELETE ON LBACSYS.DBA_LBAC_LABEL_TAGS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT DELETE ON LBACSYS.DBA_LBAC_LABEL_TAGS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.DBA_LBAC_LABEL_TAGS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.DBA_LBAC_LABEL_TAGS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.DBA_LBAC_LABEL_TAGS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.DBA_LBAC_LABEL_TAGS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT SELECT ON LBACSYS.DBA_LBAC_LABEL_TAGS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.DBA_LBAC_POLICIES BY ACCESS WHENEVER SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.DBA_LBAC_POLICIES BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT RENAME ON LBACSYS.DBA_LBAC_POLICIES BY ACCESS WHENEVER SUCCESSFUL;
AUDIT RENAME ON LBACSYS.DBA_LBAC_POLICIES BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT INSERT ON LBACSYS.DBA_LBAC_POLICIES BY ACCESS WHENEVER SUCCESSFUL;
AUDIT INSERT ON LBACSYS.DBA_LBAC_POLICIES BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.DBA_LBAC_POLICIES BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.DBA_LBAC_POLICIES BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT DELETE ON LBACSYS.DBA_LBAC_POLICIES BY ACCESS WHENEVER SUCCESSFUL;
AUDIT DELETE ON LBACSYS.DBA_LBAC_POLICIES BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.DBA_LBAC_POLICIES BY ACCESS WHENEVER SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.DBA_LBAC_POLICIES BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.DBA_LBAC_POLICIES BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.DBA_LBAC_POLICIES BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT SELECT ON LBACSYS.DBA_LBAC_POLICIES BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.DBA_LBAC_PROGRAMS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.DBA_LBAC_PROGRAMS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT RENAME ON LBACSYS.DBA_LBAC_PROGRAMS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT RENAME ON LBACSYS.DBA_LBAC_PROGRAMS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT INSERT ON LBACSYS.DBA_LBAC_PROGRAMS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT INSERT ON LBACSYS.DBA_LBAC_PROGRAMS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.DBA_LBAC_PROGRAMS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.DBA_LBAC_PROGRAMS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT DELETE ON LBACSYS.DBA_LBAC_PROGRAMS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT DELETE ON LBACSYS.DBA_LBAC_PROGRAMS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.DBA_LBAC_PROGRAMS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.DBA_LBAC_PROGRAMS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.DBA_LBAC_PROGRAMS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.DBA_LBAC_PROGRAMS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT SELECT ON LBACSYS.DBA_LBAC_PROGRAMS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.DBA_LBAC_PROG_LABELS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.DBA_LBAC_PROG_LABELS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT RENAME ON LBACSYS.DBA_LBAC_PROG_LABELS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT RENAME ON LBACSYS.DBA_LBAC_PROG_LABELS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT INSERT ON LBACSYS.DBA_LBAC_PROG_LABELS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT INSERT ON LBACSYS.DBA_LBAC_PROG_LABELS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.DBA_LBAC_PROG_LABELS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.DBA_LBAC_PROG_LABELS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT DELETE ON LBACSYS.DBA_LBAC_PROG_LABELS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT DELETE ON LBACSYS.DBA_LBAC_PROG_LABELS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.DBA_LBAC_PROG_LABELS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.DBA_LBAC_PROG_LABELS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.DBA_LBAC_PROG_LABELS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.DBA_LBAC_PROG_LABELS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT SELECT ON LBACSYS.DBA_LBAC_PROG_LABELS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.DBA_LBAC_PROG_PRIVS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.DBA_LBAC_PROG_PRIVS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT RENAME ON LBACSYS.DBA_LBAC_PROG_PRIVS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT RENAME ON LBACSYS.DBA_LBAC_PROG_PRIVS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT INSERT ON LBACSYS.DBA_LBAC_PROG_PRIVS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT INSERT ON LBACSYS.DBA_LBAC_PROG_PRIVS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.DBA_LBAC_PROG_PRIVS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.DBA_LBAC_PROG_PRIVS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT DELETE ON LBACSYS.DBA_LBAC_PROG_PRIVS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT DELETE ON LBACSYS.DBA_LBAC_PROG_PRIVS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.DBA_LBAC_PROG_PRIVS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.DBA_LBAC_PROG_PRIVS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.DBA_LBAC_PROG_PRIVS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.DBA_LBAC_PROG_PRIVS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT SELECT ON LBACSYS.DBA_LBAC_PROG_PRIVS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.DBA_LBAC_SCHEMA_POLICIES BY ACCESS WHENEVER SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.DBA_LBAC_SCHEMA_POLICIES BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT RENAME ON LBACSYS.DBA_LBAC_SCHEMA_POLICIES BY ACCESS WHENEVER SUCCESSFUL;
AUDIT RENAME ON LBACSYS.DBA_LBAC_SCHEMA_POLICIES BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT INSERT ON LBACSYS.DBA_LBAC_SCHEMA_POLICIES BY ACCESS WHENEVER SUCCESSFUL;
AUDIT INSERT ON LBACSYS.DBA_LBAC_SCHEMA_POLICIES BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.DBA_LBAC_SCHEMA_POLICIES BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.DBA_LBAC_SCHEMA_POLICIES BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT DELETE ON LBACSYS.DBA_LBAC_SCHEMA_POLICIES BY ACCESS WHENEVER SUCCESSFUL;
AUDIT DELETE ON LBACSYS.DBA_LBAC_SCHEMA_POLICIES BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.DBA_LBAC_SCHEMA_POLICIES BY ACCESS WHENEVER SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.DBA_LBAC_SCHEMA_POLICIES BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.DBA_LBAC_SCHEMA_POLICIES BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.DBA_LBAC_SCHEMA_POLICIES BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT SELECT ON LBACSYS.DBA_LBAC_SCHEMA_POLICIES BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.DBA_LBAC_TABLE_POLICIES BY ACCESS WHENEVER SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.DBA_LBAC_TABLE_POLICIES BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT RENAME ON LBACSYS.DBA_LBAC_TABLE_POLICIES BY ACCESS WHENEVER SUCCESSFUL;
AUDIT RENAME ON LBACSYS.DBA_LBAC_TABLE_POLICIES BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT INSERT ON LBACSYS.DBA_LBAC_TABLE_POLICIES BY ACCESS WHENEVER SUCCESSFUL;
AUDIT INSERT ON LBACSYS.DBA_LBAC_TABLE_POLICIES BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.DBA_LBAC_TABLE_POLICIES BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.DBA_LBAC_TABLE_POLICIES BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT DELETE ON LBACSYS.DBA_LBAC_TABLE_POLICIES BY ACCESS WHENEVER SUCCESSFUL;
AUDIT DELETE ON LBACSYS.DBA_LBAC_TABLE_POLICIES BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.DBA_LBAC_TABLE_POLICIES BY ACCESS WHENEVER SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.DBA_LBAC_TABLE_POLICIES BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.DBA_LBAC_TABLE_POLICIES BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.DBA_LBAC_TABLE_POLICIES BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT SELECT ON LBACSYS.DBA_LBAC_TABLE_POLICIES BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.DBA_LBAC_USERS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.DBA_LBAC_USERS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT RENAME ON LBACSYS.DBA_LBAC_USERS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT RENAME ON LBACSYS.DBA_LBAC_USERS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT INSERT ON LBACSYS.DBA_LBAC_USERS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT INSERT ON LBACSYS.DBA_LBAC_USERS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.DBA_LBAC_USERS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.DBA_LBAC_USERS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT DELETE ON LBACSYS.DBA_LBAC_USERS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT DELETE ON LBACSYS.DBA_LBAC_USERS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.DBA_LBAC_USERS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.DBA_LBAC_USERS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.DBA_LBAC_USERS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.DBA_LBAC_USERS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT SELECT ON LBACSYS.DBA_LBAC_USERS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.DBA_LBAC_USER_LABELS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.DBA_LBAC_USER_LABELS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT RENAME ON LBACSYS.DBA_LBAC_USER_LABELS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT RENAME ON LBACSYS.DBA_LBAC_USER_LABELS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT INSERT ON LBACSYS.DBA_LBAC_USER_LABELS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT INSERT ON LBACSYS.DBA_LBAC_USER_LABELS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.DBA_LBAC_USER_LABELS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.DBA_LBAC_USER_LABELS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT DELETE ON LBACSYS.DBA_LBAC_USER_LABELS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT DELETE ON LBACSYS.DBA_LBAC_USER_LABELS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.DBA_LBAC_USER_LABELS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.DBA_LBAC_USER_LABELS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.DBA_LBAC_USER_LABELS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.DBA_LBAC_USER_LABELS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT SELECT ON LBACSYS.DBA_LBAC_USER_LABELS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.DBA_LBAC_USER_PRIVS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.DBA_LBAC_USER_PRIVS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT RENAME ON LBACSYS.DBA_LBAC_USER_PRIVS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT RENAME ON LBACSYS.DBA_LBAC_USER_PRIVS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT INSERT ON LBACSYS.DBA_LBAC_USER_PRIVS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT INSERT ON LBACSYS.DBA_LBAC_USER_PRIVS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.DBA_LBAC_USER_PRIVS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.DBA_LBAC_USER_PRIVS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT DELETE ON LBACSYS.DBA_LBAC_USER_PRIVS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT DELETE ON LBACSYS.DBA_LBAC_USER_PRIVS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.DBA_LBAC_USER_PRIVS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.DBA_LBAC_USER_PRIVS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.DBA_LBAC_USER_PRIVS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.DBA_LBAC_USER_PRIVS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT SELECT ON LBACSYS.DBA_LBAC_USER_PRIVS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.DBA_SA_AUDIT_OPTIONS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.DBA_SA_AUDIT_OPTIONS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT RENAME ON LBACSYS.DBA_SA_AUDIT_OPTIONS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT RENAME ON LBACSYS.DBA_SA_AUDIT_OPTIONS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT INSERT ON LBACSYS.DBA_SA_AUDIT_OPTIONS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT INSERT ON LBACSYS.DBA_SA_AUDIT_OPTIONS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.DBA_SA_AUDIT_OPTIONS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.DBA_SA_AUDIT_OPTIONS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT DELETE ON LBACSYS.DBA_SA_AUDIT_OPTIONS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT DELETE ON LBACSYS.DBA_SA_AUDIT_OPTIONS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.DBA_SA_AUDIT_OPTIONS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.DBA_SA_AUDIT_OPTIONS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.DBA_SA_AUDIT_OPTIONS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.DBA_SA_AUDIT_OPTIONS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT SELECT ON LBACSYS.DBA_SA_AUDIT_OPTIONS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.DBA_SA_COMPARTMENTS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.DBA_SA_COMPARTMENTS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT RENAME ON LBACSYS.DBA_SA_COMPARTMENTS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT RENAME ON LBACSYS.DBA_SA_COMPARTMENTS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT INSERT ON LBACSYS.DBA_SA_COMPARTMENTS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT INSERT ON LBACSYS.DBA_SA_COMPARTMENTS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.DBA_SA_COMPARTMENTS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.DBA_SA_COMPARTMENTS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT DELETE ON LBACSYS.DBA_SA_COMPARTMENTS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT DELETE ON LBACSYS.DBA_SA_COMPARTMENTS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.DBA_SA_COMPARTMENTS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.DBA_SA_COMPARTMENTS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.DBA_SA_COMPARTMENTS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.DBA_SA_COMPARTMENTS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT SELECT ON LBACSYS.DBA_SA_COMPARTMENTS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.DBA_SA_DATA_LABELS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.DBA_SA_DATA_LABELS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT RENAME ON LBACSYS.DBA_SA_DATA_LABELS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT RENAME ON LBACSYS.DBA_SA_DATA_LABELS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT INSERT ON LBACSYS.DBA_SA_DATA_LABELS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT INSERT ON LBACSYS.DBA_SA_DATA_LABELS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.DBA_SA_DATA_LABELS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.DBA_SA_DATA_LABELS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT DELETE ON LBACSYS.DBA_SA_DATA_LABELS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT DELETE ON LBACSYS.DBA_SA_DATA_LABELS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.DBA_SA_DATA_LABELS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.DBA_SA_DATA_LABELS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.DBA_SA_DATA_LABELS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.DBA_SA_DATA_LABELS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT SELECT ON LBACSYS.DBA_SA_DATA_LABELS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.DBA_SA_GROUPS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.DBA_SA_GROUPS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT RENAME ON LBACSYS.DBA_SA_GROUPS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT RENAME ON LBACSYS.DBA_SA_GROUPS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT INSERT ON LBACSYS.DBA_SA_GROUPS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT INSERT ON LBACSYS.DBA_SA_GROUPS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.DBA_SA_GROUPS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.DBA_SA_GROUPS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT DELETE ON LBACSYS.DBA_SA_GROUPS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT DELETE ON LBACSYS.DBA_SA_GROUPS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.DBA_SA_GROUPS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.DBA_SA_GROUPS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.DBA_SA_GROUPS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.DBA_SA_GROUPS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT SELECT ON LBACSYS.DBA_SA_GROUPS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.DBA_SA_GROUP_HIERARCHY BY ACCESS WHENEVER SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.DBA_SA_GROUP_HIERARCHY BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT RENAME ON LBACSYS.DBA_SA_GROUP_HIERARCHY BY ACCESS WHENEVER SUCCESSFUL;
AUDIT RENAME ON LBACSYS.DBA_SA_GROUP_HIERARCHY BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT INSERT ON LBACSYS.DBA_SA_GROUP_HIERARCHY BY ACCESS WHENEVER SUCCESSFUL;
AUDIT INSERT ON LBACSYS.DBA_SA_GROUP_HIERARCHY BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.DBA_SA_GROUP_HIERARCHY BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.DBA_SA_GROUP_HIERARCHY BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT DELETE ON LBACSYS.DBA_SA_GROUP_HIERARCHY BY ACCESS WHENEVER SUCCESSFUL;
AUDIT DELETE ON LBACSYS.DBA_SA_GROUP_HIERARCHY BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.DBA_SA_GROUP_HIERARCHY BY ACCESS WHENEVER SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.DBA_SA_GROUP_HIERARCHY BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.DBA_SA_GROUP_HIERARCHY BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.DBA_SA_GROUP_HIERARCHY BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT SELECT ON LBACSYS.DBA_SA_GROUP_HIERARCHY BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.DBA_SA_LABELS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.DBA_SA_LABELS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT RENAME ON LBACSYS.DBA_SA_LABELS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT RENAME ON LBACSYS.DBA_SA_LABELS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT INSERT ON LBACSYS.DBA_SA_LABELS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT INSERT ON LBACSYS.DBA_SA_LABELS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.DBA_SA_LABELS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.DBA_SA_LABELS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT DELETE ON LBACSYS.DBA_SA_LABELS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT DELETE ON LBACSYS.DBA_SA_LABELS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.DBA_SA_LABELS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.DBA_SA_LABELS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.DBA_SA_LABELS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.DBA_SA_LABELS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT SELECT ON LBACSYS.DBA_SA_LABELS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.DBA_SA_LEVELS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.DBA_SA_LEVELS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT RENAME ON LBACSYS.DBA_SA_LEVELS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT RENAME ON LBACSYS.DBA_SA_LEVELS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT INSERT ON LBACSYS.DBA_SA_LEVELS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT INSERT ON LBACSYS.DBA_SA_LEVELS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.DBA_SA_LEVELS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.DBA_SA_LEVELS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT DELETE ON LBACSYS.DBA_SA_LEVELS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT DELETE ON LBACSYS.DBA_SA_LEVELS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.DBA_SA_LEVELS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.DBA_SA_LEVELS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.DBA_SA_LEVELS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.DBA_SA_LEVELS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT SELECT ON LBACSYS.DBA_SA_LEVELS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.DBA_SA_POLICIES BY ACCESS WHENEVER SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.DBA_SA_POLICIES BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT RENAME ON LBACSYS.DBA_SA_POLICIES BY ACCESS WHENEVER SUCCESSFUL;
AUDIT RENAME ON LBACSYS.DBA_SA_POLICIES BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT INSERT ON LBACSYS.DBA_SA_POLICIES BY ACCESS WHENEVER SUCCESSFUL;
AUDIT INSERT ON LBACSYS.DBA_SA_POLICIES BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.DBA_SA_POLICIES BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.DBA_SA_POLICIES BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT DELETE ON LBACSYS.DBA_SA_POLICIES BY ACCESS WHENEVER SUCCESSFUL;
AUDIT DELETE ON LBACSYS.DBA_SA_POLICIES BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.DBA_SA_POLICIES BY ACCESS WHENEVER SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.DBA_SA_POLICIES BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.DBA_SA_POLICIES BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.DBA_SA_POLICIES BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT SELECT ON LBACSYS.DBA_SA_POLICIES BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.DBA_SA_PROGRAMS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.DBA_SA_PROGRAMS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT RENAME ON LBACSYS.DBA_SA_PROGRAMS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT RENAME ON LBACSYS.DBA_SA_PROGRAMS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT INSERT ON LBACSYS.DBA_SA_PROGRAMS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT INSERT ON LBACSYS.DBA_SA_PROGRAMS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.DBA_SA_PROGRAMS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.DBA_SA_PROGRAMS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT DELETE ON LBACSYS.DBA_SA_PROGRAMS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT DELETE ON LBACSYS.DBA_SA_PROGRAMS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.DBA_SA_PROGRAMS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.DBA_SA_PROGRAMS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.DBA_SA_PROGRAMS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.DBA_SA_PROGRAMS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT SELECT ON LBACSYS.DBA_SA_PROGRAMS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.DBA_SA_PROG_PRIVS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.DBA_SA_PROG_PRIVS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT RENAME ON LBACSYS.DBA_SA_PROG_PRIVS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT RENAME ON LBACSYS.DBA_SA_PROG_PRIVS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT INSERT ON LBACSYS.DBA_SA_PROG_PRIVS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT INSERT ON LBACSYS.DBA_SA_PROG_PRIVS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.DBA_SA_PROG_PRIVS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.DBA_SA_PROG_PRIVS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT DELETE ON LBACSYS.DBA_SA_PROG_PRIVS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT DELETE ON LBACSYS.DBA_SA_PROG_PRIVS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.DBA_SA_PROG_PRIVS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.DBA_SA_PROG_PRIVS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.DBA_SA_PROG_PRIVS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.DBA_SA_PROG_PRIVS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT SELECT ON LBACSYS.DBA_SA_PROG_PRIVS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.DBA_SA_SCHEMA_POLICIES BY ACCESS WHENEVER SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.DBA_SA_SCHEMA_POLICIES BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT RENAME ON LBACSYS.DBA_SA_SCHEMA_POLICIES BY ACCESS WHENEVER SUCCESSFUL;
AUDIT RENAME ON LBACSYS.DBA_SA_SCHEMA_POLICIES BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT INSERT ON LBACSYS.DBA_SA_SCHEMA_POLICIES BY ACCESS WHENEVER SUCCESSFUL;
AUDIT INSERT ON LBACSYS.DBA_SA_SCHEMA_POLICIES BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.DBA_SA_SCHEMA_POLICIES BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.DBA_SA_SCHEMA_POLICIES BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT DELETE ON LBACSYS.DBA_SA_SCHEMA_POLICIES BY ACCESS WHENEVER SUCCESSFUL;
AUDIT DELETE ON LBACSYS.DBA_SA_SCHEMA_POLICIES BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.DBA_SA_SCHEMA_POLICIES BY ACCESS WHENEVER SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.DBA_SA_SCHEMA_POLICIES BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.DBA_SA_SCHEMA_POLICIES BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.DBA_SA_SCHEMA_POLICIES BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT SELECT ON LBACSYS.DBA_SA_SCHEMA_POLICIES BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.DBA_SA_TABLE_POLICIES BY ACCESS WHENEVER SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.DBA_SA_TABLE_POLICIES BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT RENAME ON LBACSYS.DBA_SA_TABLE_POLICIES BY ACCESS WHENEVER SUCCESSFUL;
AUDIT RENAME ON LBACSYS.DBA_SA_TABLE_POLICIES BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT INSERT ON LBACSYS.DBA_SA_TABLE_POLICIES BY ACCESS WHENEVER SUCCESSFUL;
AUDIT INSERT ON LBACSYS.DBA_SA_TABLE_POLICIES BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.DBA_SA_TABLE_POLICIES BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.DBA_SA_TABLE_POLICIES BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT DELETE ON LBACSYS.DBA_SA_TABLE_POLICIES BY ACCESS WHENEVER SUCCESSFUL;
AUDIT DELETE ON LBACSYS.DBA_SA_TABLE_POLICIES BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.DBA_SA_TABLE_POLICIES BY ACCESS WHENEVER SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.DBA_SA_TABLE_POLICIES BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.DBA_SA_TABLE_POLICIES BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.DBA_SA_TABLE_POLICIES BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT SELECT ON LBACSYS.DBA_SA_TABLE_POLICIES BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.DBA_SA_USERS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.DBA_SA_USERS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT RENAME ON LBACSYS.DBA_SA_USERS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT RENAME ON LBACSYS.DBA_SA_USERS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT INSERT ON LBACSYS.DBA_SA_USERS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT INSERT ON LBACSYS.DBA_SA_USERS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.DBA_SA_USERS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.DBA_SA_USERS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT DELETE ON LBACSYS.DBA_SA_USERS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT DELETE ON LBACSYS.DBA_SA_USERS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.DBA_SA_USERS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.DBA_SA_USERS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.DBA_SA_USERS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.DBA_SA_USERS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT SELECT ON LBACSYS.DBA_SA_USERS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.DBA_SA_USER_COMPARTMENTS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.DBA_SA_USER_COMPARTMENTS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT RENAME ON LBACSYS.DBA_SA_USER_COMPARTMENTS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT RENAME ON LBACSYS.DBA_SA_USER_COMPARTMENTS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT INSERT ON LBACSYS.DBA_SA_USER_COMPARTMENTS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT INSERT ON LBACSYS.DBA_SA_USER_COMPARTMENTS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.DBA_SA_USER_COMPARTMENTS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.DBA_SA_USER_COMPARTMENTS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT DELETE ON LBACSYS.DBA_SA_USER_COMPARTMENTS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT DELETE ON LBACSYS.DBA_SA_USER_COMPARTMENTS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.DBA_SA_USER_COMPARTMENTS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.DBA_SA_USER_COMPARTMENTS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.DBA_SA_USER_COMPARTMENTS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.DBA_SA_USER_COMPARTMENTS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT SELECT ON LBACSYS.DBA_SA_USER_COMPARTMENTS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.DBA_SA_USER_GROUPS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.DBA_SA_USER_GROUPS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT RENAME ON LBACSYS.DBA_SA_USER_GROUPS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT RENAME ON LBACSYS.DBA_SA_USER_GROUPS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT INSERT ON LBACSYS.DBA_SA_USER_GROUPS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT INSERT ON LBACSYS.DBA_SA_USER_GROUPS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.DBA_SA_USER_GROUPS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.DBA_SA_USER_GROUPS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT DELETE ON LBACSYS.DBA_SA_USER_GROUPS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT DELETE ON LBACSYS.DBA_SA_USER_GROUPS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.DBA_SA_USER_GROUPS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.DBA_SA_USER_GROUPS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.DBA_SA_USER_GROUPS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.DBA_SA_USER_GROUPS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT SELECT ON LBACSYS.DBA_SA_USER_GROUPS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.DBA_SA_USER_LABELS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.DBA_SA_USER_LABELS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT RENAME ON LBACSYS.DBA_SA_USER_LABELS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT RENAME ON LBACSYS.DBA_SA_USER_LABELS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT INSERT ON LBACSYS.DBA_SA_USER_LABELS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT INSERT ON LBACSYS.DBA_SA_USER_LABELS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.DBA_SA_USER_LABELS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.DBA_SA_USER_LABELS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT DELETE ON LBACSYS.DBA_SA_USER_LABELS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT DELETE ON LBACSYS.DBA_SA_USER_LABELS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.DBA_SA_USER_LABELS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.DBA_SA_USER_LABELS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.DBA_SA_USER_LABELS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.DBA_SA_USER_LABELS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT SELECT ON LBACSYS.DBA_SA_USER_LABELS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.DBA_SA_USER_LEVELS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.DBA_SA_USER_LEVELS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT RENAME ON LBACSYS.DBA_SA_USER_LEVELS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT RENAME ON LBACSYS.DBA_SA_USER_LEVELS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT INSERT ON LBACSYS.DBA_SA_USER_LEVELS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT INSERT ON LBACSYS.DBA_SA_USER_LEVELS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.DBA_SA_USER_LEVELS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.DBA_SA_USER_LEVELS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT DELETE ON LBACSYS.DBA_SA_USER_LEVELS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT DELETE ON LBACSYS.DBA_SA_USER_LEVELS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.DBA_SA_USER_LEVELS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.DBA_SA_USER_LEVELS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.DBA_SA_USER_LEVELS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.DBA_SA_USER_LEVELS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT SELECT ON LBACSYS.DBA_SA_USER_LEVELS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.DBA_SA_USER_PRIVS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.DBA_SA_USER_PRIVS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT RENAME ON LBACSYS.DBA_SA_USER_PRIVS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT RENAME ON LBACSYS.DBA_SA_USER_PRIVS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT INSERT ON LBACSYS.DBA_SA_USER_PRIVS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT INSERT ON LBACSYS.DBA_SA_USER_PRIVS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.DBA_SA_USER_PRIVS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.DBA_SA_USER_PRIVS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT DELETE ON LBACSYS.DBA_SA_USER_PRIVS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT DELETE ON LBACSYS.DBA_SA_USER_PRIVS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.DBA_SA_USER_PRIVS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.DBA_SA_USER_PRIVS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.DBA_SA_USER_PRIVS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.DBA_SA_USER_PRIVS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT SELECT ON LBACSYS.DBA_SA_USER_PRIVS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.LBAC$ALL_TABLE_POLICIES BY ACCESS WHENEVER SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.LBAC$ALL_TABLE_POLICIES BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT RENAME ON LBACSYS.LBAC$ALL_TABLE_POLICIES BY ACCESS WHENEVER SUCCESSFUL;
AUDIT RENAME ON LBACSYS.LBAC$ALL_TABLE_POLICIES BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT INSERT ON LBACSYS.LBAC$ALL_TABLE_POLICIES BY ACCESS WHENEVER SUCCESSFUL;
AUDIT INSERT ON LBACSYS.LBAC$ALL_TABLE_POLICIES BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.LBAC$ALL_TABLE_POLICIES BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.LBAC$ALL_TABLE_POLICIES BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT DELETE ON LBACSYS.LBAC$ALL_TABLE_POLICIES BY ACCESS WHENEVER SUCCESSFUL;
AUDIT DELETE ON LBACSYS.LBAC$ALL_TABLE_POLICIES BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.LBAC$ALL_TABLE_POLICIES BY ACCESS WHENEVER SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.LBAC$ALL_TABLE_POLICIES BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.LBAC$ALL_TABLE_POLICIES BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.LBAC$ALL_TABLE_POLICIES BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT SELECT ON LBACSYS.LBAC$ALL_TABLE_POLICIES BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.LBAC$PACKAGE_FUNCTIONS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.LBAC$PACKAGE_FUNCTIONS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT RENAME ON LBACSYS.LBAC$PACKAGE_FUNCTIONS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT RENAME ON LBACSYS.LBAC$PACKAGE_FUNCTIONS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT INSERT ON LBACSYS.LBAC$PACKAGE_FUNCTIONS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT INSERT ON LBACSYS.LBAC$PACKAGE_FUNCTIONS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.LBAC$PACKAGE_FUNCTIONS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.LBAC$PACKAGE_FUNCTIONS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT DELETE ON LBACSYS.LBAC$PACKAGE_FUNCTIONS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT DELETE ON LBACSYS.LBAC$PACKAGE_FUNCTIONS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.LBAC$PACKAGE_FUNCTIONS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.LBAC$PACKAGE_FUNCTIONS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.LBAC$PACKAGE_FUNCTIONS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.LBAC$PACKAGE_FUNCTIONS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT SELECT ON LBACSYS.LBAC$PACKAGE_FUNCTIONS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.LBAC$POLICY_COLUMNS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.LBAC$POLICY_COLUMNS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT RENAME ON LBACSYS.LBAC$POLICY_COLUMNS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT RENAME ON LBACSYS.LBAC$POLICY_COLUMNS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT INSERT ON LBACSYS.LBAC$POLICY_COLUMNS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT INSERT ON LBACSYS.LBAC$POLICY_COLUMNS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.LBAC$POLICY_COLUMNS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.LBAC$POLICY_COLUMNS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT DELETE ON LBACSYS.LBAC$POLICY_COLUMNS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT DELETE ON LBACSYS.LBAC$POLICY_COLUMNS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.LBAC$POLICY_COLUMNS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.LBAC$POLICY_COLUMNS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.LBAC$POLICY_COLUMNS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.LBAC$POLICY_COLUMNS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT SELECT ON LBACSYS.LBAC$POLICY_COLUMNS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.LBAC$TRUSTED_PROGS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.LBAC$TRUSTED_PROGS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT RENAME ON LBACSYS.LBAC$TRUSTED_PROGS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT RENAME ON LBACSYS.LBAC$TRUSTED_PROGS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT INSERT ON LBACSYS.LBAC$TRUSTED_PROGS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT INSERT ON LBACSYS.LBAC$TRUSTED_PROGS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.LBAC$TRUSTED_PROGS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.LBAC$TRUSTED_PROGS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT DELETE ON LBACSYS.LBAC$TRUSTED_PROGS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT DELETE ON LBACSYS.LBAC$TRUSTED_PROGS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.LBAC$TRUSTED_PROGS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.LBAC$TRUSTED_PROGS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.LBAC$TRUSTED_PROGS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.LBAC$TRUSTED_PROGS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT SELECT ON LBACSYS.LBAC$TRUSTED_PROGS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.LBAC$USER_LOGON BY ACCESS WHENEVER SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.LBAC$USER_LOGON BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT RENAME ON LBACSYS.LBAC$USER_LOGON BY ACCESS WHENEVER SUCCESSFUL;
AUDIT RENAME ON LBACSYS.LBAC$USER_LOGON BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT INSERT ON LBACSYS.LBAC$USER_LOGON BY ACCESS WHENEVER SUCCESSFUL;
AUDIT INSERT ON LBACSYS.LBAC$USER_LOGON BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.LBAC$USER_LOGON BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.LBAC$USER_LOGON BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT DELETE ON LBACSYS.LBAC$USER_LOGON BY ACCESS WHENEVER SUCCESSFUL;
AUDIT DELETE ON LBACSYS.LBAC$USER_LOGON BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.LBAC$USER_LOGON BY ACCESS WHENEVER SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.LBAC$USER_LOGON BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.LBAC$USER_LOGON BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.LBAC$USER_LOGON BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT SELECT ON LBACSYS.LBAC$USER_LOGON BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.SA$ADMIN BY ACCESS WHENEVER SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.SA$ADMIN BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT RENAME ON LBACSYS.SA$ADMIN BY ACCESS WHENEVER SUCCESSFUL;
AUDIT RENAME ON LBACSYS.SA$ADMIN BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT INSERT ON LBACSYS.SA$ADMIN BY ACCESS WHENEVER SUCCESSFUL;
AUDIT INSERT ON LBACSYS.SA$ADMIN BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.SA$ADMIN BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.SA$ADMIN BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT DELETE ON LBACSYS.SA$ADMIN BY ACCESS WHENEVER SUCCESSFUL;
AUDIT DELETE ON LBACSYS.SA$ADMIN BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.SA$ADMIN BY ACCESS WHENEVER SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.SA$ADMIN BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.SA$ADMIN BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.SA$ADMIN BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT SELECT ON LBACSYS.SA$ADMIN BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.SA$POL BY ACCESS WHENEVER SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.SA$POL BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT RENAME ON LBACSYS.SA$POL BY ACCESS WHENEVER SUCCESSFUL;
AUDIT RENAME ON LBACSYS.SA$POL BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT INSERT ON LBACSYS.SA$POL BY ACCESS WHENEVER SUCCESSFUL;
AUDIT INSERT ON LBACSYS.SA$POL BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.SA$POL BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.SA$POL BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT DELETE ON LBACSYS.SA$POL BY ACCESS WHENEVER SUCCESSFUL;
AUDIT DELETE ON LBACSYS.SA$POL BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.SA$POL BY ACCESS WHENEVER SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.SA$POL BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.SA$POL BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.SA$POL BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT SELECT ON LBACSYS.SA$POL BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.USER_SA_SESSION BY ACCESS WHENEVER SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.USER_SA_SESSION BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT RENAME ON LBACSYS.USER_SA_SESSION BY ACCESS WHENEVER SUCCESSFUL;
AUDIT RENAME ON LBACSYS.USER_SA_SESSION BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT INSERT ON LBACSYS.USER_SA_SESSION BY ACCESS WHENEVER SUCCESSFUL;
AUDIT INSERT ON LBACSYS.USER_SA_SESSION BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.USER_SA_SESSION BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.USER_SA_SESSION BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT DELETE ON LBACSYS.USER_SA_SESSION BY ACCESS WHENEVER SUCCESSFUL;
AUDIT DELETE ON LBACSYS.USER_SA_SESSION BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.USER_SA_SESSION BY ACCESS WHENEVER SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.USER_SA_SESSION BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.USER_SA_SESSION BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.USER_SA_SESSION BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT SELECT ON LBACSYS.USER_SA_SESSION BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.LBAC$AUDIT BY ACCESS WHENEVER SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.LBAC$AUDIT BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT RENAME ON LBACSYS.LBAC$AUDIT BY ACCESS WHENEVER SUCCESSFUL;
AUDIT RENAME ON LBACSYS.LBAC$AUDIT BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT INSERT ON LBACSYS.LBAC$AUDIT BY ACCESS WHENEVER SUCCESSFUL;
AUDIT INSERT ON LBACSYS.LBAC$AUDIT BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT INDEX ON LBACSYS.LBAC$AUDIT BY ACCESS WHENEVER SUCCESSFUL;
AUDIT INDEX ON LBACSYS.LBAC$AUDIT BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.LBAC$AUDIT BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.LBAC$AUDIT BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT DELETE ON LBACSYS.LBAC$AUDIT BY ACCESS WHENEVER SUCCESSFUL;
AUDIT DELETE ON LBACSYS.LBAC$AUDIT BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.LBAC$AUDIT BY ACCESS WHENEVER SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.LBAC$AUDIT BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.LBAC$AUDIT BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.LBAC$AUDIT BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT ALTER ON LBACSYS.LBAC$AUDIT BY ACCESS WHENEVER SUCCESSFUL;
AUDIT ALTER ON LBACSYS.LBAC$AUDIT BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT SELECT ON LBACSYS.LBAC$AUDIT BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.LBAC$INSTALLATIONS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.LBAC$INSTALLATIONS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT RENAME ON LBACSYS.LBAC$INSTALLATIONS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT RENAME ON LBACSYS.LBAC$INSTALLATIONS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT INSERT ON LBACSYS.LBAC$INSTALLATIONS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT INSERT ON LBACSYS.LBAC$INSTALLATIONS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT INDEX ON LBACSYS.LBAC$INSTALLATIONS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT INDEX ON LBACSYS.LBAC$INSTALLATIONS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.LBAC$INSTALLATIONS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.LBAC$INSTALLATIONS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT DELETE ON LBACSYS.LBAC$INSTALLATIONS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT DELETE ON LBACSYS.LBAC$INSTALLATIONS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.LBAC$INSTALLATIONS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.LBAC$INSTALLATIONS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.LBAC$INSTALLATIONS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.LBAC$INSTALLATIONS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT ALTER ON LBACSYS.LBAC$INSTALLATIONS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT ALTER ON LBACSYS.LBAC$INSTALLATIONS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT SELECT ON LBACSYS.LBAC$INSTALLATIONS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.LBAC$LAB BY ACCESS WHENEVER SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.LBAC$LAB BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT RENAME ON LBACSYS.LBAC$LAB BY ACCESS WHENEVER SUCCESSFUL;
AUDIT RENAME ON LBACSYS.LBAC$LAB BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT INSERT ON LBACSYS.LBAC$LAB BY ACCESS WHENEVER SUCCESSFUL;
AUDIT INSERT ON LBACSYS.LBAC$LAB BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT INDEX ON LBACSYS.LBAC$LAB BY ACCESS WHENEVER SUCCESSFUL;
AUDIT INDEX ON LBACSYS.LBAC$LAB BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.LBAC$LAB BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.LBAC$LAB BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT DELETE ON LBACSYS.LBAC$LAB BY ACCESS WHENEVER SUCCESSFUL;
AUDIT DELETE ON LBACSYS.LBAC$LAB BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.LBAC$LAB BY ACCESS WHENEVER SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.LBAC$LAB BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.LBAC$LAB BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.LBAC$LAB BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT ALTER ON LBACSYS.LBAC$LAB BY ACCESS WHENEVER SUCCESSFUL;
AUDIT ALTER ON LBACSYS.LBAC$LAB BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT SELECT ON LBACSYS.LBAC$LAB BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.LBAC$POL BY ACCESS WHENEVER SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.LBAC$POL BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT RENAME ON LBACSYS.LBAC$POL BY ACCESS WHENEVER SUCCESSFUL;
AUDIT RENAME ON LBACSYS.LBAC$POL BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT INSERT ON LBACSYS.LBAC$POL BY ACCESS WHENEVER SUCCESSFUL;
AUDIT INSERT ON LBACSYS.LBAC$POL BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT INDEX ON LBACSYS.LBAC$POL BY ACCESS WHENEVER SUCCESSFUL;
AUDIT INDEX ON LBACSYS.LBAC$POL BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.LBAC$POL BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.LBAC$POL BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT DELETE ON LBACSYS.LBAC$POL BY ACCESS WHENEVER SUCCESSFUL;
AUDIT DELETE ON LBACSYS.LBAC$POL BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.LBAC$POL BY ACCESS WHENEVER SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.LBAC$POL BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.LBAC$POL BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.LBAC$POL BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT ALTER ON LBACSYS.LBAC$POL BY ACCESS WHENEVER SUCCESSFUL;
AUDIT ALTER ON LBACSYS.LBAC$POL BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT SELECT ON LBACSYS.LBAC$POL BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.LBAC$POLICY_ADMIN BY ACCESS WHENEVER SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.LBAC$POLICY_ADMIN BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT RENAME ON LBACSYS.LBAC$POLICY_ADMIN BY ACCESS WHENEVER SUCCESSFUL;
AUDIT RENAME ON LBACSYS.LBAC$POLICY_ADMIN BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT INSERT ON LBACSYS.LBAC$POLICY_ADMIN BY ACCESS WHENEVER SUCCESSFUL;
AUDIT INSERT ON LBACSYS.LBAC$POLICY_ADMIN BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT INDEX ON LBACSYS.LBAC$POLICY_ADMIN BY ACCESS WHENEVER SUCCESSFUL;
AUDIT INDEX ON LBACSYS.LBAC$POLICY_ADMIN BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.LBAC$POLICY_ADMIN BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.LBAC$POLICY_ADMIN BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT DELETE ON LBACSYS.LBAC$POLICY_ADMIN BY ACCESS WHENEVER SUCCESSFUL;
AUDIT DELETE ON LBACSYS.LBAC$POLICY_ADMIN BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.LBAC$POLICY_ADMIN BY ACCESS WHENEVER SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.LBAC$POLICY_ADMIN BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.LBAC$POLICY_ADMIN BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.LBAC$POLICY_ADMIN BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT ALTER ON LBACSYS.LBAC$POLICY_ADMIN BY ACCESS WHENEVER SUCCESSFUL;
AUDIT ALTER ON LBACSYS.LBAC$POLICY_ADMIN BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT SELECT ON LBACSYS.LBAC$POLICY_ADMIN BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.LBAC$POLS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.LBAC$POLS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT RENAME ON LBACSYS.LBAC$POLS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT RENAME ON LBACSYS.LBAC$POLS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT INSERT ON LBACSYS.LBAC$POLS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT INSERT ON LBACSYS.LBAC$POLS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT INDEX ON LBACSYS.LBAC$POLS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT INDEX ON LBACSYS.LBAC$POLS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.LBAC$POLS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.LBAC$POLS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT DELETE ON LBACSYS.LBAC$POLS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT DELETE ON LBACSYS.LBAC$POLS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.LBAC$POLS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.LBAC$POLS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.LBAC$POLS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.LBAC$POLS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT ALTER ON LBACSYS.LBAC$POLS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT ALTER ON LBACSYS.LBAC$POLS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT SELECT ON LBACSYS.LBAC$POLS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.LBAC$POLT BY ACCESS WHENEVER SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.LBAC$POLT BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT RENAME ON LBACSYS.LBAC$POLT BY ACCESS WHENEVER SUCCESSFUL;
AUDIT RENAME ON LBACSYS.LBAC$POLT BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT INSERT ON LBACSYS.LBAC$POLT BY ACCESS WHENEVER SUCCESSFUL;
AUDIT INSERT ON LBACSYS.LBAC$POLT BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT INDEX ON LBACSYS.LBAC$POLT BY ACCESS WHENEVER SUCCESSFUL;
AUDIT INDEX ON LBACSYS.LBAC$POLT BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.LBAC$POLT BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.LBAC$POLT BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT DELETE ON LBACSYS.LBAC$POLT BY ACCESS WHENEVER SUCCESSFUL;
AUDIT DELETE ON LBACSYS.LBAC$POLT BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.LBAC$POLT BY ACCESS WHENEVER SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.LBAC$POLT BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.LBAC$POLT BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.LBAC$POLT BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT ALTER ON LBACSYS.LBAC$POLT BY ACCESS WHENEVER SUCCESSFUL;
AUDIT ALTER ON LBACSYS.LBAC$POLT BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT SELECT ON LBACSYS.LBAC$POLT BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.LBAC$PROG BY ACCESS WHENEVER SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.LBAC$PROG BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT RENAME ON LBACSYS.LBAC$PROG BY ACCESS WHENEVER SUCCESSFUL;
AUDIT RENAME ON LBACSYS.LBAC$PROG BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT INSERT ON LBACSYS.LBAC$PROG BY ACCESS WHENEVER SUCCESSFUL;
AUDIT INSERT ON LBACSYS.LBAC$PROG BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT INDEX ON LBACSYS.LBAC$PROG BY ACCESS WHENEVER SUCCESSFUL;
AUDIT INDEX ON LBACSYS.LBAC$PROG BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.LBAC$PROG BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.LBAC$PROG BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT DELETE ON LBACSYS.LBAC$PROG BY ACCESS WHENEVER SUCCESSFUL;
AUDIT DELETE ON LBACSYS.LBAC$PROG BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.LBAC$PROG BY ACCESS WHENEVER SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.LBAC$PROG BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.LBAC$PROG BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.LBAC$PROG BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT ALTER ON LBACSYS.LBAC$PROG BY ACCESS WHENEVER SUCCESSFUL;
AUDIT ALTER ON LBACSYS.LBAC$PROG BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT SELECT ON LBACSYS.LBAC$PROG BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.LBAC$PROPS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.LBAC$PROPS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT RENAME ON LBACSYS.LBAC$PROPS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT RENAME ON LBACSYS.LBAC$PROPS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT INSERT ON LBACSYS.LBAC$PROPS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT INSERT ON LBACSYS.LBAC$PROPS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT INDEX ON LBACSYS.LBAC$PROPS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT INDEX ON LBACSYS.LBAC$PROPS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.LBAC$PROPS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.LBAC$PROPS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT DELETE ON LBACSYS.LBAC$PROPS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT DELETE ON LBACSYS.LBAC$PROPS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.LBAC$PROPS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.LBAC$PROPS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.LBAC$PROPS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.LBAC$PROPS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT ALTER ON LBACSYS.LBAC$PROPS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT ALTER ON LBACSYS.LBAC$PROPS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT SELECT ON LBACSYS.LBAC$PROPS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.LBAC$USER BY ACCESS WHENEVER SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.LBAC$USER BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT RENAME ON LBACSYS.LBAC$USER BY ACCESS WHENEVER SUCCESSFUL;
AUDIT RENAME ON LBACSYS.LBAC$USER BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT INSERT ON LBACSYS.LBAC$USER BY ACCESS WHENEVER SUCCESSFUL;
AUDIT INSERT ON LBACSYS.LBAC$USER BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT INDEX ON LBACSYS.LBAC$USER BY ACCESS WHENEVER SUCCESSFUL;
AUDIT INDEX ON LBACSYS.LBAC$USER BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.LBAC$USER BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.LBAC$USER BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT DELETE ON LBACSYS.LBAC$USER BY ACCESS WHENEVER SUCCESSFUL;
AUDIT DELETE ON LBACSYS.LBAC$USER BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.LBAC$USER BY ACCESS WHENEVER SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.LBAC$USER BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.LBAC$USER BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.LBAC$USER BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT ALTER ON LBACSYS.LBAC$USER BY ACCESS WHENEVER SUCCESSFUL;
AUDIT ALTER ON LBACSYS.LBAC$USER BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT SELECT ON LBACSYS.LBAC$USER BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.LBAC_AUDIT_ACTIONS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.LBAC_AUDIT_ACTIONS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT RENAME ON LBACSYS.LBAC_AUDIT_ACTIONS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT RENAME ON LBACSYS.LBAC_AUDIT_ACTIONS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT INSERT ON LBACSYS.LBAC_AUDIT_ACTIONS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT INSERT ON LBACSYS.LBAC_AUDIT_ACTIONS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT INDEX ON LBACSYS.LBAC_AUDIT_ACTIONS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT INDEX ON LBACSYS.LBAC_AUDIT_ACTIONS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.LBAC_AUDIT_ACTIONS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.LBAC_AUDIT_ACTIONS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT DELETE ON LBACSYS.LBAC_AUDIT_ACTIONS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT DELETE ON LBACSYS.LBAC_AUDIT_ACTIONS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.LBAC_AUDIT_ACTIONS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.LBAC_AUDIT_ACTIONS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.LBAC_AUDIT_ACTIONS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.LBAC_AUDIT_ACTIONS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT ALTER ON LBACSYS.LBAC_AUDIT_ACTIONS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT ALTER ON LBACSYS.LBAC_AUDIT_ACTIONS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT SELECT ON LBACSYS.LBAC_AUDIT_ACTIONS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.SA$COMPARTMENTS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.SA$COMPARTMENTS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT RENAME ON LBACSYS.SA$COMPARTMENTS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT RENAME ON LBACSYS.SA$COMPARTMENTS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT INSERT ON LBACSYS.SA$COMPARTMENTS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT INSERT ON LBACSYS.SA$COMPARTMENTS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT INDEX ON LBACSYS.SA$COMPARTMENTS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT INDEX ON LBACSYS.SA$COMPARTMENTS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.SA$COMPARTMENTS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.SA$COMPARTMENTS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT DELETE ON LBACSYS.SA$COMPARTMENTS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT DELETE ON LBACSYS.SA$COMPARTMENTS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.SA$COMPARTMENTS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.SA$COMPARTMENTS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.SA$COMPARTMENTS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.SA$COMPARTMENTS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT ALTER ON LBACSYS.SA$COMPARTMENTS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT ALTER ON LBACSYS.SA$COMPARTMENTS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT SELECT ON LBACSYS.SA$COMPARTMENTS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.SA$DIP_DEBUG BY ACCESS WHENEVER SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.SA$DIP_DEBUG BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT RENAME ON LBACSYS.SA$DIP_DEBUG BY ACCESS WHENEVER SUCCESSFUL;
AUDIT RENAME ON LBACSYS.SA$DIP_DEBUG BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT INSERT ON LBACSYS.SA$DIP_DEBUG BY ACCESS WHENEVER SUCCESSFUL;
AUDIT INSERT ON LBACSYS.SA$DIP_DEBUG BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT INDEX ON LBACSYS.SA$DIP_DEBUG BY ACCESS WHENEVER SUCCESSFUL;
AUDIT INDEX ON LBACSYS.SA$DIP_DEBUG BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.SA$DIP_DEBUG BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.SA$DIP_DEBUG BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT DELETE ON LBACSYS.SA$DIP_DEBUG BY ACCESS WHENEVER SUCCESSFUL;
AUDIT DELETE ON LBACSYS.SA$DIP_DEBUG BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.SA$DIP_DEBUG BY ACCESS WHENEVER SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.SA$DIP_DEBUG BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.SA$DIP_DEBUG BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.SA$DIP_DEBUG BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT ALTER ON LBACSYS.SA$DIP_DEBUG BY ACCESS WHENEVER SUCCESSFUL;
AUDIT ALTER ON LBACSYS.SA$DIP_DEBUG BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT SELECT ON LBACSYS.SA$DIP_DEBUG BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.SA$DIP_EVENTS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.SA$DIP_EVENTS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT RENAME ON LBACSYS.SA$DIP_EVENTS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT RENAME ON LBACSYS.SA$DIP_EVENTS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT INSERT ON LBACSYS.SA$DIP_EVENTS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT INSERT ON LBACSYS.SA$DIP_EVENTS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT INDEX ON LBACSYS.SA$DIP_EVENTS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT INDEX ON LBACSYS.SA$DIP_EVENTS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.SA$DIP_EVENTS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.SA$DIP_EVENTS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT DELETE ON LBACSYS.SA$DIP_EVENTS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT DELETE ON LBACSYS.SA$DIP_EVENTS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.SA$DIP_EVENTS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.SA$DIP_EVENTS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.SA$DIP_EVENTS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.SA$DIP_EVENTS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT ALTER ON LBACSYS.SA$DIP_EVENTS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT ALTER ON LBACSYS.SA$DIP_EVENTS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT SELECT ON LBACSYS.SA$DIP_EVENTS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.SA$GROUPS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.SA$GROUPS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT RENAME ON LBACSYS.SA$GROUPS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT RENAME ON LBACSYS.SA$GROUPS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT INSERT ON LBACSYS.SA$GROUPS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT INSERT ON LBACSYS.SA$GROUPS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT INDEX ON LBACSYS.SA$GROUPS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT INDEX ON LBACSYS.SA$GROUPS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.SA$GROUPS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.SA$GROUPS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT DELETE ON LBACSYS.SA$GROUPS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT DELETE ON LBACSYS.SA$GROUPS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.SA$GROUPS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.SA$GROUPS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.SA$GROUPS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.SA$GROUPS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT ALTER ON LBACSYS.SA$GROUPS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT ALTER ON LBACSYS.SA$GROUPS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT SELECT ON LBACSYS.SA$GROUPS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.SA$LEVELS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.SA$LEVELS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT RENAME ON LBACSYS.SA$LEVELS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT RENAME ON LBACSYS.SA$LEVELS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT INSERT ON LBACSYS.SA$LEVELS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT INSERT ON LBACSYS.SA$LEVELS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT INDEX ON LBACSYS.SA$LEVELS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT INDEX ON LBACSYS.SA$LEVELS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.SA$LEVELS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.SA$LEVELS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT DELETE ON LBACSYS.SA$LEVELS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT DELETE ON LBACSYS.SA$LEVELS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.SA$LEVELS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.SA$LEVELS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.SA$LEVELS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.SA$LEVELS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT ALTER ON LBACSYS.SA$LEVELS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT ALTER ON LBACSYS.SA$LEVELS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT SELECT ON LBACSYS.SA$LEVELS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.SA$PROFILES BY ACCESS WHENEVER SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.SA$PROFILES BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT RENAME ON LBACSYS.SA$PROFILES BY ACCESS WHENEVER SUCCESSFUL;
AUDIT RENAME ON LBACSYS.SA$PROFILES BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT INSERT ON LBACSYS.SA$PROFILES BY ACCESS WHENEVER SUCCESSFUL;
AUDIT INSERT ON LBACSYS.SA$PROFILES BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT INDEX ON LBACSYS.SA$PROFILES BY ACCESS WHENEVER SUCCESSFUL;
AUDIT INDEX ON LBACSYS.SA$PROFILES BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.SA$PROFILES BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.SA$PROFILES BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT DELETE ON LBACSYS.SA$PROFILES BY ACCESS WHENEVER SUCCESSFUL;
AUDIT DELETE ON LBACSYS.SA$PROFILES BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.SA$PROFILES BY ACCESS WHENEVER SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.SA$PROFILES BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.SA$PROFILES BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.SA$PROFILES BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT ALTER ON LBACSYS.SA$PROFILES BY ACCESS WHENEVER SUCCESSFUL;
AUDIT ALTER ON LBACSYS.SA$PROFILES BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT SELECT ON LBACSYS.SA$PROFILES BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.SA$USER_COMPARTMENTS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.SA$USER_COMPARTMENTS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT RENAME ON LBACSYS.SA$USER_COMPARTMENTS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT RENAME ON LBACSYS.SA$USER_COMPARTMENTS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT INSERT ON LBACSYS.SA$USER_COMPARTMENTS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT INSERT ON LBACSYS.SA$USER_COMPARTMENTS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT INDEX ON LBACSYS.SA$USER_COMPARTMENTS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT INDEX ON LBACSYS.SA$USER_COMPARTMENTS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.SA$USER_COMPARTMENTS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.SA$USER_COMPARTMENTS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT DELETE ON LBACSYS.SA$USER_COMPARTMENTS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT DELETE ON LBACSYS.SA$USER_COMPARTMENTS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.SA$USER_COMPARTMENTS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.SA$USER_COMPARTMENTS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.SA$USER_COMPARTMENTS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.SA$USER_COMPARTMENTS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT ALTER ON LBACSYS.SA$USER_COMPARTMENTS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT ALTER ON LBACSYS.SA$USER_COMPARTMENTS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT SELECT ON LBACSYS.SA$USER_COMPARTMENTS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.SA$USER_GROUPS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.SA$USER_GROUPS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT RENAME ON LBACSYS.SA$USER_GROUPS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT RENAME ON LBACSYS.SA$USER_GROUPS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT INSERT ON LBACSYS.SA$USER_GROUPS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT INSERT ON LBACSYS.SA$USER_GROUPS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT INDEX ON LBACSYS.SA$USER_GROUPS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT INDEX ON LBACSYS.SA$USER_GROUPS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.SA$USER_GROUPS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.SA$USER_GROUPS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT DELETE ON LBACSYS.SA$USER_GROUPS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT DELETE ON LBACSYS.SA$USER_GROUPS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.SA$USER_GROUPS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.SA$USER_GROUPS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.SA$USER_GROUPS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.SA$USER_GROUPS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT ALTER ON LBACSYS.SA$USER_GROUPS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT ALTER ON LBACSYS.SA$USER_GROUPS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT SELECT ON LBACSYS.SA$USER_GROUPS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.SA$USER_LEVELS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT UPDATE ON LBACSYS.SA$USER_LEVELS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT RENAME ON LBACSYS.SA$USER_LEVELS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT RENAME ON LBACSYS.SA$USER_LEVELS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT INSERT ON LBACSYS.SA$USER_LEVELS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT INSERT ON LBACSYS.SA$USER_LEVELS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT INDEX ON LBACSYS.SA$USER_LEVELS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT INDEX ON LBACSYS.SA$USER_LEVELS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ON LBACSYS.SA$USER_LEVELS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ON LBACSYS.SA$USER_LEVELS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT DELETE ON LBACSYS.SA$USER_LEVELS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT DELETE ON LBACSYS.SA$USER_LEVELS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.SA$USER_LEVELS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT COMMENT ON LBACSYS.SA$USER_LEVELS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.SA$USER_LEVELS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ON LBACSYS.SA$USER_LEVELS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT ALTER ON LBACSYS.SA$USER_LEVELS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT ALTER ON LBACSYS.SA$USER_LEVELS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT SELECT ON LBACSYS.SA$USER_LEVELS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT SELECT TABLE BY DVF BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT SELECT SEQUENCE BY DVF BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT MATERIALIZED VIEW BY DVF BY ACCESS WHENEVER SUCCESSFUL;
AUDIT MATERIALIZED VIEW BY DVF BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT MANAGE TABLESPACE BY DVF BY ACCESS WHENEVER SUCCESSFUL;
AUDIT MANAGE TABLESPACE BY DVF BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT MANAGE SCHEDULER BY DVF BY ACCESS WHENEVER SUCCESSFUL;
AUDIT MANAGE SCHEDULER BY DVF BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT INDEX BY DVF BY ACCESS WHENEVER SUCCESSFUL;
AUDIT INDEX BY DVF BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT IMPORT FULL DATABASE BY DVF BY ACCESS WHENEVER SUCCESSFUL;
AUDIT IMPORT FULL DATABASE BY DVF BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT TYPE BY DVF BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT TYPE BY DVF BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT TABLE BY DVF BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT TABLE BY DVF BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT SEQUENCE BY DVF BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT SEQUENCE BY DVF BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT PROCEDURE BY DVF BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT PROCEDURE BY DVF BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT DIRECTORY BY DVF BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT DIRECTORY BY DVF BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT EXPORT FULL DATABASE BY DVF BY ACCESS WHENEVER SUCCESSFUL;
AUDIT EXPORT FULL DATABASE BY DVF BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT EXEMPT IDENTITY POLICY BY DVF BY ACCESS WHENEVER SUCCESSFUL;
AUDIT EXEMPT IDENTITY POLICY BY DVF BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT EXEMPT ACCESS POLICY BY DVF BY ACCESS WHENEVER SUCCESSFUL;
AUDIT EXEMPT ACCESS POLICY BY DVF BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT EXECUTE PROCEDURE BY DVF BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT EXECUTE LIBRARY BY DVF BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT DROP USER BY DVF BY ACCESS WHENEVER SUCCESSFUL;
AUDIT DROP USER BY DVF BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT DROP TABLESPACE BY DVF BY ACCESS WHENEVER SUCCESSFUL;
AUDIT DROP TABLESPACE BY DVF BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT DROP ROLLBACK SEGMENT BY DVF BY ACCESS WHENEVER SUCCESSFUL;
AUDIT DROP ROLLBACK SEGMENT BY DVF BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT DROP PUBLIC SYNONYM BY DVF BY ACCESS WHENEVER SUCCESSFUL;
AUDIT DROP PUBLIC SYNONYM BY DVF BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT DROP PUBLIC DATABASE LINK BY DVF BY ACCESS WHENEVER SUCCESSFUL;
AUDIT DROP PUBLIC DATABASE LINK BY DVF BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT DROP PROFILE BY DVF BY ACCESS WHENEVER SUCCESSFUL;
AUDIT DROP PROFILE BY DVF BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT DIRECTORY BY DVF BY ACCESS WHENEVER SUCCESSFUL;
AUDIT DIRECTORY BY DVF BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT DEBUG PROCEDURE BY DVF BY ACCESS WHENEVER SUCCESSFUL;
AUDIT DEBUG PROCEDURE BY DVF BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT DEBUG CONNECT SESSION BY DVF BY ACCESS WHENEVER SUCCESSFUL;
AUDIT DEBUG CONNECT SESSION BY DVF BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT DEBUG ANY PROCEDURE BY DVF BY ACCESS WHENEVER SUCCESSFUL;
AUDIT DEBUG ANY PROCEDURE BY DVF BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT DATABASE LINK BY DVF BY ACCESS WHENEVER SUCCESSFUL;
AUDIT DATABASE LINK BY DVF BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT CREATE VIEW BY DVF BY ACCESS WHENEVER SUCCESSFUL;
AUDIT CREATE VIEW BY DVF BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT CREATE USER BY DVF BY ACCESS WHENEVER SUCCESSFUL;
AUDIT CREATE USER BY DVF BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT CREATE TYPE BY DVF BY ACCESS WHENEVER SUCCESSFUL;
AUDIT CREATE TYPE BY DVF BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT CREATE TRIGGER BY DVF BY ACCESS WHENEVER SUCCESSFUL;
AUDIT CREATE TRIGGER BY DVF BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT CREATE TABLESPACE BY DVF BY ACCESS WHENEVER SUCCESSFUL;
AUDIT CREATE TABLESPACE BY DVF BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT CREATE TABLE BY DVF BY ACCESS WHENEVER SUCCESSFUL;
AUDIT CREATE TABLE BY DVF BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT CREATE SYNONYM BY DVF BY ACCESS WHENEVER SUCCESSFUL;
AUDIT CREATE SYNONYM BY DVF BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT CREATE SESSION BY DVF BY ACCESS WHENEVER SUCCESSFUL;
AUDIT CREATE SESSION BY DVF BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT CREATE SEQUENCE BY DVF BY ACCESS WHENEVER SUCCESSFUL;
AUDIT CREATE SEQUENCE BY DVF BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT CREATE ROLLBACK SEGMENT BY DVF BY ACCESS WHENEVER SUCCESSFUL;
AUDIT CREATE ROLLBACK SEGMENT BY DVF BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT CREATE ROLE BY DVF BY ACCESS WHENEVER SUCCESSFUL;
AUDIT CREATE ROLE BY DVF BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT CREATE PUBLIC SYNONYM BY DVF BY ACCESS WHENEVER SUCCESSFUL;
AUDIT CREATE PUBLIC SYNONYM BY DVF BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT CREATE PUBLIC DATABASE LINK BY DVF BY ACCESS WHENEVER SUCCESSFUL;
AUDIT CREATE PUBLIC DATABASE LINK BY DVF BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT CREATE PROFILE BY DVF BY ACCESS WHENEVER SUCCESSFUL;
AUDIT CREATE PROFILE BY DVF BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT CREATE PROCEDURE BY DVF BY ACCESS WHENEVER SUCCESSFUL;
AUDIT CREATE PROCEDURE BY DVF BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT CREATE OPERATOR BY DVF BY ACCESS WHENEVER SUCCESSFUL;
AUDIT CREATE OPERATOR BY DVF BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT CREATE MATERIALIZED VIEW BY DVF BY ACCESS WHENEVER SUCCESSFUL;
AUDIT CREATE MATERIALIZED VIEW BY DVF BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT CREATE LIBRARY BY DVF BY ACCESS WHENEVER SUCCESSFUL;
AUDIT CREATE LIBRARY BY DVF BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT CREATE JOB BY DVF BY ACCESS WHENEVER SUCCESSFUL;
AUDIT CREATE JOB BY DVF BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT CREATE INDEXTYPE BY DVF BY ACCESS WHENEVER SUCCESSFUL;
AUDIT CREATE INDEXTYPE BY DVF BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT CREATE DATABASE LINK BY DVF BY ACCESS WHENEVER SUCCESSFUL;
AUDIT CREATE DATABASE LINK BY DVF BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT CREATE CLUSTER BY DVF BY ACCESS WHENEVER SUCCESSFUL;
AUDIT CREATE CLUSTER BY DVF BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT CONTEXT BY DVF BY ACCESS WHENEVER SUCCESSFUL;
AUDIT CONTEXT BY DVF BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT COMMENT TABLE BY DVF BY ACCESS WHENEVER SUCCESSFUL;
AUDIT COMMENT TABLE BY DVF BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT CLUSTER BY DVF BY ACCESS WHENEVER SUCCESSFUL;
AUDIT CLUSTER BY DVF BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT BECOME USER BY DVF BY ACCESS WHENEVER SUCCESSFUL;
AUDIT BECOME USER BY DVF BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT SYSTEM BY DVF BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT SYSTEM BY DVF BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT ALTER USER BY DVF BY ACCESS WHENEVER SUCCESSFUL;
AUDIT ALTER USER BY DVF BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT ALTER TABLESPACE BY DVF BY ACCESS WHENEVER SUCCESSFUL;
AUDIT ALTER TABLESPACE BY DVF BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT ALTER TABLE BY DVF BY ACCESS WHENEVER SUCCESSFUL;
AUDIT ALTER TABLE BY DVF BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT ALTER SYSTEM BY DVF BY ACCESS WHENEVER SUCCESSFUL;
AUDIT ALTER SYSTEM BY DVF BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT ALTER SESSION BY DVF BY ACCESS WHENEVER SUCCESSFUL;
AUDIT ALTER SESSION BY DVF BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT ALTER SEQUENCE BY DVF BY ACCESS WHENEVER SUCCESSFUL;
AUDIT ALTER SEQUENCE BY DVF BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT ALTER ROLLBACK SEGMENT BY DVF BY ACCESS WHENEVER SUCCESSFUL;
AUDIT ALTER ROLLBACK SEGMENT BY DVF BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT ALTER RESOURCE COST BY DVF BY ACCESS WHENEVER SUCCESSFUL;
AUDIT ALTER RESOURCE COST BY DVF BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT ALTER PROFILE BY DVF BY ACCESS WHENEVER SUCCESSFUL;
AUDIT ALTER PROFILE BY DVF BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT ALTER DATABASE BY DVF BY ACCESS WHENEVER SUCCESSFUL;
AUDIT ALTER DATABASE BY DVF BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT ADMINISTER DATABASE TRIGGER BY DVF BY ACCESS WHENEVER SUCCESSFUL;
AUDIT ADMINISTER DATABASE TRIGGER BY DVF BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT SELECT TABLE BY DVSYS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT SELECT SEQUENCE BY DVSYS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT MATERIALIZED VIEW BY DVSYS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT MATERIALIZED VIEW BY DVSYS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT MANAGE TABLESPACE BY DVSYS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT MANAGE TABLESPACE BY DVSYS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT MANAGE SCHEDULER BY DVSYS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT MANAGE SCHEDULER BY DVSYS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT INDEX BY DVSYS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT INDEX BY DVSYS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT IMPORT FULL DATABASE BY DVSYS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT IMPORT FULL DATABASE BY DVSYS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT TYPE BY DVSYS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT TYPE BY DVSYS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT TABLE BY DVSYS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT TABLE BY DVSYS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT SEQUENCE BY DVSYS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT SEQUENCE BY DVSYS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT PROCEDURE BY DVSYS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT PROCEDURE BY DVSYS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT DIRECTORY BY DVSYS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT DIRECTORY BY DVSYS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT EXPORT FULL DATABASE BY DVSYS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT EXPORT FULL DATABASE BY DVSYS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT EXEMPT IDENTITY POLICY BY DVSYS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT EXEMPT IDENTITY POLICY BY DVSYS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT EXEMPT ACCESS POLICY BY DVSYS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT EXEMPT ACCESS POLICY BY DVSYS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT EXECUTE PROCEDURE BY DVSYS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT EXECUTE LIBRARY BY DVSYS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT DROP USER BY DVSYS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT DROP USER BY DVSYS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT DROP TABLESPACE BY DVSYS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT DROP TABLESPACE BY DVSYS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT DROP ROLLBACK SEGMENT BY DVSYS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT DROP ROLLBACK SEGMENT BY DVSYS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT DROP PUBLIC SYNONYM BY DVSYS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT DROP PUBLIC SYNONYM BY DVSYS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT DROP PUBLIC DATABASE LINK BY DVSYS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT DROP PUBLIC DATABASE LINK BY DVSYS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT DROP PROFILE BY DVSYS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT DROP PROFILE BY DVSYS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT DIRECTORY BY DVSYS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT DIRECTORY BY DVSYS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT DEBUG PROCEDURE BY DVSYS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT DEBUG PROCEDURE BY DVSYS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT DEBUG CONNECT SESSION BY DVSYS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT DEBUG CONNECT SESSION BY DVSYS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT DEBUG ANY PROCEDURE BY DVSYS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT DEBUG ANY PROCEDURE BY DVSYS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT DATABASE LINK BY DVSYS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT DATABASE LINK BY DVSYS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT CREATE VIEW BY DVSYS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT CREATE VIEW BY DVSYS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT CREATE USER BY DVSYS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT CREATE USER BY DVSYS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT CREATE TYPE BY DVSYS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT CREATE TYPE BY DVSYS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT CREATE TRIGGER BY DVSYS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT CREATE TRIGGER BY DVSYS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT CREATE TABLESPACE BY DVSYS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT CREATE TABLESPACE BY DVSYS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT CREATE TABLE BY DVSYS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT CREATE TABLE BY DVSYS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT CREATE SYNONYM BY DVSYS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT CREATE SYNONYM BY DVSYS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT CREATE SESSION BY DVSYS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT CREATE SESSION BY DVSYS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT CREATE SEQUENCE BY DVSYS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT CREATE SEQUENCE BY DVSYS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT CREATE ROLLBACK SEGMENT BY DVSYS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT CREATE ROLLBACK SEGMENT BY DVSYS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT CREATE ROLE BY DVSYS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT CREATE ROLE BY DVSYS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT CREATE PUBLIC SYNONYM BY DVSYS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT CREATE PUBLIC SYNONYM BY DVSYS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT CREATE PUBLIC DATABASE LINK BY DVSYS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT CREATE PUBLIC DATABASE LINK BY DVSYS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT CREATE PROFILE BY DVSYS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT CREATE PROFILE BY DVSYS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT CREATE PROCEDURE BY DVSYS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT CREATE PROCEDURE BY DVSYS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT CREATE OPERATOR BY DVSYS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT CREATE OPERATOR BY DVSYS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT CREATE MATERIALIZED VIEW BY DVSYS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT CREATE MATERIALIZED VIEW BY DVSYS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT CREATE LIBRARY BY DVSYS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT CREATE LIBRARY BY DVSYS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT CREATE JOB BY DVSYS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT CREATE JOB BY DVSYS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT CREATE INDEXTYPE BY DVSYS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT CREATE INDEXTYPE BY DVSYS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT CREATE DATABASE LINK BY DVSYS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT CREATE DATABASE LINK BY DVSYS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT CREATE CLUSTER BY DVSYS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT CREATE CLUSTER BY DVSYS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT CONTEXT BY DVSYS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT CONTEXT BY DVSYS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT COMMENT TABLE BY DVSYS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT COMMENT TABLE BY DVSYS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT CLUSTER BY DVSYS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT CLUSTER BY DVSYS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT BECOME USER BY DVSYS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT BECOME USER BY DVSYS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT SYSTEM BY DVSYS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT SYSTEM BY DVSYS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT ALTER USER BY DVSYS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT ALTER USER BY DVSYS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT ALTER TABLESPACE BY DVSYS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT ALTER TABLESPACE BY DVSYS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT ALTER TABLE BY DVSYS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT ALTER TABLE BY DVSYS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT ALTER SYSTEM BY DVSYS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT ALTER SYSTEM BY DVSYS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT ALTER SESSION BY DVSYS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT ALTER SESSION BY DVSYS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT ALTER SEQUENCE BY DVSYS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT ALTER SEQUENCE BY DVSYS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT ALTER ROLLBACK SEGMENT BY DVSYS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT ALTER ROLLBACK SEGMENT BY DVSYS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT ALTER RESOURCE COST BY DVSYS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT ALTER RESOURCE COST BY DVSYS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT ALTER PROFILE BY DVSYS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT ALTER PROFILE BY DVSYS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT ALTER DATABASE BY DVSYS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT ALTER DATABASE BY DVSYS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT ADMINISTER DATABASE TRIGGER BY DVSYS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT ADMINISTER DATABASE TRIGGER BY DVSYS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT SELECT TABLE BY LBACSYS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT SELECT SEQUENCE BY LBACSYS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT MATERIALIZED VIEW BY LBACSYS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT MATERIALIZED VIEW BY LBACSYS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT MANAGE TABLESPACE BY LBACSYS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT MANAGE TABLESPACE BY LBACSYS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT MANAGE SCHEDULER BY LBACSYS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT MANAGE SCHEDULER BY LBACSYS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT INDEX BY LBACSYS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT INDEX BY LBACSYS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT IMPORT FULL DATABASE BY LBACSYS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT IMPORT FULL DATABASE BY LBACSYS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT TYPE BY LBACSYS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT TYPE BY LBACSYS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT TABLE BY LBACSYS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT TABLE BY LBACSYS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT SEQUENCE BY LBACSYS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT SEQUENCE BY LBACSYS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT PROCEDURE BY LBACSYS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT PROCEDURE BY LBACSYS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT DIRECTORY BY LBACSYS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT DIRECTORY BY LBACSYS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT EXPORT FULL DATABASE BY LBACSYS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT EXPORT FULL DATABASE BY LBACSYS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT EXEMPT IDENTITY POLICY BY LBACSYS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT EXEMPT IDENTITY POLICY BY LBACSYS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT EXEMPT ACCESS POLICY BY LBACSYS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT EXEMPT ACCESS POLICY BY LBACSYS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT EXECUTE PROCEDURE BY LBACSYS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT EXECUTE LIBRARY BY LBACSYS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT DROP USER BY LBACSYS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT DROP USER BY LBACSYS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT DROP TABLESPACE BY LBACSYS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT DROP TABLESPACE BY LBACSYS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT DROP ROLLBACK SEGMENT BY LBACSYS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT DROP ROLLBACK SEGMENT BY LBACSYS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT DROP PUBLIC SYNONYM BY LBACSYS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT DROP PUBLIC SYNONYM BY LBACSYS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT DROP PUBLIC DATABASE LINK BY LBACSYS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT DROP PUBLIC DATABASE LINK BY LBACSYS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT DROP PROFILE BY LBACSYS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT DROP PROFILE BY LBACSYS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT DIRECTORY BY LBACSYS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT DIRECTORY BY LBACSYS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT DEBUG PROCEDURE BY LBACSYS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT DEBUG PROCEDURE BY LBACSYS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT DEBUG CONNECT SESSION BY LBACSYS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT DEBUG CONNECT SESSION BY LBACSYS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT DEBUG ANY PROCEDURE BY LBACSYS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT DEBUG ANY PROCEDURE BY LBACSYS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT DATABASE LINK BY LBACSYS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT DATABASE LINK BY LBACSYS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT CREATE VIEW BY LBACSYS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT CREATE VIEW BY LBACSYS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT CREATE USER BY LBACSYS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT CREATE USER BY LBACSYS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT CREATE TYPE BY LBACSYS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT CREATE TYPE BY LBACSYS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT CREATE TRIGGER BY LBACSYS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT CREATE TRIGGER BY LBACSYS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT CREATE TABLESPACE BY LBACSYS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT CREATE TABLESPACE BY LBACSYS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT CREATE TABLE BY LBACSYS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT CREATE TABLE BY LBACSYS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT CREATE SYNONYM BY LBACSYS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT CREATE SYNONYM BY LBACSYS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT CREATE SESSION BY LBACSYS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT CREATE SESSION BY LBACSYS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT CREATE SEQUENCE BY LBACSYS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT CREATE SEQUENCE BY LBACSYS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT CREATE ROLLBACK SEGMENT BY LBACSYS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT CREATE ROLLBACK SEGMENT BY LBACSYS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT CREATE ROLE BY LBACSYS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT CREATE ROLE BY LBACSYS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT CREATE PUBLIC SYNONYM BY LBACSYS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT CREATE PUBLIC SYNONYM BY LBACSYS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT CREATE PUBLIC DATABASE LINK BY LBACSYS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT CREATE PUBLIC DATABASE LINK BY LBACSYS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT CREATE PROFILE BY LBACSYS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT CREATE PROFILE BY LBACSYS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT CREATE PROCEDURE BY LBACSYS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT CREATE PROCEDURE BY LBACSYS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT CREATE OPERATOR BY LBACSYS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT CREATE OPERATOR BY LBACSYS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT CREATE MATERIALIZED VIEW BY LBACSYS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT CREATE MATERIALIZED VIEW BY LBACSYS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT CREATE LIBRARY BY LBACSYS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT CREATE LIBRARY BY LBACSYS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT CREATE JOB BY LBACSYS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT CREATE JOB BY LBACSYS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT CREATE INDEXTYPE BY LBACSYS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT CREATE INDEXTYPE BY LBACSYS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT CREATE DATABASE LINK BY LBACSYS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT CREATE DATABASE LINK BY LBACSYS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT CREATE CLUSTER BY LBACSYS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT CREATE CLUSTER BY LBACSYS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT CONTEXT BY LBACSYS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT CONTEXT BY LBACSYS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT COMMENT TABLE BY LBACSYS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT COMMENT TABLE BY LBACSYS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT CLUSTER BY LBACSYS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT CLUSTER BY LBACSYS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT BECOME USER BY LBACSYS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT BECOME USER BY LBACSYS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT SYSTEM BY LBACSYS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT SYSTEM BY LBACSYS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT ALTER USER BY LBACSYS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT ALTER USER BY LBACSYS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT ALTER TABLESPACE BY LBACSYS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT ALTER TABLESPACE BY LBACSYS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT ALTER TABLE BY LBACSYS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT ALTER TABLE BY LBACSYS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT ALTER SYSTEM BY LBACSYS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT ALTER SYSTEM BY LBACSYS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT ALTER SESSION BY LBACSYS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT ALTER SESSION BY LBACSYS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT ALTER SEQUENCE BY LBACSYS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT ALTER SEQUENCE BY LBACSYS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT ALTER ROLLBACK SEGMENT BY LBACSYS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT ALTER ROLLBACK SEGMENT BY LBACSYS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT ALTER RESOURCE COST BY LBACSYS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT ALTER RESOURCE COST BY LBACSYS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT ALTER PROFILE BY LBACSYS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT ALTER PROFILE BY LBACSYS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT ALTER DATABASE BY LBACSYS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT ALTER DATABASE BY LBACSYS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT ADMINISTER DATABASE TRIGGER BY LBACSYS BY ACCESS WHENEVER SUCCESSFUL;
AUDIT ADMINISTER DATABASE TRIGGER BY LBACSYS BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT DIRECTORY BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT DIRECTORY BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT PROCEDURE BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT PROCEDURE BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT SEQUENCE BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT SEQUENCE BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT TABLE BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT TABLE BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT TYPE BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT TYPE BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT SYSTEM BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT SYSTEM BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT EXEMPT ACCESS POLICY BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT FORCE TRANSACTION BY ACCESS WHENEVER SUCCESSFUL;
AUDIT FORCE TRANSACTION BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT MANAGE TABLESPACE BY ACCESS WHENEVER SUCCESSFUL;
AUDIT MANAGE TABLESPACE BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT DELETE ANY TABLE BY ACCESS WHENEVER SUCCESSFUL;
AUDIT DELETE ANY TABLE BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT INSERT ANY TABLE BY ACCESS WHENEVER SUCCESSFUL;
AUDIT INSERT ANY TABLE BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT SELECT ANY SEQUENCE BY ACCESS WHENEVER SUCCESSFUL;
AUDIT SELECT ANY SEQUENCE BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT UPDATE ANY TABLE BY ACCESS WHENEVER SUCCESSFUL;
AUDIT UPDATE ANY TABLE BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT TRUNCATE BY ACCESS WHENEVER SUCCESSFUL;
AUDIT TRUNCATE BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT BECOME USER BY ACCESS WHENEVER SUCCESSFUL;
AUDIT BECOME USER BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT RESTRICTED SESSION BY ACCESS WHENEVER SUCCESSFUL;
AUDIT RESTRICTED SESSION BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT AUDIT ANY BY ACCESS WHENEVER SUCCESSFUL;
AUDIT AUDIT ANY BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT BACKUP ANY TABLE BY ACCESS WHENEVER SUCCESSFUL;
AUDIT BACKUP ANY TABLE BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT FORCE ANY TRANSACTION BY ACCESS WHENEVER SUCCESSFUL;
AUDIT FORCE ANY TRANSACTION BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ANY OBJECT PRIVILEGE BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ANY OBJECT PRIVILEGE BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ANY PRIVILEGE BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ANY PRIVILEGE BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT GRANT ANY ROLE BY ACCESS WHENEVER SUCCESSFUL;
AUDIT GRANT ANY ROLE BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT ALTER ANY INDEX BY ACCESS WHENEVER SUCCESSFUL;
AUDIT ALTER ANY INDEX BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT ALTER ANY LIBRARY BY ACCESS WHENEVER SUCCESSFUL;
AUDIT ALTER ANY LIBRARY BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT ALTER ANY PROCEDURE BY ACCESS WHENEVER SUCCESSFUL;
AUDIT ALTER ANY PROCEDURE BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT ALTER ANY ROLE BY ACCESS WHENEVER SUCCESSFUL;
AUDIT ALTER ANY ROLE BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT ALTER ANY SEQUENCE BY ACCESS WHENEVER SUCCESSFUL;
AUDIT ALTER ANY SEQUENCE BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT ALTER ANY TABLE BY ACCESS WHENEVER SUCCESSFUL;
AUDIT ALTER ANY TABLE BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT ALTER ANY TRIGGER BY ACCESS WHENEVER SUCCESSFUL;
AUDIT ALTER ANY TRIGGER BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT ALTER DATABASE BY ACCESS WHENEVER SUCCESSFUL;
AUDIT ALTER DATABASE BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT ALTER PROFILE BY ACCESS WHENEVER SUCCESSFUL;
AUDIT ALTER PROFILE BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT ALTER ROLLBACK SEGMENT BY ACCESS WHENEVER SUCCESSFUL;
AUDIT ALTER ROLLBACK SEGMENT BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT ALTER SESSION BY ACCESS WHENEVER SUCCESSFUL;
AUDIT ALTER SESSION BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT ALTER TABLESPACE BY ACCESS WHENEVER SUCCESSFUL;
AUDIT ALTER TABLESPACE BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT ALTER USER BY ACCESS WHENEVER SUCCESSFUL;
AUDIT ALTER USER BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT CREATE ANY DIMENSION BY ACCESS WHENEVER SUCCESSFUL;
AUDIT CREATE ANY DIMENSION BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT CREATE ANY DIRECTORY BY ACCESS WHENEVER SUCCESSFUL;
AUDIT CREATE ANY DIRECTORY BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT CREATE ANY LIBRARY BY ACCESS WHENEVER SUCCESSFUL;
AUDIT CREATE ANY LIBRARY BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT CREATE ANY PROCEDURE BY ACCESS WHENEVER SUCCESSFUL;
AUDIT CREATE ANY PROCEDURE BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT CREATE ANY SNAPSHOT BY ACCESS WHENEVER SUCCESSFUL;
AUDIT CREATE ANY SNAPSHOT BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT CREATE ANY TABLE BY ACCESS WHENEVER SUCCESSFUL;
AUDIT CREATE ANY TABLE BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT CREATE ANY TRIGGER BY ACCESS WHENEVER SUCCESSFUL;
AUDIT CREATE ANY TRIGGER BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT CREATE ANY VIEW BY ACCESS WHENEVER SUCCESSFUL;
AUDIT CREATE ANY VIEW BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT CREATE CLUSTER BY ACCESS WHENEVER SUCCESSFUL;
AUDIT CREATE CLUSTER BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT CREATE DATABASE LINK BY ACCESS WHENEVER SUCCESSFUL;
AUDIT CREATE DATABASE LINK BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT CREATE DIMENSION BY ACCESS WHENEVER SUCCESSFUL;
AUDIT CREATE DIMENSION BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT CREATE PROCEDURE BY ACCESS WHENEVER SUCCESSFUL;
AUDIT CREATE PROCEDURE BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT CREATE PROFILE BY ACCESS WHENEVER SUCCESSFUL;
AUDIT CREATE PROFILE BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT CREATE PUBLIC DATABASE LINK BY ACCESS WHENEVER SUCCESSFUL;
AUDIT CREATE PUBLIC DATABASE LINK BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT CREATE PUBLIC SYNONYM BY ACCESS WHENEVER SUCCESSFUL;
AUDIT CREATE PUBLIC SYNONYM BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT CREATE ROLE BY ACCESS WHENEVER SUCCESSFUL;
AUDIT CREATE ROLE BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT CREATE ROLLBACK SEGMENT BY ACCESS WHENEVER SUCCESSFUL;
AUDIT CREATE ROLLBACK SEGMENT BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT CREATE SEQUENCE BY ACCESS WHENEVER SUCCESSFUL;
AUDIT CREATE SEQUENCE BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT CREATE SESSION BY ACCESS WHENEVER SUCCESSFUL;
AUDIT CREATE SESSION BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT CREATE SNAPSHOT BY ACCESS WHENEVER SUCCESSFUL;
AUDIT CREATE SNAPSHOT BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT CREATE SYNONYM BY ACCESS WHENEVER SUCCESSFUL;
AUDIT CREATE SYNONYM BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT CREATE TABLE BY ACCESS WHENEVER SUCCESSFUL;
AUDIT CREATE TABLE BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT CREATE TABLESPACE BY ACCESS WHENEVER SUCCESSFUL;
AUDIT CREATE TABLESPACE BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT CREATE TRIGGER BY ACCESS WHENEVER SUCCESSFUL;
AUDIT CREATE TRIGGER BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT CREATE TYPE BY ACCESS WHENEVER SUCCESSFUL;
AUDIT CREATE TYPE BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT CREATE USER BY ACCESS WHENEVER SUCCESSFUL;
AUDIT CREATE USER BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT CREATE VIEW BY ACCESS WHENEVER SUCCESSFUL;
AUDIT CREATE VIEW BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT DROP ANY DIMENSION WHENEVER SUCCESSFUL;
AUDIT DROP ANY DIMENSION WHENEVER NOT SUCCESSFUL;
AUDIT DROP ANY DIRECTORY BY ACCESS WHENEVER SUCCESSFUL;
AUDIT DROP ANY DIRECTORY BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT DROP ANY INDEX BY ACCESS WHENEVER SUCCESSFUL;
AUDIT DROP ANY INDEX BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT DROP ANY LIBRARY BY ACCESS WHENEVER SUCCESSFUL;
AUDIT DROP ANY LIBRARY BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT DROP ANY PROCEDURE BY ACCESS WHENEVER SUCCESSFUL;
AUDIT DROP ANY PROCEDURE BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT DROP ANY ROLE BY ACCESS WHENEVER SUCCESSFUL;
AUDIT DROP ANY ROLE BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT DROP ANY SEQUENCE BY ACCESS WHENEVER SUCCESSFUL;
AUDIT DROP ANY SEQUENCE BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT DROP ANY SNAPSHOT BY ACCESS WHENEVER SUCCESSFUL;
AUDIT DROP ANY SNAPSHOT BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT DROP ANY SYNONYM BY ACCESS WHENEVER SUCCESSFUL;
AUDIT DROP ANY SYNONYM BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT DROP ANY TABLE BY ACCESS WHENEVER SUCCESSFUL;
AUDIT DROP ANY TABLE BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT DROP ANY TRIGGER BY ACCESS WHENEVER SUCCESSFUL;
AUDIT DROP ANY TRIGGER BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT DROP ANY TYPE BY ACCESS WHENEVER SUCCESSFUL;
AUDIT DROP ANY TYPE BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT DROP ANY VIEW BY ACCESS WHENEVER SUCCESSFUL;
AUDIT DROP ANY VIEW BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT DROP PROFILE BY ACCESS WHENEVER SUCCESSFUL;
AUDIT DROP PROFILE BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT DROP PUBLIC DATABASE LINK BY ACCESS WHENEVER SUCCESSFUL;
AUDIT DROP PUBLIC DATABASE LINK BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT DROP PUBLIC SYNONYM BY ACCESS WHENEVER SUCCESSFUL;
AUDIT DROP PUBLIC SYNONYM BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT DROP ROLLBACK SEGMENT BY ACCESS WHENEVER SUCCESSFUL;
AUDIT DROP ROLLBACK SEGMENT BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT DROP TABLESPACE BY ACCESS WHENEVER SUCCESSFUL;
AUDIT DROP TABLESPACE BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT DROP USER BY ACCESS WHENEVER SUCCESSFUL;
AUDIT DROP USER BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT DROP ANY CONTEXT BY ACCESS WHENEVER SUCCESSFUL;
AUDIT DROP ANY CONTEXT BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT EXECUTE ANY INDEXTYPE BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT EXECUTE ANY LIBRARY BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT EXECUTE ANY OPERATOR BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT EXECUTE ANY TYPE BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT EXECUTE ANY INDEXTYPE BY ACCESS WHENEVER SUCCESSFUL;
AUDIT EXECUTE ANY LIBRARY BY ACCESS WHENEVER SUCCESSFUL;
AUDIT EXECUTE ANY OPERATOR BY ACCESS WHENEVER SUCCESSFUL;
AUDIT EXECUTE ANY TYPE BY ACCESS WHENEVER SUCCESSFUL;
AUDIT FLASHBACK ANY TABLE BY ACCESS WHENEVER SUCCESSFUL;
AUDIT FLASHBACK ANY TABLE BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT ALTER ANY CLUSTER BY ACCESS WHENEVER SUCCESSFUL;
AUDIT ALTER ANY CLUSTER BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT ALTER ANY INDEXTYPE BY ACCESS WHENEVER SUCCESSFUL;
AUDIT ALTER ANY INDEXTYPE BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT ALTER ANY OPERATOR BY ACCESS WHENEVER SUCCESSFUL;
AUDIT ALTER ANY OPERATOR BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT ALTER ANY SNAPSHOT BY ACCESS WHENEVER SUCCESSFUL;
AUDIT ALTER ANY SNAPSHOT BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT ALTER ANY TYPE BY ACCESS WHENEVER SUCCESSFUL;
AUDIT ALTER ANY TYPE BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT ALTER SEQUENCE BY ACCESS WHENEVER SUCCESSFUL;
AUDIT ALTER SEQUENCE BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT ALTER SYSTEM BY ACCESS WHENEVER SUCCESSFUL;
AUDIT ALTER SYSTEM BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT ALTER TABLE BY ACCESS WHENEVER SUCCESSFUL;
AUDIT ALTER TABLE BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT COMMENT ANY TABLE BY ACCESS WHENEVER SUCCESSFUL;
AUDIT COMMENT ANY TABLE BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT COMMENT TABLE BY ACCESS WHENEVER SUCCESSFUL;
AUDIT COMMENT TABLE BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT CREATE ANY CLUSTER BY ACCESS WHENEVER SUCCESSFUL;
AUDIT CREATE ANY CLUSTER BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT CREATE ANY CONTEXT BY ACCESS WHENEVER SUCCESSFUL;
AUDIT CREATE ANY CONTEXT BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT CREATE ANY INDEX BY ACCESS WHENEVER SUCCESSFUL;
AUDIT CREATE ANY INDEX BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT CREATE ANY INDEXTYPE BY ACCESS WHENEVER SUCCESSFUL;
AUDIT CREATE ANY INDEXTYPE BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT CREATE ANY OPERATOR BY ACCESS WHENEVER SUCCESSFUL;
AUDIT CREATE ANY SEQUENCE BY ACCESS WHENEVER SUCCESSFUL;
AUDIT CREATE ANY SEQUENCE BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT CREATE ANY SYNONYM BY ACCESS WHENEVER SUCCESSFUL;
AUDIT CREATE ANY SYNONYM BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT CREATE ANY TYPE BY ACCESS WHENEVER SUCCESSFUL;
AUDIT CREATE ANY TYPE BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT CREATE INDEXTYPE BY ACCESS WHENEVER SUCCESSFUL;
AUDIT CREATE INDEXTYPE BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT CREATE LIBRARY BY ACCESS WHENEVER SUCCESSFUL;
AUDIT CREATE LIBRARY BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT CREATE OPERATOR BY ACCESS WHENEVER SUCCESSFUL;
AUDIT CREATE OPERATOR BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT DROP ANY CLUSTER BY ACCESS WHENEVER SUCCESSFUL;
AUDIT DROP ANY CLUSTER BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT DROP ANY INDEXTYPE BY ACCESS WHENEVER SUCCESSFUL;
AUDIT DROP ANY INDEXTYPE BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT DROP ANY OPERATOR BY ACCESS WHENEVER SUCCESSFUL;
AUDIT DROP ANY OPERATOR BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT EXECUTE ANY PROCEDURE BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT EXECUTE ANY PROCEDURE BY ACCESS WHENEVER SUCCESSFUL;
AUDIT DEBUG CONNECT SESSION BY ACCESS WHENEVER SUCCESSFUL;
AUDIT DEBUG CONNECT SESSION BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT DEBUG PROCEDURE BY ACCESS WHENEVER SUCCESSFUL;
AUDIT DEBUG PROCEDURE BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT DELETE TABLE BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT ADMINISTER DATABASE TRIGGER BY ACCESS WHENEVER SUCCESSFUL;
AUDIT ADMINISTER DATABASE TRIGGER BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT EXECUTE PROCEDURE BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT ALTER RESOURCE COST BY ACCESS WHENEVER SUCCESSFUL;
AUDIT ALTER RESOURCE COST BY ACCESS WHENEVER NOT SUCCESSFUL;
AUDIT SYSTEM GRANT BY ACCESS WHENEVER SUCCESSFUL      ;
AUDIT SYSTEM GRANT BY ACCESS WHENEVER NOT SUCCESSFUL  ;
AUDIT SYSTEM AUDIT BY ACCESS WHENEVER  SUCCESSFUL     ;
AUDIT SYSTEM AUDIT BY ACCESS WHENEVER NOT SUCCESSFUL  ;
AUDIT SELECT ANY TABLE BY ACCESS WHENEVER NOT SUCCESSFUL;
