Rem
Rem $Header: rdbms/admin/dvpatch.sql /main/3 2008/11/24 14:34:56 vigaur Exp $
Rem
Rem dvpatch.sql
Rem
Rem Copyright (c) 2006, 2008, Oracle and/or its affiliates.
Rem All rights reserved. 
Rem
Rem    NAME
Rem      dvpatch.sql - Oracle Database Vault Patch Script
Rem
Rem    DESCRIPTION
Rem       This script is used to apply bugfixes to the DV component.It is run 
Rem      in the context of catpatch.sql, after the RDBMS catalog.sql and 
Rem      catproc.sql scripts are run. It is run with a special EVENT set which
Rem      causes CREATE OR REPLACE statements to only recompile objects if the 
Rem      new source is different than the source stored in the database.
Rem      Tables, types, and public interfaces should not be changed here.
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    vigaur      11/21/08 - XbranchMerge vigaur_lrg-3392573 from
Rem                           st_rdbms_11.1.0
Rem    vigaur      01/09/08 - LRG 3205969 
Rem    mxu         01/26/07 - Fix errors
Rem    rvissapr    12/01/06 - DV patch
Rem    rvissapr    12/01/06 - Created
Rem

WHENEVER SQLERROR EXIT;
EXECUTE dbms_registry.check_server_instance;
WHENEVER SQLERROR CONTINUE;

--
-- Add Database Vault to the registry
--

Begin
 DBMS_REGISTRY.LOADING(comp_id     =>  'DV', 
                       comp_name   =>  'Oracle Database Vault', 
                       comp_proc   =>  'VALIDATE_DV', 
                       comp_schema =>  'DVSYS',
                       comp_schemas =>  dbms_registry.schema_list_t('DVF'));
End;
/

--
-- Reload all the packages, functions and procedures from previous release
--

ALTER SESSION SET CURRENT_SCHEMA = DVSYS;

-- Add the new Rule Set Row Cache library
CREATE OR REPLACE LIBRARY DVSYS.KZV$RSRC_LIBT TRUSTED AS STATIC
/


@@dvmacfnc.plb

@@catmacp.sql

@@prvtmacp.plb

@@catmact.sql

-- LRG 3392573. Re-sync command rules
exec DVSYS.dbms_macadm.sync_rules;

--
-- Done Loading DV. Now Validate 
--

Begin
 dbms_registry.loaded( 'DV');
 sys.validate_dv;
End;
/
   
ALTER SESSION SET CURRENT_SCHEMA = SYS;

COMMIT;

