Rem
Rem $Header: rdbms/admin/dvremov.sql /main/2 2009/04/01 02:16:00 jsamuel Exp $
Rem
Rem dvremov.sql
Rem
Rem Copyright (c) 2006, 2009, Oracle and/or its affiliates. 
Rem All rights reserved. 
Rem
Rem    NAME
Rem      dvremov.sql - This script should be used remove DV 
rEM                    related metadata.
Rem
Rem    DESCRIPTION
Rem        This script requires that DV and OLS be turned off. 
Rem    Recreate Password file with  NOSYSDBA = 'n' option.
Rem    This script will only remove DV related metadata.
Rem 
Rem    This script needs to be executed as SYSDBA
Rem
Rem    Please see documentation for more details.
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    jsamuel     03/16/09 - remove 11gR2 DV functionality
Rem    mxu         12/19/06 - 
Rem    rvissapr    12/06/06 - remove dv metadata
Rem    rvissapr    12/06/06 - Created
Rem



WHENEVER SQLERROR EXIT;

--
-- Check the user who is executing this script.
--

BEGIN
   IF SYS_CONTEXT('userenv','session_user') != 'SYS' then
   DBMS_MACUTL.RAISE_ERROR(47994);
   end if;
END;
/

--Check that Database Vault is linked off 
DECLARE
linkdvoff VARCHAR2(10);
BEGIN
  SELECT value INTO linkdvoff FROM v$option WHERE parameter LIKE 'Oracle Database Vault';
  IF (linkdvoff LIKE 'TRUE') THEN
     DBMS_MACUTL.RAISE_ERROR(47995);
  END IF;
END;
/

--Check that DV_OWNER has disabled Database Vault
--exec DBMS_MACADM.DISABLE_DV_CHECK
DECLARE
disabledv NUMBER;
BEGIN
  SELECT status INTO disabledv FROM dvsys.config$;
  IF (disabledv != 0) THEN
    DBMS_MACUTL.RAISE_ERROR(47995);
  END IF;
END;
/

--Check that the RecycleBin is turned off.
DECLARE 
 recyclebin_status VARCHAR2(10);
BEGIN
   select value into recyclebin_status from v$parameter where name like '%recyclebin%';
   IF (recyclebin_status LIKE 'on') THEN
      DBMS_MACUTL.RAISE_ERROR(47996);
   END IF;
END;
/

WHENEVER SQLERROR CONTINUE;

--
-- Remove Database Vault  via registry
-- 
EXECUTE DBMS_REGISTRY.REMOVING('DV');


--Revoke Network Access privileges from DVSYS
--unassign the acl
begin
   dbms_network_acl_admin.unassign_acl('dvsys-network-privileges.xml','*');
end;
/

--drop the acl from /sys/acls/
begin
   dbms_network_acl_admin.drop_acl('dvsys-network-privileges.xml');
end;
/

commit;

--
-- DROP PASSWORD FILE RELATED sys OBJECTS
-- 

DROP TABLE SYS.db_profile_dict$;
DROP FUNCTION SYS.db_profile_function;

--
-- Drop all the PUBLIC synonyms for objects in DVSYS and DVF
--

DECLARE
  CURSOR dv_public_syn IS
  SELECT synonym_name 
  FROM all_synonyms
  WHERE owner = 'PUBLIC' AND 
        table_owner in ('DVSYS', 'DVF');
BEGIN
  For s IN dv_public_syn LOOP
    dbms_output.put_line('Dropping public synonym ' || s.synonym_name);
   BEGIN
      EXECUTE IMMEDIATE 'DROP PUBLIC SYNONYM ' || s.synonym_name;
    EXCEPTION
    WHEN OTHERS THEN
      dbms_output.put_line('Unable to drop synonym '|| s.synonym_name);
    END;
  END LOOP;
END;
/

------------------------------------------------------------------------------
-- bug 6938028: Database Vault Protected Schema.
-- Delete rows from metaview$ to remove the registrations of
-- the real Data Pump types, which were dropped just below
-- when the entire "DVSYS" schema is dropped. 
------------------------------------------------------------------------------

delete from metaview$ 
 where type       = 'DVPS_REALM'
   and flags      = 0 
   and properties = 0
   and model      = 'ORACLE'
   and version    = 1002000200
   and xmltag     = 'DVPS_REALM_T'
   and udt        = 'KU$_DV_REALM_T'
   and schema     = 'DVSYS'
   and viewname   = 'KU$_DV_REALM_VIEW';

delete from metaview$ 
 where type       = 'DVPS_REALM_MEMBERSHIP'
   and flags      = 0 
   and properties = 0
   and model      = 'ORACLE'
   and version    = 1002000200
   and xmltag     = 'DVPS_REALM_MEMBERSHIP_T'
   and udt        = 'KU$_DV_REALM_MEMBER_T'
   and schema     = 'DVSYS'
   and viewname   = 'KU$_DV_REALM_MEMBER_VIEW';

delete from metaview$ 
 where type       = 'DVPS_REALM_AUTHORIZATION'
   and flags      = 0 
   and properties = 0
   and model      = 'ORACLE'
   and version    = 1002000200
   and xmltag     = 'DVPS_REALM_AUTHORIZATION_T'
   and udt        = 'KU$_DV_REALM_AUTH_T'
   and schema     = 'DVSYS'
   and viewname   = 'KU$_DV_REALM_AUTH_VIEW';

delete from metaview$ 
 where type       = 'DVPS_IMPORT_STAGING_REALM'
   and flags      = 0 
   and properties = 0
   and model      = 'ORACLE'
   and version    = 1002000200
   and xmltag     = 'DVPS_IMPORT_STAGING_REALM_T'
   and udt        = 'KU$_DV_ISR_T'
   and schema     = 'DVSYS'
   and viewname   = 'KU$_DV_ISR_VIEW';

delete from metaview$ 
 where type       = 'DVPS_STAGING_REALM_MEMBERSHIP'
   and flags      = 0 
   and properties = 0
   and model      = 'ORACLE'
   and version    = 1002000200
   and xmltag     = 'DVPS_STAGING_REALM_MEMBERSHP_T'
   and udt        = 'KU$_DV_ISRM_T'
   and schema     = 'DVSYS'
   and viewname   = 'KU$_DV_ISRM_VIEW';

delete from metaview$ 
 where type       = 'DVPS_DROP_IMPORT_STAGING_REALM'
   and flags      = 0 
   and properties = 0
   and model      = 'ORACLE'
   and version    = 1002000200
   and xmltag     = 'DVPS_DISR_T'
   and udt        = 'KU$_DV_ISR_T'
   and schema     = 'DVSYS'
   and viewname   = 'KU$_DV_ISR_VIEW';

delete from metaview$ 
 where type       = 'DVPS_RULE'
   and flags      = 0 
   and properties = 0
   and model      = 'ORACLE'
   and version    = 1002000200
   and xmltag     = 'DVPS_RULE_T'
   and udt        = 'KU$_DV_RULE_T'
   and schema     = 'DVSYS'
   and viewname   = 'KU$_DV_RULE_VIEW';

delete from metaview$ 
 where type       = 'DVPS_RULE_SET'
   and flags      = 0 
   and properties = 0
   and model      = 'ORACLE'
   and version    = 1002000200
   and xmltag     = 'DVPS_RULE_SET_T'
   and udt        = 'KU$_DV_RULE_SET_T'
   and schema     = 'DVSYS'
   and viewname   = 'KU$_DV_RULE_SET_VIEW';

delete from metaview$ 
 where type       = 'DVPS_RULE_SET_MEMBERSHIP'
   and flags      = 0 
   and properties = 0
   and model      = 'ORACLE'
   and version    = 1002000200
   and xmltag     = 'DVPS_RULE_SET_MEMBERSHIP_T'
   and udt        = 'KU$_DV_RULE_SET_MEMBER_T'
   and schema     = 'DVSYS'
   and viewname   = 'KU$_DV_RULE_SET_MEMBER_VIEW';

delete from metaview$ 
 where type       = 'DVPS_COMMAND_RULE'
   and flags      = 0 
   and properties = 0
   and model      = 'ORACLE'
   and version    = 1002000200
   and xmltag     = 'DVPS_COMMAND_RULE_T'
   and udt        = 'KU$_DV_COMMAND_RULE_T'
   and schema     = 'DVSYS'
   and viewname   = 'KU$_DV_COMMAND_RULE_VIEW';

delete from metaview$ 
 where type       = 'DVPS_ROLE'
   and flags      = 0 
   and properties = 0
   and model      = 'ORACLE'
   and version    = 1002000200
   and xmltag     = 'DVPS_ROLE_T'
   and udt        = 'KU$_DV_ROLE_T'
   and schema     = 'DVSYS'
   and viewname   = 'KU$_DV_ROLE_VIEW';

delete from metaview$ 
 where type       = 'DVPS_FACTOR'
   and flags      = 0 
   and properties = 0
   and model      = 'ORACLE'
   and version    = 1002000200
   and xmltag     = 'DVPS_FACTOR_T'
   and udt        = 'KU$_DV_FACTOR_T'
   and schema     = 'DVSYS'
   and viewname   = 'KU$_DV_FACTOR_VIEW';

delete from metaview$ 
 where type       = 'DVPS_FACTOR_LINK'
   and flags      = 0 
   and properties = 0
   and model      = 'ORACLE'
   and version    = 1002000200
   and xmltag     = 'DVPS_FACTOR_LINK_T'
   and udt        = 'KU$_DV_FACTOR_LINK_T'
   and schema     = 'DVSYS'
   and viewname   = 'KU$_DV_FACTOR_LINK_VIEW';

delete from metaview$ 
 where type       = 'DVPS_FACTOR_TYPE'
   and flags      = 0 
   and properties = 0
   and model      = 'ORACLE'
   and version    = 1002000200
   and xmltag     = 'DVPS_FACTOR_TYPE_T'
   and udt        = 'KU$_DV_FACTOR_TYPE_T'
   and schema     = 'DVSYS'
   and viewname   = 'KU$_DV_FACTOR_TYPE_VIEW';

delete from metaview$ 
 where type       = 'DVPS_IDENTITY'
   and flags      = 0 
   and properties = 0
   and model      = 'ORACLE'
   and version    = 1002000200
   and xmltag     = 'DVPS_IDENTITY_T'
   and udt        = 'KU$_DV_IDENTITY_T'
   and schema     = 'DVSYS'
   and viewname   = 'KU$_DV_IDENTITY_VIEW';

delete from metaview$ 
 where type       = 'DVPS_IDENTITY_MAP'
   and flags      = 0 
   and properties = 0
   and model      = 'ORACLE'
   and version    = 1002000200
   and xmltag     = 'DVPS_IDENTITY_MAP_T'
   and udt        = 'KU$_DV_IDENTITY_MAP_T'
   and schema     = 'DVSYS'
   and viewname   = 'KU$_DV_IDENTITY_MAP_VIEW';


--delete rules both seeded and customer-created

declare
cursor rcur is
  select r.id# from dvsys.rule$ r,
                    dvsys.rule_set_rule$ rsr;
begin
  for iter in rcur loop
    delete from dvsys.rule_set_rule$ where rule_id# = iter.id#;
    delete from dvsys.rule$ where id# = iter.id#;  
  end loop;
   EXCEPTION
   WHEN OTHERS THEN
     IF SQLCODE IN ( -24147) THEN NULL; --object has already been deleted
     ELSE RAISE;
     END IF;
end;
/

--Sync Rules after deleting.
exec DVSYS.dbms_macadm.sync_rules;

--
-- DROP the Database Vault Roles
-- Drop the roles automatically drops all the grants
--

DROP ROLE dv_secanalyst;
DROP ROLE dv_admin;
DROP ROLE dv_owner;
DROP ROLE dv_acctmgr;
DROP ROLE dv_public;
DROP ROLE dv_monitor;
DROP ROLE dv_patch_admin;
DROP ROLE dv_streams_admin;

DROP ROLE dv_realm_resource;
DROP ROLE dv_realm_owner;

--
-- Restore all the privilege revoked by Database Vault as part of hardening
--

GRANT BECOME USER TO DBA;
GRANT BECOME USER TO IMP_FULL_DATABASE;
GRANT SELECT ANY TRANSACTION TO DBA;
GRANT EXECUTE ON DBMS_LOGMNR TO EXECUTE_CATALOG_ROLE;
GRANT EXECUTE ON DBMS_LOGMNR_D TO EXECUTE_CATALOG_ROLE;
GRANT EXECUTE ON DBMS_LOGMNR_LOGREP_DICT TO EXECUTE_CATALOG_ROLE;
GRANT EXECUTE ON DBMS_LOGMNR_SESSION TO EXECUTE_CATALOG_ROLE;
GRANT EXECUTE ON DBMS_FILE_TRANSFER TO EXECUTE_CATALOG_ROLE;
GRANT EXECUTE ON UTL_FILE TO PUBLIC;
GRANT CREATE ANY JOB TO DBA;
GRANT CREATE ANY JOB TO SCHEDULER_ADMIN;
GRANT CREATE EXTERNAL JOB TO DBA;
GRANT CREATE EXTERNAL JOB TO SCHEDULER_ADMIN;
GRANT EXECUTE ANY PROGRAM TO DBA;
GRANT EXECUTE ANY PROGRAM TO SCHEDULER_ADMIN;
GRANT EXECUTE ANY CLASS TO DBA;
GRANT EXECUTE ANY CLASS TO SCHEDULER_ADMIN;
GRANT MANAGE SCHEDULER TO DBA;
GRANT MANAGE SCHEDULER TO SCHEDULER_ADMIN;
GRANT DEQUEUE ANY QUEUE TO DBA;
GRANT ENQUEUE ANY QUEUE TO DBA;
GRANT MANAGE ANY QUEUE TO DBA;
GRANT MANAGE ANY QUEUE TO IMP_FULL_DATABASE;

--
-- Drop the DVSYS and DVF schema
--

DROP user DVSYS CASCADE;
DROP user DVF CASCADE;  

--
-- Nasty Cleanup Auditing added as part of Database Vault ha
--

NOAUDIT EXECUTE ON LBACSYS.BIN_TO_RAW WHENEVER NOT SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.BIN_TO_RAW WHENEVER SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.BIN_TO_RAW WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.BIN_TO_RAW WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.BIN_TO_RAW WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.BIN_TO_RAW WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.BIN_TO_RAW WHENEVER NOT SUCCESSFUL;
NOAUDIT EXECUTE ON LBACSYS.FROM_BIN_LABEL WHENEVER NOT SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.FROM_BIN_LABEL WHENEVER SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.FROM_BIN_LABEL WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.FROM_BIN_LABEL WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.FROM_BIN_LABEL WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.FROM_BIN_LABEL WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.FROM_BIN_LABEL WHENEVER NOT SUCCESSFUL;
NOAUDIT EXECUTE ON LBACSYS.FROM_INTERNAL_LABEL WHENEVER NOT SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.FROM_INTERNAL_LABEL WHENEVER SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.FROM_INTERNAL_LABEL WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.FROM_INTERNAL_LABEL WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.FROM_INTERNAL_LABEL WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.FROM_INTERNAL_LABEL WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.FROM_INTERNAL_LABEL WHENEVER NOT SUCCESSFUL;
NOAUDIT EXECUTE ON LBACSYS.LABELNAMES_TO_CHAR WHENEVER NOT SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.LABELNAMES_TO_CHAR WHENEVER SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.LABELNAMES_TO_CHAR WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.LABELNAMES_TO_CHAR WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.LABELNAMES_TO_CHAR WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.LABELNAMES_TO_CHAR WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.LABELNAMES_TO_CHAR WHENEVER NOT SUCCESSFUL;
NOAUDIT EXECUTE ON LBACSYS.LABEL_LIST_TO_CHAR WHENEVER NOT SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.LABEL_LIST_TO_CHAR WHENEVER SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.LABEL_LIST_TO_CHAR WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.LABEL_LIST_TO_CHAR WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.LABEL_LIST_TO_CHAR WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.LABEL_LIST_TO_CHAR WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.LABEL_LIST_TO_CHAR WHENEVER NOT SUCCESSFUL;
NOAUDIT EXECUTE ON LBACSYS.LABEL_LIST_TO_NAMED_CHAR WHENEVER NOT SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.LABEL_LIST_TO_NAMED_CHAR WHENEVER SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.LABEL_LIST_TO_NAMED_CHAR WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.LABEL_LIST_TO_NAMED_CHAR WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.LABEL_LIST_TO_NAMED_CHAR WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.LABEL_LIST_TO_NAMED_CHAR WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.LABEL_LIST_TO_NAMED_CHAR WHENEVER NOT SUCCESSFUL;
NOAUDIT EXECUTE ON LBACSYS.LBAC_DOMINATED_BY WHENEVER NOT SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.LBAC_DOMINATED_BY WHENEVER SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.LBAC_DOMINATED_BY WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.LBAC_DOMINATED_BY WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.LBAC_DOMINATED_BY WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.LBAC_DOMINATED_BY WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.LBAC_DOMINATED_BY WHENEVER NOT SUCCESSFUL;
NOAUDIT EXECUTE ON LBACSYS.LBAC_DOMINATES WHENEVER NOT SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.LBAC_DOMINATES WHENEVER SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.LBAC_DOMINATES WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.LBAC_DOMINATES WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.LBAC_DOMINATES WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.LBAC_DOMINATES WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.LBAC_DOMINATES WHENEVER NOT SUCCESSFUL;
NOAUDIT EXECUTE ON LBACSYS.LBAC_GREATEST_LBOUND WHENEVER NOT SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.LBAC_GREATEST_LBOUND WHENEVER SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.LBAC_GREATEST_LBOUND WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.LBAC_GREATEST_LBOUND WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.LBAC_GREATEST_LBOUND WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.LBAC_GREATEST_LBOUND WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.LBAC_GREATEST_LBOUND WHENEVER NOT SUCCESSFUL;
NOAUDIT EXECUTE ON LBACSYS.LBAC_LABEL_TAGSEQ_TO_CHAR WHENEVER NOT SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.LBAC_LABEL_TAGSEQ_TO_CHAR WHENEVER SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.LBAC_LABEL_TAGSEQ_TO_CHAR WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.LBAC_LABEL_TAGSEQ_TO_CHAR WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.LBAC_LABEL_TAGSEQ_TO_CHAR WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.LBAC_LABEL_TAGSEQ_TO_CHAR WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.LBAC_LABEL_TAGSEQ_TO_CHAR WHENEVER NOT SUCCESSFUL;
NOAUDIT EXECUTE ON LBACSYS.LBAC_LABEL_TO_CHAR WHENEVER NOT SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.LBAC_LABEL_TO_CHAR WHENEVER SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.LBAC_LABEL_TO_CHAR WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.LBAC_LABEL_TO_CHAR WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.LBAC_LABEL_TO_CHAR WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.LBAC_LABEL_TO_CHAR WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.LBAC_LABEL_TO_CHAR WHENEVER NOT SUCCESSFUL;
NOAUDIT EXECUTE ON LBACSYS.LBAC_LABEL_TO_NUMERIC WHENEVER NOT SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.LBAC_LABEL_TO_NUMERIC WHENEVER SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.LBAC_LABEL_TO_NUMERIC WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.LBAC_LABEL_TO_NUMERIC WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.LBAC_LABEL_TO_NUMERIC WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.LBAC_LABEL_TO_NUMERIC WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.LBAC_LABEL_TO_NUMERIC WHENEVER NOT SUCCESSFUL;
NOAUDIT EXECUTE ON LBACSYS.LBAC_LEAST_UBOUND WHENEVER NOT SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.LBAC_LEAST_UBOUND WHENEVER SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.LBAC_LEAST_UBOUND WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.LBAC_LEAST_UBOUND WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.LBAC_LEAST_UBOUND WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.LBAC_LEAST_UBOUND WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.LBAC_LEAST_UBOUND WHENEVER NOT SUCCESSFUL;
NOAUDIT EXECUTE ON LBACSYS.LBAC_MERGE_LABEL WHENEVER NOT SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.LBAC_MERGE_LABEL WHENEVER SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.LBAC_MERGE_LABEL WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.LBAC_MERGE_LABEL WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.LBAC_MERGE_LABEL WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.LBAC_MERGE_LABEL WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.LBAC_MERGE_LABEL WHENEVER NOT SUCCESSFUL;
NOAUDIT EXECUTE ON LBACSYS.LBAC_STRICTLY_DOMINATED_BY WHENEVER NOT SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.LBAC_STRICTLY_DOMINATED_BY WHENEVER SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.LBAC_STRICTLY_DOMINATED_BY WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.LBAC_STRICTLY_DOMINATED_BY WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.LBAC_STRICTLY_DOMINATED_BY WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.LBAC_STRICTLY_DOMINATED_BY WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.LBAC_STRICTLY_DOMINATED_BY WHENEVER NOT SUCCESSFUL;
NOAUDIT EXECUTE ON LBACSYS.LBAC_STRICTLY_DOMINATES WHENEVER NOT SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.LBAC_STRICTLY_DOMINATES WHENEVER SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.LBAC_STRICTLY_DOMINATES WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.LBAC_STRICTLY_DOMINATES WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.LBAC_STRICTLY_DOMINATES WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.LBAC_STRICTLY_DOMINATES WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.LBAC_STRICTLY_DOMINATES WHENEVER NOT SUCCESSFUL;
NOAUDIT EXECUTE ON LBACSYS.NUMERIC_DOMINATED_BY WHENEVER NOT SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.NUMERIC_DOMINATED_BY WHENEVER SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.NUMERIC_DOMINATED_BY WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.NUMERIC_DOMINATED_BY WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.NUMERIC_DOMINATED_BY WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.NUMERIC_DOMINATED_BY WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.NUMERIC_DOMINATED_BY WHENEVER NOT SUCCESSFUL;
NOAUDIT EXECUTE ON LBACSYS.NUMERIC_DOMINATES WHENEVER NOT SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.NUMERIC_DOMINATES WHENEVER SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.NUMERIC_DOMINATES WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.NUMERIC_DOMINATES WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.NUMERIC_DOMINATES WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.NUMERIC_DOMINATES WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.NUMERIC_DOMINATES WHENEVER NOT SUCCESSFUL;
NOAUDIT EXECUTE ON LBACSYS.NUMERIC_GREATEST_LBOUND WHENEVER NOT SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.NUMERIC_GREATEST_LBOUND WHENEVER SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.NUMERIC_GREATEST_LBOUND WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.NUMERIC_GREATEST_LBOUND WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.NUMERIC_GREATEST_LBOUND WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.NUMERIC_GREATEST_LBOUND WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.NUMERIC_GREATEST_LBOUND WHENEVER NOT SUCCESSFUL;
NOAUDIT EXECUTE ON LBACSYS.NUMERIC_LABEL_TAGSEQ_TO_CHAR WHENEVER NOT SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.NUMERIC_LABEL_TAGSEQ_TO_CHAR WHENEVER SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.NUMERIC_LABEL_TAGSEQ_TO_CHAR WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.NUMERIC_LABEL_TAGSEQ_TO_CHAR WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.NUMERIC_LABEL_TAGSEQ_TO_CHAR WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.NUMERIC_LABEL_TAGSEQ_TO_CHAR WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.NUMERIC_LABEL_TAGSEQ_TO_CHAR WHENEVER NOT SUCCESSFUL;
NOAUDIT EXECUTE ON LBACSYS.NUMERIC_LABEL_TO_CHAR WHENEVER NOT SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.NUMERIC_LABEL_TO_CHAR WHENEVER SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.NUMERIC_LABEL_TO_CHAR WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.NUMERIC_LABEL_TO_CHAR WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.NUMERIC_LABEL_TO_CHAR WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.NUMERIC_LABEL_TO_CHAR WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.NUMERIC_LABEL_TO_CHAR WHENEVER NOT SUCCESSFUL;
NOAUDIT EXECUTE ON LBACSYS.NUMERIC_LABEL_TO_LBAC WHENEVER NOT SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.NUMERIC_LABEL_TO_LBAC WHENEVER SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.NUMERIC_LABEL_TO_LBAC WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.NUMERIC_LABEL_TO_LBAC WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.NUMERIC_LABEL_TO_LBAC WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.NUMERIC_LABEL_TO_LBAC WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.NUMERIC_LABEL_TO_LBAC WHENEVER NOT SUCCESSFUL;
NOAUDIT EXECUTE ON LBACSYS.NUMERIC_LEAST_UBOUND WHENEVER NOT SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.NUMERIC_LEAST_UBOUND WHENEVER SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.NUMERIC_LEAST_UBOUND WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.NUMERIC_LEAST_UBOUND WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.NUMERIC_LEAST_UBOUND WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.NUMERIC_LEAST_UBOUND WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.NUMERIC_LEAST_UBOUND WHENEVER NOT SUCCESSFUL;
NOAUDIT EXECUTE ON LBACSYS.NUMERIC_MERGE_LABEL WHENEVER NOT SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.NUMERIC_MERGE_LABEL WHENEVER SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.NUMERIC_MERGE_LABEL WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.NUMERIC_MERGE_LABEL WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.NUMERIC_MERGE_LABEL WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.NUMERIC_MERGE_LABEL WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.NUMERIC_MERGE_LABEL WHENEVER NOT SUCCESSFUL;
NOAUDIT EXECUTE ON LBACSYS.NUMERIC_STRICTLY_DOMINATED_BY WHENEVER NOT SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.NUMERIC_STRICTLY_DOMINATED_BY WHENEVER SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.NUMERIC_STRICTLY_DOMINATED_BY WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.NUMERIC_STRICTLY_DOMINATED_BY WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.NUMERIC_STRICTLY_DOMINATED_BY WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.NUMERIC_STRICTLY_DOMINATED_BY WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.NUMERIC_STRICTLY_DOMINATED_BY WHENEVER NOT SUCCESSFUL;
NOAUDIT EXECUTE ON LBACSYS.NUMERIC_STRICTLY_DOMINATES WHENEVER NOT SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.NUMERIC_STRICTLY_DOMINATES WHENEVER SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.NUMERIC_STRICTLY_DOMINATES WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.NUMERIC_STRICTLY_DOMINATES WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.NUMERIC_STRICTLY_DOMINATES WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.NUMERIC_STRICTLY_DOMINATES WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.NUMERIC_STRICTLY_DOMINATES WHENEVER NOT SUCCESSFUL;
NOAUDIT EXECUTE ON LBACSYS.PRIVS_TO_CHAR WHENEVER NOT SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.PRIVS_TO_CHAR WHENEVER SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.PRIVS_TO_CHAR WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.PRIVS_TO_CHAR WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.PRIVS_TO_CHAR WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.PRIVS_TO_CHAR WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.PRIVS_TO_CHAR WHENEVER NOT SUCCESSFUL;
NOAUDIT EXECUTE ON LBACSYS.TO_BIN_LABEL WHENEVER NOT SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.TO_BIN_LABEL WHENEVER SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.TO_BIN_LABEL WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.TO_BIN_LABEL WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.TO_BIN_LABEL WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.TO_BIN_LABEL WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.TO_BIN_LABEL WHENEVER NOT SUCCESSFUL;
NOAUDIT EXECUTE ON LBACSYS.TO_INTERNAL_LABEL WHENEVER NOT SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.TO_INTERNAL_LABEL WHENEVER SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.TO_INTERNAL_LABEL WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.TO_INTERNAL_LABEL WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.TO_INTERNAL_LABEL WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.TO_INTERNAL_LABEL WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.TO_INTERNAL_LABEL WHENEVER NOT SUCCESSFUL;
NOAUDIT EXECUTE ON LBACSYS.TO_LBAC_DATA_LABEL WHENEVER NOT SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.TO_LBAC_DATA_LABEL WHENEVER SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.TO_LBAC_DATA_LABEL WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.TO_LBAC_DATA_LABEL WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.TO_LBAC_DATA_LABEL WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.TO_LBAC_DATA_LABEL WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.TO_LBAC_DATA_LABEL WHENEVER NOT SUCCESSFUL;
NOAUDIT EXECUTE ON LBACSYS.TO_LBAC_LABEL WHENEVER NOT SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.TO_LBAC_LABEL WHENEVER SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.TO_LBAC_LABEL WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.TO_LBAC_LABEL WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.TO_LBAC_LABEL WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.TO_LBAC_LABEL WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.TO_LBAC_LABEL WHENEVER NOT SUCCESSFUL;
NOAUDIT EXECUTE ON LBACSYS.TO_NUMERIC_DATA_LABEL WHENEVER NOT SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.TO_NUMERIC_DATA_LABEL WHENEVER SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.TO_NUMERIC_DATA_LABEL WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.TO_NUMERIC_DATA_LABEL WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.TO_NUMERIC_DATA_LABEL WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.TO_NUMERIC_DATA_LABEL WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.TO_NUMERIC_DATA_LABEL WHENEVER NOT SUCCESSFUL;
NOAUDIT EXECUTE ON LBACSYS.TO_NUMERIC_LABEL WHENEVER NOT SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.TO_NUMERIC_LABEL WHENEVER SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.TO_NUMERIC_LABEL WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.TO_NUMERIC_LABEL WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.TO_NUMERIC_LABEL WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.TO_NUMERIC_LABEL WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.TO_NUMERIC_LABEL WHENEVER NOT SUCCESSFUL;
NOAUDIT EXECUTE ON LBACSYS.TO_PRIVS WHENEVER NOT SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.TO_PRIVS WHENEVER SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.TO_PRIVS WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.TO_PRIVS WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.TO_PRIVS WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.TO_PRIVS WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.TO_PRIVS WHENEVER NOT SUCCESSFUL;
NOAUDIT EXECUTE ON LBACSYS.LBAC_BIN_LABEL WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.LBAC_BIN_LABEL WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.LBAC_BIN_LABEL WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.LBAC_BIN_LABEL WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.LBAC_BIN_LABEL WHENEVER NOT SUCCESSFUL;
NOAUDIT ALTER ON LBACSYS.LBAC_BIN_LABEL WHENEVER SUCCESSFUL;
NOAUDIT ALTER ON LBACSYS.LBAC_BIN_LABEL WHENEVER NOT SUCCESSFUL;
NOAUDIT EXECUTE ON LBACSYS.LBAC_COMPS WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.LBAC_COMPS WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.LBAC_COMPS WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.LBAC_COMPS WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.LBAC_COMPS WHENEVER NOT SUCCESSFUL;
NOAUDIT ALTER ON LBACSYS.LBAC_COMPS WHENEVER SUCCESSFUL;
NOAUDIT ALTER ON LBACSYS.LBAC_COMPS WHENEVER NOT SUCCESSFUL;
NOAUDIT EXECUTE ON LBACSYS.LBAC_LABEL WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.LBAC_LABEL WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.LBAC_LABEL WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.LBAC_LABEL WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.LBAC_LABEL WHENEVER NOT SUCCESSFUL;
NOAUDIT ALTER ON LBACSYS.LBAC_LABEL WHENEVER SUCCESSFUL;
NOAUDIT ALTER ON LBACSYS.LBAC_LABEL WHENEVER NOT SUCCESSFUL;
NOAUDIT EXECUTE ON LBACSYS.LBAC_LABEL_LIST WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.LBAC_LABEL_LIST WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.LBAC_LABEL_LIST WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.LBAC_LABEL_LIST WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.LBAC_LABEL_LIST WHENEVER NOT SUCCESSFUL;
NOAUDIT ALTER ON LBACSYS.LBAC_LABEL_LIST WHENEVER SUCCESSFUL;
NOAUDIT ALTER ON LBACSYS.LBAC_LABEL_LIST WHENEVER NOT SUCCESSFUL;
NOAUDIT EXECUTE ON LBACSYS.LBAC_NAME_LIST WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.LBAC_NAME_LIST WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.LBAC_NAME_LIST WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.LBAC_NAME_LIST WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.LBAC_NAME_LIST WHENEVER NOT SUCCESSFUL;
NOAUDIT ALTER ON LBACSYS.LBAC_NAME_LIST WHENEVER SUCCESSFUL;
NOAUDIT ALTER ON LBACSYS.LBAC_NAME_LIST WHENEVER NOT SUCCESSFUL;
NOAUDIT EXECUTE ON LBACSYS.LBAC_PRIVS WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.LBAC_PRIVS WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.LBAC_PRIVS WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.LBAC_PRIVS WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.LBAC_PRIVS WHENEVER NOT SUCCESSFUL;
NOAUDIT ALTER ON LBACSYS.LBAC_PRIVS WHENEVER SUCCESSFUL;
NOAUDIT ALTER ON LBACSYS.LBAC_PRIVS WHENEVER NOT SUCCESSFUL;
NOAUDIT EXECUTE ON LBACSYS.LDAP_ATTR WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.LDAP_ATTR WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.LDAP_ATTR WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.LDAP_ATTR WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.LDAP_ATTR WHENEVER NOT SUCCESSFUL;
NOAUDIT ALTER ON LBACSYS.LDAP_ATTR WHENEVER SUCCESSFUL;
NOAUDIT ALTER ON LBACSYS.LDAP_ATTR WHENEVER NOT SUCCESSFUL;
NOAUDIT EXECUTE ON LBACSYS.LDAP_ATTR_LIST WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.LDAP_ATTR_LIST WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.LDAP_ATTR_LIST WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.LDAP_ATTR_LIST WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.LDAP_ATTR_LIST WHENEVER NOT SUCCESSFUL;
NOAUDIT ALTER ON LBACSYS.LDAP_ATTR_LIST WHENEVER SUCCESSFUL;
NOAUDIT ALTER ON LBACSYS.LDAP_ATTR_LIST WHENEVER NOT SUCCESSFUL;
NOAUDIT EXECUTE ON LBACSYS.LDAP_EVENT WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.LDAP_EVENT WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.LDAP_EVENT WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.LDAP_EVENT WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.LDAP_EVENT WHENEVER NOT SUCCESSFUL;
NOAUDIT ALTER ON LBACSYS.LDAP_EVENT WHENEVER SUCCESSFUL;
NOAUDIT ALTER ON LBACSYS.LDAP_EVENT WHENEVER NOT SUCCESSFUL;
NOAUDIT EXECUTE ON LBACSYS.LDAP_EVENT_STATUS WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.LDAP_EVENT_STATUS WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.LDAP_EVENT_STATUS WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.LDAP_EVENT_STATUS WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.LDAP_EVENT_STATUS WHENEVER NOT SUCCESSFUL;
NOAUDIT ALTER ON LBACSYS.LDAP_EVENT_STATUS WHENEVER SUCCESSFUL;
NOAUDIT ALTER ON LBACSYS.LDAP_EVENT_STATUS WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.LBAC$LAB_SEQUENCE WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.LBAC$LAB_SEQUENCE WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.LBAC$LAB_SEQUENCE WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.LBAC$LAB_SEQUENCE WHENEVER NOT SUCCESSFUL;
NOAUDIT ALTER ON LBACSYS.LBAC$LAB_SEQUENCE WHENEVER SUCCESSFUL;
NOAUDIT ALTER ON LBACSYS.LBAC$LAB_SEQUENCE WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.LBAC$TAG_SEQUENCE WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.LBAC$TAG_SEQUENCE WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.LBAC$TAG_SEQUENCE WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.LBAC$TAG_SEQUENCE WHENEVER NOT SUCCESSFUL;
NOAUDIT ALTER ON LBACSYS.LBAC$TAG_SEQUENCE WHENEVER SUCCESSFUL;
NOAUDIT ALTER ON LBACSYS.LBAC$TAG_SEQUENCE WHENEVER NOT SUCCESSFUL;
NOAUDIT EXECUTE ON LBACSYS.SA_POLICY_GRANT WHENEVER NOT SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.SA_POLICY_GRANT WHENEVER SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.SA_POLICY_GRANT WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.SA_POLICY_GRANT WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.SA_POLICY_GRANT WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.SA_POLICY_GRANT WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.SA_POLICY_GRANT WHENEVER NOT SUCCESSFUL;
NOAUDIT EXECUTE ON LBACSYS.LBAC_FRAME_GRANT WHENEVER NOT SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.LBAC_FRAME_GRANT WHENEVER SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.LBAC_FRAME_GRANT WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.LBAC_FRAME_GRANT WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.LBAC_FRAME_GRANT WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.LBAC_FRAME_GRANT WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.LBAC_FRAME_GRANT WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.LBAC$CACHE_LIBT WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.LBAC$CACHE_LIBT WHENEVER NOT SUCCESSFUL;
NOAUDIT EXECUTE ON LBACSYS.LBAC$CACHE_LIBT WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.LBAC$COMPS_LIBT WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.LBAC$COMPS_LIBT WHENEVER NOT SUCCESSFUL;
NOAUDIT EXECUTE ON LBACSYS.LBAC$COMPS_LIBT WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.LBAC$EVENT_LIBT WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.LBAC$EVENT_LIBT WHENEVER NOT SUCCESSFUL;
NOAUDIT EXECUTE ON LBACSYS.LBAC$EVENT_LIBT WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.LBAC$LABEL_LIBT WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.LBAC$LABEL_LIBT WHENEVER NOT SUCCESSFUL;
NOAUDIT EXECUTE ON LBACSYS.LBAC$LABEL_LIBT WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.LBAC$LABLT_LIBT WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.LBAC$LABLT_LIBT WHENEVER NOT SUCCESSFUL;
NOAUDIT EXECUTE ON LBACSYS.LBAC$LABLT_LIBT WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.LBAC$PRIVS_LIBT WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.LBAC$PRIVS_LIBT WHENEVER NOT SUCCESSFUL;
NOAUDIT EXECUTE ON LBACSYS.LBAC$PRIVS_LIBT WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.LBAC$STD_LIBT WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.LBAC$STD_LIBT WHENEVER NOT SUCCESSFUL;
NOAUDIT EXECUTE ON LBACSYS.LBAC$STD_LIBT WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.LBAC$TYPE_LIBT WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.LBAC$TYPE_LIBT WHENEVER NOT SUCCESSFUL;
NOAUDIT EXECUTE ON LBACSYS.LBAC$TYPE_LIBT WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.LBAC$USER_LIBT WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.LBAC$USER_LIBT WHENEVER NOT SUCCESSFUL;
NOAUDIT EXECUTE ON LBACSYS.LBAC$USER_LIBT WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.SECURE_CONTEXT_LIB WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.SECURE_CONTEXT_LIB WHENEVER NOT SUCCESSFUL;
NOAUDIT EXECUTE ON LBACSYS.SECURE_CONTEXT_LIB WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.LBAC$SA_LABELS WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.LBAC$SA_LABELS WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.LBAC$SA_LABELS WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.LBAC$SA_LABELS WHENEVER NOT SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.LBAC$SA_LABELS WHENEVER SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.LBAC$SA_LABELS WHENEVER NOT SUCCESSFUL;
NOAUDIT EXECUTE ON LBACSYS.LBAC$SA_LABELS WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.LBAC$SA WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.LBAC$SA WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.LBAC$SA WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.LBAC$SA WHENEVER NOT SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.LBAC$SA WHENEVER SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.LBAC$SA WHENEVER NOT SUCCESSFUL;
NOAUDIT EXECUTE ON LBACSYS.LBAC$SA WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.LBAC_AUDIT_ADMIN WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.LBAC_AUDIT_ADMIN WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.LBAC_AUDIT_ADMIN WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.LBAC_AUDIT_ADMIN WHENEVER NOT SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.LBAC_AUDIT_ADMIN WHENEVER SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.LBAC_AUDIT_ADMIN WHENEVER NOT SUCCESSFUL;
NOAUDIT EXECUTE ON LBACSYS.LBAC_AUDIT_ADMIN WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.LBAC_CACHE WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.LBAC_CACHE WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.LBAC_CACHE WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.LBAC_CACHE WHENEVER NOT SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.LBAC_CACHE WHENEVER SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.LBAC_CACHE WHENEVER NOT SUCCESSFUL;
NOAUDIT EXECUTE ON LBACSYS.LBAC_CACHE WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.LBAC_COMPARE WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.LBAC_COMPARE WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.LBAC_COMPARE WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.LBAC_COMPARE WHENEVER NOT SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.LBAC_COMPARE WHENEVER SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.LBAC_COMPARE WHENEVER NOT SUCCESSFUL;
NOAUDIT EXECUTE ON LBACSYS.LBAC_COMPARE WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.LBAC_ERRORS WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.LBAC_ERRORS WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.LBAC_ERRORS WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.LBAC_ERRORS WHENEVER NOT SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.LBAC_ERRORS WHENEVER SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.LBAC_ERRORS WHENEVER NOT SUCCESSFUL;
NOAUDIT EXECUTE ON LBACSYS.LBAC_ERRORS WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.LBAC_EVENTS WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.LBAC_EVENTS WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.LBAC_EVENTS WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.LBAC_EVENTS WHENEVER NOT SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.LBAC_EVENTS WHENEVER SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.LBAC_EVENTS WHENEVER NOT SUCCESSFUL;
NOAUDIT EXECUTE ON LBACSYS.LBAC_EVENTS WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.LBAC_LABEL_ADMIN WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.LBAC_LABEL_ADMIN WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.LBAC_LABEL_ADMIN WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.LBAC_LABEL_ADMIN WHENEVER NOT SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.LBAC_LABEL_ADMIN WHENEVER SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.LBAC_LABEL_ADMIN WHENEVER NOT SUCCESSFUL;
NOAUDIT EXECUTE ON LBACSYS.LBAC_LABEL_ADMIN WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.LBAC_POLICY_ADMIN WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.LBAC_POLICY_ADMIN WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.LBAC_POLICY_ADMIN WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.LBAC_POLICY_ADMIN WHENEVER NOT SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.LBAC_POLICY_ADMIN WHENEVER SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.LBAC_POLICY_ADMIN WHENEVER NOT SUCCESSFUL;
NOAUDIT EXECUTE ON LBACSYS.LBAC_POLICY_ADMIN WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.LBAC_RLS WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.LBAC_RLS WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.LBAC_RLS WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.LBAC_RLS WHENEVER NOT SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.LBAC_RLS WHENEVER SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.LBAC_RLS WHENEVER NOT SUCCESSFUL;
NOAUDIT EXECUTE ON LBACSYS.LBAC_RLS WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.LBAC_SERVICES WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.LBAC_SERVICES WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.LBAC_SERVICES WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.LBAC_SERVICES WHENEVER NOT SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.LBAC_SERVICES WHENEVER SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.LBAC_SERVICES WHENEVER NOT SUCCESSFUL;
NOAUDIT EXECUTE ON LBACSYS.LBAC_SERVICES WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.LBAC_SESSION WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.LBAC_SESSION WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.LBAC_SESSION WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.LBAC_SESSION WHENEVER NOT SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.LBAC_SESSION WHENEVER SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.LBAC_SESSION WHENEVER NOT SUCCESSFUL;
NOAUDIT EXECUTE ON LBACSYS.LBAC_SESSION WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.LBAC_STANDARD WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.LBAC_STANDARD WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.LBAC_STANDARD WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.LBAC_STANDARD WHENEVER NOT SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.LBAC_STANDARD WHENEVER SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.LBAC_STANDARD WHENEVER NOT SUCCESSFUL;
NOAUDIT EXECUTE ON LBACSYS.LBAC_STANDARD WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.LBAC_SYSDBA WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.LBAC_SYSDBA WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.LBAC_SYSDBA WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.LBAC_SYSDBA WHENEVER NOT SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.LBAC_SYSDBA WHENEVER SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.LBAC_SYSDBA WHENEVER NOT SUCCESSFUL;
NOAUDIT EXECUTE ON LBACSYS.LBAC_SYSDBA WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.LBAC_USER_ADMIN WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.LBAC_USER_ADMIN WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.LBAC_USER_ADMIN WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.LBAC_USER_ADMIN WHENEVER NOT SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.LBAC_USER_ADMIN WHENEVER SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.LBAC_USER_ADMIN WHENEVER NOT SUCCESSFUL;
NOAUDIT EXECUTE ON LBACSYS.LBAC_USER_ADMIN WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.LBAC_UTL WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.LBAC_UTL WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.LBAC_UTL WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.LBAC_UTL WHENEVER NOT SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.LBAC_UTL WHENEVER SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.LBAC_UTL WHENEVER NOT SUCCESSFUL;
NOAUDIT EXECUTE ON LBACSYS.LBAC_UTL WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.OLS_DIP_NTFY WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.OLS_DIP_NTFY WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.OLS_DIP_NTFY WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.OLS_DIP_NTFY WHENEVER NOT SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.OLS_DIP_NTFY WHENEVER SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.OLS_DIP_NTFY WHENEVER NOT SUCCESSFUL;
NOAUDIT EXECUTE ON LBACSYS.OLS_DIP_NTFY WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.SA$CTX WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.SA$CTX WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.SA$CTX WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.SA$CTX WHENEVER NOT SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.SA$CTX WHENEVER SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.SA$CTX WHENEVER NOT SUCCESSFUL;
NOAUDIT EXECUTE ON LBACSYS.SA$CTX WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.SA_COMPONENTS WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.SA_COMPONENTS WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.SA_COMPONENTS WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.SA_COMPONENTS WHENEVER NOT SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.SA_COMPONENTS WHENEVER SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.SA_COMPONENTS WHENEVER NOT SUCCESSFUL;
NOAUDIT EXECUTE ON LBACSYS.SA_COMPONENTS WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.SA_SESSION WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.SA_SESSION WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.SA_SESSION WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.SA_SESSION WHENEVER NOT SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.SA_SESSION WHENEVER SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.SA_SESSION WHENEVER NOT SUCCESSFUL;
NOAUDIT EXECUTE ON LBACSYS.SA_SESSION WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.SA_SYSDBA WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.SA_SYSDBA WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.SA_SYSDBA WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.SA_SYSDBA WHENEVER NOT SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.SA_SYSDBA WHENEVER SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.SA_SYSDBA WHENEVER NOT SUCCESSFUL;
NOAUDIT EXECUTE ON LBACSYS.SA_SYSDBA WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.SA_USER_ADMIN WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.SA_USER_ADMIN WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.SA_USER_ADMIN WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.SA_USER_ADMIN WHENEVER NOT SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.SA_USER_ADMIN WHENEVER SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.SA_USER_ADMIN WHENEVER NOT SUCCESSFUL;
NOAUDIT EXECUTE ON LBACSYS.SA_USER_ADMIN WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.SA_UTL WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.SA_UTL WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.SA_UTL WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.SA_UTL WHENEVER NOT SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.SA_UTL WHENEVER SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.SA_UTL WHENEVER NOT SUCCESSFUL;
NOAUDIT EXECUTE ON LBACSYS.SA_UTL WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.TO_LABEL_LIST WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.TO_LABEL_LIST WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.TO_LABEL_LIST WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.TO_LABEL_LIST WHENEVER NOT SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.TO_LABEL_LIST WHENEVER SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.TO_LABEL_LIST WHENEVER NOT SUCCESSFUL;
NOAUDIT EXECUTE ON LBACSYS.TO_LABEL_LIST WHENEVER NOT SUCCESSFUL;



NOAUDIT SELECT ON LBACSYS.LBAC$LAB_SEQUENCE WHENEVER NOT SUCCESSFUL;
NOAUDIT SELECT ON LBACSYS.LBAC$TAG_SEQUENCE WHENEVER NOT SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.ALL_SA_AUDIT_OPTIONS WHENEVER SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.ALL_SA_AUDIT_OPTIONS WHENEVER NOT SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.ALL_SA_AUDIT_OPTIONS WHENEVER SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.ALL_SA_AUDIT_OPTIONS WHENEVER NOT SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.ALL_SA_AUDIT_OPTIONS WHENEVER SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.ALL_SA_AUDIT_OPTIONS WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.ALL_SA_AUDIT_OPTIONS WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.ALL_SA_AUDIT_OPTIONS WHENEVER NOT SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.ALL_SA_AUDIT_OPTIONS WHENEVER SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.ALL_SA_AUDIT_OPTIONS WHENEVER NOT SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.ALL_SA_AUDIT_OPTIONS WHENEVER SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.ALL_SA_AUDIT_OPTIONS WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.ALL_SA_AUDIT_OPTIONS WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.ALL_SA_AUDIT_OPTIONS WHENEVER NOT SUCCESSFUL;
NOAUDIT SELECT ON LBACSYS.ALL_SA_AUDIT_OPTIONS WHENEVER NOT SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.ALL_SA_COMPARTMENTS WHENEVER SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.ALL_SA_COMPARTMENTS WHENEVER NOT SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.ALL_SA_COMPARTMENTS WHENEVER SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.ALL_SA_COMPARTMENTS WHENEVER NOT SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.ALL_SA_COMPARTMENTS WHENEVER SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.ALL_SA_COMPARTMENTS WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.ALL_SA_COMPARTMENTS WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.ALL_SA_COMPARTMENTS WHENEVER NOT SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.ALL_SA_COMPARTMENTS WHENEVER SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.ALL_SA_COMPARTMENTS WHENEVER NOT SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.ALL_SA_COMPARTMENTS WHENEVER SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.ALL_SA_COMPARTMENTS WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.ALL_SA_COMPARTMENTS WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.ALL_SA_COMPARTMENTS WHENEVER NOT SUCCESSFUL;
NOAUDIT SELECT ON LBACSYS.ALL_SA_COMPARTMENTS WHENEVER NOT SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.ALL_SA_DATA_LABELS WHENEVER SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.ALL_SA_DATA_LABELS WHENEVER NOT SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.ALL_SA_DATA_LABELS WHENEVER SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.ALL_SA_DATA_LABELS WHENEVER NOT SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.ALL_SA_DATA_LABELS WHENEVER SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.ALL_SA_DATA_LABELS WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.ALL_SA_DATA_LABELS WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.ALL_SA_DATA_LABELS WHENEVER NOT SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.ALL_SA_DATA_LABELS WHENEVER SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.ALL_SA_DATA_LABELS WHENEVER NOT SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.ALL_SA_DATA_LABELS WHENEVER SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.ALL_SA_DATA_LABELS WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.ALL_SA_DATA_LABELS WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.ALL_SA_DATA_LABELS WHENEVER NOT SUCCESSFUL;
NOAUDIT SELECT ON LBACSYS.ALL_SA_DATA_LABELS WHENEVER NOT SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.ALL_SA_GROUPS WHENEVER SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.ALL_SA_GROUPS WHENEVER NOT SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.ALL_SA_GROUPS WHENEVER SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.ALL_SA_GROUPS WHENEVER NOT SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.ALL_SA_GROUPS WHENEVER SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.ALL_SA_GROUPS WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.ALL_SA_GROUPS WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.ALL_SA_GROUPS WHENEVER NOT SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.ALL_SA_GROUPS WHENEVER SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.ALL_SA_GROUPS WHENEVER NOT SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.ALL_SA_GROUPS WHENEVER SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.ALL_SA_GROUPS WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.ALL_SA_GROUPS WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.ALL_SA_GROUPS WHENEVER NOT SUCCESSFUL;
NOAUDIT SELECT ON LBACSYS.ALL_SA_GROUPS WHENEVER NOT SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.ALL_SA_GROUP_HIERARCHY WHENEVER SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.ALL_SA_GROUP_HIERARCHY WHENEVER NOT SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.ALL_SA_GROUP_HIERARCHY WHENEVER SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.ALL_SA_GROUP_HIERARCHY WHENEVER NOT SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.ALL_SA_GROUP_HIERARCHY WHENEVER SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.ALL_SA_GROUP_HIERARCHY WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.ALL_SA_GROUP_HIERARCHY WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.ALL_SA_GROUP_HIERARCHY WHENEVER NOT SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.ALL_SA_GROUP_HIERARCHY WHENEVER SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.ALL_SA_GROUP_HIERARCHY WHENEVER NOT SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.ALL_SA_GROUP_HIERARCHY WHENEVER SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.ALL_SA_GROUP_HIERARCHY WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.ALL_SA_GROUP_HIERARCHY WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.ALL_SA_GROUP_HIERARCHY WHENEVER NOT SUCCESSFUL;
NOAUDIT SELECT ON LBACSYS.ALL_SA_GROUP_HIERARCHY WHENEVER NOT SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.ALL_SA_LABELS WHENEVER SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.ALL_SA_LABELS WHENEVER NOT SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.ALL_SA_LABELS WHENEVER SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.ALL_SA_LABELS WHENEVER NOT SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.ALL_SA_LABELS WHENEVER SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.ALL_SA_LABELS WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.ALL_SA_LABELS WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.ALL_SA_LABELS WHENEVER NOT SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.ALL_SA_LABELS WHENEVER SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.ALL_SA_LABELS WHENEVER NOT SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.ALL_SA_LABELS WHENEVER SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.ALL_SA_LABELS WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.ALL_SA_LABELS WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.ALL_SA_LABELS WHENEVER NOT SUCCESSFUL;
NOAUDIT SELECT ON LBACSYS.ALL_SA_LABELS WHENEVER NOT SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.ALL_SA_LEVELS WHENEVER SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.ALL_SA_LEVELS WHENEVER NOT SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.ALL_SA_LEVELS WHENEVER SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.ALL_SA_LEVELS WHENEVER NOT SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.ALL_SA_LEVELS WHENEVER SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.ALL_SA_LEVELS WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.ALL_SA_LEVELS WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.ALL_SA_LEVELS WHENEVER NOT SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.ALL_SA_LEVELS WHENEVER SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.ALL_SA_LEVELS WHENEVER NOT SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.ALL_SA_LEVELS WHENEVER SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.ALL_SA_LEVELS WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.ALL_SA_LEVELS WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.ALL_SA_LEVELS WHENEVER NOT SUCCESSFUL;
NOAUDIT SELECT ON LBACSYS.ALL_SA_LEVELS WHENEVER NOT SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.ALL_SA_POLICIES WHENEVER SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.ALL_SA_POLICIES WHENEVER NOT SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.ALL_SA_POLICIES WHENEVER SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.ALL_SA_POLICIES WHENEVER NOT SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.ALL_SA_POLICIES WHENEVER SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.ALL_SA_POLICIES WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.ALL_SA_POLICIES WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.ALL_SA_POLICIES WHENEVER NOT SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.ALL_SA_POLICIES WHENEVER SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.ALL_SA_POLICIES WHENEVER NOT SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.ALL_SA_POLICIES WHENEVER SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.ALL_SA_POLICIES WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.ALL_SA_POLICIES WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.ALL_SA_POLICIES WHENEVER NOT SUCCESSFUL;
NOAUDIT SELECT ON LBACSYS.ALL_SA_POLICIES WHENEVER NOT SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.ALL_SA_PROGRAMS WHENEVER SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.ALL_SA_PROGRAMS WHENEVER NOT SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.ALL_SA_PROGRAMS WHENEVER SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.ALL_SA_PROGRAMS WHENEVER NOT SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.ALL_SA_PROGRAMS WHENEVER SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.ALL_SA_PROGRAMS WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.ALL_SA_PROGRAMS WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.ALL_SA_PROGRAMS WHENEVER NOT SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.ALL_SA_PROGRAMS WHENEVER SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.ALL_SA_PROGRAMS WHENEVER NOT SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.ALL_SA_PROGRAMS WHENEVER SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.ALL_SA_PROGRAMS WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.ALL_SA_PROGRAMS WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.ALL_SA_PROGRAMS WHENEVER NOT SUCCESSFUL;
NOAUDIT SELECT ON LBACSYS.ALL_SA_PROGRAMS WHENEVER NOT SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.ALL_SA_PROG_PRIVS WHENEVER SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.ALL_SA_PROG_PRIVS WHENEVER NOT SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.ALL_SA_PROG_PRIVS WHENEVER SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.ALL_SA_PROG_PRIVS WHENEVER NOT SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.ALL_SA_PROG_PRIVS WHENEVER SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.ALL_SA_PROG_PRIVS WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.ALL_SA_PROG_PRIVS WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.ALL_SA_PROG_PRIVS WHENEVER NOT SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.ALL_SA_PROG_PRIVS WHENEVER SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.ALL_SA_PROG_PRIVS WHENEVER NOT SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.ALL_SA_PROG_PRIVS WHENEVER SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.ALL_SA_PROG_PRIVS WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.ALL_SA_PROG_PRIVS WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.ALL_SA_PROG_PRIVS WHENEVER NOT SUCCESSFUL;
NOAUDIT SELECT ON LBACSYS.ALL_SA_PROG_PRIVS WHENEVER NOT SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.ALL_SA_SCHEMA_POLICIES WHENEVER SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.ALL_SA_SCHEMA_POLICIES WHENEVER NOT SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.ALL_SA_SCHEMA_POLICIES WHENEVER SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.ALL_SA_SCHEMA_POLICIES WHENEVER NOT SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.ALL_SA_SCHEMA_POLICIES WHENEVER SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.ALL_SA_SCHEMA_POLICIES WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.ALL_SA_SCHEMA_POLICIES WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.ALL_SA_SCHEMA_POLICIES WHENEVER NOT SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.ALL_SA_SCHEMA_POLICIES WHENEVER SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.ALL_SA_SCHEMA_POLICIES WHENEVER NOT SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.ALL_SA_SCHEMA_POLICIES WHENEVER SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.ALL_SA_SCHEMA_POLICIES WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.ALL_SA_SCHEMA_POLICIES WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.ALL_SA_SCHEMA_POLICIES WHENEVER NOT SUCCESSFUL;
NOAUDIT SELECT ON LBACSYS.ALL_SA_SCHEMA_POLICIES WHENEVER NOT SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.ALL_SA_TABLE_POLICIES WHENEVER SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.ALL_SA_TABLE_POLICIES WHENEVER NOT SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.ALL_SA_TABLE_POLICIES WHENEVER SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.ALL_SA_TABLE_POLICIES WHENEVER NOT SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.ALL_SA_TABLE_POLICIES WHENEVER SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.ALL_SA_TABLE_POLICIES WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.ALL_SA_TABLE_POLICIES WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.ALL_SA_TABLE_POLICIES WHENEVER NOT SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.ALL_SA_TABLE_POLICIES WHENEVER SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.ALL_SA_TABLE_POLICIES WHENEVER NOT SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.ALL_SA_TABLE_POLICIES WHENEVER SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.ALL_SA_TABLE_POLICIES WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.ALL_SA_TABLE_POLICIES WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.ALL_SA_TABLE_POLICIES WHENEVER NOT SUCCESSFUL;
NOAUDIT SELECT ON LBACSYS.ALL_SA_TABLE_POLICIES WHENEVER NOT SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.ALL_SA_USERS WHENEVER SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.ALL_SA_USERS WHENEVER NOT SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.ALL_SA_USERS WHENEVER SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.ALL_SA_USERS WHENEVER NOT SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.ALL_SA_USERS WHENEVER SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.ALL_SA_USERS WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.ALL_SA_USERS WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.ALL_SA_USERS WHENEVER NOT SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.ALL_SA_USERS WHENEVER SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.ALL_SA_USERS WHENEVER NOT SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.ALL_SA_USERS WHENEVER SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.ALL_SA_USERS WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.ALL_SA_USERS WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.ALL_SA_USERS WHENEVER NOT SUCCESSFUL;
NOAUDIT SELECT ON LBACSYS.ALL_SA_USERS WHENEVER NOT SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.ALL_SA_USER_COMPARTMENTS WHENEVER SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.ALL_SA_USER_COMPARTMENTS WHENEVER NOT SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.ALL_SA_USER_COMPARTMENTS WHENEVER SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.ALL_SA_USER_COMPARTMENTS WHENEVER NOT SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.ALL_SA_USER_COMPARTMENTS WHENEVER SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.ALL_SA_USER_COMPARTMENTS WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.ALL_SA_USER_COMPARTMENTS WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.ALL_SA_USER_COMPARTMENTS WHENEVER NOT SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.ALL_SA_USER_COMPARTMENTS WHENEVER SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.ALL_SA_USER_COMPARTMENTS WHENEVER NOT SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.ALL_SA_USER_COMPARTMENTS WHENEVER SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.ALL_SA_USER_COMPARTMENTS WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.ALL_SA_USER_COMPARTMENTS WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.ALL_SA_USER_COMPARTMENTS WHENEVER NOT SUCCESSFUL;
NOAUDIT SELECT ON LBACSYS.ALL_SA_USER_COMPARTMENTS WHENEVER NOT SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.ALL_SA_USER_GROUPS WHENEVER SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.ALL_SA_USER_GROUPS WHENEVER NOT SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.ALL_SA_USER_GROUPS WHENEVER SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.ALL_SA_USER_GROUPS WHENEVER NOT SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.ALL_SA_USER_GROUPS WHENEVER SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.ALL_SA_USER_GROUPS WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.ALL_SA_USER_GROUPS WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.ALL_SA_USER_GROUPS WHENEVER NOT SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.ALL_SA_USER_GROUPS WHENEVER SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.ALL_SA_USER_GROUPS WHENEVER NOT SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.ALL_SA_USER_GROUPS WHENEVER SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.ALL_SA_USER_GROUPS WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.ALL_SA_USER_GROUPS WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.ALL_SA_USER_GROUPS WHENEVER NOT SUCCESSFUL;
NOAUDIT SELECT ON LBACSYS.ALL_SA_USER_GROUPS WHENEVER NOT SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.ALL_SA_USER_LABELS WHENEVER SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.ALL_SA_USER_LABELS WHENEVER NOT SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.ALL_SA_USER_LABELS WHENEVER SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.ALL_SA_USER_LABELS WHENEVER NOT SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.ALL_SA_USER_LABELS WHENEVER SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.ALL_SA_USER_LABELS WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.ALL_SA_USER_LABELS WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.ALL_SA_USER_LABELS WHENEVER NOT SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.ALL_SA_USER_LABELS WHENEVER SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.ALL_SA_USER_LABELS WHENEVER NOT SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.ALL_SA_USER_LABELS WHENEVER SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.ALL_SA_USER_LABELS WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.ALL_SA_USER_LABELS WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.ALL_SA_USER_LABELS WHENEVER NOT SUCCESSFUL;
NOAUDIT SELECT ON LBACSYS.ALL_SA_USER_LABELS WHENEVER NOT SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.ALL_SA_USER_LEVELS WHENEVER SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.ALL_SA_USER_LEVELS WHENEVER NOT SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.ALL_SA_USER_LEVELS WHENEVER SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.ALL_SA_USER_LEVELS WHENEVER NOT SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.ALL_SA_USER_LEVELS WHENEVER SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.ALL_SA_USER_LEVELS WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.ALL_SA_USER_LEVELS WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.ALL_SA_USER_LEVELS WHENEVER NOT SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.ALL_SA_USER_LEVELS WHENEVER SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.ALL_SA_USER_LEVELS WHENEVER NOT SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.ALL_SA_USER_LEVELS WHENEVER SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.ALL_SA_USER_LEVELS WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.ALL_SA_USER_LEVELS WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.ALL_SA_USER_LEVELS WHENEVER NOT SUCCESSFUL;
NOAUDIT SELECT ON LBACSYS.ALL_SA_USER_LEVELS WHENEVER NOT SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.ALL_SA_USER_PRIVS WHENEVER SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.ALL_SA_USER_PRIVS WHENEVER NOT SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.ALL_SA_USER_PRIVS WHENEVER SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.ALL_SA_USER_PRIVS WHENEVER NOT SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.ALL_SA_USER_PRIVS WHENEVER SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.ALL_SA_USER_PRIVS WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.ALL_SA_USER_PRIVS WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.ALL_SA_USER_PRIVS WHENEVER NOT SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.ALL_SA_USER_PRIVS WHENEVER SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.ALL_SA_USER_PRIVS WHENEVER NOT SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.ALL_SA_USER_PRIVS WHENEVER SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.ALL_SA_USER_PRIVS WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.ALL_SA_USER_PRIVS WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.ALL_SA_USER_PRIVS WHENEVER NOT SUCCESSFUL;
NOAUDIT SELECT ON LBACSYS.ALL_SA_USER_PRIVS WHENEVER NOT SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.DBA_LBAC_AUDIT_OPTIONS WHENEVER SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.DBA_LBAC_AUDIT_OPTIONS WHENEVER NOT SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.DBA_LBAC_AUDIT_OPTIONS WHENEVER SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.DBA_LBAC_AUDIT_OPTIONS WHENEVER NOT SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.DBA_LBAC_AUDIT_OPTIONS WHENEVER SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.DBA_LBAC_AUDIT_OPTIONS WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.DBA_LBAC_AUDIT_OPTIONS WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.DBA_LBAC_AUDIT_OPTIONS WHENEVER NOT SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.DBA_LBAC_AUDIT_OPTIONS WHENEVER SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.DBA_LBAC_AUDIT_OPTIONS WHENEVER NOT SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.DBA_LBAC_AUDIT_OPTIONS WHENEVER SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.DBA_LBAC_AUDIT_OPTIONS WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.DBA_LBAC_AUDIT_OPTIONS WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.DBA_LBAC_AUDIT_OPTIONS WHENEVER NOT SUCCESSFUL;
NOAUDIT SELECT ON LBACSYS.DBA_LBAC_AUDIT_OPTIONS WHENEVER NOT SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.DBA_LBAC_DATA_LABELS WHENEVER SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.DBA_LBAC_DATA_LABELS WHENEVER NOT SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.DBA_LBAC_DATA_LABELS WHENEVER SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.DBA_LBAC_DATA_LABELS WHENEVER NOT SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.DBA_LBAC_DATA_LABELS WHENEVER SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.DBA_LBAC_DATA_LABELS WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.DBA_LBAC_DATA_LABELS WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.DBA_LBAC_DATA_LABELS WHENEVER NOT SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.DBA_LBAC_DATA_LABELS WHENEVER SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.DBA_LBAC_DATA_LABELS WHENEVER NOT SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.DBA_LBAC_DATA_LABELS WHENEVER SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.DBA_LBAC_DATA_LABELS WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.DBA_LBAC_DATA_LABELS WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.DBA_LBAC_DATA_LABELS WHENEVER NOT SUCCESSFUL;
NOAUDIT SELECT ON LBACSYS.DBA_LBAC_DATA_LABELS WHENEVER NOT SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.DBA_LBAC_LABELS WHENEVER SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.DBA_LBAC_LABELS WHENEVER NOT SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.DBA_LBAC_LABELS WHENEVER SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.DBA_LBAC_LABELS WHENEVER NOT SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.DBA_LBAC_LABELS WHENEVER SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.DBA_LBAC_LABELS WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.DBA_LBAC_LABELS WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.DBA_LBAC_LABELS WHENEVER NOT SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.DBA_LBAC_LABELS WHENEVER SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.DBA_LBAC_LABELS WHENEVER NOT SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.DBA_LBAC_LABELS WHENEVER SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.DBA_LBAC_LABELS WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.DBA_LBAC_LABELS WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.DBA_LBAC_LABELS WHENEVER NOT SUCCESSFUL;
NOAUDIT SELECT ON LBACSYS.DBA_LBAC_LABELS WHENEVER NOT SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.DBA_LBAC_LABEL_TAGS WHENEVER SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.DBA_LBAC_LABEL_TAGS WHENEVER NOT SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.DBA_LBAC_LABEL_TAGS WHENEVER SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.DBA_LBAC_LABEL_TAGS WHENEVER NOT SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.DBA_LBAC_LABEL_TAGS WHENEVER SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.DBA_LBAC_LABEL_TAGS WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.DBA_LBAC_LABEL_TAGS WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.DBA_LBAC_LABEL_TAGS WHENEVER NOT SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.DBA_LBAC_LABEL_TAGS WHENEVER SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.DBA_LBAC_LABEL_TAGS WHENEVER NOT SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.DBA_LBAC_LABEL_TAGS WHENEVER SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.DBA_LBAC_LABEL_TAGS WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.DBA_LBAC_LABEL_TAGS WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.DBA_LBAC_LABEL_TAGS WHENEVER NOT SUCCESSFUL;
NOAUDIT SELECT ON LBACSYS.DBA_LBAC_LABEL_TAGS WHENEVER NOT SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.DBA_LBAC_POLICIES WHENEVER SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.DBA_LBAC_POLICIES WHENEVER NOT SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.DBA_LBAC_POLICIES WHENEVER SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.DBA_LBAC_POLICIES WHENEVER NOT SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.DBA_LBAC_POLICIES WHENEVER SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.DBA_LBAC_POLICIES WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.DBA_LBAC_POLICIES WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.DBA_LBAC_POLICIES WHENEVER NOT SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.DBA_LBAC_POLICIES WHENEVER SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.DBA_LBAC_POLICIES WHENEVER NOT SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.DBA_LBAC_POLICIES WHENEVER SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.DBA_LBAC_POLICIES WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.DBA_LBAC_POLICIES WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.DBA_LBAC_POLICIES WHENEVER NOT SUCCESSFUL;
NOAUDIT SELECT ON LBACSYS.DBA_LBAC_POLICIES WHENEVER NOT SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.DBA_LBAC_PROGRAMS WHENEVER SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.DBA_LBAC_PROGRAMS WHENEVER NOT SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.DBA_LBAC_PROGRAMS WHENEVER SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.DBA_LBAC_PROGRAMS WHENEVER NOT SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.DBA_LBAC_PROGRAMS WHENEVER SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.DBA_LBAC_PROGRAMS WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.DBA_LBAC_PROGRAMS WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.DBA_LBAC_PROGRAMS WHENEVER NOT SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.DBA_LBAC_PROGRAMS WHENEVER SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.DBA_LBAC_PROGRAMS WHENEVER NOT SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.DBA_LBAC_PROGRAMS WHENEVER SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.DBA_LBAC_PROGRAMS WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.DBA_LBAC_PROGRAMS WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.DBA_LBAC_PROGRAMS WHENEVER NOT SUCCESSFUL;
NOAUDIT SELECT ON LBACSYS.DBA_LBAC_PROGRAMS WHENEVER NOT SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.DBA_LBAC_PROG_LABELS WHENEVER SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.DBA_LBAC_PROG_LABELS WHENEVER NOT SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.DBA_LBAC_PROG_LABELS WHENEVER SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.DBA_LBAC_PROG_LABELS WHENEVER NOT SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.DBA_LBAC_PROG_LABELS WHENEVER SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.DBA_LBAC_PROG_LABELS WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.DBA_LBAC_PROG_LABELS WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.DBA_LBAC_PROG_LABELS WHENEVER NOT SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.DBA_LBAC_PROG_LABELS WHENEVER SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.DBA_LBAC_PROG_LABELS WHENEVER NOT SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.DBA_LBAC_PROG_LABELS WHENEVER SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.DBA_LBAC_PROG_LABELS WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.DBA_LBAC_PROG_LABELS WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.DBA_LBAC_PROG_LABELS WHENEVER NOT SUCCESSFUL;
NOAUDIT SELECT ON LBACSYS.DBA_LBAC_PROG_LABELS WHENEVER NOT SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.DBA_LBAC_PROG_PRIVS WHENEVER SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.DBA_LBAC_PROG_PRIVS WHENEVER NOT SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.DBA_LBAC_PROG_PRIVS WHENEVER SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.DBA_LBAC_PROG_PRIVS WHENEVER NOT SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.DBA_LBAC_PROG_PRIVS WHENEVER SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.DBA_LBAC_PROG_PRIVS WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.DBA_LBAC_PROG_PRIVS WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.DBA_LBAC_PROG_PRIVS WHENEVER NOT SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.DBA_LBAC_PROG_PRIVS WHENEVER SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.DBA_LBAC_PROG_PRIVS WHENEVER NOT SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.DBA_LBAC_PROG_PRIVS WHENEVER SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.DBA_LBAC_PROG_PRIVS WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.DBA_LBAC_PROG_PRIVS WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.DBA_LBAC_PROG_PRIVS WHENEVER NOT SUCCESSFUL;
NOAUDIT SELECT ON LBACSYS.DBA_LBAC_PROG_PRIVS WHENEVER NOT SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.DBA_LBAC_SCHEMA_POLICIES WHENEVER SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.DBA_LBAC_SCHEMA_POLICIES WHENEVER NOT SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.DBA_LBAC_SCHEMA_POLICIES WHENEVER SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.DBA_LBAC_SCHEMA_POLICIES WHENEVER NOT SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.DBA_LBAC_SCHEMA_POLICIES WHENEVER SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.DBA_LBAC_SCHEMA_POLICIES WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.DBA_LBAC_SCHEMA_POLICIES WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.DBA_LBAC_SCHEMA_POLICIES WHENEVER NOT SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.DBA_LBAC_SCHEMA_POLICIES WHENEVER SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.DBA_LBAC_SCHEMA_POLICIES WHENEVER NOT SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.DBA_LBAC_SCHEMA_POLICIES WHENEVER SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.DBA_LBAC_SCHEMA_POLICIES WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.DBA_LBAC_SCHEMA_POLICIES WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.DBA_LBAC_SCHEMA_POLICIES WHENEVER NOT SUCCESSFUL;
NOAUDIT SELECT ON LBACSYS.DBA_LBAC_SCHEMA_POLICIES WHENEVER NOT SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.DBA_LBAC_TABLE_POLICIES WHENEVER SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.DBA_LBAC_TABLE_POLICIES WHENEVER NOT SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.DBA_LBAC_TABLE_POLICIES WHENEVER SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.DBA_LBAC_TABLE_POLICIES WHENEVER NOT SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.DBA_LBAC_TABLE_POLICIES WHENEVER SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.DBA_LBAC_TABLE_POLICIES WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.DBA_LBAC_TABLE_POLICIES WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.DBA_LBAC_TABLE_POLICIES WHENEVER NOT SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.DBA_LBAC_TABLE_POLICIES WHENEVER SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.DBA_LBAC_TABLE_POLICIES WHENEVER NOT SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.DBA_LBAC_TABLE_POLICIES WHENEVER SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.DBA_LBAC_TABLE_POLICIES WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.DBA_LBAC_TABLE_POLICIES WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.DBA_LBAC_TABLE_POLICIES WHENEVER NOT SUCCESSFUL;
NOAUDIT SELECT ON LBACSYS.DBA_LBAC_TABLE_POLICIES WHENEVER NOT SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.DBA_LBAC_USERS WHENEVER SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.DBA_LBAC_USERS WHENEVER NOT SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.DBA_LBAC_USERS WHENEVER SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.DBA_LBAC_USERS WHENEVER NOT SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.DBA_LBAC_USERS WHENEVER SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.DBA_LBAC_USERS WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.DBA_LBAC_USERS WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.DBA_LBAC_USERS WHENEVER NOT SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.DBA_LBAC_USERS WHENEVER SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.DBA_LBAC_USERS WHENEVER NOT SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.DBA_LBAC_USERS WHENEVER SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.DBA_LBAC_USERS WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.DBA_LBAC_USERS WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.DBA_LBAC_USERS WHENEVER NOT SUCCESSFUL;
NOAUDIT SELECT ON LBACSYS.DBA_LBAC_USERS WHENEVER NOT SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.DBA_LBAC_USER_LABELS WHENEVER SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.DBA_LBAC_USER_LABELS WHENEVER NOT SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.DBA_LBAC_USER_LABELS WHENEVER SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.DBA_LBAC_USER_LABELS WHENEVER NOT SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.DBA_LBAC_USER_LABELS WHENEVER SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.DBA_LBAC_USER_LABELS WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.DBA_LBAC_USER_LABELS WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.DBA_LBAC_USER_LABELS WHENEVER NOT SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.DBA_LBAC_USER_LABELS WHENEVER SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.DBA_LBAC_USER_LABELS WHENEVER NOT SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.DBA_LBAC_USER_LABELS WHENEVER SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.DBA_LBAC_USER_LABELS WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.DBA_LBAC_USER_LABELS WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.DBA_LBAC_USER_LABELS WHENEVER NOT SUCCESSFUL;
NOAUDIT SELECT ON LBACSYS.DBA_LBAC_USER_LABELS WHENEVER NOT SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.DBA_LBAC_USER_PRIVS WHENEVER SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.DBA_LBAC_USER_PRIVS WHENEVER NOT SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.DBA_LBAC_USER_PRIVS WHENEVER SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.DBA_LBAC_USER_PRIVS WHENEVER NOT SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.DBA_LBAC_USER_PRIVS WHENEVER SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.DBA_LBAC_USER_PRIVS WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.DBA_LBAC_USER_PRIVS WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.DBA_LBAC_USER_PRIVS WHENEVER NOT SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.DBA_LBAC_USER_PRIVS WHENEVER SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.DBA_LBAC_USER_PRIVS WHENEVER NOT SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.DBA_LBAC_USER_PRIVS WHENEVER SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.DBA_LBAC_USER_PRIVS WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.DBA_LBAC_USER_PRIVS WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.DBA_LBAC_USER_PRIVS WHENEVER NOT SUCCESSFUL;
NOAUDIT SELECT ON LBACSYS.DBA_LBAC_USER_PRIVS WHENEVER NOT SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.DBA_SA_AUDIT_OPTIONS WHENEVER SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.DBA_SA_AUDIT_OPTIONS WHENEVER NOT SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.DBA_SA_AUDIT_OPTIONS WHENEVER SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.DBA_SA_AUDIT_OPTIONS WHENEVER NOT SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.DBA_SA_AUDIT_OPTIONS WHENEVER SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.DBA_SA_AUDIT_OPTIONS WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.DBA_SA_AUDIT_OPTIONS WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.DBA_SA_AUDIT_OPTIONS WHENEVER NOT SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.DBA_SA_AUDIT_OPTIONS WHENEVER SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.DBA_SA_AUDIT_OPTIONS WHENEVER NOT SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.DBA_SA_AUDIT_OPTIONS WHENEVER SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.DBA_SA_AUDIT_OPTIONS WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.DBA_SA_AUDIT_OPTIONS WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.DBA_SA_AUDIT_OPTIONS WHENEVER NOT SUCCESSFUL;
NOAUDIT SELECT ON LBACSYS.DBA_SA_AUDIT_OPTIONS WHENEVER NOT SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.DBA_SA_COMPARTMENTS WHENEVER SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.DBA_SA_COMPARTMENTS WHENEVER NOT SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.DBA_SA_COMPARTMENTS WHENEVER SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.DBA_SA_COMPARTMENTS WHENEVER NOT SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.DBA_SA_COMPARTMENTS WHENEVER SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.DBA_SA_COMPARTMENTS WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.DBA_SA_COMPARTMENTS WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.DBA_SA_COMPARTMENTS WHENEVER NOT SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.DBA_SA_COMPARTMENTS WHENEVER SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.DBA_SA_COMPARTMENTS WHENEVER NOT SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.DBA_SA_COMPARTMENTS WHENEVER SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.DBA_SA_COMPARTMENTS WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.DBA_SA_COMPARTMENTS WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.DBA_SA_COMPARTMENTS WHENEVER NOT SUCCESSFUL;
NOAUDIT SELECT ON LBACSYS.DBA_SA_COMPARTMENTS WHENEVER NOT SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.DBA_SA_DATA_LABELS WHENEVER SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.DBA_SA_DATA_LABELS WHENEVER NOT SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.DBA_SA_DATA_LABELS WHENEVER SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.DBA_SA_DATA_LABELS WHENEVER NOT SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.DBA_SA_DATA_LABELS WHENEVER SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.DBA_SA_DATA_LABELS WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.DBA_SA_DATA_LABELS WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.DBA_SA_DATA_LABELS WHENEVER NOT SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.DBA_SA_DATA_LABELS WHENEVER SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.DBA_SA_DATA_LABELS WHENEVER NOT SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.DBA_SA_DATA_LABELS WHENEVER SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.DBA_SA_DATA_LABELS WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.DBA_SA_DATA_LABELS WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.DBA_SA_DATA_LABELS WHENEVER NOT SUCCESSFUL;
NOAUDIT SELECT ON LBACSYS.DBA_SA_DATA_LABELS WHENEVER NOT SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.DBA_SA_GROUPS WHENEVER SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.DBA_SA_GROUPS WHENEVER NOT SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.DBA_SA_GROUPS WHENEVER SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.DBA_SA_GROUPS WHENEVER NOT SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.DBA_SA_GROUPS WHENEVER SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.DBA_SA_GROUPS WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.DBA_SA_GROUPS WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.DBA_SA_GROUPS WHENEVER NOT SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.DBA_SA_GROUPS WHENEVER SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.DBA_SA_GROUPS WHENEVER NOT SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.DBA_SA_GROUPS WHENEVER SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.DBA_SA_GROUPS WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.DBA_SA_GROUPS WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.DBA_SA_GROUPS WHENEVER NOT SUCCESSFUL;
NOAUDIT SELECT ON LBACSYS.DBA_SA_GROUPS WHENEVER NOT SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.DBA_SA_GROUP_HIERARCHY WHENEVER SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.DBA_SA_GROUP_HIERARCHY WHENEVER NOT SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.DBA_SA_GROUP_HIERARCHY WHENEVER SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.DBA_SA_GROUP_HIERARCHY WHENEVER NOT SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.DBA_SA_GROUP_HIERARCHY WHENEVER SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.DBA_SA_GROUP_HIERARCHY WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.DBA_SA_GROUP_HIERARCHY WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.DBA_SA_GROUP_HIERARCHY WHENEVER NOT SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.DBA_SA_GROUP_HIERARCHY WHENEVER SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.DBA_SA_GROUP_HIERARCHY WHENEVER NOT SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.DBA_SA_GROUP_HIERARCHY WHENEVER SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.DBA_SA_GROUP_HIERARCHY WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.DBA_SA_GROUP_HIERARCHY WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.DBA_SA_GROUP_HIERARCHY WHENEVER NOT SUCCESSFUL;
NOAUDIT SELECT ON LBACSYS.DBA_SA_GROUP_HIERARCHY WHENEVER NOT SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.DBA_SA_LABELS WHENEVER SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.DBA_SA_LABELS WHENEVER NOT SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.DBA_SA_LABELS WHENEVER SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.DBA_SA_LABELS WHENEVER NOT SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.DBA_SA_LABELS WHENEVER SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.DBA_SA_LABELS WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.DBA_SA_LABELS WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.DBA_SA_LABELS WHENEVER NOT SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.DBA_SA_LABELS WHENEVER SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.DBA_SA_LABELS WHENEVER NOT SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.DBA_SA_LABELS WHENEVER SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.DBA_SA_LABELS WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.DBA_SA_LABELS WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.DBA_SA_LABELS WHENEVER NOT SUCCESSFUL;
NOAUDIT SELECT ON LBACSYS.DBA_SA_LABELS WHENEVER NOT SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.DBA_SA_LEVELS WHENEVER SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.DBA_SA_LEVELS WHENEVER NOT SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.DBA_SA_LEVELS WHENEVER SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.DBA_SA_LEVELS WHENEVER NOT SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.DBA_SA_LEVELS WHENEVER SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.DBA_SA_LEVELS WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.DBA_SA_LEVELS WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.DBA_SA_LEVELS WHENEVER NOT SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.DBA_SA_LEVELS WHENEVER SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.DBA_SA_LEVELS WHENEVER NOT SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.DBA_SA_LEVELS WHENEVER SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.DBA_SA_LEVELS WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.DBA_SA_LEVELS WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.DBA_SA_LEVELS WHENEVER NOT SUCCESSFUL;
NOAUDIT SELECT ON LBACSYS.DBA_SA_LEVELS WHENEVER NOT SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.DBA_SA_POLICIES WHENEVER SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.DBA_SA_POLICIES WHENEVER NOT SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.DBA_SA_POLICIES WHENEVER SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.DBA_SA_POLICIES WHENEVER NOT SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.DBA_SA_POLICIES WHENEVER SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.DBA_SA_POLICIES WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.DBA_SA_POLICIES WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.DBA_SA_POLICIES WHENEVER NOT SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.DBA_SA_POLICIES WHENEVER SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.DBA_SA_POLICIES WHENEVER NOT SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.DBA_SA_POLICIES WHENEVER SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.DBA_SA_POLICIES WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.DBA_SA_POLICIES WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.DBA_SA_POLICIES WHENEVER NOT SUCCESSFUL;
NOAUDIT SELECT ON LBACSYS.DBA_SA_POLICIES WHENEVER NOT SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.DBA_SA_PROGRAMS WHENEVER SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.DBA_SA_PROGRAMS WHENEVER NOT SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.DBA_SA_PROGRAMS WHENEVER SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.DBA_SA_PROGRAMS WHENEVER NOT SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.DBA_SA_PROGRAMS WHENEVER SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.DBA_SA_PROGRAMS WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.DBA_SA_PROGRAMS WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.DBA_SA_PROGRAMS WHENEVER NOT SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.DBA_SA_PROGRAMS WHENEVER SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.DBA_SA_PROGRAMS WHENEVER NOT SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.DBA_SA_PROGRAMS WHENEVER SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.DBA_SA_PROGRAMS WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.DBA_SA_PROGRAMS WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.DBA_SA_PROGRAMS WHENEVER NOT SUCCESSFUL;
NOAUDIT SELECT ON LBACSYS.DBA_SA_PROGRAMS WHENEVER NOT SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.DBA_SA_PROG_PRIVS WHENEVER SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.DBA_SA_PROG_PRIVS WHENEVER NOT SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.DBA_SA_PROG_PRIVS WHENEVER SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.DBA_SA_PROG_PRIVS WHENEVER NOT SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.DBA_SA_PROG_PRIVS WHENEVER SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.DBA_SA_PROG_PRIVS WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.DBA_SA_PROG_PRIVS WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.DBA_SA_PROG_PRIVS WHENEVER NOT SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.DBA_SA_PROG_PRIVS WHENEVER SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.DBA_SA_PROG_PRIVS WHENEVER NOT SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.DBA_SA_PROG_PRIVS WHENEVER SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.DBA_SA_PROG_PRIVS WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.DBA_SA_PROG_PRIVS WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.DBA_SA_PROG_PRIVS WHENEVER NOT SUCCESSFUL;
NOAUDIT SELECT ON LBACSYS.DBA_SA_PROG_PRIVS WHENEVER NOT SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.DBA_SA_SCHEMA_POLICIES WHENEVER SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.DBA_SA_SCHEMA_POLICIES WHENEVER NOT SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.DBA_SA_SCHEMA_POLICIES WHENEVER SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.DBA_SA_SCHEMA_POLICIES WHENEVER NOT SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.DBA_SA_SCHEMA_POLICIES WHENEVER SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.DBA_SA_SCHEMA_POLICIES WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.DBA_SA_SCHEMA_POLICIES WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.DBA_SA_SCHEMA_POLICIES WHENEVER NOT SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.DBA_SA_SCHEMA_POLICIES WHENEVER SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.DBA_SA_SCHEMA_POLICIES WHENEVER NOT SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.DBA_SA_SCHEMA_POLICIES WHENEVER SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.DBA_SA_SCHEMA_POLICIES WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.DBA_SA_SCHEMA_POLICIES WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.DBA_SA_SCHEMA_POLICIES WHENEVER NOT SUCCESSFUL;
NOAUDIT SELECT ON LBACSYS.DBA_SA_SCHEMA_POLICIES WHENEVER NOT SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.DBA_SA_TABLE_POLICIES WHENEVER SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.DBA_SA_TABLE_POLICIES WHENEVER NOT SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.DBA_SA_TABLE_POLICIES WHENEVER SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.DBA_SA_TABLE_POLICIES WHENEVER NOT SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.DBA_SA_TABLE_POLICIES WHENEVER SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.DBA_SA_TABLE_POLICIES WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.DBA_SA_TABLE_POLICIES WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.DBA_SA_TABLE_POLICIES WHENEVER NOT SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.DBA_SA_TABLE_POLICIES WHENEVER SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.DBA_SA_TABLE_POLICIES WHENEVER NOT SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.DBA_SA_TABLE_POLICIES WHENEVER SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.DBA_SA_TABLE_POLICIES WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.DBA_SA_TABLE_POLICIES WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.DBA_SA_TABLE_POLICIES WHENEVER NOT SUCCESSFUL;
NOAUDIT SELECT ON LBACSYS.DBA_SA_TABLE_POLICIES WHENEVER NOT SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.DBA_SA_USERS WHENEVER SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.DBA_SA_USERS WHENEVER NOT SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.DBA_SA_USERS WHENEVER SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.DBA_SA_USERS WHENEVER NOT SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.DBA_SA_USERS WHENEVER SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.DBA_SA_USERS WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.DBA_SA_USERS WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.DBA_SA_USERS WHENEVER NOT SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.DBA_SA_USERS WHENEVER SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.DBA_SA_USERS WHENEVER NOT SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.DBA_SA_USERS WHENEVER SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.DBA_SA_USERS WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.DBA_SA_USERS WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.DBA_SA_USERS WHENEVER NOT SUCCESSFUL;
NOAUDIT SELECT ON LBACSYS.DBA_SA_USERS WHENEVER NOT SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.DBA_SA_USER_COMPARTMENTS WHENEVER SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.DBA_SA_USER_COMPARTMENTS WHENEVER NOT SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.DBA_SA_USER_COMPARTMENTS WHENEVER SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.DBA_SA_USER_COMPARTMENTS WHENEVER NOT SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.DBA_SA_USER_COMPARTMENTS WHENEVER SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.DBA_SA_USER_COMPARTMENTS WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.DBA_SA_USER_COMPARTMENTS WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.DBA_SA_USER_COMPARTMENTS WHENEVER NOT SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.DBA_SA_USER_COMPARTMENTS WHENEVER SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.DBA_SA_USER_COMPARTMENTS WHENEVER NOT SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.DBA_SA_USER_COMPARTMENTS WHENEVER SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.DBA_SA_USER_COMPARTMENTS WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.DBA_SA_USER_COMPARTMENTS WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.DBA_SA_USER_COMPARTMENTS WHENEVER NOT SUCCESSFUL;
NOAUDIT SELECT ON LBACSYS.DBA_SA_USER_COMPARTMENTS WHENEVER NOT SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.DBA_SA_USER_GROUPS WHENEVER SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.DBA_SA_USER_GROUPS WHENEVER NOT SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.DBA_SA_USER_GROUPS WHENEVER SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.DBA_SA_USER_GROUPS WHENEVER NOT SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.DBA_SA_USER_GROUPS WHENEVER SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.DBA_SA_USER_GROUPS WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.DBA_SA_USER_GROUPS WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.DBA_SA_USER_GROUPS WHENEVER NOT SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.DBA_SA_USER_GROUPS WHENEVER SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.DBA_SA_USER_GROUPS WHENEVER NOT SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.DBA_SA_USER_GROUPS WHENEVER SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.DBA_SA_USER_GROUPS WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.DBA_SA_USER_GROUPS WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.DBA_SA_USER_GROUPS WHENEVER NOT SUCCESSFUL;
NOAUDIT SELECT ON LBACSYS.DBA_SA_USER_GROUPS WHENEVER NOT SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.DBA_SA_USER_LABELS WHENEVER SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.DBA_SA_USER_LABELS WHENEVER NOT SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.DBA_SA_USER_LABELS WHENEVER SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.DBA_SA_USER_LABELS WHENEVER NOT SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.DBA_SA_USER_LABELS WHENEVER SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.DBA_SA_USER_LABELS WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.DBA_SA_USER_LABELS WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.DBA_SA_USER_LABELS WHENEVER NOT SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.DBA_SA_USER_LABELS WHENEVER SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.DBA_SA_USER_LABELS WHENEVER NOT SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.DBA_SA_USER_LABELS WHENEVER SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.DBA_SA_USER_LABELS WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.DBA_SA_USER_LABELS WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.DBA_SA_USER_LABELS WHENEVER NOT SUCCESSFUL;
NOAUDIT SELECT ON LBACSYS.DBA_SA_USER_LABELS WHENEVER NOT SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.DBA_SA_USER_LEVELS WHENEVER SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.DBA_SA_USER_LEVELS WHENEVER NOT SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.DBA_SA_USER_LEVELS WHENEVER SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.DBA_SA_USER_LEVELS WHENEVER NOT SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.DBA_SA_USER_LEVELS WHENEVER SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.DBA_SA_USER_LEVELS WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.DBA_SA_USER_LEVELS WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.DBA_SA_USER_LEVELS WHENEVER NOT SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.DBA_SA_USER_LEVELS WHENEVER SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.DBA_SA_USER_LEVELS WHENEVER NOT SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.DBA_SA_USER_LEVELS WHENEVER SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.DBA_SA_USER_LEVELS WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.DBA_SA_USER_LEVELS WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.DBA_SA_USER_LEVELS WHENEVER NOT SUCCESSFUL;
NOAUDIT SELECT ON LBACSYS.DBA_SA_USER_LEVELS WHENEVER NOT SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.DBA_SA_USER_PRIVS WHENEVER SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.DBA_SA_USER_PRIVS WHENEVER NOT SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.DBA_SA_USER_PRIVS WHENEVER SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.DBA_SA_USER_PRIVS WHENEVER NOT SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.DBA_SA_USER_PRIVS WHENEVER SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.DBA_SA_USER_PRIVS WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.DBA_SA_USER_PRIVS WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.DBA_SA_USER_PRIVS WHENEVER NOT SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.DBA_SA_USER_PRIVS WHENEVER SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.DBA_SA_USER_PRIVS WHENEVER NOT SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.DBA_SA_USER_PRIVS WHENEVER SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.DBA_SA_USER_PRIVS WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.DBA_SA_USER_PRIVS WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.DBA_SA_USER_PRIVS WHENEVER NOT SUCCESSFUL;
NOAUDIT SELECT ON LBACSYS.DBA_SA_USER_PRIVS WHENEVER NOT SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.LBAC$ALL_TABLE_POLICIES WHENEVER SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.LBAC$ALL_TABLE_POLICIES WHENEVER NOT SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.LBAC$ALL_TABLE_POLICIES WHENEVER SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.LBAC$ALL_TABLE_POLICIES WHENEVER NOT SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.LBAC$ALL_TABLE_POLICIES WHENEVER SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.LBAC$ALL_TABLE_POLICIES WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.LBAC$ALL_TABLE_POLICIES WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.LBAC$ALL_TABLE_POLICIES WHENEVER NOT SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.LBAC$ALL_TABLE_POLICIES WHENEVER SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.LBAC$ALL_TABLE_POLICIES WHENEVER NOT SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.LBAC$ALL_TABLE_POLICIES WHENEVER SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.LBAC$ALL_TABLE_POLICIES WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.LBAC$ALL_TABLE_POLICIES WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.LBAC$ALL_TABLE_POLICIES WHENEVER NOT SUCCESSFUL;
NOAUDIT SELECT ON LBACSYS.LBAC$ALL_TABLE_POLICIES WHENEVER NOT SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.LBAC$PACKAGE_FUNCTIONS WHENEVER SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.LBAC$PACKAGE_FUNCTIONS WHENEVER NOT SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.LBAC$PACKAGE_FUNCTIONS WHENEVER SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.LBAC$PACKAGE_FUNCTIONS WHENEVER NOT SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.LBAC$PACKAGE_FUNCTIONS WHENEVER SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.LBAC$PACKAGE_FUNCTIONS WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.LBAC$PACKAGE_FUNCTIONS WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.LBAC$PACKAGE_FUNCTIONS WHENEVER NOT SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.LBAC$PACKAGE_FUNCTIONS WHENEVER SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.LBAC$PACKAGE_FUNCTIONS WHENEVER NOT SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.LBAC$PACKAGE_FUNCTIONS WHENEVER SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.LBAC$PACKAGE_FUNCTIONS WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.LBAC$PACKAGE_FUNCTIONS WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.LBAC$PACKAGE_FUNCTIONS WHENEVER NOT SUCCESSFUL;
NOAUDIT SELECT ON LBACSYS.LBAC$PACKAGE_FUNCTIONS WHENEVER NOT SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.LBAC$POLICY_COLUMNS WHENEVER SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.LBAC$POLICY_COLUMNS WHENEVER NOT SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.LBAC$POLICY_COLUMNS WHENEVER SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.LBAC$POLICY_COLUMNS WHENEVER NOT SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.LBAC$POLICY_COLUMNS WHENEVER SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.LBAC$POLICY_COLUMNS WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.LBAC$POLICY_COLUMNS WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.LBAC$POLICY_COLUMNS WHENEVER NOT SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.LBAC$POLICY_COLUMNS WHENEVER SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.LBAC$POLICY_COLUMNS WHENEVER NOT SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.LBAC$POLICY_COLUMNS WHENEVER SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.LBAC$POLICY_COLUMNS WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.LBAC$POLICY_COLUMNS WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.LBAC$POLICY_COLUMNS WHENEVER NOT SUCCESSFUL;
NOAUDIT SELECT ON LBACSYS.LBAC$POLICY_COLUMNS WHENEVER NOT SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.LBAC$TRUSTED_PROGS WHENEVER SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.LBAC$TRUSTED_PROGS WHENEVER NOT SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.LBAC$TRUSTED_PROGS WHENEVER SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.LBAC$TRUSTED_PROGS WHENEVER NOT SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.LBAC$TRUSTED_PROGS WHENEVER SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.LBAC$TRUSTED_PROGS WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.LBAC$TRUSTED_PROGS WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.LBAC$TRUSTED_PROGS WHENEVER NOT SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.LBAC$TRUSTED_PROGS WHENEVER SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.LBAC$TRUSTED_PROGS WHENEVER NOT SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.LBAC$TRUSTED_PROGS WHENEVER SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.LBAC$TRUSTED_PROGS WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.LBAC$TRUSTED_PROGS WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.LBAC$TRUSTED_PROGS WHENEVER NOT SUCCESSFUL;
NOAUDIT SELECT ON LBACSYS.LBAC$TRUSTED_PROGS WHENEVER NOT SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.LBAC$USER_LOGON WHENEVER SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.LBAC$USER_LOGON WHENEVER NOT SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.LBAC$USER_LOGON WHENEVER SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.LBAC$USER_LOGON WHENEVER NOT SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.LBAC$USER_LOGON WHENEVER SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.LBAC$USER_LOGON WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.LBAC$USER_LOGON WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.LBAC$USER_LOGON WHENEVER NOT SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.LBAC$USER_LOGON WHENEVER SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.LBAC$USER_LOGON WHENEVER NOT SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.LBAC$USER_LOGON WHENEVER SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.LBAC$USER_LOGON WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.LBAC$USER_LOGON WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.LBAC$USER_LOGON WHENEVER NOT SUCCESSFUL;
NOAUDIT SELECT ON LBACSYS.LBAC$USER_LOGON WHENEVER NOT SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.SA$ADMIN WHENEVER SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.SA$ADMIN WHENEVER NOT SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.SA$ADMIN WHENEVER SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.SA$ADMIN WHENEVER NOT SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.SA$ADMIN WHENEVER SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.SA$ADMIN WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.SA$ADMIN WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.SA$ADMIN WHENEVER NOT SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.SA$ADMIN WHENEVER SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.SA$ADMIN WHENEVER NOT SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.SA$ADMIN WHENEVER SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.SA$ADMIN WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.SA$ADMIN WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.SA$ADMIN WHENEVER NOT SUCCESSFUL;
NOAUDIT SELECT ON LBACSYS.SA$ADMIN WHENEVER NOT SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.SA$POL WHENEVER SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.SA$POL WHENEVER NOT SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.SA$POL WHENEVER SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.SA$POL WHENEVER NOT SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.SA$POL WHENEVER SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.SA$POL WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.SA$POL WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.SA$POL WHENEVER NOT SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.SA$POL WHENEVER SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.SA$POL WHENEVER NOT SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.SA$POL WHENEVER SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.SA$POL WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.SA$POL WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.SA$POL WHENEVER NOT SUCCESSFUL;
NOAUDIT SELECT ON LBACSYS.SA$POL WHENEVER NOT SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.USER_SA_SESSION WHENEVER SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.USER_SA_SESSION WHENEVER NOT SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.USER_SA_SESSION WHENEVER SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.USER_SA_SESSION WHENEVER NOT SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.USER_SA_SESSION WHENEVER SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.USER_SA_SESSION WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.USER_SA_SESSION WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.USER_SA_SESSION WHENEVER NOT SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.USER_SA_SESSION WHENEVER SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.USER_SA_SESSION WHENEVER NOT SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.USER_SA_SESSION WHENEVER SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.USER_SA_SESSION WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.USER_SA_SESSION WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.USER_SA_SESSION WHENEVER NOT SUCCESSFUL;
NOAUDIT SELECT ON LBACSYS.USER_SA_SESSION WHENEVER NOT SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.LBAC$AUDIT WHENEVER SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.LBAC$AUDIT WHENEVER NOT SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.LBAC$AUDIT WHENEVER SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.LBAC$AUDIT WHENEVER NOT SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.LBAC$AUDIT WHENEVER SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.LBAC$AUDIT WHENEVER NOT SUCCESSFUL;
NOAUDIT INDEX ON LBACSYS.LBAC$AUDIT WHENEVER SUCCESSFUL;
NOAUDIT INDEX ON LBACSYS.LBAC$AUDIT WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.LBAC$AUDIT WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.LBAC$AUDIT WHENEVER NOT SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.LBAC$AUDIT WHENEVER SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.LBAC$AUDIT WHENEVER NOT SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.LBAC$AUDIT WHENEVER SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.LBAC$AUDIT WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.LBAC$AUDIT WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.LBAC$AUDIT WHENEVER NOT SUCCESSFUL;
NOAUDIT ALTER ON LBACSYS.LBAC$AUDIT WHENEVER SUCCESSFUL;
NOAUDIT ALTER ON LBACSYS.LBAC$AUDIT WHENEVER NOT SUCCESSFUL;
NOAUDIT SELECT ON LBACSYS.LBAC$AUDIT WHENEVER NOT SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.LBAC$INSTALLATIONS WHENEVER SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.LBAC$INSTALLATIONS WHENEVER NOT SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.LBAC$INSTALLATIONS WHENEVER SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.LBAC$INSTALLATIONS WHENEVER NOT SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.LBAC$INSTALLATIONS WHENEVER SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.LBAC$INSTALLATIONS WHENEVER NOT SUCCESSFUL;
NOAUDIT INDEX ON LBACSYS.LBAC$INSTALLATIONS WHENEVER SUCCESSFUL;
NOAUDIT INDEX ON LBACSYS.LBAC$INSTALLATIONS WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.LBAC$INSTALLATIONS WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.LBAC$INSTALLATIONS WHENEVER NOT SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.LBAC$INSTALLATIONS WHENEVER SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.LBAC$INSTALLATIONS WHENEVER NOT SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.LBAC$INSTALLATIONS WHENEVER SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.LBAC$INSTALLATIONS WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.LBAC$INSTALLATIONS WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.LBAC$INSTALLATIONS WHENEVER NOT SUCCESSFUL;
NOAUDIT ALTER ON LBACSYS.LBAC$INSTALLATIONS WHENEVER SUCCESSFUL;
NOAUDIT ALTER ON LBACSYS.LBAC$INSTALLATIONS WHENEVER NOT SUCCESSFUL;
NOAUDIT SELECT ON LBACSYS.LBAC$INSTALLATIONS WHENEVER NOT SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.LBAC$LAB WHENEVER SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.LBAC$LAB WHENEVER NOT SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.LBAC$LAB WHENEVER SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.LBAC$LAB WHENEVER NOT SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.LBAC$LAB WHENEVER SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.LBAC$LAB WHENEVER NOT SUCCESSFUL;
NOAUDIT INDEX ON LBACSYS.LBAC$LAB WHENEVER SUCCESSFUL;
NOAUDIT INDEX ON LBACSYS.LBAC$LAB WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.LBAC$LAB WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.LBAC$LAB WHENEVER NOT SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.LBAC$LAB WHENEVER SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.LBAC$LAB WHENEVER NOT SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.LBAC$LAB WHENEVER SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.LBAC$LAB WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.LBAC$LAB WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.LBAC$LAB WHENEVER NOT SUCCESSFUL;
NOAUDIT ALTER ON LBACSYS.LBAC$LAB WHENEVER SUCCESSFUL;
NOAUDIT ALTER ON LBACSYS.LBAC$LAB WHENEVER NOT SUCCESSFUL;
NOAUDIT SELECT ON LBACSYS.LBAC$LAB WHENEVER NOT SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.LBAC$POL WHENEVER SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.LBAC$POL WHENEVER NOT SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.LBAC$POL WHENEVER SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.LBAC$POL WHENEVER NOT SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.LBAC$POL WHENEVER SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.LBAC$POL WHENEVER NOT SUCCESSFUL;
NOAUDIT INDEX ON LBACSYS.LBAC$POL WHENEVER SUCCESSFUL;
NOAUDIT INDEX ON LBACSYS.LBAC$POL WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.LBAC$POL WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.LBAC$POL WHENEVER NOT SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.LBAC$POL WHENEVER SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.LBAC$POL WHENEVER NOT SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.LBAC$POL WHENEVER SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.LBAC$POL WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.LBAC$POL WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.LBAC$POL WHENEVER NOT SUCCESSFUL;
NOAUDIT ALTER ON LBACSYS.LBAC$POL WHENEVER SUCCESSFUL;
NOAUDIT ALTER ON LBACSYS.LBAC$POL WHENEVER NOT SUCCESSFUL;
NOAUDIT SELECT ON LBACSYS.LBAC$POL WHENEVER NOT SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.LBAC$POLICY_ADMIN WHENEVER SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.LBAC$POLICY_ADMIN WHENEVER NOT SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.LBAC$POLICY_ADMIN WHENEVER SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.LBAC$POLICY_ADMIN WHENEVER NOT SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.LBAC$POLICY_ADMIN WHENEVER SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.LBAC$POLICY_ADMIN WHENEVER NOT SUCCESSFUL;
NOAUDIT INDEX ON LBACSYS.LBAC$POLICY_ADMIN WHENEVER SUCCESSFUL;
NOAUDIT INDEX ON LBACSYS.LBAC$POLICY_ADMIN WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.LBAC$POLICY_ADMIN WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.LBAC$POLICY_ADMIN WHENEVER NOT SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.LBAC$POLICY_ADMIN WHENEVER SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.LBAC$POLICY_ADMIN WHENEVER NOT SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.LBAC$POLICY_ADMIN WHENEVER SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.LBAC$POLICY_ADMIN WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.LBAC$POLICY_ADMIN WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.LBAC$POLICY_ADMIN WHENEVER NOT SUCCESSFUL;
NOAUDIT ALTER ON LBACSYS.LBAC$POLICY_ADMIN WHENEVER SUCCESSFUL;
NOAUDIT ALTER ON LBACSYS.LBAC$POLICY_ADMIN WHENEVER NOT SUCCESSFUL;
NOAUDIT SELECT ON LBACSYS.LBAC$POLICY_ADMIN WHENEVER NOT SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.LBAC$POLS WHENEVER SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.LBAC$POLS WHENEVER NOT SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.LBAC$POLS WHENEVER SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.LBAC$POLS WHENEVER NOT SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.LBAC$POLS WHENEVER SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.LBAC$POLS WHENEVER NOT SUCCESSFUL;
NOAUDIT INDEX ON LBACSYS.LBAC$POLS WHENEVER SUCCESSFUL;
NOAUDIT INDEX ON LBACSYS.LBAC$POLS WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.LBAC$POLS WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.LBAC$POLS WHENEVER NOT SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.LBAC$POLS WHENEVER SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.LBAC$POLS WHENEVER NOT SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.LBAC$POLS WHENEVER SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.LBAC$POLS WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.LBAC$POLS WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.LBAC$POLS WHENEVER NOT SUCCESSFUL;
NOAUDIT ALTER ON LBACSYS.LBAC$POLS WHENEVER SUCCESSFUL;
NOAUDIT ALTER ON LBACSYS.LBAC$POLS WHENEVER NOT SUCCESSFUL;
NOAUDIT SELECT ON LBACSYS.LBAC$POLS WHENEVER NOT SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.LBAC$POLT WHENEVER SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.LBAC$POLT WHENEVER NOT SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.LBAC$POLT WHENEVER SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.LBAC$POLT WHENEVER NOT SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.LBAC$POLT WHENEVER SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.LBAC$POLT WHENEVER NOT SUCCESSFUL;
NOAUDIT INDEX ON LBACSYS.LBAC$POLT WHENEVER SUCCESSFUL;
NOAUDIT INDEX ON LBACSYS.LBAC$POLT WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.LBAC$POLT WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.LBAC$POLT WHENEVER NOT SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.LBAC$POLT WHENEVER SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.LBAC$POLT WHENEVER NOT SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.LBAC$POLT WHENEVER SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.LBAC$POLT WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.LBAC$POLT WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.LBAC$POLT WHENEVER NOT SUCCESSFUL;
NOAUDIT ALTER ON LBACSYS.LBAC$POLT WHENEVER SUCCESSFUL;
NOAUDIT ALTER ON LBACSYS.LBAC$POLT WHENEVER NOT SUCCESSFUL;
NOAUDIT SELECT ON LBACSYS.LBAC$POLT WHENEVER NOT SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.LBAC$PROG WHENEVER SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.LBAC$PROG WHENEVER NOT SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.LBAC$PROG WHENEVER SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.LBAC$PROG WHENEVER NOT SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.LBAC$PROG WHENEVER SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.LBAC$PROG WHENEVER NOT SUCCESSFUL;
NOAUDIT INDEX ON LBACSYS.LBAC$PROG WHENEVER SUCCESSFUL;
NOAUDIT INDEX ON LBACSYS.LBAC$PROG WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.LBAC$PROG WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.LBAC$PROG WHENEVER NOT SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.LBAC$PROG WHENEVER SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.LBAC$PROG WHENEVER NOT SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.LBAC$PROG WHENEVER SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.LBAC$PROG WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.LBAC$PROG WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.LBAC$PROG WHENEVER NOT SUCCESSFUL;
NOAUDIT ALTER ON LBACSYS.LBAC$PROG WHENEVER SUCCESSFUL;
NOAUDIT ALTER ON LBACSYS.LBAC$PROG WHENEVER NOT SUCCESSFUL;
NOAUDIT SELECT ON LBACSYS.LBAC$PROG WHENEVER NOT SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.LBAC$PROPS WHENEVER SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.LBAC$PROPS WHENEVER NOT SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.LBAC$PROPS WHENEVER SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.LBAC$PROPS WHENEVER NOT SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.LBAC$PROPS WHENEVER SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.LBAC$PROPS WHENEVER NOT SUCCESSFUL;
NOAUDIT INDEX ON LBACSYS.LBAC$PROPS WHENEVER SUCCESSFUL;
NOAUDIT INDEX ON LBACSYS.LBAC$PROPS WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.LBAC$PROPS WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.LBAC$PROPS WHENEVER NOT SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.LBAC$PROPS WHENEVER SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.LBAC$PROPS WHENEVER NOT SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.LBAC$PROPS WHENEVER SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.LBAC$PROPS WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.LBAC$PROPS WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.LBAC$PROPS WHENEVER NOT SUCCESSFUL;
NOAUDIT ALTER ON LBACSYS.LBAC$PROPS WHENEVER SUCCESSFUL;
NOAUDIT ALTER ON LBACSYS.LBAC$PROPS WHENEVER NOT SUCCESSFUL;
NOAUDIT SELECT ON LBACSYS.LBAC$PROPS WHENEVER NOT SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.LBAC$USER WHENEVER SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.LBAC$USER WHENEVER NOT SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.LBAC$USER WHENEVER SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.LBAC$USER WHENEVER NOT SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.LBAC$USER WHENEVER SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.LBAC$USER WHENEVER NOT SUCCESSFUL;
NOAUDIT INDEX ON LBACSYS.LBAC$USER WHENEVER SUCCESSFUL;
NOAUDIT INDEX ON LBACSYS.LBAC$USER WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.LBAC$USER WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.LBAC$USER WHENEVER NOT SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.LBAC$USER WHENEVER SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.LBAC$USER WHENEVER NOT SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.LBAC$USER WHENEVER SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.LBAC$USER WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.LBAC$USER WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.LBAC$USER WHENEVER NOT SUCCESSFUL;
NOAUDIT ALTER ON LBACSYS.LBAC$USER WHENEVER SUCCESSFUL;
NOAUDIT ALTER ON LBACSYS.LBAC$USER WHENEVER NOT SUCCESSFUL;
NOAUDIT SELECT ON LBACSYS.LBAC$USER WHENEVER NOT SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.LBAC_AUDIT_ACTIONS WHENEVER SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.LBAC_AUDIT_ACTIONS WHENEVER NOT SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.LBAC_AUDIT_ACTIONS WHENEVER SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.LBAC_AUDIT_ACTIONS WHENEVER NOT SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.LBAC_AUDIT_ACTIONS WHENEVER SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.LBAC_AUDIT_ACTIONS WHENEVER NOT SUCCESSFUL;
NOAUDIT INDEX ON LBACSYS.LBAC_AUDIT_ACTIONS WHENEVER SUCCESSFUL;
NOAUDIT INDEX ON LBACSYS.LBAC_AUDIT_ACTIONS WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.LBAC_AUDIT_ACTIONS WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.LBAC_AUDIT_ACTIONS WHENEVER NOT SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.LBAC_AUDIT_ACTIONS WHENEVER SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.LBAC_AUDIT_ACTIONS WHENEVER NOT SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.LBAC_AUDIT_ACTIONS WHENEVER SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.LBAC_AUDIT_ACTIONS WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.LBAC_AUDIT_ACTIONS WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.LBAC_AUDIT_ACTIONS WHENEVER NOT SUCCESSFUL;
NOAUDIT ALTER ON LBACSYS.LBAC_AUDIT_ACTIONS WHENEVER SUCCESSFUL;
NOAUDIT ALTER ON LBACSYS.LBAC_AUDIT_ACTIONS WHENEVER NOT SUCCESSFUL;
NOAUDIT SELECT ON LBACSYS.LBAC_AUDIT_ACTIONS WHENEVER NOT SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.SA$COMPARTMENTS WHENEVER SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.SA$COMPARTMENTS WHENEVER NOT SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.SA$COMPARTMENTS WHENEVER SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.SA$COMPARTMENTS WHENEVER NOT SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.SA$COMPARTMENTS WHENEVER SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.SA$COMPARTMENTS WHENEVER NOT SUCCESSFUL;
NOAUDIT INDEX ON LBACSYS.SA$COMPARTMENTS WHENEVER SUCCESSFUL;
NOAUDIT INDEX ON LBACSYS.SA$COMPARTMENTS WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.SA$COMPARTMENTS WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.SA$COMPARTMENTS WHENEVER NOT SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.SA$COMPARTMENTS WHENEVER SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.SA$COMPARTMENTS WHENEVER NOT SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.SA$COMPARTMENTS WHENEVER SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.SA$COMPARTMENTS WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.SA$COMPARTMENTS WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.SA$COMPARTMENTS WHENEVER NOT SUCCESSFUL;

NOAUDIT ALTER ON LBACSYS.SA$COMPARTMENTS WHENEVER SUCCESSFUL;
NOAUDIT ALTER ON LBACSYS.SA$COMPARTMENTS WHENEVER NOT SUCCESSFUL;
NOAUDIT SELECT ON LBACSYS.SA$COMPARTMENTS WHENEVER NOT SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.SA$DIP_DEBUG WHENEVER SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.SA$DIP_DEBUG WHENEVER NOT SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.SA$DIP_DEBUG WHENEVER SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.SA$DIP_DEBUG WHENEVER NOT SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.SA$DIP_DEBUG WHENEVER SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.SA$DIP_DEBUG WHENEVER NOT SUCCESSFUL;
NOAUDIT INDEX ON LBACSYS.SA$DIP_DEBUG WHENEVER SUCCESSFUL;
NOAUDIT INDEX ON LBACSYS.SA$DIP_DEBUG WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.SA$DIP_DEBUG WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.SA$DIP_DEBUG WHENEVER NOT SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.SA$DIP_DEBUG WHENEVER SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.SA$DIP_DEBUG WHENEVER NOT SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.SA$DIP_DEBUG WHENEVER SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.SA$DIP_DEBUG WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.SA$DIP_DEBUG WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.SA$DIP_DEBUG WHENEVER NOT SUCCESSFUL;

NOAUDIT ALTER ON LBACSYS.SA$DIP_DEBUG WHENEVER SUCCESSFUL;
NOAUDIT ALTER ON LBACSYS.SA$DIP_DEBUG WHENEVER NOT SUCCESSFUL;
NOAUDIT SELECT ON LBACSYS.SA$DIP_DEBUG WHENEVER NOT SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.SA$DIP_EVENTS WHENEVER SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.SA$DIP_EVENTS WHENEVER NOT SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.SA$DIP_EVENTS WHENEVER SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.SA$DIP_EVENTS WHENEVER NOT SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.SA$DIP_EVENTS WHENEVER SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.SA$DIP_EVENTS WHENEVER NOT SUCCESSFUL;
NOAUDIT INDEX ON LBACSYS.SA$DIP_EVENTS WHENEVER SUCCESSFUL;
NOAUDIT INDEX ON LBACSYS.SA$DIP_EVENTS WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.SA$DIP_EVENTS WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.SA$DIP_EVENTS WHENEVER NOT SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.SA$DIP_EVENTS WHENEVER SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.SA$DIP_EVENTS WHENEVER NOT SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.SA$DIP_EVENTS WHENEVER SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.SA$DIP_EVENTS WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.SA$DIP_EVENTS WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.SA$DIP_EVENTS WHENEVER NOT SUCCESSFUL;

NOAUDIT ALTER ON LBACSYS.SA$DIP_EVENTS WHENEVER SUCCESSFUL;
NOAUDIT ALTER ON LBACSYS.SA$DIP_EVENTS WHENEVER NOT SUCCESSFUL;
NOAUDIT SELECT ON LBACSYS.SA$DIP_EVENTS WHENEVER NOT SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.SA$GROUPS WHENEVER SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.SA$GROUPS WHENEVER NOT SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.SA$GROUPS WHENEVER SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.SA$GROUPS WHENEVER NOT SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.SA$GROUPS WHENEVER SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.SA$GROUPS WHENEVER NOT SUCCESSFUL;
NOAUDIT INDEX ON LBACSYS.SA$GROUPS WHENEVER SUCCESSFUL;
NOAUDIT INDEX ON LBACSYS.SA$GROUPS WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.SA$GROUPS WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.SA$GROUPS WHENEVER NOT SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.SA$GROUPS WHENEVER SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.SA$GROUPS WHENEVER NOT SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.SA$GROUPS WHENEVER SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.SA$GROUPS WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.SA$GROUPS WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.SA$GROUPS WHENEVER NOT SUCCESSFUL;

NOAUDIT ALTER ON LBACSYS.SA$GROUPS WHENEVER SUCCESSFUL;
NOAUDIT ALTER ON LBACSYS.SA$GROUPS WHENEVER NOT SUCCESSFUL;
NOAUDIT SELECT ON LBACSYS.SA$GROUPS WHENEVER NOT SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.SA$LEVELS WHENEVER SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.SA$LEVELS WHENEVER NOT SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.SA$LEVELS WHENEVER SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.SA$LEVELS WHENEVER NOT SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.SA$LEVELS WHENEVER SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.SA$LEVELS WHENEVER NOT SUCCESSFUL;
NOAUDIT INDEX ON LBACSYS.SA$LEVELS WHENEVER SUCCESSFUL;
NOAUDIT INDEX ON LBACSYS.SA$LEVELS WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.SA$LEVELS WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.SA$LEVELS WHENEVER NOT SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.SA$LEVELS WHENEVER SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.SA$LEVELS WHENEVER NOT SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.SA$LEVELS WHENEVER SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.SA$LEVELS WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.SA$LEVELS WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.SA$LEVELS WHENEVER NOT SUCCESSFUL;

NOAUDIT ALTER ON LBACSYS.SA$LEVELS WHENEVER SUCCESSFUL;
NOAUDIT ALTER ON LBACSYS.SA$LEVELS WHENEVER NOT SUCCESSFUL;
NOAUDIT SELECT ON LBACSYS.SA$LEVELS WHENEVER NOT SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.SA$PROFILES WHENEVER SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.SA$PROFILES WHENEVER NOT SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.SA$PROFILES WHENEVER SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.SA$PROFILES WHENEVER NOT SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.SA$PROFILES WHENEVER SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.SA$PROFILES WHENEVER NOT SUCCESSFUL;
NOAUDIT INDEX ON LBACSYS.SA$PROFILES WHENEVER SUCCESSFUL;
NOAUDIT INDEX ON LBACSYS.SA$PROFILES WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.SA$PROFILES WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.SA$PROFILES WHENEVER NOT SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.SA$PROFILES WHENEVER SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.SA$PROFILES WHENEVER NOT SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.SA$PROFILES WHENEVER SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.SA$PROFILES WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.SA$PROFILES WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.SA$PROFILES WHENEVER NOT SUCCESSFUL;

NOAUDIT ALTER ON LBACSYS.SA$PROFILES WHENEVER SUCCESSFUL;
NOAUDIT ALTER ON LBACSYS.SA$PROFILES WHENEVER NOT SUCCESSFUL;
NOAUDIT SELECT ON LBACSYS.SA$PROFILES WHENEVER NOT SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.SA$USER_COMPARTMENTS WHENEVER SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.SA$USER_COMPARTMENTS WHENEVER NOT SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.SA$USER_COMPARTMENTS WHENEVER SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.SA$USER_COMPARTMENTS WHENEVER NOT SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.SA$USER_COMPARTMENTS WHENEVER SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.SA$USER_COMPARTMENTS WHENEVER NOT SUCCESSFUL;
NOAUDIT INDEX ON LBACSYS.SA$USER_COMPARTMENTS WHENEVER SUCCESSFUL;
NOAUDIT INDEX ON LBACSYS.SA$USER_COMPARTMENTS WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.SA$USER_COMPARTMENTS WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.SA$USER_COMPARTMENTS WHENEVER NOT SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.SA$USER_COMPARTMENTS WHENEVER SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.SA$USER_COMPARTMENTS WHENEVER NOT SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.SA$USER_COMPARTMENTS WHENEVER SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.SA$USER_COMPARTMENTS WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.SA$USER_COMPARTMENTS WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.SA$USER_COMPARTMENTS WHENEVER NOT SUCCESSFUL;

NOAUDIT ALTER ON LBACSYS.SA$USER_COMPARTMENTS WHENEVER SUCCESSFUL;
NOAUDIT ALTER ON LBACSYS.SA$USER_COMPARTMENTS WHENEVER NOT SUCCESSFUL;
NOAUDIT SELECT ON LBACSYS.SA$USER_COMPARTMENTS WHENEVER NOT SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.SA$USER_GROUPS WHENEVER SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.SA$USER_GROUPS WHENEVER NOT SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.SA$USER_GROUPS WHENEVER SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.SA$USER_GROUPS WHENEVER NOT SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.SA$USER_GROUPS WHENEVER SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.SA$USER_GROUPS WHENEVER NOT SUCCESSFUL;
NOAUDIT INDEX ON LBACSYS.SA$USER_GROUPS WHENEVER SUCCESSFUL;
NOAUDIT INDEX ON LBACSYS.SA$USER_GROUPS WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.SA$USER_GROUPS WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.SA$USER_GROUPS WHENEVER NOT SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.SA$USER_GROUPS WHENEVER SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.SA$USER_GROUPS WHENEVER NOT SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.SA$USER_GROUPS WHENEVER SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.SA$USER_GROUPS WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.SA$USER_GROUPS WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.SA$USER_GROUPS WHENEVER NOT SUCCESSFUL;
NOAUDIT ALTER ON LBACSYS.SA$USER_GROUPS WHENEVER SUCCESSFUL;
NOAUDIT ALTER ON LBACSYS.SA$USER_GROUPS WHENEVER NOT SUCCESSFUL;
NOAUDIT SELECT ON LBACSYS.SA$USER_GROUPS WHENEVER NOT SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.SA$USER_LEVELS WHENEVER SUCCESSFUL;
NOAUDIT UPDATE ON LBACSYS.SA$USER_LEVELS WHENEVER NOT SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.SA$USER_LEVELS WHENEVER SUCCESSFUL;
NOAUDIT RENAME ON LBACSYS.SA$USER_LEVELS WHENEVER NOT SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.SA$USER_LEVELS WHENEVER SUCCESSFUL;
NOAUDIT INSERT ON LBACSYS.SA$USER_LEVELS WHENEVER NOT SUCCESSFUL;
NOAUDIT INDEX ON LBACSYS.SA$USER_LEVELS WHENEVER SUCCESSFUL;
NOAUDIT INDEX ON LBACSYS.SA$USER_LEVELS WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.SA$USER_LEVELS WHENEVER SUCCESSFUL;
NOAUDIT GRANT ON LBACSYS.SA$USER_LEVELS WHENEVER NOT SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.SA$USER_LEVELS WHENEVER SUCCESSFUL;
NOAUDIT DELETE ON LBACSYS.SA$USER_LEVELS WHENEVER NOT SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.SA$USER_LEVELS WHENEVER SUCCESSFUL;
NOAUDIT COMMENT ON LBACSYS.SA$USER_LEVELS WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.SA$USER_LEVELS WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ON LBACSYS.SA$USER_LEVELS WHENEVER NOT SUCCESSFUL;
NOAUDIT ALTER ON LBACSYS.SA$USER_LEVELS WHENEVER SUCCESSFUL;
NOAUDIT ALTER ON LBACSYS.SA$USER_LEVELS WHENEVER NOT SUCCESSFUL;
NOAUDIT SELECT ON LBACSYS.SA$USER_LEVELS WHENEVER NOT SUCCESSFUL;


NOAUDIT SELECT TABLE BY LBACSYS WHENEVER NOT SUCCESSFUL;
NOAUDIT SELECT SEQUENCE BY LBACSYS WHENEVER NOT SUCCESSFUL;
NOAUDIT MATERIALIZED VIEW BY LBACSYS WHENEVER SUCCESSFUL;
NOAUDIT MATERIALIZED VIEW BY LBACSYS WHENEVER NOT SUCCESSFUL;
NOAUDIT MANAGE TABLESPACE BY LBACSYS WHENEVER SUCCESSFUL;
NOAUDIT MANAGE TABLESPACE BY LBACSYS WHENEVER NOT SUCCESSFUL;
NOAUDIT MANAGE SCHEDULER BY LBACSYS WHENEVER SUCCESSFUL;
NOAUDIT MANAGE SCHEDULER BY LBACSYS WHENEVER NOT SUCCESSFUL;
NOAUDIT INDEX BY LBACSYS WHENEVER SUCCESSFUL;
NOAUDIT INDEX BY LBACSYS WHENEVER NOT SUCCESSFUL;
NOAUDIT IMPORT FULL DATABASE BY LBACSYS WHENEVER SUCCESSFUL;
NOAUDIT IMPORT FULL DATABASE BY LBACSYS WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT TYPE BY LBACSYS WHENEVER SUCCESSFUL;
NOAUDIT GRANT TYPE BY LBACSYS WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT TABLE BY LBACSYS WHENEVER SUCCESSFUL;
NOAUDIT GRANT TABLE BY LBACSYS WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT SEQUENCE BY LBACSYS WHENEVER SUCCESSFUL;
NOAUDIT GRANT SEQUENCE BY LBACSYS WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT PROCEDURE BY LBACSYS WHENEVER SUCCESSFUL;
NOAUDIT GRANT PROCEDURE BY LBACSYS WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT DIRECTORY BY LBACSYS WHENEVER SUCCESSFUL;
NOAUDIT GRANT DIRECTORY BY LBACSYS WHENEVER NOT SUCCESSFUL;
NOAUDIT EXPORT FULL DATABASE BY LBACSYS WHENEVER SUCCESSFUL;
NOAUDIT EXPORT FULL DATABASE BY LBACSYS WHENEVER NOT SUCCESSFUL;
NOAUDIT EXEMPT IDENTITY POLICY BY LBACSYS WHENEVER SUCCESSFUL;
NOAUDIT EXEMPT IDENTITY POLICY BY LBACSYS WHENEVER NOT SUCCESSFUL;
NOAUDIT EXEMPT ACCESS POLICY BY LBACSYS WHENEVER SUCCESSFUL;
NOAUDIT EXEMPT ACCESS POLICY BY LBACSYS WHENEVER NOT SUCCESSFUL;
NOAUDIT EXECUTE PROCEDURE BY LBACSYS WHENEVER NOT SUCCESSFUL;
NOAUDIT EXECUTE LIBRARY BY LBACSYS WHENEVER NOT SUCCESSFUL;
NOAUDIT DROP USER BY LBACSYS WHENEVER SUCCESSFUL;
NOAUDIT DROP USER BY LBACSYS WHENEVER NOT SUCCESSFUL;
NOAUDIT DROP TABLESPACE BY LBACSYS WHENEVER SUCCESSFUL;
NOAUDIT DROP TABLESPACE BY LBACSYS WHENEVER NOT SUCCESSFUL;
NOAUDIT DROP ROLLBACK SEGMENT BY LBACSYS WHENEVER SUCCESSFUL;
NOAUDIT DROP ROLLBACK SEGMENT BY LBACSYS WHENEVER NOT SUCCESSFUL;
NOAUDIT DROP PUBLIC SYNONYM BY LBACSYS WHENEVER SUCCESSFUL;
NOAUDIT DROP PUBLIC SYNONYM BY LBACSYS WHENEVER NOT SUCCESSFUL;
NOAUDIT DROP PUBLIC DATABASE LINK BY LBACSYS WHENEVER SUCCESSFUL;
NOAUDIT DROP PUBLIC DATABASE LINK BY LBACSYS WHENEVER NOT SUCCESSFUL;
NOAUDIT DROP PROFILE BY LBACSYS WHENEVER SUCCESSFUL;
NOAUDIT DROP PROFILE BY LBACSYS WHENEVER NOT SUCCESSFUL;
NOAUDIT DIRECTORY BY LBACSYS WHENEVER SUCCESSFUL;
NOAUDIT DIRECTORY BY LBACSYS WHENEVER NOT SUCCESSFUL;
NOAUDIT DEBUG PROCEDURE BY LBACSYS WHENEVER SUCCESSFUL;
NOAUDIT DEBUG PROCEDURE BY LBACSYS WHENEVER NOT SUCCESSFUL;
NOAUDIT DEBUG CONNECT SESSION BY LBACSYS WHENEVER SUCCESSFUL;
NOAUDIT DEBUG CONNECT SESSION BY LBACSYS WHENEVER NOT SUCCESSFUL;
NOAUDIT DEBUG ANY PROCEDURE BY LBACSYS WHENEVER SUCCESSFUL;
NOAUDIT DEBUG ANY PROCEDURE BY LBACSYS WHENEVER NOT SUCCESSFUL;
NOAUDIT DATABASE LINK BY LBACSYS WHENEVER SUCCESSFUL;
NOAUDIT DATABASE LINK BY LBACSYS WHENEVER NOT SUCCESSFUL;
NOAUDIT CREATE VIEW BY LBACSYS WHENEVER SUCCESSFUL;
NOAUDIT CREATE VIEW BY LBACSYS WHENEVER NOT SUCCESSFUL;
NOAUDIT CREATE USER BY LBACSYS WHENEVER SUCCESSFUL;
NOAUDIT CREATE USER BY LBACSYS WHENEVER NOT SUCCESSFUL;
NOAUDIT CREATE TYPE BY LBACSYS WHENEVER SUCCESSFUL;
NOAUDIT CREATE TYPE BY LBACSYS WHENEVER NOT SUCCESSFUL;
NOAUDIT CREATE TRIGGER BY LBACSYS WHENEVER SUCCESSFUL;
NOAUDIT CREATE TRIGGER BY LBACSYS WHENEVER NOT SUCCESSFUL;
NOAUDIT CREATE TABLESPACE BY LBACSYS WHENEVER SUCCESSFUL;
NOAUDIT CREATE TABLESPACE BY LBACSYS WHENEVER NOT SUCCESSFUL;
NOAUDIT CREATE TABLE BY LBACSYS WHENEVER SUCCESSFUL;
NOAUDIT CREATE TABLE BY LBACSYS WHENEVER NOT SUCCESSFUL;
NOAUDIT CREATE SYNONYM BY LBACSYS WHENEVER SUCCESSFUL;
NOAUDIT CREATE SYNONYM BY LBACSYS WHENEVER NOT SUCCESSFUL;
NOAUDIT CREATE SESSION BY LBACSYS WHENEVER SUCCESSFUL;
NOAUDIT CREATE SESSION BY LBACSYS WHENEVER NOT SUCCESSFUL;
NOAUDIT CREATE SEQUENCE BY LBACSYS WHENEVER SUCCESSFUL;
NOAUDIT CREATE SEQUENCE BY LBACSYS WHENEVER NOT SUCCESSFUL;
NOAUDIT CREATE ROLLBACK SEGMENT BY LBACSYS WHENEVER SUCCESSFUL;
NOAUDIT CREATE ROLLBACK SEGMENT BY LBACSYS WHENEVER NOT SUCCESSFUL;
NOAUDIT CREATE ROLE BY LBACSYS WHENEVER SUCCESSFUL;
NOAUDIT CREATE ROLE BY LBACSYS WHENEVER NOT SUCCESSFUL;
NOAUDIT CREATE PUBLIC SYNONYM BY LBACSYS WHENEVER SUCCESSFUL;
NOAUDIT CREATE PUBLIC SYNONYM BY LBACSYS WHENEVER NOT SUCCESSFUL;
NOAUDIT CREATE PUBLIC DATABASE LINK BY LBACSYS WHENEVER SUCCESSFUL;
NOAUDIT CREATE PUBLIC DATABASE LINK BY LBACSYS WHENEVER NOT SUCCESSFUL;
NOAUDIT CREATE PROFILE BY LBACSYS WHENEVER SUCCESSFUL;
NOAUDIT CREATE PROFILE BY LBACSYS WHENEVER NOT SUCCESSFUL;
NOAUDIT CREATE PROCEDURE BY LBACSYS WHENEVER SUCCESSFUL;
NOAUDIT CREATE PROCEDURE BY LBACSYS WHENEVER NOT SUCCESSFUL;
NOAUDIT CREATE OPERATOR BY LBACSYS WHENEVER SUCCESSFUL;
NOAUDIT CREATE OPERATOR BY LBACSYS WHENEVER NOT SUCCESSFUL;
NOAUDIT CREATE MATERIALIZED VIEW BY LBACSYS WHENEVER SUCCESSFUL;
NOAUDIT CREATE MATERIALIZED VIEW BY LBACSYS WHENEVER NOT SUCCESSFUL;
NOAUDIT CREATE LIBRARY BY LBACSYS WHENEVER SUCCESSFUL;
NOAUDIT CREATE LIBRARY BY LBACSYS WHENEVER NOT SUCCESSFUL;
NOAUDIT CREATE JOB BY LBACSYS WHENEVER SUCCESSFUL;
NOAUDIT CREATE JOB BY LBACSYS WHENEVER NOT SUCCESSFUL;
NOAUDIT CREATE INDEXTYPE BY LBACSYS WHENEVER SUCCESSFUL;
NOAUDIT CREATE INDEXTYPE BY LBACSYS WHENEVER NOT SUCCESSFUL;
NOAUDIT CREATE DATABASE LINK BY LBACSYS WHENEVER SUCCESSFUL;
NOAUDIT CREATE DATABASE LINK BY LBACSYS WHENEVER NOT SUCCESSFUL;
NOAUDIT CREATE CLUSTER BY LBACSYS WHENEVER SUCCESSFUL;
NOAUDIT CREATE CLUSTER BY LBACSYS WHENEVER NOT SUCCESSFUL;
NOAUDIT CONTEXT BY LBACSYS WHENEVER SUCCESSFUL;
NOAUDIT CONTEXT BY LBACSYS WHENEVER NOT SUCCESSFUL;
NOAUDIT COMMENT TABLE BY LBACSYS WHENEVER SUCCESSFUL;
NOAUDIT COMMENT TABLE BY LBACSYS WHENEVER NOT SUCCESSFUL;
NOAUDIT CLUSTER BY LBACSYS WHENEVER SUCCESSFUL;
NOAUDIT CLUSTER BY LBACSYS WHENEVER NOT SUCCESSFUL;
NOAUDIT BECOME USER BY LBACSYS WHENEVER SUCCESSFUL;
NOAUDIT BECOME USER BY LBACSYS WHENEVER NOT SUCCESSFUL;

NOAUDIT ALTER USER BY LBACSYS WHENEVER SUCCESSFUL;
NOAUDIT ALTER USER BY LBACSYS WHENEVER NOT SUCCESSFUL;
NOAUDIT ALTER TABLESPACE BY LBACSYS WHENEVER SUCCESSFUL;
NOAUDIT ALTER TABLESPACE BY LBACSYS WHENEVER NOT SUCCESSFUL;
NOAUDIT ALTER TABLE BY LBACSYS WHENEVER SUCCESSFUL;
NOAUDIT ALTER TABLE BY LBACSYS WHENEVER NOT SUCCESSFUL;
NOAUDIT ALTER SYSTEM BY LBACSYS WHENEVER SUCCESSFUL;
NOAUDIT ALTER SYSTEM BY LBACSYS WHENEVER NOT SUCCESSFUL;
NOAUDIT ALTER SESSION BY LBACSYS WHENEVER SUCCESSFUL;
NOAUDIT ALTER SESSION BY LBACSYS WHENEVER NOT SUCCESSFUL;
NOAUDIT ALTER SEQUENCE BY LBACSYS WHENEVER SUCCESSFUL;
NOAUDIT ALTER SEQUENCE BY LBACSYS WHENEVER NOT SUCCESSFUL;
NOAUDIT ALTER ROLLBACK SEGMENT BY LBACSYS WHENEVER SUCCESSFUL;
NOAUDIT ALTER ROLLBACK SEGMENT BY LBACSYS WHENEVER NOT SUCCESSFUL;
NOAUDIT ALTER RESOURCE COST BY LBACSYS WHENEVER SUCCESSFUL;
NOAUDIT ALTER RESOURCE COST BY LBACSYS WHENEVER NOT SUCCESSFUL;
NOAUDIT ALTER PROFILE BY LBACSYS WHENEVER SUCCESSFUL;
NOAUDIT ALTER PROFILE BY LBACSYS WHENEVER NOT SUCCESSFUL;
NOAUDIT ALTER DATABASE BY LBACSYS WHENEVER SUCCESSFUL;
NOAUDIT ALTER DATABASE BY LBACSYS WHENEVER NOT SUCCESSFUL;
NOAUDIT ADMINISTER DATABASE TRIGGER BY LBACSYS WHENEVER SUCCESSFUL;
NOAUDIT ADMINISTER DATABASE TRIGGER BY LBACSYS WHENEVER NOT SUCCESSFUL;

NOAUDIT GRANT DIRECTORY WHENEVER SUCCESSFUL;
NOAUDIT GRANT DIRECTORY WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT PROCEDURE WHENEVER SUCCESSFUL;
NOAUDIT GRANT PROCEDURE WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT SEQUENCE WHENEVER SUCCESSFUL;
NOAUDIT GRANT SEQUENCE WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT TABLE WHENEVER SUCCESSFUL;
NOAUDIT GRANT TABLE WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT TYPE WHENEVER SUCCESSFUL;
NOAUDIT GRANT TYPE WHENEVER NOT SUCCESSFUL;

NOAUDIT EXEMPT ACCESS POLICY WHENEVER NOT SUCCESSFUL;
NOAUDIT FORCE TRANSACTION WHENEVER SUCCESSFUL;
NOAUDIT FORCE TRANSACTION WHENEVER NOT SUCCESSFUL;
NOAUDIT MANAGE TABLESPACE WHENEVER SUCCESSFUL;
NOAUDIT MANAGE TABLESPACE WHENEVER NOT SUCCESSFUL;
NOAUDIT DELETE ANY TABLE WHENEVER SUCCESSFUL;
NOAUDIT DELETE ANY TABLE WHENEVER NOT SUCCESSFUL;
NOAUDIT INSERT ANY TABLE WHENEVER SUCCESSFUL;
NOAUDIT INSERT ANY TABLE WHENEVER NOT SUCCESSFUL;
NOAUDIT SELECT ANY SEQUENCE WHENEVER SUCCESSFUL;
NOAUDIT SELECT ANY SEQUENCE WHENEVER NOT SUCCESSFUL;
NOAUDIT UPDATE ANY TABLE WHENEVER SUCCESSFUL;
NOAUDIT UPDATE ANY TABLE WHENEVER NOT SUCCESSFUL;
NOAUDIT TRUNCATE WHENEVER SUCCESSFUL;
NOAUDIT TRUNCATE WHENEVER NOT SUCCESSFUL;
NOAUDIT BECOME USER WHENEVER SUCCESSFUL;
NOAUDIT BECOME USER WHENEVER NOT SUCCESSFUL;
NOAUDIT RESTRICTED SESSION WHENEVER SUCCESSFUL;
NOAUDIT RESTRICTED SESSION WHENEVER NOT SUCCESSFUL;
NOAUDIT AUDIT ANY WHENEVER SUCCESSFUL;
NOAUDIT AUDIT ANY WHENEVER NOT SUCCESSFUL;
NOAUDIT BACKUP ANY TABLE WHENEVER SUCCESSFUL;
NOAUDIT BACKUP ANY TABLE WHENEVER NOT SUCCESSFUL;
NOAUDIT FORCE ANY TRANSACTION WHENEVER SUCCESSFUL;
NOAUDIT FORCE ANY TRANSACTION WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ANY OBJECT PRIVILEGE WHENEVER SUCCESSFUL;
NOAUDIT GRANT ANY OBJECT PRIVILEGE WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ANY PRIVILEGE WHENEVER SUCCESSFUL;
NOAUDIT GRANT ANY PRIVILEGE WHENEVER NOT SUCCESSFUL;
NOAUDIT GRANT ANY ROLE WHENEVER SUCCESSFUL;
NOAUDIT GRANT ANY ROLE WHENEVER NOT SUCCESSFUL;
NOAUDIT ALTER ANY INDEX WHENEVER SUCCESSFUL;
NOAUDIT ALTER ANY INDEX WHENEVER NOT SUCCESSFUL;
NOAUDIT ALTER ANY LIBRARY WHENEVER SUCCESSFUL;
NOAUDIT ALTER ANY LIBRARY WHENEVER NOT SUCCESSFUL;
NOAUDIT ALTER ANY PROCEDURE WHENEVER SUCCESSFUL;
NOAUDIT ALTER ANY PROCEDURE WHENEVER NOT SUCCESSFUL;
NOAUDIT ALTER ANY ROLE WHENEVER SUCCESSFUL;
NOAUDIT ALTER ANY ROLE WHENEVER NOT SUCCESSFUL;
NOAUDIT ALTER ANY SEQUENCE WHENEVER SUCCESSFUL;
NOAUDIT ALTER ANY SEQUENCE WHENEVER NOT SUCCESSFUL;
NOAUDIT ALTER ANY TABLE WHENEVER SUCCESSFUL;
NOAUDIT ALTER ANY TABLE WHENEVER NOT SUCCESSFUL;
NOAUDIT ALTER ANY TRIGGER WHENEVER SUCCESSFUL;
NOAUDIT ALTER ANY TRIGGER WHENEVER NOT SUCCESSFUL;
NOAUDIT ALTER DATABASE WHENEVER SUCCESSFUL;
NOAUDIT ALTER DATABASE WHENEVER NOT SUCCESSFUL;
NOAUDIT ALTER PROFILE WHENEVER SUCCESSFUL;
NOAUDIT ALTER PROFILE WHENEVER NOT SUCCESSFUL;
NOAUDIT ALTER ROLLBACK SEGMENT WHENEVER SUCCESSFUL;
NOAUDIT ALTER ROLLBACK SEGMENT WHENEVER NOT SUCCESSFUL;
NOAUDIT ALTER SESSION WHENEVER SUCCESSFUL;
NOAUDIT ALTER SESSION WHENEVER NOT SUCCESSFUL;
NOAUDIT ALTER TABLESPACE WHENEVER SUCCESSFUL;
NOAUDIT ALTER TABLESPACE WHENEVER NOT SUCCESSFUL;
NOAUDIT ALTER USER WHENEVER SUCCESSFUL;
NOAUDIT ALTER USER WHENEVER NOT SUCCESSFUL;
NOAUDIT CREATE ANY DIMENSION WHENEVER SUCCESSFUL;
NOAUDIT CREATE ANY DIMENSION WHENEVER NOT SUCCESSFUL;
NOAUDIT CREATE ANY DIRECTORY WHENEVER SUCCESSFUL;
NOAUDIT CREATE ANY DIRECTORY WHENEVER NOT SUCCESSFUL;
NOAUDIT CREATE ANY LIBRARY WHENEVER SUCCESSFUL;
NOAUDIT CREATE ANY LIBRARY WHENEVER NOT SUCCESSFUL;
NOAUDIT CREATE ANY PROCEDURE WHENEVER SUCCESSFUL;
NOAUDIT CREATE ANY PROCEDURE WHENEVER NOT SUCCESSFUL;
NOAUDIT CREATE ANY SNAPSHOT WHENEVER SUCCESSFUL;
NOAUDIT CREATE ANY SNAPSHOT WHENEVER NOT SUCCESSFUL;
NOAUDIT CREATE ANY TABLE WHENEVER SUCCESSFUL;
NOAUDIT CREATE ANY TABLE WHENEVER NOT SUCCESSFUL;
NOAUDIT CREATE ANY TRIGGER WHENEVER SUCCESSFUL;
NOAUDIT CREATE ANY TRIGGER WHENEVER NOT SUCCESSFUL;
NOAUDIT CREATE ANY VIEW WHENEVER SUCCESSFUL;
NOAUDIT CREATE ANY VIEW WHENEVER NOT SUCCESSFUL;
NOAUDIT CREATE CLUSTER WHENEVER SUCCESSFUL;
NOAUDIT CREATE CLUSTER WHENEVER NOT SUCCESSFUL;
NOAUDIT CREATE DATABASE LINK WHENEVER SUCCESSFUL;
NOAUDIT CREATE DATABASE LINK WHENEVER NOT SUCCESSFUL;
NOAUDIT CREATE DIMENSION WHENEVER SUCCESSFUL;
NOAUDIT CREATE DIMENSION WHENEVER NOT SUCCESSFUL;
NOAUDIT CREATE PROCEDURE WHENEVER SUCCESSFUL;
NOAUDIT CREATE PROCEDURE WHENEVER NOT SUCCESSFUL;
NOAUDIT CREATE PROFILE WHENEVER SUCCESSFUL;
NOAUDIT CREATE PROFILE WHENEVER NOT SUCCESSFUL;
NOAUDIT CREATE PUBLIC DATABASE LINK WHENEVER SUCCESSFUL;
NOAUDIT CREATE PUBLIC DATABASE LINK WHENEVER NOT SUCCESSFUL;
NOAUDIT CREATE PUBLIC SYNONYM WHENEVER SUCCESSFUL;
NOAUDIT CREATE PUBLIC SYNONYM WHENEVER NOT SUCCESSFUL;
NOAUDIT CREATE ROLE WHENEVER SUCCESSFUL;
NOAUDIT CREATE ROLE WHENEVER NOT SUCCESSFUL;
NOAUDIT CREATE ROLLBACK SEGMENT WHENEVER SUCCESSFUL;
NOAUDIT CREATE ROLLBACK SEGMENT WHENEVER NOT SUCCESSFUL;
NOAUDIT CREATE SEQUENCE WHENEVER SUCCESSFUL;
NOAUDIT CREATE SEQUENCE WHENEVER NOT SUCCESSFUL;
NOAUDIT CREATE SESSION WHENEVER SUCCESSFUL;
NOAUDIT CREATE SESSION WHENEVER NOT SUCCESSFUL;
NOAUDIT CREATE SNAPSHOT WHENEVER SUCCESSFUL;
NOAUDIT CREATE SNAPSHOT WHENEVER NOT SUCCESSFUL;
NOAUDIT CREATE SYNONYM WHENEVER SUCCESSFUL;
NOAUDIT CREATE SYNONYM WHENEVER NOT SUCCESSFUL;
NOAUDIT CREATE TABLE WHENEVER SUCCESSFUL;
NOAUDIT CREATE TABLE WHENEVER NOT SUCCESSFUL;
NOAUDIT CREATE TABLESPACE WHENEVER SUCCESSFUL;
NOAUDIT CREATE TABLESPACE WHENEVER NOT SUCCESSFUL;
NOAUDIT CREATE TRIGGER WHENEVER SUCCESSFUL;
NOAUDIT CREATE TRIGGER WHENEVER NOT SUCCESSFUL;
NOAUDIT CREATE TYPE WHENEVER SUCCESSFUL;
NOAUDIT CREATE TYPE WHENEVER NOT SUCCESSFUL;
NOAUDIT CREATE USER WHENEVER SUCCESSFUL;
NOAUDIT CREATE USER WHENEVER NOT SUCCESSFUL;
NOAUDIT CREATE VIEW WHENEVER SUCCESSFUL;
NOAUDIT CREATE VIEW WHENEVER NOT SUCCESSFUL;
NOAUDIT DROP ANY DIMENSION WHENEVER SUCCESSFUL;
NOAUDIT DROP ANY DIMENSION WHENEVER NOT SUCCESSFUL;
NOAUDIT DROP ANY DIRECTORY WHENEVER SUCCESSFUL;
NOAUDIT DROP ANY DIRECTORY WHENEVER NOT SUCCESSFUL;
NOAUDIT DROP ANY INDEX WHENEVER SUCCESSFUL;
NOAUDIT DROP ANY INDEX WHENEVER NOT SUCCESSFUL;
NOAUDIT DROP ANY LIBRARY WHENEVER SUCCESSFUL;
NOAUDIT DROP ANY LIBRARY WHENEVER NOT SUCCESSFUL;
NOAUDIT DROP ANY PROCEDURE WHENEVER SUCCESSFUL;
NOAUDIT DROP ANY PROCEDURE WHENEVER NOT SUCCESSFUL;
NOAUDIT DROP ANY ROLE WHENEVER SUCCESSFUL;
NOAUDIT DROP ANY ROLE WHENEVER NOT SUCCESSFUL;
NOAUDIT DROP ANY SEQUENCE WHENEVER SUCCESSFUL;
NOAUDIT DROP ANY SEQUENCE WHENEVER NOT SUCCESSFUL;
NOAUDIT DROP ANY SNAPSHOT WHENEVER SUCCESSFUL;
NOAUDIT DROP ANY SNAPSHOT WHENEVER NOT SUCCESSFUL;
NOAUDIT DROP ANY SYNONYM WHENEVER SUCCESSFUL;
NOAUDIT DROP ANY SYNONYM WHENEVER NOT SUCCESSFUL;
NOAUDIT DROP ANY TABLE WHENEVER SUCCESSFUL;
NOAUDIT DROP ANY TABLE WHENEVER NOT SUCCESSFUL;
NOAUDIT DROP ANY TRIGGER WHENEVER SUCCESSFUL;
NOAUDIT DROP ANY TRIGGER WHENEVER NOT SUCCESSFUL;
NOAUDIT DROP ANY TYPE WHENEVER SUCCESSFUL;
NOAUDIT DROP ANY TYPE WHENEVER NOT SUCCESSFUL;
NOAUDIT DROP ANY VIEW WHENEVER SUCCESSFUL;
NOAUDIT DROP ANY VIEW WHENEVER NOT SUCCESSFUL;
NOAUDIT DROP PROFILE WHENEVER SUCCESSFUL;
NOAUDIT DROP PROFILE WHENEVER NOT SUCCESSFUL;
NOAUDIT DROP PUBLIC DATABASE LINK WHENEVER SUCCESSFUL;
NOAUDIT DROP PUBLIC DATABASE LINK WHENEVER NOT SUCCESSFUL;
NOAUDIT DROP PUBLIC SYNONYM WHENEVER SUCCESSFUL;
NOAUDIT DROP PUBLIC SYNONYM WHENEVER NOT SUCCESSFUL;
NOAUDIT DROP ROLLBACK SEGMENT WHENEVER SUCCESSFUL;
NOAUDIT DROP ROLLBACK SEGMENT WHENEVER NOT SUCCESSFUL;
NOAUDIT DROP TABLESPACE WHENEVER SUCCESSFUL;
NOAUDIT DROP TABLESPACE WHENEVER NOT SUCCESSFUL;
NOAUDIT DROP USER WHENEVER SUCCESSFUL;
NOAUDIT DROP USER WHENEVER NOT SUCCESSFUL;
NOAUDIT DROP ANY CONTEXT WHENEVER SUCCESSFUL;
NOAUDIT DROP ANY CONTEXT WHENEVER NOT SUCCESSFUL;
NOAUDIT EXECUTE ANY INDEXTYPE WHENEVER NOT SUCCESSFUL;
NOAUDIT EXECUTE ANY LIBRARY WHENEVER NOT SUCCESSFUL;
NOAUDIT EXECUTE ANY OPERATOR WHENEVER NOT SUCCESSFUL;
NOAUDIT EXECUTE ANY TYPE WHENEVER NOT SUCCESSFUL;
NOAUDIT EXECUTE ANY INDEXTYPE WHENEVER SUCCESSFUL;
NOAUDIT EXECUTE ANY LIBRARY WHENEVER SUCCESSFUL;
NOAUDIT EXECUTE ANY OPERATOR WHENEVER SUCCESSFUL;
NOAUDIT EXECUTE ANY TYPE WHENEVER SUCCESSFUL;
NOAUDIT FLASHBACK ANY TABLE WHENEVER SUCCESSFUL;
NOAUDIT FLASHBACK ANY TABLE WHENEVER NOT SUCCESSFUL;
NOAUDIT ALTER ANY CLUSTER WHENEVER SUCCESSFUL;
NOAUDIT ALTER ANY CLUSTER WHENEVER NOT SUCCESSFUL;
NOAUDIT ALTER ANY INDEXTYPE WHENEVER SUCCESSFUL;
NOAUDIT ALTER ANY INDEXTYPE WHENEVER NOT SUCCESSFUL;
NOAUDIT ALTER ANY OPERATOR WHENEVER SUCCESSFUL;
NOAUDIT ALTER ANY OPERATOR WHENEVER NOT SUCCESSFUL;
NOAUDIT ALTER ANY SNAPSHOT WHENEVER SUCCESSFUL;
NOAUDIT ALTER ANY SNAPSHOT WHENEVER NOT SUCCESSFUL;
NOAUDIT ALTER ANY TYPE WHENEVER SUCCESSFUL;
NOAUDIT ALTER ANY TYPE WHENEVER NOT SUCCESSFUL;
NOAUDIT ALTER SEQUENCE WHENEVER SUCCESSFUL;
NOAUDIT ALTER SEQUENCE WHENEVER NOT SUCCESSFUL;
NOAUDIT ALTER SYSTEM WHENEVER SUCCESSFUL;
NOAUDIT ALTER SYSTEM WHENEVER NOT SUCCESSFUL;
NOAUDIT ALTER TABLE WHENEVER SUCCESSFUL;
NOAUDIT ALTER TABLE WHENEVER NOT SUCCESSFUL;
NOAUDIT COMMENT ANY TABLE WHENEVER SUCCESSFUL;
NOAUDIT COMMENT ANY TABLE WHENEVER NOT SUCCESSFUL;
NOAUDIT COMMENT TABLE WHENEVER SUCCESSFUL;
NOAUDIT COMMENT TABLE WHENEVER NOT SUCCESSFUL;
NOAUDIT CREATE ANY CLUSTER WHENEVER SUCCESSFUL;
NOAUDIT CREATE ANY CLUSTER WHENEVER NOT SUCCESSFUL;
NOAUDIT CREATE ANY CONTEXT WHENEVER SUCCESSFUL;
NOAUDIT CREATE ANY CONTEXT WHENEVER NOT SUCCESSFUL;
NOAUDIT CREATE ANY INDEX WHENEVER SUCCESSFUL;
NOAUDIT CREATE ANY INDEX WHENEVER NOT SUCCESSFUL;
NOAUDIT CREATE ANY INDEXTYPE WHENEVER SUCCESSFUL;
NOAUDIT CREATE ANY INDEXTYPE WHENEVER NOT SUCCESSFUL;
NOAUDIT CREATE ANY OPERATOR WHENEVER SUCCESSFUL;
NOAUDIT CREATE ANY SEQUENCE WHENEVER SUCCESSFUL;
NOAUDIT CREATE ANY SEQUENCE WHENEVER NOT SUCCESSFUL;
NOAUDIT CREATE ANY SYNONYM WHENEVER SUCCESSFUL;
NOAUDIT CREATE ANY SYNONYM WHENEVER NOT SUCCESSFUL;
NOAUDIT CREATE ANY TYPE WHENEVER SUCCESSFUL;
NOAUDIT CREATE ANY TYPE WHENEVER NOT SUCCESSFUL;
NOAUDIT CREATE INDEXTYPE WHENEVER SUCCESSFUL;
NOAUDIT CREATE INDEXTYPE WHENEVER NOT SUCCESSFUL;
NOAUDIT CREATE LIBRARY WHENEVER SUCCESSFUL;
NOAUDIT CREATE LIBRARY WHENEVER NOT SUCCESSFUL;
NOAUDIT CREATE OPERATOR WHENEVER SUCCESSFUL;
NOAUDIT CREATE OPERATOR WHENEVER NOT SUCCESSFUL;
NOAUDIT DROP ANY CLUSTER WHENEVER SUCCESSFUL;
NOAUDIT DROP ANY CLUSTER WHENEVER NOT SUCCESSFUL;
NOAUDIT DROP ANY INDEXTYPE WHENEVER SUCCESSFUL;
NOAUDIT DROP ANY INDEXTYPE WHENEVER NOT SUCCESSFUL;
NOAUDIT DROP ANY OPERATOR WHENEVER SUCCESSFUL;
NOAUDIT DROP ANY OPERATOR WHENEVER NOT SUCCESSFUL;
NOAUDIT EXECUTE ANY PROCEDURE WHENEVER NOT SUCCESSFUL;
NOAUDIT EXECUTE ANY PROCEDURE WHENEVER SUCCESSFUL;
NOAUDIT DEBUG CONNECT SESSION WHENEVER SUCCESSFUL;
NOAUDIT DEBUG CONNECT SESSION WHENEVER NOT SUCCESSFUL;
NOAUDIT DEBUG PROCEDURE WHENEVER SUCCESSFUL;
NOAUDIT DEBUG PROCEDURE WHENEVER NOT SUCCESSFUL;
NOAUDIT DELETE TABLE WHENEVER NOT SUCCESSFUL;
NOAUDIT ADMINISTER DATABASE TRIGGER WHENEVER SUCCESSFUL;
NOAUDIT ADMINISTER DATABASE TRIGGER WHENEVER NOT SUCCESSFUL;
NOAUDIT EXECUTE PROCEDURE WHENEVER NOT SUCCESSFUL;
NOAUDIT ALTER RESOURCE COST WHENEVER SUCCESSFUL;
NOAUDIT ALTER RESOURCE COST WHENEVER NOT SUCCESSFUL;
NOAUDIT SYSTEM GRANT WHENEVER SUCCESSFUL      ;
NOAUDIT SYSTEM GRANT WHENEVER NOT SUCCESSFUL  ;
NOAUDIT SYSTEM AUDIT WHENEVER  SUCCESSFUL     ;
NOAUDIT SYSTEM AUDIT WHENEVER NOT SUCCESSFUL  ;
NOAUDIT SELECT ANY TABLE WHENEVER NOT SUCCESSFUL;


COMMIT;

begin
  dbms_registry.removed('DV');
exception 
  when others then null;
end;
/





