@echo off
Rem
Rem Copyright (c) 2009, 2010, Oracle and/or its affiliates. 
Rem All rights reserved. 
Rem
Rem    NAME
Rem      winprod_cleanup.bat - script to cleanup/ungac winprod components.
Rem
Rem    DESCRIPTION
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    ssampath    03/04/10 - Any cleanup to be done only when .NET framework
Rem                           is installed.
Rem    ssampath    01/21/10 - Add full path to msiexec
Rem    ssampath    01/04/10 - Do minor fixes.
Rem    ssampath    12/24/09 - Call regsvr32.exe in silent mode
Rem    ssampath    12/24/09 - Creation

if %1.==. (
   CALL :MISSING DEINSTALL_TOOL_PATH
   GOTO END
)

if %2.==. (
   CALL :MISSING ORACLE_HOME_PATH
   GOTO END
)

if %3.==. (
   CALL :MISSING ORACLE_HOME_NAME
   GOTO END
)

if %4.==. (
   set COMPS=all
) ELSE (
   set COMPS=%4
)

REM TOOLHOME should be set to either deinstall tool unzip location or the 
REM bootstrap location
set TOOLHOME=%1

REM ORACLE_HOME_PATH to be passed to oramts_deinst.exe
set ORA_HOME_PATH=%2

REM ORACLE_HOME_NAME to be passed to oramts_deinst.exe
set ORA_HOME_NAME=%3

REM set REG_EXE, REGSVR32_EXE, MSIEXEC
set REG_EXE=%SystemRoot%\system32\reg.exe
set REGSVR32_EXE=%SystemRoot%\system32\regsvr32.exe
set MSIEXEC_EXE=%SystemRoot%\system32\msiexec.exe

set ORAPROVEXEPATH=%TOOLHOME%\odp.net\bin\2.x
set ORAMTS_DEINST_EXEPATH=%TOOLHOME%\bin

IF NOT EXIST %ORAPROVEXEPATH%\OraProvCfg.exe (
   CALL :FNF %ORAPROVEXEPATH%\OraProvCfg.exe
   GOTO END
)

IF NOT EXIST %ORAMTS_DEINST_EXEPATH%\oramts_deinst.exe (
   CALL :FNF %ORAMTS_DEINST_EXEPATH%\oramts_deinst.exe
   GOTO END
)

setlocal
set ASP_NET_dllNames=Oracle.Web Policy.2.111.Oracle.Web Oracle.Web.resources
set CLRINTG_ODE_NET_dllNames=Oracle.Database.extensions
set NTOLEDB_ODP_NET_dllNames=Oracle.DataAccess Policy.2.102.Oracle.DataAccess Policy.2.111.Oracle.DataAccess
set ALL_dllNames=%ASP_NET_dllNames% %CLRINTG_ODE_NET_dllNames% %NTOLEDB_ODP_NET_dllNames%

REM Version # should be updated for every release.
set version=2.112.1.0

REM Framework version (Currently used only in aspnet_2)
REM NOTE:  Needs to be updated for every release. 
set framework_version=v2.0.50727

set language=de es fr it ja ko pt-BR zh-CHS zh-CHT neutral

REM set ntoledb_odpnet_2 dynamic help GUID
REM NOTE:  Needs to be updated for every release. 
set odpnet_help_guid=6AA003BF-73E5-4911-ADB7-71DD5674DDD4

REM DLL's to unregister using regsvr32.exe
REM
set ntoledbDllToUnregister=oraoledb11.dll
set oo4oDllsToUnregister=oradc.ocx oip11.dll oo4ocodewiz.dll odbtreeview.dll oo4oaddin.dll
set AllDllsToUnregister=%ntoledbDllToUnregister% %oo4oDllsToUnregister%

if (%COMPS%)==("all") (
   set dllNames=%ALL_dllNames%
   set DllsToUnregister=%AllDllsToUnregister%
   CALL :ASP_NET_CLEANUP
   CALL :ODP_NET_CLEANUP
   CALL :ORA_MTS_CLEANUP
)

ECHO "Removing key HKLM\System\CurrentControlSet\Services\Oracle11\Performance\KEY_%ORA_HOME_NAME%"
%REG_EXE% delete HKLM\System\CurrentControlSet\Services\Oracle11\Performance\KEY_%ORA_HOME_NAME% /f

REM Check if HKLM\Software\Microsoft\.NETFramework\Policy\v2.0 is present.
%REG_EXE% QUERY "HKLM\Software\Microsoft\.NETFramework\Policy\v2.0" /v 50727 > nul 2>&1

REM If not present, no need to run oraprovcfg.  But, we still need to run others
IF %ErrorLevel%==1 (
   set RUNORAPROV="false"
)

IF %ErrorLevel%==0 (
   set RUNORAPROV="true"
)

if (%COMPS%)==("asp.net") (
   ECHO "Deconfiguring ASP.NET Component..."
   set dllNames=%ASP_NET_dllNames%
   CALL :ASP_NET_CLEANUP
)

if (%COMPS%)==("ode.net") (
   ECHO "Deconfiguring ODE.NET Component..."
   set dllNames=%CLRINTG_ODE_NET_dllNames%
)

if (%COMPS%)==("odp.net") (
   ECHO "Deconfiguring ODP.NET Component..."
   set dllNames=%NTOLEDB_ODP_NET_dllNames%
   CALL :ODP_NET_CLEANUP
)

if (%COMPS%)==("oramts") (
   ECHO "Deconfiguring ORAMTS Component..."
   CALL :ORA_MTS_CLEANUP
)

if (%COMPS%)==("ntoledb") (
   ECHO "Deconfiguring NTOLEDB Component..."
   set DllsToUnregister=%ntoledbDllToUnregister%
)

if (%COMPS%)==("oo4o") (
   ECHO "Deconfiguring Oracle Object for OLE Component..."
   set DllsToUnregister=%oo4oDllsToUnregister%
)

REM Loop to ungac all winprod dlls
REM
for %%n in (%dllNames%) do (
   for %%l in (%language%) do (
      if %RUNORAPROV% == "true" (
         %ORAPROVEXEPATH%\OraProvCfg.exe /action:ungac /providerpath:"%%n,Version=%version%,Culture=%%l"
      )
   )
)

REM Need to Change directory to OH\bin before calling regsvr32.exe
REM Otherwise regsvr32.exe does not unregister dll's
REM Reset back to %TOOLHOME% after regsvr32.exe loop below.
CD /D %ORA_HOME_PATH%\bin

REM unregister dlls
REM
for %%d in (%DllsToUnregister%) do (
   %REGSVR32_EXE% /u /s %%d
)

REM Change directory back to %TOOLHOME%
CD /D %TOOLHOME%

endlocal
GOTO END

REM Define all GOTO handlers and SUBS below
:ASP_NET_CLEANUP
REM
REM unconfig aspnet
REM NOTE: aspnet needs /component:all.  Else, oraprovcfg.exe gives usage
if (%RUNORAPROV%) == ("true") (
   %ORAPROVEXEPATH%\OraProvCfg.exe /action:unconfig /product:aspnet /frameworkversion:%framework_version% /component:all
)

REM Remove registry keys
REM NOTE: use /f for force option
REM
if "%PROCESSOR_ARCHITECTURE%" == "x86" (
   %REG_EXE% delete HKLM\Software\Microsoft\.NETFramework\%framework_version%\AssemblyFoldersEX\ASP.NET /f
) ELSE (
   %REG_EXE% delete HKLM\Software\Wow6432Node\Microsoft\.NETFramework\%framework_version%\AssemblyFoldersEX\ASP.NET /f
)

GOTO :eof  REM This is something like 'return' from subroutine

:ODP_NET_CLEANUP
REM
REM unconfig odp
if (%RUNORAPROV%) == ("true") (
   %ORAPROVEXEPATH%\OraProvCfg.exe /action:unconfig /product:odp /frameworkversion:%framework_version%
)

REM Remove registry keys
REM NOTE: use /f for force option
REM
%REG_EXE% delete HKLM\Software\Oracle\ODP.NET\%version% /f

if "%PROCESSOR_ARCHITECTURE%" == "x86" (
   %REG_EXE% delete HKLM\Software\Microsoft\.NETFramework\%framework_version%\AssemblyFoldersEX\ODP.NET /f
   %REG_EXE% delete HKLM\Software\Microsoft\VisualStudio\8.0\Help\VisibleFilters /v OracleDataProviderTechFilter /f
) ELSE (
   %REG_EXE% delete HKLM\Software\Wow6432Node\Microsoft\.NETFramework\%framework_version%\AssemblyFoldersEX\ODP.NET /f
   %REG_EXE% delete HKLM\Software\Wow6432Node\Microsoft\VisualStudio\8.0\Help\VisibleFilters /v OracleDataProviderTechFilter /f
)

REM Call msiexec to remove odpnet_2 dynamic help
%MSIEXEC_EXE% /x{%odpnet_help_guid%} /qn

GOTO :eof  REM This is something like 'return' from subroutine

:ORA_MTS_CLEANUP
REM
REM oramts_deinst.exe to get rid of OracleMTSRecoveryService registry entries.
%ORAMTS_DEINST_EXEPATH%\oramts_deinst.exe %ORA_HOME_NAME% %ORA_HOME_PATH%

GOTO :eof  REM This is something like 'return' from subroutine

REM  File Not Found handle
:FNF
echo Unable to locate %1
GOTO :eof  REM This is something like 'return' from subroutine

REM  This batch file not called with right arguments
:MISSINGPATH
echo You need to specify %1 when calling this batch script
GOTO END

:END
