#!/usr/bin/perl

#check if a system variable EMSTATE exists if not then exit. 
#check if ORACLE_HOME/agentpatches/patchstarted, this is present.
#if does not exists the return 0;
#create $EMSTATE/agentpatch/blackout file.
#stop agent bu executing $EMSTATE/bin/emctl stop agent
#loop through till the $ORACLE_HOME/agentpatches/patchstarted exists
#if the $ORACLE_HOME/agentpatches/patchstarted does not exists, start detached process 
#to start the agent.
#kill the watch dog with exit command.


use English;
use File::Path;
use Config;

#-------------------------------------------------------------------------------

sub patchPlug {


$debug = 0;
$OraHome=$ENV{ORACLE_HOME};
$emState=$ENV{EMSTATE};
open(OUTFILE,">>$emState/sysman/log/nfsPatchPlug.log");

#------------ Finding OS---------------------------
$OSNAME = $Config{'osname'};
$IsWin32 = ($OSNAME eq 'MSWin32' || $OSNAME eq `Windows_NT`) ;



#-------------checking whether Master agent is getting patched-----------------
if ( -d "$OraHome/agentpatch" ) {
	 if ( ! -e "$OraHome/agentpatch/patchstarted") {
		 if ($debug) {
			 print "Master Agent is not getting patched";
		 }
		 return 0;
	 }
}
else {
  	 if ($debug) {
		print "Master Agent is not getting patched";
	 }
		 return 0;
}

#-- if agentpatch dir does not exists then create in state dir of NFS Agent----

if (! -d "$emState/agentpatch") {
         mkpath( "$emState/agentpatch" );
}

#------start the blackout on the agent--------------------------------------

if ($IsWin32) {
        print OUTFILE "Starting Agent blackout...\n";
	system( "$emState/bin/emctl start blackout agent" );
        $exit_value  = $? >> 8;
        if( $exit_value eq  1) {
          return  1;   
       }
              
 }
else {
    print OUTFILE "Starting Agent blackout...\n";
    system( "$emState/bin/emctl start blackout agent" );
    $exit_value  = $? >> 8;
    if( $exit_value eq  1) {
     return 1;
    }  
}

#--------create a blackout file in $emState/agentpatch-------------------

print OUTFILE "creating a blackout file\n";
open(TEMPFILE,">$emState/agentpatch/blackout");
close(TEMPFIE);

#--------stop agent ----------------------------------------------------

 system("$emState/bin/emctl stop agent");
 $exit_value  = $? >> 8;
 if( $exit_value eq 1) {
  print OUTFILE "Stopping agent in $emState failed.\n";
  return 1;
 }
 print OUTFILE "Stopping the NFSAgent...\n"; 

#--loop till $OraHome/agentpatches/patchestarted exits in Master agent home----


while( TRUE ) {
  if( ! -e  "$OraHome/agentpatch/patchstarted" ) {
    last; 	  
   }
  sleep 10;  
 }

print OUTFILE "Exiting from the watchDog and starting the agent";
#if the Master Agent is getting patched,we starting a different process to start agent--------
 exec `$OraHome/perl/bin/perl  "$OraHome/bin/StartAgent.pl"` ;
 exit;
}

close(OUTFILE);

1;
