#!/usr/bin/perl
#--------------------------------------------------------------------------
# This plugin will apply the patch to state Directories.
#--------------------------------------------------------------------------
use English;
use File::Path;
use Config;


#--------------------------------------------------------------------------
sub applyPatch {

$debug = 0;
$OraHome=$ENV{ORACLE_HOME};
$emState=$ENV{EMSTATE};
$nfsPatchPlugin = "false";

open(OUTFILE, ">>$emState/sysman/log/patchAgtStPlugin.log") ;
#------------ Finding OS---------------------------
$OSNAME = $Config{'osname'};
$IsWin32 = ($OSNAME eq 'MSWin32' || $OSNAME eq `Windows_NT`) ;


#------------------checking if master agent is patched ------------------------

if (! -d "$OraHome/agentpatch" ) {
	if ($debug) {
            print "No patching is required as MasterAgent is not pathched\n";
	}
  return 0;
}

if (! -d "$OraHome/agentpatch/state")  {
  if (-e "$emState/agentpatch/blackout") {
         print OUTFILE "Stopping the blackout\n";
         removeBlackOut($emState);
   }
  else {  
	if ($debug) {
	  print "No patching is required as MasterAgent is not pathched\n";
	}
  }
  return 0;
}

#-----------check if $OraHome/agentpatch/state has any entries----------------

opendir( DIR,"$OraHome/agentpatch/state");

@files = readdir(DIR);

if ( $#files <= 1  ) {
  close(DIR);
  if ($debug) {
    print "No patching is required as MasterAgent is not pathched\n";
  }
  return 0;
}

#-----------------creating patch Dir------------------------------------------
if (! -d "$emState/agentpatch") {
         mkpath( "$emState/agentpatch");
}

#--------------Apply Patches to local host-------------------------------------
#  For all the patchDir the MasterAgent
#  check if file with same directory name exists in the local agent home.
#  If so then don't apply that patch and go to next one.
#  After applying all the patches delete the black out file and stop agent blackout
#------------------------------------------------------------------------------

foreach $patchDir (@files ) {
	chomp $patchDir;

        if( $patchDir eq "."  || $patchDir eq "..") {
             next;
        }

	if ( -e "$emState/agentpatch/$patchDir") {
		next;
	}

       if ($IsWin32) {
         $patchFileName="statepatchcmd.bat";
       }
       else {
           $patchFileName="statepatchcmd.sh";
       }
       

 
        open(AGTLOG, ">>$emState/sysman/log/emagent.trc");
        if ( ! open(PATCHFILE,"$OraHome/agentpatch/state/$patchDir/$patchFileName") ) {
           print "$patchFileName  not found....\n"; 
           print OUTFILE "$patchFileName not found....\n";
           print AGTLOG  "$patchFileName not found...\n";
           return 1;               
        }
        else {
            print OUTFILE "Applying Patch\n";
            $patchfile = "$OraHome/agentpatch/state/$patchDir/$patchFileName";
            if($IsWin32) {
                system( "$patchfile");
            }
            else {
             system( "/bin/sh $patchfile");
            }
            $exit_value  = $? >> 8;
	    if ( $exit_value != 0 ) {
        	   print "Error while applying patch $patchDir \n";
                   print AGTLOG "Error while applying patch\n";
                   print AGTLOG "Failed command is $cmd\n"; 
		   #return 1;
	   } 
	   open(INFILE,">$emState/agentpatch/$patchDir");  #creating a file with same name as patchdir in local host
	   close(INFILE);
           close(AGTLOG);
    }
  }


#
  if (-e "$emState/agentpatch/blackout") {

             print OUTFILE "Stopping the blackout\n";
             removeBlackOut(emState);
             #print OUTFILE "Removing the blackout file\n";
             #system("$emState/bin/emctl stop blackout agent");    
             
             #$exit_value  = $? >> 8;

             #if ( $exit_value eq  1) {
             #print OUTFILE "Error while stopping blackout \n";
             #  return 1;
             #}        
             #print OUTFILE "Removing the blackout file\n";
             #unlink("$emState/agentpatch/blackout");
   }
}
#--------------------------------------------------------------------------------

sub removeBlackOut
{
  $emState=shift;

  system("$emState/bin/emctl stop blackout agent");

  $exit_value  = $? >> 8;

  if ( $exit_value eq  1) {
      print OUTFILE "Error while stopping blackout \n";
      return 1;
   }        
  unlink("$emState/agentpatch/blackout");
}

 
close(OUTFILE);

1;



