my $DF= "";
if($^O =~ /solaris/i){
    $DF = "/bin/df -k"
}
elsif($^O =~ /aix/i){
    $DF = "/bin/df -Pk"
}
elsif($^O =~ /linux/i){
    $DF = "/bin/df -k"
}
elsif($^O =~ /hpux/i){
    $DF = "/usr/bin/df -Pk"
}
## Operating system unknown (probably Unix)
else{
    $DF = "/bin/df -k"
}

print(getFreeSpace($ARGV[0]));

sub paramForGetFreeSpace
{
    my $df = "";
    my $row = "";
    my $column = "";
    my $divide = "";

    if($^O =~ /MSWin32/i)
    {
        $ENV{dircmd}="";
        my $cmd = $ENV{ComSpec}." /c";
        $df = "$cmd dir /ad /-c";
        $row = -1;

        #For XP, 2000, 2003 etc.
        $column = 2;

        my $winVer= `ver`;
        if(($winVer =~ "NT"))
        {
            $column = 0;
        }

        $divide = 1024;
    }
    # This should cover all UNIX variants
    else #may be Unix
    {
        $df = "$DF .";
        $row = -1;
        $column = 3;
        $divide = 1;
    }

    return ($df, $row, $column, $divide);
}





sub getFreeSpace
{
    my ($dirName) = @_;
    chdir($dirName)
        or (return "-1");
    my $freeKB = 0;

    (my $df, my $row, my $column, my $divide) = &paramForGetFreeSpace();

    my @temp = `$df`;
    $_ = $temp[$row];
    my @tokens = split;

    if(($^O !~ /MSWin32/i) && (@temp == 3)){
        $column = 2;
    }

    $freeKB = $tokens[$column]/$divide;

    if("$freeKB" eq "")
    {
        $freeKB = -1;
    }

    return $freeKB;
}
