/*
 * We are dropping logon/logoof triggers ON DATABASE as it impacts a critical path.
 * The old code for the triggers can be looked up from the OVM_MAIN_SOLARIS_030819 label.
 */
/* 8.1.5 had problems with having the code for the TABLE trigger in the
 * same trigger as the ones for VIEW and USER. So, we moved the TABLE trigger
 * code to the new trigger no_vm_drop_table.
 * NOTE: We had further problems as above with 8.1.5 after having added some
 * more logic in the no_vm_drop trigger - So, we have moved all the logic
 * into a procedure and call this procedure from the trigger. This solves the
 * 8.1.5 problems and is in a way better becuase we will fire only one trigger
 * for any 'drop' DDL statement (as opposed to more than one earlier).
 */
create or replace procedure wmsys.no_vm_drop_proc wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
7
2340 acd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==

/
create or replace procedure wmsys.no_vm_create_proc wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
7
98a 3ac
rXjfxTCPwKQqO25vjyxQvjjJ0jIwgztcr0gFfHRVrQ+v+0R+sjXI9Qey1QlnLSlgbWZC8YrY
STgWI2h7jmrcc86hwgvVSpygVfUmDCLx0HeMCcVYOIc+RiwoM/6/Ev4wtc2x7XM6zriclz0X
9kgMRuzlfi49Q440oVDNUBS/4VyRCj4Xvt8hBaa2OSBp83Aj4WkERayLirMp4CJPtlObh5P0
NAhhOKXevce7l0behkpxkpnEgxYepgmzZ3LA6PCCornW8buWBezVNDjgBmnYqbyabBRDP9G9
+wNgfwgIq63JOWWA6xq74xdm/SWvTBa+AqBEvmCt39a9ieg7laquDtqoycQ9xCNhBYfDvsyK
1GXMhecDuoyYT48pTq3xc13e2coi3lynTSUvPDKEg0vINcUExnoANeBYWWZ8KU7qrKH7iU5N
XaoRexdFGhu6W2aSTXNAKRx3i0lbXqWgF/S1AxdVF6hpLvjxKsXN7N1oOT+rJ4L08tdAEFNl
DVgCtQWJSAak4oB2Mh44c2VWwdzAr4ZDPE1zq4v3FQ6GEcw+JskYZfDugnl6aPXc+PnWlPFx
Alr1vlTzJe+xhK34vZiQQiZ1mDd/a7IlcW88FyXXtKmIToprYcD1qAPlRyavyCmPb7rM1PK5
1sCA/pU1St/FghyiykXvKErRAKc9oXfjxSNQnX0GkoHlVM9xdAH7quvp17j+J8x0lnq8zbkn
dakhq4AwoyvDC9Odsju+aJHvi1kY4GjYtymzA8QkhDD/GC1WcckT806fwV/GoeGvF5xWeL5y
ZeCH8In1i2q5+mc83i9fOLpx0ayp3P91Ey1mGEzY3PW4YWwfIGAlPOIErQaYnyQVIJz0uNOh
/7YzEZxGov3AJx+Gza0DepZoQdkXICi2rT/wsYDDbrvqQsCLoq5h+FMjTlulhaGG

/
create or replace procedure wmsys.no_vm_alter_proc wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
7
851 2ea
4qalCPghJGmSN7th/D6lSsdSWPYwg9dc2UgFfC+KMQ8tB+Hxnmq4Iz5pakQR3qQD94WpGkNd
ohRhy72jJkvwDgfPzz4lpxYkGDk1GH1mQhe+0FhMkqOlBLe+ZxbVc9JemnO0b/Zz9kxihCI6
4j3NKubconrvBscsJ7bvMWv0lgSecqe3iRsJ986eFl4w9GbhxRKmXiIX+hk5D8Z8doEbMKFY
r32O5hG3SqhpkfHgpnGpIGNWrxPK4eBmDfqyS4VdO3TK4Spqe8qpZyoffpG8LdzapIGfQkoD
MLAU6ATV4y47xeSOPUPA6r4CsKwXcMeybzHGdgIabjhReXbeTG+CIUa5mfZtFJgvud6FGnTm
EoNzzz9AZ7DFfWpr90cg3FTrzpez7pVIlAQoebHiIMa1eAQjzebrX2CoUwTn5myDclCoJidn
EAhD5oIZB8qWPBMH5VYraVUkb9nNOae/AZN57rym2qKVJy+i7xMVLSiY5ofbloQmdL5/rsGI
t0qRcC38T5ymwEMmcM9bgPKKq2SAFtikdSUJUrPAncdhFBM6Hs4waV1ElwV6Lv/Rir3Bz6PW
u85IY2rDHNFyP4gPoHr6RhESUBGNUKorZWuqlCXd331Bj+1asGxlGUpzjEIRyMl4mCUNHkIV
ud/SdzcjoYy1xYJi6pW74B1cva4gRdgXgc+Bm7yHwKpzcvY/uct9/xUI6VCvmpJlqf6tG81P
CkLQIuT7jEBm3g==

/
create or replace trigger wmsys.no_vm_ddl before alter or create or drop or rename on database
  when ((sys.sysevent in ('ALTER', 'RENAME') and sys.dictionary_obj_type in ('INDEX','TABLE')) or
        (sys.sysevent = 'CREATE' and sys.dictionary_obj_type in ( 'PROCEDURE', 'TRIGGER', 'VIEW')) or
        (sys.sysevent = 'DROP' and sys.dictionary_obj_type in ('INDEX', 'PROCEDURE', 'ROLE', 'TABLE', 'TRIGGER', 'TYPE', 'USER', 'VIEW')))
declare
  s_event varchar2(100) := sys.sysevent ;
  validStack integer ;
begin

  








  if (sys_context('lt_ctx', 'allowDDLOperation')='true') then
    return ;
  end if ;

  if (sys_context('lt_ctx', 'validStack') is null or sys_context('lt_ctx', 'validStack') != 'YES') then
    validStack := 0 ;
  else
    validStack := 1 ;
  end if ;

  if (s_event='CREATE') then
    execute immediate 'call wmsys.no_vm_create_proc(:1,:2,:3,:4)'
      using sys.dictionary_obj_type, sys.dictionary_obj_name, sys.dictionary_obj_owner, validStack ;
  elsif (s_event='DROP') then
    execute immediate 'call wmsys.no_vm_drop_proc(:1,:2,:3,:4)'
      using sys.dictionary_obj_type, sys.dictionary_obj_name, sys.dictionary_obj_owner, validStack ;
  elsif (s_event in ('ALTER', 'RENAME')) then
    execute immediate 'call wmsys.no_vm_alter_proc(:1,:2,:3,:4)'
      using sys.dictionary_obj_type, sys.dictionary_obj_name, sys.dictionary_obj_owner, validStack ;
  end if ;
end;
/
alter trigger wmsys.no_vm_ddl disable;
create or replace trigger wmsys.no_vm_drop_a after drop on database when (sys.dictionary_obj_type in ('USER'))
begin
  execute immediate 'call wmsys.lt_ctx_pkg.allowDDLOperation(''false'')' ;

  
  
end;
/
alter trigger wmsys.no_vm_drop_a disable;
declare
  drop_procedure EXCEPTION;
  PRAGMA EXCEPTION_INIT(drop_procedure, -04043);
begin
  execute immediate 'drop procedure WMSYS.OWM_VALIDATE' ;

exception when drop_procedure then
  null;
end;
/
/*
 * This proc is used by dbms_registry to validate
 * owm_installation.
 */
declare
  version_str  varchar2(100) := wmsys.wm$getDbVersionStr;
  cnt          integer       := 0 ;

begin
   if ((nlssort(version_str, 'nls_sort=ascii7') >= nlssort('9.2.0.5.0', 'nls_sort=ascii7') and
        nlssort(version_str, 'nls_sort=ascii7') < nlssort('A.0.0.0.0', 'nls_sort=ascii7')) or
       nlssort(version_str, 'nls_sort=ascii7') >= nlssort('A.1.0.2.0', 'nls_sort=ascii7')) then
     execute immediate
       'create or replace procedure SYS.VALIDATE_OWM is
          cnt integer ;
        begin
          select count(*) into cnt from all_objects
          where status = ''VALID'' and object_type = ''PACKAGE BODY'' and owner = ''WMSYS'' and object_name = ''LT'' ;

          if (cnt = 0) then
            dbms_registry.invalid(''OWM'');
          else
            dbms_registry.valid(''OWM'');
          end if;
        end;' ;
   end if ;

   execute immediate
     'create or replace procedure WMSYS.VALIDATE_OWM is
        cnt integer ;
      begin
        select count(*) into cnt from all_objects
        where status = ''VALID'' and object_type = ''PACKAGE BODY'' and owner = ''WMSYS'' and object_name = ''LT'' ;

        if (cnt = 0) then
          dbms_registry.invalid(''OWM'');
        else
          dbms_registry.valid(''OWM'');
        end if;
      end;' ;
end;
/
