@@owmr922.plb
update wmsys.wm$env_vars set value = '9.2.0.1.0' where name = 'OWM_VERSION';
commit;
/*
 * Re-insert sentinel rows and de-populate ltlock columns
 * ======================================================
 */
create or replace function wm$getNullInsStr wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
8
8c5 3a8
NuMFYP9hk3ucWIuxq7vXjffw5pUwg5ArLseDfC/NMZ3gsLdfisvra6GuAX1fS7E16ad68XYV
+rDclt7LeXvtpYaYp1/3N47TTGf4Y/6fTzYBjMBJoKydJGQ/z6orqhwslesg+OTVRBOWLQa4
ci68XYvJ4UqWo5XVdlnINzWxBCpU0zi2pjGLo9+NnrPWgnN618ldK/CJOzI5FatoxHjr3uMW
MoyeBKdpy7tQ9UHhDBlav3IBhI01JzJ4DIVBeNQnHfVI1cMmuoPWS8j1KW9si8vgWRmHq0yz
W0khpA2PxBkNh1FrkiM7UN3PsZ7cDvEA2OKo04SvOrzaBWJLK3s8AsazCDry2uCNHO9tttxW
KEJMMfBzU+LijqMHlcswHu5uPi/jkO4y4JAa7JCw5z6YgAuhOH4VwNZoa7aUJUCJ70dIjKWv
zHYQ1WmjxkwLKZj1CcHVnzMEPivnX6vA189130Szun6fN1F1bJk0tsUw9sPva0esq1BD2R37
PrDG4MtrCR5FxobZFbwSc6IkAmgOCySgUe7CuyIi5x5WGvNjqNfGnxhHKi6gT4rpXtqW1Fej
FkWpPhJyYQXjGZ8Mp/TEShESEjkPOPLqPzmhwHTtj0rEc810XYYK7HZaddGbrCxVRVRRH97S
dMGGRuLy2EGtITLwG6Qt13tA+G7uvpJl0EHRe11niBCeIl1U+EmN4xYlFx66thqPhfVNjW56
0XPIlfGh3PUKi9QN1Wh05Vr5mi23YpjDLPda0gb9r35V6NS9fJqbh5mAOwBWfEiBKT+zf2wa
ALsOS8ycj7hfZJRobOwSkIoZUTR4GLtsc6TZIB/cu8HjcwwpivQ/HpOJgH2ivgW/mDiiZDCr
2nOZHxosSXHr2s2Aeo4Q87EaWz01fYeDIu/k61r+LZNbyKzJu/n7ebmmQw==

/
create or replace function wm$getWhereClauseStr wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
8
2ca 1b1
sN1xOoaZlwJ5OcHODJZvccMCZqkwg/AJLUjWfC/NimRTa/E1a9NpMiY9r6jcSzY5iLbC6aRp
2qAM7OUMIrzfORNmQCNLueS57dokEpoYWQjy3XLBc7qqzRn4DE8QND+qgdeB02eMFHYmR8DF
6+cnviRsbXoyrUbKWCdjpUnnqXjJWx2k3vtq7KWPf/CGV0bBH911dAGTXKfScerwSr5pit1d
No7BSrvDvOHno8KdFa5SWi+Dwh0f52KRzSUAtqxvFcsYvaOvId0CLRRQujZXFffqSsq9YgpN
5SMEedSxw096MG9SAoZs9TjrSBC3WLy2BPhXXioXX0jECPf1fN78L9aftDaGt0L1CZs5srfc
+snfgRuo2bpzxvc3FdxxNZyCf+/anLG7NzcYpLQgr/WRcQ2BM5xEYXcwazjA/pkkOk1S

/
create or replace procedure wm$Fixsentinelandltlock wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
7
c0e 587
AzsnxSGHJjgn0I5ZRszr/u8lkGQwg2MrutATYI65gp0Gen4qUJXV1qsmO0PFVhxkzFNTqYaK
toOR3qz8ApTUVaKX0HJYmXx1gd/cQksHxxO7aJPG9wwfE3UV62qVws40ctnoFk5VTEKd9p89
B6r1WmiUsnYwHtu5l/R5tgnBe5mQqZ8UfCGWs8o62XLxITMV/QoLKZ0usF4dycWxHMcq5ymY
IRIMhkH+8n2oYghRfIR7MDjyIGk5+j/8gLn93M1cVkLqdnntAo/0gp1m7UxeuHhS05WIJBK9
2/U+oVlyDTnPYC3QFqs0a8RIXUlzO52f3DaZi2Z6xqNCoZfz8N1I6iHoWB7aE0bAgS0zKu0I
5iHxaU9FPtjz5tR8dWhWmQx3FWX4EyFU1MymBcq+LuJhrwJfFEyRdTVPG8q7QBH94GnBeeiQ
uPtx5pFCGUlurWWs+MZ2ZFNTaz7B5zklgd/cD53hf/S9Gi3izk8Q6XTJoTsfIeYhR2+KTkz5
azcHUXce/CZTeI+7RSOmFUdaz0ePlEn13QQ+Tl6mSB2PKV6HwaUgh7tt5UYkOMUpVDwOHnHq
AhdnkyppiTt7qvW9ARQQb2Y9BvPYrVlr5Y2x9AEWBgbkLeLL0KX52S85QNBSjCqyk7PRLc89
Ef8E69BRDXzEGiaY4MA0aZKLdb3fEMFjVjtHd3I4idGMLlOPWa/q2sTZXk/FWQr1r5EXf9//
GMwLWJpiJ/bG7mgsGbsTo7vi3wd/6oKjiYDxNtW3dbBdOk5f/5ZNC1in+5b2gzlxrAFuN7Aq
8Oy3t6O4FZkw80c+JIcr04fAV9aDw+WOHqfI9OlFwnAAQAD/mJyCQhv45QsmdvLHN7NxWN7m
6AV02DNZJSs7TRD4TTPNp1Xqquq1YU2qAWt1/KtYDQbyJLRqPwTuKf99qUVN20ceq3Q9iBw6
/JLM5ohuPIQgJr9AU9A5GoqSM9S0CHwb/yPNEuK3wtoRdoAtIi1SNVl/t4cxXTJCxNY04lJR
ehDFn616K9AHVaRITtBQSDLdGor0awabp8V0bHZTdrO/53i8cnisH8JrGZl1VCI5/Tvhfm1c
LakIod+xgKOnrd/So3c0r4DdWoa+bb7kYzJdvbz1QfW6Lx2rBiXvhHXAXk7x7FToVgkqkFpl
SZ3EdpVirx63HknSRj2bSwX0T7ULqnUUO5Axd1Uazr22NvXurTBmtI9C12FUXpCYbncuSZ+t
DNo5QemHdSkk+DDsGrBHafZdbvSWG/6qX+dmkByg0H4cDEhnqHzL1O4I+eL6qhGh/nIiIGfi
A0KYyV3SoFl/rpivc+wW6XqJAPF+gORD9PSDuSom+5VBqpBLewbrm5PHp36Vtm9Yh/4qRpqk
omEY/UT7y5hY1OB6+Cn9+SmBvA==

/
declare
 owner_var varchar2(30) ;
 table_name_var varchar2(30) ;
 cursor c1 is
  select owner, table_name from wmsys.wm$versioned_tables ;
begin
  open c1;
  loop
    fetch c1 into owner_var, table_name_var ;
    exit when c1%NOTFOUND ;

    wm$Fixsentinelandltlock(owner_var, table_name_var) ;

  end loop;
  close c1;
end;
/
drop function wm$getNullInsStr ;
drop function wm$getWhereClauseStr ;
drop procedure wm$Fixsentinelandltlock ;
drop public synonym user_wm_constraints ;
drop public synonym all_wm_constraints ;
drop public synonym all_wm_cons_columns ;
drop public synonym user_wm_cons_columns ;
drop public synonym all_wm_ind_columns ;
drop public synonym user_wm_ind_columns ;
drop public synonym all_wm_ind_expressions ;
drop public synonym user_wm_ind_expressions ;
drop public synonym wm$conf1_hierarchy_view ;
drop public synonym wm$conf2_hierarchy_view ;
drop public synonym wm$conf_base_hierarchy_view ;
drop public synonym wm$conf1_nextver_view ;
drop public synonym wm$conf2_nextver_view ;
drop public synonym wm$conf_base_nextver_view ;
drop public synonym wm$all_nextver_view ;
drop public synonym wm$base_version_view ;
declare
  invalid_package EXCEPTION;
  PRAGMA EXCEPTION_INIT(invalid_package, -04043);
begin
  begin
    execute immediate 'drop package owm_bulk_load_pkg' ;

  exception when invalid_package then null;
  end ;

  begin
    execute immediate 'drop package owm_mp_pkg' ;

  exception when invalid_package then null;
  end ;
end ;
/
create sequence wmsys.wm$nested_columns_seq nocache ;
drop view wmsys.user_wm_constraints;
drop view wmsys.all_wm_constraints;
drop view wmsys.all_wm_cons_columns ;
drop view wmsys.user_wm_cons_columns ;
drop view wmsys.all_wm_ind_columns ;
drop view wmsys.user_wm_ind_columns ;
drop view wmsys.all_wm_ind_expressions ;
drop view wmsys.user_wm_ind_expressions ;
drop view wmsys.wm$conf1_hierarchy_view ;
drop view wmsys.wm$conf2_hierarchy_view ;
drop view wmsys.wm$conf_base_hierarchy_view ;
drop view wmsys.wm$conf1_nextver_view ;
drop view wmsys.wm$conf2_nextver_view ;
drop view wmsys.wm$conf_base_nextver_view ;
drop view wmsys.wm$all_nextver_view ;
drop view wmsys.wm$base_version_view ;
declare
  purgeOption        varchar2(30) := null ;
  version_str        varchar2(50);
  compatibility_str  varchar2(50);
begin
  dbms_utility.db_version(version_str,compatibility_str);
  version_str := sys.wm$convertDbVersion(version_str);

  if (nlssort(version_str, 'nls_sort=ascii7') >= nlssort('A.0.0.0.0', 'nls_sort=ascii7')) then
    purgeOption := ' PURGE' ;
  end if ;

  execute immediate 'drop table wmsys.wm$constraints_table' || purgeOption ;
end;
/
declare
  purgeOption        varchar2(30) := null ;
  version_str        varchar2(50);
  compatibility_str  varchar2(50);
begin
  dbms_utility.db_version(version_str,compatibility_str);
  version_str := sys.wm$convertDbVersion(version_str);

  if (nlssort(version_str, 'nls_sort=ascii7') >= nlssort('A.0.0.0.0', 'nls_sort=ascii7')) then
    purgeOption := ' PURGE' ;
  end if ;

  execute immediate 'drop table wmsys.wm$cons_columns' || purgeOption ;
end;
/
declare
  invalid_trigger EXCEPTION;
  PRAGMA EXCEPTION_INIT(invalid_trigger, -04080);
begin
  execute immediate 'drop trigger no_vm_alter' ;

exception when invalid_trigger then null;
end ;
/
declare
  invalid_procedure EXCEPTION;
  PRAGMA EXCEPTION_INIT(invalid_procedure, -04043);
begin
  execute immediate 'drop procedure no_vm_alter_proc' ;

exception when invalid_procedure then null;
end ;
/
alter table wmsys.wm$versioned_tables drop (bl_workspace, bl_version);
drop view wmsys.wm$current_child_versions_view ;
drop public synonym wm$current_child_versions_view ;
drop index wmsys.wm$vt_anc_idx ;
drop view wmsys.wm$current_child_nextvers_view ;
drop public synonym wm$current_child_nextvers_view ;
drop view wmsys.wm$current_cons_versions_view ;
drop public synonym wm$current_cons_versions_view ;
drop view wmsys.wm$current_cons_nextvers_view ;
drop public synonym wm$current_cons_nextvers_view ;
/* Insert 0 version entry in nextver_table */
delete from wmsys.wm$nextver_table where version = 0;
commit;
drop index wmsys.wm$nextver_table_nv_indx;
create index wmsys.wm$nextver_table_nv_indx on wmsys.wm$nextver_table(next_vers);
alter table wmsys.wm$workspaces_table drop ( cr_status );
alter table wmsys.wm$workspaces_table drop ( sync_parver );
alter table wmsys.wm$workspaces_table drop ( last_change );
alter table wmsys.wm$workspaces_table drop (depth) ;
alter table wmsys.wm$version_table drop (anc_depth) ;
create or replace view wmsys.wm$base_hierarchy_view as
  select -1 version from dual union
  select version from wmsys.wm$version_hierarchy_table 
  start with version = sys_context('lt_ctx', 'diffbasever')
  connect by prior parent_version  = version
WITH READ ONLY;
delete from wmsys.wm$env_vars where name = 'CR_WORKSPACE_MODE';
commit ;
create or replace view wmsys.wm$current_workspace_view as 
  select * from wmsys.wm$workspaces_table  
  where workspace = nvl(SYS_CONTEXT('lt_ctx','state'),'LIVE')
WITH READ ONLY;
drop public synonym wm$mw_versions_view;
drop view wmsys.wm$mw_versions_view;
create or replace view wmsys.wm$mw_nextvers_view as 
select next_vers from wmsys.wm$nextver_table where version in 
        (select parent_vers from wmsys.wm$mw_parvers_view);
create or replace view wmsys.wm$curConflict_parvers_view (parent_vers) as 
 (select version 
  from wmsys.wm$version_hierarchy_table  
  where workspace = SYS_CONTEXT('lt_ctx','conflict_state') and
        version   <= 
         (select current_version from wmsys.wm$workspaces_table 
          where workspace = SYS_CONTEXT('lt_ctx','conflict_state'))
 )
WITH READ ONLY;
create or replace view wmsys.wm$curConflict_nextvers_view as 
select version, next_vers, workspace, split
from wmsys.wm$nextver_table  
where version in
  (select parent_vers FROM wmsys.wm$curConflict_parvers_view)
WITH READ ONLY;
create or replace view wmsys.wm$parConflict_parvers_view (parent_vers) as 
 (select version 
  from wmsys.wm$version_hierarchy_table  
  where workspace = SYS_CONTEXT('lt_ctx','parent_conflict_state') and
        version   <= 
           (select current_version from wmsys.wm$workspaces_table 
            where workspace = SYS_CONTEXT('lt_ctx','parent_conflict_state')) and 
        version > SYS_CONTEXT('lt_ctx','parent_ver')
 )
WITH READ ONLY;
create or replace view wmsys.wm$parConflict_nextvers_view as 
select version, next_vers, workspace, split
from wmsys.wm$nextver_table  
where version in
  (select parent_vers FROM wmsys.wm$parConflict_parvers_view)
WITH READ ONLY;
declare
 curTrigStatus varchar2(10) := null;
 verTabName    varchar2(61);

 cursor verTabsCur is 
   select owner || '.' || table_name as tab_name
   from wmsys.wm$versioned_tables;

 badtab_exception EXCEPTION;
 PRAGMA EXCEPTION_INIT(badtab_exception, -00942);

 column_exists_exception EXCEPTION;
 PRAGMA EXCEPTION_INIT(column_exists_exception, -01430);
begin

  begin
    select substr(status,1,length(status)-1) into curTrigStatus
    from all_triggers 
    where owner = 'SYS' and trigger_name = 'NO_VM_DROP';

    execute immediate 'alter trigger sys.no_vm_drop disable';

  exception when no_data_found then null;
  end;
  
  for tab_rec in verTabsCur loop
    begin
      
      execute immediate 'drop view ' || tab_rec.tab_name || '_BPKB';

    exception when badtab_exception then
      null;
    end;
  end loop;

  if (curTrigStatus is not null) then
    execute immediate 'alter trigger sys.no_vm_drop ' || curTrigStatus;
  end if;

exception when others then
  if (curTrigStatus is not null) then
    execute immediate 'alter trigger sys.no_vm_drop ' || curTrigStatus;
  end if;
  raise;
end;
/
/* Cannot use the same function from the ltric packages because the packages is
  * not valid anymore. This happens because a tables have been altered and views
  * been dropped by 'r' scripts. So create independent procedure that will do the
  * same thing.
  */
 create or replace procedure wm$cleanupRicProcs wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
7
12b3 556
6yJpnqpNLhRxGpKIH//HLAg5Tzkwg83qeSATfC8ZweQYE8P0keBcPCsKoOUs51c+qwTJDpZP
2Ng49mMhO/HDPRr5zpCvi5X78fX4VAwQr7zaBXJOaFJGVkv0t3zhlihbxE71RTA/4P7E7psI
nz0HtKtCRlvqiXw/3n/dLPgV4IDocWunrieZfH03/YFnX30Hxox1vvXhjWtW+MaAsA+uWxe+
O4Zga5QFH1Ou8wPg+AFXw6ehonWE1NFsy9RBtDXmC6ac1JHmdaCIvl/QAPZman6KcTb9bNqr
owSzb/09YBDq1TFIgsCf4+t5t/0xvW3hOUcNvqk3B4XvxvrTEAbz2kB+f0lppvbmOJAtQQVK
k4+GT9UkRfTLZOTWFNanmPV2XTnqWnQ37HaiIVeaaePpkIeBtGPcXdu+0aTu4VDru5dNQwjO
GxS+t6hIGJJLnf3T4QdEOD95wHkHqZ1aBJj718x0WCoIO8BvlobUc0XQvU8HSWq3CzWb41lx
7Czm4CVG0Rfb1Osq3blENVRoa1HkIDDSMZsIvUF8jCUxTmVEHYcPE4QsJ349zD5bkv0HBRWO
dtX65zqNxInWcbba9L1TvK52sRW1l2pPPVakjo7RF6Pe6hh28nyDEP+/NMTiZmzog+0O2nFD
+T0En4/4SM/oN8pcUXkYxA5F/+BuBXr9LnpkX6FN7yylnVmrGB1YjZM9/Kqr52Nb5VN+1+m0
eIhDMITcp0HaGugW+nE8kR2jvz2FavJEIeOCffxwGEx4TAOyUnii2X1AgkIHxyhXt2K4l+o8
2m7ar/QReczB2m74TQPhF4HE2kA/s4mQai+leTuSljpNo2INo0J2dwrO1LrM07AqY8mz6uzp
hrSlQP9USH0X16O6JzwjcieJby5N44jlzGTuTJiqx2HqbTyPMcRd8MNMKyGOx6EisdJlH+QW
2vcqGBoVH8E5jRlj9DJS4sXNBr6XEmEZ3M+6XqD2trHdmzHJDrlvCvq8vv0xA2zefQzSuRow
YJG1giXwGGuch51BNtQGQiJ4OaXM42fnWs4ByaEKWFCJFMKxLpN7rrE+5KMiIo+xzfxy/C+d
Uk8XHkNzICKYDwAuscS/cWlFJzWuSpyYjogHgdLBekPQlm31+h/rB467vUD3vTWuIbMOhpf1
fx5KVoAcrW0mZUscvoXbektrXoM9E8QfSv+DLQsIEeIsgy0eg2aHoqBaoX3jNLQeffP0PZy+
VojLLR0H0mN+LgRRuHSCZFkdAzqljSdjaLZVAN6/ZI5/KdG3UfUfDTsy/rK/DL9yl48kLTkg
sHkMjRE7w5ONUfuAK2Ii1PnG3tUJTCzc4JiSeBNUtaUfTLfRTg==

/
declare
  cursor veTableCur is 
  select owner, table_name 
  from   wmsys.wm$versioned_tables;
  
begin
  for veTableCurRec in veTableCur loop
     wm$cleanupRicProcs( veTableCurRec.owner, veTableCurRec.table_name ); 
  end loop;
  commit;
end;
/
drop procedure wm$cleanupRicProcs ;
alter table wmsys.wm$udtrig_info drop (
  internal_type,
  TAB_MERGE_WO_REMOVE_COL,
  TAB_MERGE_W_REMOVE_COL,
  WSPC_MERGE_WO_REMOVE_COL,
  WSPC_MERGE_W_REMOVE_COL,
  DML_COL,               
  WORKSPACE_REFRESH_COL,
  TABLE_REFRESH_COL,   
  TABLE_ROLLBACK_COL, 
  WORKSPACE_ROLLBACK_COL,
  WORKSPACE_REMOVE_COL
); 
drop index wmsys.wm$workspaces_mp_idx ;
alter table wmsys.wm$workspaces_table drop (mp_root) ;
alter table wmsys.wm$version_table drop (refCount) ;
declare
  purgeOption        varchar2(30) := null ;
  version_str        varchar2(50);
  compatibility_str  varchar2(50);
begin
  dbms_utility.db_version(version_str,compatibility_str);
  version_str := sys.wm$convertDbVersion(version_str);

  if (nlssort(version_str, 'nls_sort=ascii7') >= nlssort('A.0.0.0.0', 'nls_sort=ascii7')) then
    purgeOption := ' PURGE' ;
  end if ;

  execute immediate 'drop table wmsys.wm$mp_parent_workspaces_table' || purgeOption ;
end;
/
declare
  purgeOption        varchar2(30) := null ;
  version_str        varchar2(50);
  compatibility_str  varchar2(50);
begin
  dbms_utility.db_version(version_str,compatibility_str);
  version_str := sys.wm$convertDbVersion(version_str);

  if (nlssort(version_str, 'nls_sort=ascii7') >= nlssort('A.0.0.0.0', 'nls_sort=ascii7')) then
    purgeOption := ' PURGE' ;
  end if ;

  execute immediate 'drop table wmsys.wm$mp_graph_workspaces_table' || purgeOption ;
end;
/
drop view wmsys.wm$mp_graph_new_versions ;
drop view wmsys.wm$mp_graph_other_versions ;
drop view wmsys.wm$mp_graph_cons_versions ;
create or replace view wmsys.user_wm_tab_triggers 
(
  trigger_name,
  table_owner,
  table_name,
  trigger_type,
  status,
  when_clause,
  description,
  trigger_body
)
as 
select trig_name,
       table_owner_name,
       table_name,
       trig_type,
       status,
       when_clause,
       description,
       trig_code       
from   wmsys.wm$udtrig_info
where  trig_owner_name = USER
with READ ONLY;
create or replace view wmsys.all_wm_tab_triggers 
(
  trigger_owner,
  trigger_name,
  table_owner,
  table_name,
  trigger_type,
  status,
  when_clause,
  description,
  trigger_body  
)
as 
(select trig_owner_name, 
        trig_name,
        table_owner_name,
        table_name,
        trig_type,
        status,
        when_clause,
        description,
        trig_code       
 from   wmsys.wm$udtrig_info
 where  trig_owner_name = USER or
        table_owner_name = USER or
        EXISTS  
        ( select * 
          from   user_sys_privs
          where  privilege = 'CREATE ANY TRIGGER' ) )
with READ ONLY;
execute wmsys.wm$execSQL('grant select on wmsys.user_wm_tab_triggers to public with grant option');
create or replace public synonym user_wm_tab_triggers for wmsys.user_wm_tab_triggers; 
execute wmsys.wm$execSQL('grant select on wmsys.all_wm_tab_triggers to public with grant option');
create or replace public synonym all_wm_tab_triggers for wmsys.all_wm_tab_triggers; 
declare
  purgeOption        varchar2(30) := null ;
  version_str        varchar2(50);
  compatibility_str  varchar2(50);
begin
  dbms_utility.db_version(version_str,compatibility_str);
  version_str := sys.wm$convertDbVersion(version_str);

  if (nlssort(version_str, 'nls_sort=ascii7') >= nlssort('A.0.0.0.0', 'nls_sort=ascii7')) then
    purgeOption := ' PURGE' ;
  end if ;

  execute immediate 'drop table wmsys.wm$ric_locking_table' || purgeOption ;
end;
/
alter table wmsys.wm$workspaces_table drop constraint workspace_lock_id_unq;
drop view wmsys.wm$anc_version_view;
declare
  purgeOption        varchar2(30) := null ;
  version_str        varchar2(50);
  compatibility_str  varchar2(50);
begin
  dbms_utility.db_version(version_str,compatibility_str);
  version_str := sys.wm$convertDbVersion(version_str);

  if (nlssort(version_str, 'nls_sort=ascii7') >= nlssort('A.0.0.0.0', 'nls_sort=ascii7')) then
    purgeOption := ' PURGE' ;
  end if ;

  execute immediate 'drop table wmsys.wm$sysparam_all_values' || purgeOption ;
end;
/
create or replace view wmsys.wm$current_workspace_view as 
  select * from wmsys.wm$workspaces_table  
  where workspace = nvl(SYS_CONTEXT('lt_ctx','state'),'LIVE')
WITH READ ONLY;
create or replace view wmsys.wm$parent_workspace_view as 
  select * from wmsys.wm$workspaces_table  
  where workspace = SYS_CONTEXT('lt_ctx','parent_state')
WITH READ ONLY;
drop public synonym wm$mw_nextvers_view ;
update wmsys.wm$ric_triggers_table
set pt_name = pt_name || '_LT'
where pt_owner = ct_owner
  and pt_name = ct_name  ; 
commit ;
