<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
  <xsl:template match="/">
    <html>
     <head>
     <title> SQL Explain Plan Report </title>
     <style type="text/css">
     body, table, input, select, textarea
     {font:normal normal 8pt Verdana,Arial;text-decoration:none;color:#000000;}
     .s8 {font-size:8pt;color:#006699}
     .s9 {font-size:10pt;color:#006699}
     .s10 {font-size:14pt;color:#006699;}
     .s16 {border-width : 1px; border-color : #CCCC99;
           border-style: solid;color:#006699;font-size:8pt;}
     .s17 {border-width : 1px; border-color : #CCCC99;
           border-style: solid;font-size:8pt;}
     .s27 {border-width : 1px; border-color : #CCCC99; border-style: solid;}

      <!--
        A { text-decoration:none } 
      -->
     </style>
     </head>
     <body bgcolor="#FFFFFF">
        <xsl:apply-templates select="/*/plan"/>
     </body>
    </html>
  </xsl:template>

<xsl:template name="left-pad">
<xsl:param name="n"/>
<xsl:if test="$n != 0">
  <xsl:text>.</xsl:text> 
  <xsl:call-template name="left-pad">
    <xsl:with-param name="n" select="$n - 1"/>
  </xsl:call-template>
</xsl:if>
</xsl:template>


<!-- ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ -->
<!--                       begin template definition                      -->
<!-- ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ -->
<xsl:template match="plan">
   <!-- metadata about the plan -->
   <table border="0">
     <xsl:if test="./@id"> 
     <tr> 
        <th align="left">Plan Id</th>
        <td>: <xsl:value-of select="./@id"/></td>
     </tr>
     </xsl:if>

     <tr>
       <th align="left">Plan Hash Value </th>
       <td>: 
       <xsl:choose>         
         <xsl:when test="./@hash = 4294967295"> 
           <!-- 
                phv = MAXUB4, so, it is unkonwn. This can happen when plan 
                is built from a sql trace 
            -->
            Unknown
         </xsl:when>
         <xsl:when test="./@hash"> 
           <xsl:value-of select="./@hash"/>
         </xsl:when>
         <xsl:otherwise>
           <xsl:value-of 
            select="operation[@id=1]/other_xml/info[@type='plan_hash']"/>
         </xsl:otherwise>
       </xsl:choose>
       </td>
     </tr>
   </table>

   <br/>
   <!-- display plan lines -->
   <table bordercolor="#000000" ora_borderstyle="headeronly">
     <tr>
       <th align="left" bgcolor="#CCCC99" class="s16">Id</th>
       <th align="left" bgcolor="#CCCC99" class="s16">Operation</th>
       <th align="left" bgcolor="#CCCC99" class="s16">Name</th>
       <th align="left" bgcolor="#CCCC99" class="s16">Rows</th>
       <th align="left" bgcolor="#CCCC99" class="s16">Bytes</th>
       <th align="left" bgcolor="#CCCC99" class="s16">Cost</th>
       <th align="left" bgcolor="#CCCC99" class="s16">Time</th>
     </tr>
     <xsl:for-each select="operation">
       <xsl:apply-templates select="."/>   
     </xsl:for-each>
   </table>      

   <!-- predicates information section -->
   <xsl:if test="operation/predicates"> 
    
     <br/>Predicate Information (identified by operation id):
     <hr size="1" width="290" align="left"/>
     <ul>   
     <xsl:for-each select="operation/predicates">
       <li>
         <xsl:value-of select="../@id"/> - 
         <xsl:value-of select="@type"/>(<xsl:value-of select="."/>)
       </li>
     </xsl:for-each>
     </ul>

   </xsl:if>

   <!-- note information section  -->
   <xsl:if test="(operation[@id=1]/other_xml/info/@type='dynamic_sampling') or
                 (operation[@id=1]/other_xml/info/@type='sql_profile') or 
                 (operation[@id=1]/other_xml/info/@type='baseline') or 
                 (operation[@id=1]/other_xml/info/@type='sql_patch')"> 
     <br/>Note
     <hr size="1" width="30" align="left"/>
     
     <!-- dynamic sampling -->
     <xsl:if test="(operation[@id=1]/other_xml/info/@type='dynamic_sampling')">
       - dynamic sampling used for this statement
     </xsl:if>

     <!-- profile information -->
     <xsl:if test="(operation[@id=1]/other_xml/info/@type='sql_profile')"> 
       - SQL profile 
         <xsl:value-of 
          select="operation[@id=1]/other_xml/info[@type='sql_profile']"/>
         used for this statement
     </xsl:if>

     <!-- plan baseline information -->
     <xsl:if test="(operation[@id=1]/other_xml/info/@type='baseline')"> 
       - SQL plan baseline 
         <xsl:value-of 
          select="operation[@id=1]/other_xml/info[@type='baseline']"/>
         used for this statement
     </xsl:if>

     <!-- sql patch information -->
     <xsl:if test="(operation[@id=1]/other_xml/info/@type='sql_patch')"> 
       - SQL patch
         <xsl:value-of 
          select="operation[@id=1]/other_xml/info[@type='sql_patch']"/>
         used for this statement
     </xsl:if>
     <br/>
   </xsl:if>
</xsl:template>


<!-- plan line template -->
<xsl:template match="operation">
  <tr bgcolor="#F7F777" valign="bottom">
    <td class="s27" align="right">
      <!-- check predicates -->
      <xsl:if test="predicates"> * </xsl:if>     
      <xsl:value-of select="./@id"/>
    </td>
    <td class="s27" ora_space_char=".">          
       <!-- indent operation using depth if needed -->               
       <xsl:if test="./@depth &gt; 0">
         <font color="#F7F777">
           <xsl:call-template name="left-pad">
             <xsl:with-param name="n" select="./@depth"/>
           </xsl:call-template>
         </font> 
       </xsl:if>
       <!-- display operation name and options --> 
       <xsl:value-of select="./@name"/> 
       <xsl:if test="./@options">
        <xsl:text disable-output-escaping="yes"> </xsl:text>  
        <xsl:value-of select="./@options"/>
      </xsl:if>     
    </td>
    <td class="s27"> <xsl:value-of select="object"/> </td>
    <td class="s27" align="right"> <xsl:value-of select="card"/> </td>
    <td class="s27" align="right"> <xsl:value-of select="bytes"/> </td>
    <td class="s27" align="right"> <xsl:value-of select="cost"/> </td>
    <td class="s27" align="right"> <xsl:value-of select="time"/> </td>
  </tr>

</xsl:template>

</xsl:stylesheet>
