# $Header: alertlogAdrViewer.pl 31-may-2007.10:26:45 keiwong Exp $
#
# alertlogAdrViewer.pl
# 
# Copyright (c) 2006, 2007, Oracle. All rights reserved.  
#
#    NAME
#      alertlogAdrViewer.pl - run query against alert log in ADR
#
#    DESCRIPTION
#      Given ADR home, run query against the alert log and return content
#
#    NOTES
#      Command-line arguments:
#      1. AdrHome: ADR home
#      2. Query: query text (optional, may come from stdin)
#
#    MODIFIED   (MM/DD/YY)
#       keiwong  05/31/07 - fix bug 6084704
#       loliu    02/20/07 - Removed AdrEnabled property
#       keiwong  11/02/06 - Creation
#

use strict;
use File::Spec;

require "emd_common.pl";
require "alertlogAdr_util.pl";

#
# process arguments
#

my $adrHome = shift(@ARGV);
my $alertDir = get_adr_alert_dir($adrHome);

if (!$alertDir || !-e $alertDir || !-d $alertDir)
{
    EMAGENT_PERL_WARN("Invalid alert directory: $alertDir");

    # still can proceed because an alert log may be specified in request
}

my $request = shift(@ARGV);
my $largeRequest;

if ($request eq "LARGE_ARGS")
{
    my %stdinArgs = get_stdinvars();

    # our stdin value has embedded '=' characters, so need to parse it ourselves
    my $key;
    my $value;

    while (($key, $value) = each %stdinArgs)
    {
        my $keyValue = $key . "=" . $value;

        if ($keyValue =~ /^$request=/)
        {
            ($largeRequest = $keyValue) =~ s/^$request=(.*)/$1/;
            last;
        }
    }

    EMAGENT_PERL_DEBUG("Request: " . $largeRequest);
}
else
{
    EMAGENT_PERL_DEBUG("Request: " . $request);
}

#
# invoke query executor
#
my $fileSeparator;
my $pathSeparator;

if ($^O =~ m/MSWin32/)
{
    $fileSeparator = "\\";
    $pathSeparator = ";";
}
else
{
    $fileSeparator = "\/";
    $pathSeparator = ":";
}

my $javaExe = $ENV{'JAVA_HOME'} . $fileSeparator . "bin" . $fileSeparator . "java";
my $emdJlib = $ENV{'ORACLE_HOME'} . $fileSeparator . "sysman" . $fileSeparator . "jlib";
my $classPath = $emdJlib . $fileSeparator . "emdbAgent.jar";
$classPath .= $pathSeparator . $emdJlib . $fileSeparator . "ojdl.jar";
$classPath .= $pathSeparator . $emdJlib . $fileSeparator . "ojdl2.jar";
my $executorClass = "oracle.sysman.emo.log.adr.query.AdrAlertLogQueryExecutor";

my $executorCommand = $javaExe . " -cp $classPath $executorClass \"$alertDir\"";

if (!$largeRequest)
{
    $executorCommand .= " \"$request\"";
}
else
{
    # pipe request via stdin
    $executorCommand = "|$executorCommand";
}

if (!open(EXECUTOR, "$executorCommand|"))
{
    print "1|Failed to execute query: $!";
    EMAGENT_PERL_ERROR("Failed to execute query: " . $executorCommand);
    exit(0);
}
else
{
    EMAGENT_PERL_DEBUG("Command: " . $executorCommand);
}

# send request via stdin
if ($largeRequest)
{
    print EXECUTOR "$largeRequest";
}

while (<EXECUTOR>)
{
    print;
}

exit(0);
