#!/usr/local/bin/perl
# 
# $Header: archivepurge_util.pl 05-jul-2006.08:20:41 ganessub Exp $
#
# archivepurge_util.pl
# 
# Copyright (c) 2006, Oracle. All rights reserved.  
#
#    NAME
#      archivepurge_util.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    ganessub    07/05/06 - 
#    armaity     06/25/06 - 
#    ganessub    04/13/06 - Creation.
#
#
# This function returns the local time.
use strict;
use Time::Local;
use HTTP::Date;
use DateManip;
use Fcntl qw (:flock);

sub getlocaltimestamp
{
	my ($second, $minute, $hour, $dayOfMonth, $month, $yearOffset, $dayOfWeek, $dayOfYear, $daylightSavings) = localtime();
	$month = $month + 1;
	my $year = 1900 + $yearOffset;
	if (length $hour == 1)
	{
   	$hour = "0".$hour;
	}
	if (length $minute == 1)
	{
	   $minute = "0".$minute;
	}
	if (length $second == 1)
	{
	   $second = "0".$second;
	}
	if (length $month == 1)
	{
	   $month = "0".$month;
	}
	if (length $dayOfMonth == 1)
	{
	   $dayOfMonth = "0".$dayOfMonth;
	}
       my $tstamp =  "".$year.$month.$dayOfMonth.$hour.$minute.$second;

       return ($tstamp);

}

sub purge_alert_log
{
my ($logFile,$purgeAge) = @_;
my $stime;      # start time filter
my $etime;      # end time filter

my $err;


# set end time as zero so that till the end of file would be matched.
  $etime = 0;

# compute the start time 
my  $purgeAgeStr = "- ".$purgeAge . " days";
my  $calcdate = DateManip::DateCalc("today",$purgeAgeStr,\$err);
my  $dispdate = DateManip::UnixDate($calcdate,"%b %e %Y");
  print "Purging contents older than $dispdate...";
my  $syear   = DateManip::UnixDate($calcdate,"%Y");
my  $smonth  = DateManip::UnixDate($calcdate,"%m");
    $smonth  = $smonth - 1;
my  $sday    = DateManip::UnixDate($calcdate,"%d");
my  $shour   = 0; 
my  $smin    = 0; 
my  $ssec    = 0; 
  $stime = $ssec.":".$smin.":".$shour.":".$sday.":".$smonth.":".$syear;

if (! -e $logFile) {
  print "em_purgealertlogError01:\n Alert Log file($logFile) does not exist,Purge operation failed. ";
  exit 1; 
}
my $origLogFile = $logFile;
my $tmpalertFile = $logFile.".old"; 
rename $logFile, $tmpalertFile;
$logFile = $tmpalertFile;


#open log file in overwrite mode
if(!open(FH2, "+>$origLogFile"))  
{
    print "em_purgeAlertLogError1:Unable to open:$origLogFile file\n, Purge operation failed.";
    exit 0;
}
flock(FH2,LOCK_EX);
if(!open(FH, "$logFile"))  
{
    print "em_purgeAlertLogError2:Unable to open:$logFile\n, Purge operation failed.";
    exit 0;
}



my $startPoint = 0; 


if(!seek(FH, $startPoint, 0))  
{
    print "em_purgeAlertLogError3: Error while reading $logFile\n,Purge operation failed.";
    exit 0;
}

my $bufferSize = 1000; # size of read buffer in bytes
my $record;

if ( (!defined($stime) &&  !defined($etime)) || ($stime eq '0' && $etime eq '0'))
{
    while(<FH>)
    {
        #read(FH, $record, $bufferSize) || die "can't read $logFile: $!";
        if(!read(FH, $record, $bufferSize))  
        {
            print "em_purgeAlertLogError4: Error while reading $logFile\n";
            exit 0;
        }    
        print FH2 $record;
    }
}
else
{
    my $secs;
    my $found=0;

    # start time
    my $stimesec;
    if ($stime eq '0')
    {
        $stimesec = 0;
    }
    else
    {
        my @startlist=split(':', $stime);
        $stimesec = timelocal(@startlist);
    }        
    
    # end time
    my $etimesec;
    if ($etime eq '0')
    {
        $etimesec = 0;
    }
    else
    {
        my @endlist=split(':', $etime);
        $etimesec = timelocal(@endlist);
    }    

    while(<FH>)
    {
        $record = $_;    
        
        if ($found == 0 ||  $etimesec != 0)
        {
            $secs = str2time($record);   
    
            if (defined $secs)
            {
                if ($secs >= $stimesec && ($secs <= $etimesec || $etimesec == 0))
                {        
                    $found = 1;
                }
                elsif ($secs > $etimesec && $etimesec != 0)
                {
                    last;
                }        
            }                  
        }           
    
        if ($found == 1)
        {         
            print FH2 "$record";
        }  
    }     
}

close FH;  
close FH2;
#remove the temp file
unlink $tmpalertFile;
print "Purging operation has been completed successfully.";
}

1;
