#!/usr/local/bin/perl
# 
# $Header: archivetracefile.pl 13-nov-2006.07:06:00 ganessub Exp $
#
# archivetracefile.pl
# 
# Copyright (c) 2006, Oracle. All rights reserved.  
#
#    NAME
#      archivetracefile.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#       This script will archive the files specified by given pattern 
#       in given directory whose modified date is older than given age
#       into the destination host&directory.
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    ganessub    11/13/06 - Bug 5622272 fix.
#    ganessub    07/05/06 - 
#    armaity     06/25/06 - 
#    ganessub    04/12/06 - Creation.
# 
#

use strict;
use Time::Local;
use HTTP::Date;
use Fcntl qw (:flock);
use File::Copy;
use Net::FTP;

require "archivepurge_util.pl";

# Command Line Arguments
my $argnum = @ARGV;

my $trcfiles       = shift(@ARGV);
my $archiveAge = shift(@ARGV);   # number of days older need to be archived
my $destdir   = shift(@ARGV);
my $destuserid = shift(@ARGV);
my $destuserpwd = shift(@ARGV);
my $purgeflag   = shift(@ARGV);
my $sourcehost   = shift(@ARGV);
my $desthost   = shift(@ARGV);
# End Arguments
# Check if timezone exist if not set to UTC as it is required by DateManip module.
my $timez = $ENV{"TZ"};
print "Host Time Zone is : $timez\n";

if ( $timez eq '') {
   print "Warning:Local Timezone is not set on this host, hence UTC is assumed as a timezone.";
   print "        Set TZ environment variable if you want correct timezone.";
   &Date_Init("TZ=UTC");
}

my $file;

#get files based on the pattern
my @files = glob($trcfiles);
#closedir(DIR);
my $fileseparator      = do {
	if(    $^O =~ m/MSWin32/ ) { '\\' }
	else                       { '/'  }
	};

if (length(@files) <= 0)
{
  print "\nNo trace files matched to the given archival criteria!";
  exit 0;
}
my $trueflag = "true";
my $filename;
my $destfilename;
my $ftp;
if ($sourcehost eq $desthost)
{
    #print "same host so ftp avoided.";
}
else
{
     # Create a new Net::FTP object, changing the
     # timeout to 60 seconds
     $ftp = Net::FTP->new($desthost, Timeout => 60) 
               or die "Could not connect to $desthost. Archive operation aborted.";   
     $ftp->login($destuserid,$destuserpwd) 
      or die "Can't login ($desthost):" . $ftp->message;  
     # Change the working directory 	
     $ftp->cwd($destdir) or 
      die "Can't change directory ($destdir) in host $desthost:" . 
        $ftp->message;  
}
my $localtstamp =  getlocaltimestamp();
my $dotc = ".";
my $archcnt = 0;
my $dispfile;
foreach $file (@files) {
          $filename = $file;
          $filename =~ s#.*$fileseparator##; # remove part before last slash 
          $dispfile = $filename;
          $filename = $filename.$dotc.$localtstamp;
   if (-M $file >= $archiveAge)
   {
      print "\n Archiving $dispfile as $filename";
      $archcnt = $archcnt + 1;
      #print "comparing source and destination";
     if ($sourcehost eq $desthost)
     {
          $destfilename = $destdir.$fileseparator.$filename; 
       #print "purgeflag is :$purgeflag";
        if ($purgeflag eq $trueflag)
        {
           move($file,$destfilename);
           if (!-e $destfilename)
           {
              print "\nError archiving trace file in $destfilename. Archive operation failed!";
              exit 1;
           }
        }
        else
        {  
           #print "copying $destfilename..\n";
           copy($file,$destfilename);
           if (!-e $destfilename)
           {
              print "\nError archiving trace file in $destfilename. Archive operation failed!";
              exit 1;
           }
        }
     } 
    else
    {
       $ftp->put($file,$filename) or 
            warn "Couldn't ftp '$file', skipped: $!";

      if ($purgeflag eq $trueflag)
      {
           unlink $file;
           if (-e $file)
           {
              print "\nError purging trace file $file. Purge operation failed!";
              exit 1;
           }
      }
  
    }
 } # end of age check
} #end of for

if (!$sourcehost eq $desthost)
{
     # Close the connection to the FTP server. 

     $ftp->quit or die "Couldn't close the ftp connection 
                      cleanly: $!";   
}

if ($archcnt > 0)
{

   if ($purgeflag eq $trueflag)
   {
        print "\nArchiving and Purging of Trace files have been successfully completed.";
   }
   else
   {
        print "\nArchiving of Trace files have been successfully completed.";
   }
}
else
{
        print "\nNo trace files found matching the archival criteria!So nothing archived!";
}
