# $Header: dbGetAdrBase.pl 20-feb-2007.11:59:30 loliu Exp $
#
# dbGetAdrBase.pl
#
# Copyright (c) 2006, 2007, Oracle. All rights reserved.  
#
#    NAME
#      dbGetAdrBase.pl
#
#    DESCRIPTION
#      Given the db_name and instance_name, determine
#      the complete path to ADR base. Note that this script should never
#      "die". It should always return some value for the ADR base.
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#       loliu    02/19/07 - Creation
#

use strict;
use DBI;

require "emd_common.pl";
require "dbAdrUtil.pl";

my $adr_base = get_diag_info_from_db("ADR Base");

EMAGENT_PERL_DEBUG("dbGetAdrBase: read from database adr_base=$adr_base");

$adr_base = read_or_save_state($adr_base, "adr.base");

if (!$adr_base)
{
    $adr_base = "";
}

EMAGENT_PERL_DEBUG("dbGetAdrBase: adr_base=$adr_base");

print "em_result=$adr_base\n";

exit 0;

