# $Header: dbGetAdrHome.pl 20-feb-2007.11:59:30 loliu Exp $
#
# dbGetAdrHome.pl
#
# Copyright (c) 2006, 2007, Oracle. All rights reserved.  
#
#    NAME
#      dbGetAdrHome.pl
#
#    DESCRIPTION
#      Given the db_name and instance_name, determine
#      the complete path to ADR home. Note that this script should never
#      "die". It should always return some value for the ADR home.
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#       loliu    02/19/07 - Creation
#

use strict;
use DBI;

require "emd_common.pl";
require "dbAdrUtil.pl";

my $adr_home = get_diag_info_from_db("ADR Home");

EMAGENT_PERL_DEBUG("dbGetAdrHome: read from database adr_home=$adr_home");

$adr_home = read_or_save_state($adr_home, "adr.home");

if (!$adr_home)
{
    $adr_home = "";
}

EMAGENT_PERL_DEBUG("dbGetAdrHome: adr_home=$adr_home");

print "em_result=$adr_home\n";

exit 0;

