#!/usr/local/bin/perl
# 
# $Header: dbGetOsmInstance.pl 24-dec-2007.10:05:14 fagonzal Exp $
#
# dbGetOsmInstance.pl
# 
# Copyright (c) 2007, Oracle. All rights reserved.  
#
#    NAME
#      dbGetOsmInstance.pl - Get the OSMInstance property.
#
#    DESCRIPTION
#      This will get the value of the associated ASM instance for this
#      RDBMS instance.  If the database is unavailable, it will use the
#      last successful read from state files on disk.
#
#    NOTES
#      
#
#    MODIFIED   (MM/DD/YY)
#    fagonzal    11/08/07 - 
#    jsoule      09/28/07 - Creation
# 

use strict;
use DBI;

require "emd_common.pl";
require "dbAdrUtil.pl";

my $asm_sid = get_asm_sid_from_db();

EMAGENT_PERL_DEBUG("read OSMInstance $asm_sid from database");

$asm_sid = read_or_save_state($asm_sid, "OSMInstance", 1);

if (!$asm_sid)
{
  $asm_sid = "";
}

EMAGENT_PERL_DEBUG("OSMInstance=$asm_sid");

print "em_result=$asm_sid\n";

exit 0;

