#  $Header: emdb/sysman/admin/scripts/lsnr_status.pl /stpl_db_11.2.0.1.0_gen/1 2009/10/20 21:49:13 prjaiswa Exp $
#
# Copyright (c) 2001, 2009, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#     lsnr_status.pl
#
#    DESCRIPTION
#     get listener status
#
#    MODIFIED    (MM/DD/YY)
#     prjaiswa    10/15/09 - bug 8686293
#     dkapoor     01/13/04 - initialize array 
#     dkapoor     12/18/03 - use exit -1 on error 
#     dkapoor     10/27/03 - fix bug#3219703 
#     rasundar    09/04/03 - remove hard coded PATH variable 
#     dkapoor     10/04/03 - Fix for bug 3109068
#     dkapoor     05/29/03 - fix 2981271
#     dkapoor     04/23/03 - provide password for status
#     xxu         06/25/02 - remove /usr/local/bin/perl
#     dkapoor     05/08/02 - fix 2359251
#     ancheng     12/20/01 - version number
#     xxu         10/12/01 - set_lib_path (bug 2044793)
#     aaitghez    07/02/01 - set ORACLE_HOME.
#     aaitghez    06/28/01 - oracle_home to lsnr_oracle_home
#     aaitghez    07/02/01 - isntance variable naming convention.
#     njagathe    05/29/01 - Set ORACLE_HOME instead of LSNR_ORACLE_HOME
#     ancheng     04/17/01 - add list of database sids
#     ancheng     04/09/01 - Creation

use strict;
require "semd_common.pl";
require has::HasCluster;
require "$ENV{EMDROOT}/sysman/admin/scripts/db/net/listenerUtil.pl";

$ENV{ORACLE_HOME} = $ENV{LSNR_ORACLE_HOME};

set_lib_path ($ENV{LSNR_ORACLE_HOME});
$ENV{TNS_ADMIN} = $ENV{LSNR_ORA_DIR};

my $machine = $ENV{LSNR_MACHINE};
my $port = $ENV{LSNR_PORT};
my $name = $ENV{LSNR_NAME};

my $listenerFile = $ENV{LSNR_ORA_DIR} . "/listener.ora";
my $executable= $ENV{LSNR_ORACLE_HOME}."/bin/lsnrctl";

# check for scan listener
my $isScan="FALSE";
eval{
    my $scanRef = has::Common::hasGetScanInformation($ENV{LSNR_ORACLE_HOME});

    if ( $scanRef and ref($scanRef) and ref($scanRef) =~ /HASH/i and keys %{$scanRef} )
    {
       if ( $scanRef->{SCAN_PORT}
             and $scanRef->{SCAN_PORT} =~ /^$port$/ ) 
       {
          $isScan = "TRUE";  
		  EMD_PERL_DEBUG(" This is scan listener ...");

       }

    }

};
if($@)
{
  # log the message to the log file
   EMD_PERL_WARN("WARN: $@->getErrorMessage()");

   # send the warning message to emagent
   print "em_warning= $@->getErrorMessage()\n"
}


my $address="(ADDRESS=(PROTOCOL=TCP)(HOST=$machine)(PORT=$port))";


my $command ="";
if ($isScan eq "TRUE" ) {
	$command = "status $name";
}else
{
	$command = "status $address";
}

my $result ;

eval
{
 $result = getResult($executable,$command,$listenerFile,$name,1);
};
if($@)
{
    print STDERR "em_error=Failed to run lsnrctl\n";
    exit (-1);
}
#my $result = `$ENV{LSNR_ORACLE_HOME}/bin/lsnrctl status "$address"` or
#          die "em_error=Failed to run lsnrctl\n";


my $alias = " ";
my $version = " ";
my $version_number = " ";
my $start_date = " ";
my $trace_level = " ";
my $security = " ";
my $snmp = " ";
my $find = 0;
my @databases ;

## parse result
my @info = split(/\n/, $result);
my $line;
foreach $line (@info)
{
  if (!$find)
  {
    if ($line =~ /^\s*Alias\s+(.*)/i)
    {
      $alias = $1;
    }
    elsif ($line =~ /^\s*Version\s+(.*)/i)
    {
      $version = $1;
      if($version =~ /Version\s+(.*?)\s+/i)
      {
        $version_number = $1;
      }
    }
    elsif ($line =~ /^\s*Start Date\s+(.*)/i)
    {
      $start_date = $1;
    }
    elsif ($line =~ /^\s*Trace Level\s+(.*)/i)
    {
      $trace_level = $1;
    }
    elsif ($line =~ /^\s*Security\s+(.*)/i)
    {
      $security = $1;
    }
    elsif ($line =~ /^\s*SNMP\s+(.*)/i)
    {
      $snmp = $1;
    }
    elsif ($line =~ /^\s*Services Summary/i)
    {
      $find = 1;
    }
  }
  else # parse database sids
  {
    if ( ($line =~ /^\s+Instance\s+\"(.*)\"/i ) || ($line =~ /^\s+(.*?)\s+has.*handler/i) )
    {
      my $sid = $1;
      if (!($sid =~ /extproc/i) )
      {
        my $add = 1;
        my $element;
        foreach $element (@databases)
        {
          if (lc($element) eq lc($sid) )
          {
            $add = 0;
            last;
          }
        }
        if ($add)
        {
          push(@databases, $sid);
        }
      }
    }
  }
}

# construct sid list
my $list;
if (scalar(@databases) >= 1)
{
  $list = $databases[0];
  my $i;
  for ($i = 1; defined($databases[$i]); $i++)
  {
    $list = $list . "," . $databases[$i];
  }
}
else
{
  $list = " ";
}

print "em_result=$address|$alias|$version_number|$start_date|$trace_level|$security|$snmp|$list\n";

