# $Header: emdb/sysman/admin/scripts/lsnrresp.pl /stpl_db_11.2.0.1.0_gen/1 2009/10/20 21:49:13 prjaiswa Exp $
#
# lsnrresp.pl
# 
# Copyright (c) 2001, 2009, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      lsnrresp.pl
#
#    DESCRIPTION
#      Returns the status of an oracle listener.  If there is an tnsping
#      failure the return is "em_result= |0" otherwise 
#      "em_result=<num millisecs>|1"
#
#    NOTES
#   
#
#    MODIFIED   (MM/DD/YY)
#    prjaiswa    10/15/09 - bug 8686293
#    vivsharm    07/06/05 - for 4433810
#    dkapoor     12/18/03 - return em_result with status down on error 
#    dkapoor     10/31/03 - fixbug#2823971 
#    dkapoor     10/07/02 - use generic perl instead of tail
#    dkapoor     07/18/02 - fix 2296998
#    xxu         06/25/02 - remove /usr/local/bin/perl
#    xxu         10/12/01 - set_lib_path (bug 2044793)
#    njagathe    10/04/01 - Return down if unable to tnsping listener
#    aaitghez    07/06/01 - die when error.
#    aaitghez    07/02/01 - error TNS check.
#    aaitghez    07/02/01 - set ORACLE_HOME
#    aaitghez    07/02/01 - instance variables naming convention
#    aaitghez    06/22/01 - oracle home naming.
#    aaitghez    06/19/01 - removing debug calls.
#    aaitghez    06/01/01 - adding debug and making common.
#    aaitghez    05/29/01 - making NLS changes.
#    aholser     05/17/01 - fix compilation error
#    aaitghez    05/16/01 - fixing syntax error.
#    aaitghez    05/14/01 - replacement for lsnrresp.tcl
#    aaitghez    05/14/01 - Creation
# 

use strict;
require "semd_common.pl";
require has::HasCluster;

$ENV{ORACLE_HOME} = $ENV{LSNR_ORACLE_HOME};

set_lib_path ($ENV{LSNR_ORACLE_HOME});

my $port = $ENV{LSNR_PORT};
my $machine = $ENV{LSNR_MACHINE};


# check for scan listener
my $isScan="FALSE";
eval{
    my $scanRef = has::Common::hasGetScanInformation($ENV{LSNR_ORACLE_HOME});

    if ( $scanRef and ref($scanRef) and ref($scanRef) =~ /HASH/i and keys %{$scanRef} )
    {
       if ( $scanRef->{SCAN_PORT}
             and $scanRef->{SCAN_PORT} =~ /^$port$/ ) 
       {
          $isScan = "TRUE";  
		  EMD_PERL_DEBUG(" This is scan listener ...");

       }

    }

};
if($@)
{
  # log the message to the log file
   EMD_PERL_WARN("WARN: $@->getErrorMessage()");

   # send the warning message to emagent
   print "em_warning= $@->getErrorMessage()\n"
}


my $address = "(ADDRESS=(PROTOCOL=TCP)(HOST=$machine)(PORT=$port))";
my $r;


if (!($r = `$ENV{LSNR_ORACLE_HOME}/bin/tnsping \"$address\"`)) {
    print "em_result=|0|Failed to tnsping $machine\n";
    exit ;
}

#get the last line from the output
my @lines = split /^/m, $r;
$r = $lines[$#lines];

my @error_parse;
my $responseTime; 

#check for errors:
@error_parse = split(m/TNS/, $r);

if ((scalar @error_parse) > 1) {
    # we got some sort of error
    # note that we parse around TNS because a TNS error
    # will hold this string
    # 
    # We assume that the error indicates the listener is down
    $r =~ s/^\s*|\s*&//g;
    $r =~ s/\n/ /g;
    print "em_result=|0|$r\n";
    exit;
} else {
    # we seem to have a good result
    # lets get the milliseconds
    # the output from a good result will look like this:
    # OK (20 msec)
    # we want the number
    $_ = $r;
    /[0-9]+/;
    $responseTime = $&; 
}

#Some Oracle Net process is running at the port validate that its this listener

my $name = $ENV{LSNR_NAME};
require "$ENV{EMDROOT}/sysman/admin/scripts/db/net/listenerUtil.pl";

set_lib_path ($ENV{LSNR_ORACLE_HOME});
$ENV{TNS_ADMIN} = $ENV{LSNR_ORA_DIR};

my $listenerFile = $ENV{LSNR_ORA_DIR} . "/listener.ora";
my $executable= $ENV{LSNR_ORACLE_HOME}."/bin/lsnrctl";

my $command ="";
if ($isScan eq "TRUE" ) {
	$command = "status $name";
}else
{
	$command = "status $address";
}



my $result ;

eval
{
 $result = getResult($executable,$command,$listenerFile,$name,1);
};
if($@)
{
    print "em_result=|0|Failed to run lsnrctl\n";
    exit;
}

my $errorMsg = getErrorIfAny($result);
if (defined $errorMsg) 
{
	@error_parse = split(m/TNS/, $result);
    	$result =~ s/^\s*|\s*&//g;
    	$result =~ s/\n/ /g;
    	print "em_result=|0|$result\n";
 	exit;
}

## parse result
my @info = split(/\n/, $result);
if ($#info < 0)
{
    print "em_result=|0|Failed to run lsnrctl\n";
    exit;
}

if(isThisListenerRunning($result,$ENV{LSNR_ORA_DIR},$name))
{
 print "em_result=$responseTime|1|\n";
 exit;
}
#print "em_result=|0|listener \"$name\" is not running using \"$listenerFile\" file.\n";

if(isAnyListenerRunning($result, $machine, $port, $name))
{
	my $currListenerFile = getCurrentListenerOraFile($result, $name);

	if (!($currListenerFile eq ""))
	{
		print "em_result=|0|Although a Listener with name \"$name\", is running on this host at port: \"$port\", it was not started using this target\'s \"LISTENER.ORA\" file. CORRECTIVE ACTION: To monitor this \"EM  Listener Target\" with its present configuration, you must stop the currently running listener process, and start it again using the Listener Parameter file: $listenerFile . Alternatively, you can update this target\'s \"LISTENER.ORA Location\" parameter with the location of the currently running Listener, which was started using: $currListenerFile\n";
		exit;
	}
	else
	{
		print "em_result=|0|A listener process with name \"$name\" is currently running on this host at port:  \"$port\", but it was started without using any Listener Parameter File. CORRECTIVE ACTION: An \"EM  Listener Target\" cannot be configured without specifying a valid \"Listener Parameter File\" location. To monitor this \"EM  Listener Target\" with its present configuration, you must stop the currently running listener , and create an entry for it in the parameter file: $listenerFile . After this is done, you must start the listener again using this updated listener parameter file\n";
		exit;
	}
}
print "em_result=|0| The listener \"$name\" is not running using the Listener parameter file: \"$listenerFile\" on Host: \"$machine\" at Port: \"$port\".\n";

