#!/usr/local/bin/perl
# 
# $Header: maxRowCount.pl 12-jan-2007.12:11:56 manosing Exp $
#
# maxRowCount.pl
# 
# Copyright (c) 2005, 2007, Oracle. All rights reserved.  
#
#    NAME
#      maxRowCount.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    manosing    01/12/07 - XbranchMerge manosing_lastpols from main
#    dsukhwal    01/06/07 - XbranchMerge manosing_ntpol from main
#    manosing    01/10/07 - flood control for NT policies
#    manosing    12/04/06 - bug 5443094
#    manosing    11/28/06 - add windows NT 11g policies 
#    dsukhwal    10/17/06 - add proxy account
#    dsukhwal    10/17/06 - add proxy account
#    manosing    10/09/06 - 
#    manosing    10/09/06 - 
#    manosing    10/09/06 - 
#    dsukhwal    10/31/06 - add audit insert failures policy
#    rmadampa    08/05/06 - bug 5435113: 3 new policies
#    rmadampa    07/24/06 - add Password_Complexity_Fn_Usage 
#    dsukhwal    09/26/05 - use bulk sub for maxCount 
#    dsukhwal    06/30/05 - add flood control for all 
#    dsukhwal    06/06/05 - limit number of rows for win32 
#    dsukhwal    05/26/05 - dsukhwal_bug4369815
#    dsukhwal    05/09/05 - Creation
# 

require "$ENV{EMDROOT}/sysman/admin/scripts/esa_config.pl";
my @instanceOOTBPolicies = qw(Umask_Setting Log_Archive_Destination_Permission Log_Archive_Destination_Owner Log_Archive_Duplex_Destination_Permission Log_Archive_Duplex_Destination_Owner Oracle_Home_Executable_Files_Owner Oracle_Home_File_Permission Oracle_Home_Executable_Files_Permission Utl_File_Directory Utl_File_Dir_for_9iPlus_Versions ifile_File_Permission initora_File_Permission spfile_Permission Audit_File_Destination User_Dump_Destination Background_Dump_Destination Core_Dump_Destination OS_Authenticate_Prefix_Domain PUBLIC_Trace_Files Remote_Listener_Instances Audit_Trail Os_Authent_Prefix Sql92_Security DB_Link_Global_Name Secure_OS_Audit_Level Remote_OS_Role Remote_OS_Authentication Remote_Password_File tkprof otrace sqlplus tkprof_owner sqlplus_owner Webcache Webcache_Owner Snmp_ro Snmp_ro_Owner Snmp_rw Snmp_rw_Owner Wdbsvr Wdbsvr_Owner Htaccess Htaccess_Owner Xsql Xsql_Owner winPlatformNT drivePermNT domainUserGrpNT winToolsNT Oracle_Home_File_PermissionNT tkprofNT sqlplusNT WebcacheNT Snmp_roNT Snmp_rwNT WdbsvrNT HtaccessNT XsqlNT Audit_File_DestinationNT User_Dump_DestinationNT Background_Dump_DestinationNT Core_Dump_DestinationNT ifile_File_PermissionNT Log_Archive_Destination_PermissionNT Log_Archive_Duplex_Destination_PermissionNT Oracle_Home_Executable_Files_PermissionNT spfile_PermissionNT initora_File_PermissionNT);

my @lsnrOOTBPolicies = qw(Lsnr_Host_Name Lsnr_Ora_Restrict_Perms Lsnr_Tracefile_Perm_Policy Lsnr_Tracefile_Own_Policy Lsnr_Tracedir_Perm_Policy Lsnr_Tracedir_Own_Policy Lsnr_Logfile_Perm_Policy Lsnr_Logfile_Own_Policy Listener_Direct_Administration Sqlnet_Ora_Restrict_Perms sqlnet_Client_Log_Dir sqlnet_Client_Log_Dir_Owner sqlnet_Server_Log_Dir sqlnet_Server_Log_Dir_Owner sqlnet_Client_Trace_Dir sqlnet_Client_Trace_Dir_Owner sqlnet_Server_Trace_Dir sqlnet_Server_Trace_Dir_Owner Listener_Default_Name Listener_Logging_Status Listener_Password Sqlnet_Allowed_Logon_Version Sqlnet_Inbound_Connect_Timeout Lsnr_Inbound_Connect_Timeout Ssl_Server_DN_Match Sqlnet_Ora_Restrict_PermsNT sqlnet_Client_Log_DirNT sqlnet_Server_Log_DirNT sqlnet_Client_Trace_DirNT sqlnet_Server_Trace_DirNT Lsnr_Ora_Restrict_PermsNT Lsnr_Tracefile_Perm_PolicyNT Lsnr_Tracedir_Perm_PolicyNT Lsnr_Logfile_Perm_PolicyNT);


my @dbOOTBPolicies = qw(DB_Link_With_Password Unlimited_Table_Space_Quota Password_Life_Time Password_Reuse_Max Password_Reuse_Time Password_Locking_Time Password_Grace_Time Well_known_Accounts Default_Passwords System_Privileges_To_Public Unlimited_login_attempts Oracle_Home_Data_Files_Permission DB_control_files_Permission Access_To_AUD_Table Access_To_USER_HISTORY_Table Access_To_SOURCE_Table Access_To_LINK_Table Access_To_USER_Table Access_To_STATSSQLTEXT_Table Access_To_STATSSQL_SUMMARY_Table Access_To_ALL_SOURCE_View Access_To_DBA_ROLES_View Access_To_DBA_SYS_PRIVS_View Access_To_DBA_ROLE_PRIVS_View Access_To_DBA_TAB_PRIVS_View Access_To_DBA_USERS_View Access_To_ROLE_ROLE_PRIVS_View Access_To_USER_TAB_PRIVS_View Access_To_USER_ROLE_PRIVS_View EXECUTE_UTL_FILE_Privileges_To_PUBLIC Password_Complexity_Fn_Usage Public_Exec_Priv_Utl_Tcp Public_Exec_Priv_Utl_Http Public_Exec_Priv_Utl_Smtp Select_Any_Table Select_Privilege Proxy_Account Insert_Failure Oracle_Home_Data_Files_PermissionNT DB_control_files_PermissionNT);

my $toPrint="em_result=";
if($ARGV[0] eq "instance"){
    my %instHash = get_max_upload_rowcount_bulk("instance", @instanceOOTBPolicies);
    for (my $i=0;$i<@instanceOOTBPolicies;$i++){
        my $maxRows = $instHash{$instanceOOTBPolicies[$i]};
        if(!defined($maxRows)){
            $maxRows = 0;
        }
        if((@instanceOOTBPolicies-1) == $i){
            $toPrint = $toPrint.$maxRows."\n";
        }
        else{
            $toPrint = $toPrint.$maxRows.'|';
        }
    }
}
elsif($ARGV[0] eq "listener"){
    my %lsnrHash = get_max_upload_rowcount_bulk("oracle_listener",@lsnrOOTBPolicies);
    for (my $i=0;$i<@lsnrOOTBPolicies;$i++){
        my $maxRows = $lsnrHash{$lsnrOOTBPolicies[$i]};
        if(!defined($maxRows)){
            $maxRows = 0;
        }
        if((@lsnrOOTBPolicies-1) == $i){
            $toPrint = $toPrint.$maxRows."\n";
        }
        else{
            $toPrint = $toPrint.$maxRows.'|';
        }
    }
}
elsif($ARGV[0] eq "database"){
    my %dbHash = get_max_upload_rowcount_bulk("database", @dbOOTBPolicies);
    for (my $i=0;$i<@dbOOTBPolicies;$i++){
        my $maxRows = $dbHash{$dbOOTBPolicies[$i]};
        if(!defined($maxRows)){
            $maxRows = 0;
        }
        if((@dbOOTBPolicies-1) == $i){
            $toPrint = $toPrint.$maxRows."\n";
        }
        else{
            $toPrint = $toPrint.$maxRows.'|';
        }
    }
}
    
print "$toPrint";

