#!/usr/local/bin/perl
# 
# $Header: purgealertlog.pl 13-nov-2006.07:06:20 ganessub Exp $
#
# purgealertlog.pl
# 
# Copyright (c) 2006, Oracle. All rights reserved.  
#
#    NAME
#      purgealertlog.pl - Purges alert log file.
#
#    DESCRIPTION
#      Given  Oracle alert log file
#      purgealertlog purges the content of the alert log file which are older
#      than given number of days.
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    ganessub    11/13/06 - Bug 5622272 fix.
#    ganessub    07/05/06 - 
#    armaity     06/25/06 - 
#    ganessub    03/29/06 - creation.
# 
#

use strict;
use Time::Local;
use HTTP::Date;
use DateManip;
use Fcntl qw (:flock);

require "alertlog_util.pl";
require "archivepurge_util.pl";

sub purge_alert_log;  #declaration
# Command Line Arguments
my $argnum = @ARGV;

my $logFile = shift(@ARGV);
my $purgeAge = shift(@ARGV);   # number of days older need to be purged
# End Arguments

# Check if timezone exist if not set to UTC as it is required by DateManip module.
my $timez = $ENV{"TZ"};
print "Host Time Zone is : $timez\n";

if ( $timez eq '') {
   print "Warning:Local Timezone is not set on this host, hence UTC is assumed as a timezone.";
   print "        Set TZ environment variable if you want correct timezone.";
   &Date_Init("TZ=UTC");
}

#####
##call the subroutine to purge.
#####
 purge_alert_log($logFile,$purgeAge);

####
