@echo off
REM Copyright (c) 2009, Oracle Corporation.  All rights reserved

echo This script is going to restore the Oracle Home to the previous state.
echo It does not perform any of the following:
echo - Running init/pre/post scripts
echo - Customized steps performed manually by user
echo Please use this script with supervision from Oracle Technical Support.



REM # Get ORACLE_HOME from environment variable "ORACLE_HOME"
set OH=%ORACLE_HOME%

REM # Error out if OH is not set
if NOT "$OH" == ""  goto MODIFY_FILES
    echo Oracle Home is not set.
    echo Please set env. variable ORACLE_HOME and try again.
    echo Script failed to proceed.
    set %ERROR_LEVEL% = 1
    exit %ERROR_LEVEL%

:MODIFY_FILES

echo About to modify Oracle Home( %OH% )
echo Do you want to proceed? [Y/N]
if "%1" == "-silent" goto PROCEED
set /p response= ^>

if "%response%" == "Y" goto PROCEED
if "%response%" == "y" goto PROCEED
echo User responded with : %response%
exit 0;

:PROCEED
echo User responded with : Y




echo Date   Time : %date% %time% >> %OH%\cfgtoollogs\opatch\opatch_history.txt
echo Oracle Home : %OH% >> %OH%\cfgtoollogs\opatch\opatch_history.txt
echo Command     : restore.bat >> %OH%\cfgtoollogs\opatch\opatch_history.txt

rmdir /S /Q %OH%\.patch_storage\7439847_Feb_8_2009_20_36_24\files

xcopy %OH%\.patch_storage\7439847_Feb_8_2009_20_36_24\backup\*.* %OH% /E /Y /C

echo Restore script completed.
