DROP TABLE OC4J_TX CASCADE CONSTRAINTS;
DROP TABLE OC4J_TX_BRANCH CASCADE CONSTRAINTS;
DROP TABLE OC4J_RESOURCES CASCADE CONSTRAINTS;
CREATE TABLE OC4J_TX (
    TID           RAW(64) NOT NULL,
    FORMATID      INTEGER NOT NULL,
    BRANCHQUAL    RAW(65),
    STATE         INTEGER NOT NULL,
    PARENTREF_PROTOCOL     VARCHAR(512),
    PARENTREF_ENDPOINT     VARCHAR(512),
    INSTANCE      VARCHAR(512),
    TYPE          VARCHAR(512),
    PRIMARY KEY ( TID, FORMATID, BRANCHQUAL )
);
CREATE TABLE OC4J_TX_BRANCH (
    TID              RAW(64) NOT NULL,
    FORMATID         INTEGER NOT NULL,
    PARENTBRANCHQUAL RAW (65),
    BRANCHQUAL       RAW(64) NOT NULL,
    JNDINAME         VARCHAR(256),
    ARG	             VARCHAR(256),
    PRIMARY KEY ( TID, FORMATID, BRANCHQUAL ),
    FOREIGN KEY ( TID, FORMATID, PARENTBRANCHQUAL ) REFERENCES OC4J_TX ( TID, FORMATID, BRANCHQUAL ) ON DELETE CASCADE
);
CREATE TABLE OC4J_RESOURCES (   
    INSTANCE         VARCHAR(512) NOT NULL,
    JNDINAME         VARCHAR(256) NOT NULL,
    ARG	             VARCHAR(256),
    RLRCNAME	     VARCHAR(256)
);
