Rem
Rem Copyright (c) 2002, 2008, Oracle. All rights reserved.
Rem
Rem    NAME
Rem      amddbmig.sql - migration script for upgrading olap catalog
Rem
Rem    DESCRIPTION
Rem      Migration script for providing upgrading to the olap catalog
Rem
Rem    NOTES
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    glyon       08/06/08 - 11gR1 support
Rem    awesley     04/21/06 - 10gR2 support
Rem    cdalessi    08/24/04 - 10gR1 support
Rem    cdalessi    10/21/03 - change refs to cwmlite
Rem    cdalessi    08/29/03 - Rearrange relod and add MR table truncate 
Rem    cdalessi    02/06/03 - 
Rem    cdalessi    01/24/03 - fix call to amdrelod to amd_relod
Rem    cdalessi    01/22/03 - Fix redundant reload when going from 901
Rem    cdalessi    01/16/03 - Unfrying some really bad, duplicate code
Rem    cdalessi    01/08/03 - Fix typo
Rem    cdalessi    12/09/02 - 10i migration changes
Rem    cdalessi    11/19/02 - Remove ? notation; replace with @@ notation
Rem    cdalessi    08/15/02 - 92020
Rem    dbardwel    03/12/02 - Updates per Rae Burns for bug 2262308
Rem    dbardwel    02/22/02 - dbardwel_txn101968
Rem    dbardwel    02/21/02 - Updates per Rae Burns
Rem    dbardwel    02/18/02 - Created


COLUMN :amd_fname NEW_VALUE amd_file NOPRINT
VARIABLE amd_fname VARCHAR2(128)
DECLARE
  compat VARCHAR2(30);
BEGIN
  -- if the current version of AMD is 11qR1
  IF substr(dbms_registry.version('AMD'),1,4)='11.1' THEN
    :amd_fname := 'amdu111.sql';
  -- if the current version of AMD is 10gR2
  ELSIF substr(dbms_registry.version('AMD'),1,4)='10.2' THEN
    :amd_fname := 'amdu102.sql';
  -- if the current version of AMD is 10gR1
  ELSIF substr(dbms_registry.version('AMD'),1,4)='10.1' THEN
    :amd_fname := 'amdu101.sql';
  -- else if the current version of AMD is 9i
  ELSIF substr(dbms_registry.version('AMD'),1,1)='9' THEN
    IF substr(dbms_registry.version('AMD'),1,5)='9.2.0' THEN
      -- upgrade 9.2.0
      :amd_fname := 'amdu920.sql';
    ELSIF substr(dbms_registry.version('AMD'),1,5)='9.0.1' THEN 
      -- upgrade 9.0.1
      -- No reload needed, since we are essentially installing all new stuff
      :amd_fname := 'amdu901.sql';
    END IF;
  ELSE
    -- otherwise, if the OLAP option is turned ON
    select value into compat from v$option where parameter='OLAP';
    IF upper(compat) = 'TRUE' THEN
      -- AND, the compatibility setting is high enough to support
      -- this component
      select value into compat from v$parameter where name='compatible';
      IF substr(compat,1,5) >= '8.1.6' then
        -- Put the component in, no reload would be necessary
        :amd_fname := 'catamd.sql';
      ELSE
        :amd_fname := '?/rdbms/admin/nothing.sql';
      END IF;
    END IF;
  END IF;
END;
/
SELECT :amd_fname FROM DUAL;
@@&amd_file






