Rem
Rem Copyright (c) 2004, 2006, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      amdu101.sql - migration script for upgrading olap catalog component
Rem
Rem    DESCRIPTION
Rem      Upgrade OLAP Catalog from 10.1.0
Rem
Rem    NOTES
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    glyon       06/22/07 - replace grant to public with roles for sequence
Rem    awesley     09/21/06 - add call to amdu102.sql, removeing call to amdrelod, call @@cwm2iner.pls and @@cwm2iner.plb so 
Rem                           Validate_CWM2_Install will work
Rem    dbardwel    05/24/06 - Fix bug 5243313 - make sure obsolete package cwm2_olap_aw_access is dropped
Rem    awesley     07/05/05 - change display_name and plural_name to change displayname and pluralname
Rem    awesley     06/21/05 - change display name and plural name length 
Rem    dbardwel    04/25/05 - add one performance index
Rem    dbardwel    04/24/05 - 3 additional columns for refresh table cwm2$mrall_facttblkeymaps bug 3996129
Rem    cdalessi    04/08/05 - drop obsolete view
Rem    cdalessi    10/06/04 - Move validation to SYS 
Rem    cdalessi    10/04/04 - add table change 
Rem    dbardwel    09/29/04 - Add create job to olap_user and olap_dba roles.
Rem    dbardwel    09/15/04 - Drop package and public synonym for 
Rem                           dbms_aw_utilities obsolete in 10.2.
Rem                           Also make mr_refresh property value 
Rem                           column varchar2(4000).
Rem    cdalessi    08/24/04 - Make it do something
Rem    cdalessi    05/26/04 - cdalessi_txn111650
Rem    cdalessi    05/26/04 - Creation

execute sys.dbms_registry.upgrading('AMD' ,'OLAP Catalog' ,'cwm2_olap_installer.Validate_CWM2_Install' ,'OLAPSYS');

grant select on sys.all_aws to olapsys with grant option;
grant select on sys.all_aw_prop_name to olapsys with grant option;
grant select on sys.view$ to olapsys;
grant select on sys.syn$ to olapsys;
grant create any synonym to olapsys;
grant drop any synonym to olapsys;
grant create job to OLAP_USER;
grant create job to OLAP_DBA;

alter session set current_schema = olapsys;
@@cwm2awtm.sql

alter table cwm2$mrall_hierdims modify (
    display_name varchar2(240),
    plural_name varchar2(240)
); 

alter table MRAC_OLAP2_AW_PHYS_OBJ_PROP_T modify (
   AW_PROP_VALUE varchar2(4000)
);

alter table cwm2$mrall_listdims add (
  level_name varchar2(30)
);

alter table olapsys.cwm2$mrall_facttblkeymaps add table_id number;
alter table olapsys.cwm2$mrall_facttblkeymaps add column_id number;
alter table olapsys.cwm2$mrall_facttblkeymaps add gidcolumn_id number; 

-- One more for BUG 3996129
create index cwm2$factdimhiertplsdtl_ih on olapsys.cwm2$FactDimHierTplsDtl (HIER_IRID);

grant select on XML_LOADID_SEQUENCE to OLAP_USER, OLAP_DBA;


alter table olapsys.CwM2$Dimension modify (
    displayname varchar2(90),
    pluralname varchar2(90)
); 

alter table olapsys.CwM2$Level modify (
    displayname varchar2(90),
    pluralname varchar2(90)
); 

alter table olapsys.CwM2$Hierarchy modify (
    displayname varchar2(90)
); 

alter table olapsys.CwM2$DimensionAttribute modify (
    displayname varchar2(90)
); 

alter table olapsys.CwM2$LevelAttribute modify (
    displayname varchar2(90)
); 

alter table olapsys.CwM2$Cube modify (
    displayname varchar2(90)
); 

alter table olapsys.CwM2$Measure modify (
    displayname varchar2(90)
); 


@@cwm2sed2.sql

drop public synonym dbms_aw_utilities;
drop package dbms_aw_utilities;
drop public synonym cwm2_olap_installer;
drop package cwm2_olap_installer;
drop view odm_olap2_dim_hier_level_uses;
drop public synonym cwm2_olap_aw_access;
drop package cwm2_olap_aw_access;

Rem @@amdrelod.sql

execute sys.dbms_registry.upgraded('AMD');

alter session set current_schema = sys;

@@cwm2iner.pls
@@cwm2iner.plb
execute sys.cwm2_olap_installer.Validate_CWM2_Install;

@@amdu102.sql
