Rem
Rem Copyright (c) 2004, 2009, Oracle and/or its affiliates. 
Rem All rights reserved. 
Rem
Rem    NAME
Rem      amdu102.sql - migration script for upgrading olap catalog component
Rem
Rem    DESCRIPTION
Rem      Upgrade OLAP Catalog from 10.2.0.
Rem
Rem    NOTES
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    glyon       07/14/09 - move revokes of grant all on <various> to amdu111.sql
Rem    dbardwel    01/20/09 - move the revoke of select on sys.user$ from olapsys to the amdu111.sql script.
Rem    awesley     09/03/08 - add 'grant select any dictionary to olapsy;' to fix LRG 3594047
Rem    glyon       08/06/09 - chain to amdu111.sql
Rem    glyon       06/24/08 - bug 7204558: eliminate references to sys.user$
Rem    glyon       05/23/08 - revoke more unnecessary object privileges
Rem    glyon       05/08/08 - revoke unnecessary object privileges
Rem    glyon       06/22/07 - replace grant to public with roles for sequence
Rem    mstasiew    09/07/06 - New cwm2mrfacttblkeymaps cols for 11
Rem    dbardwel    05/24/06 - Fix bug 5243313 - make sure obsolete package cwm2_olap_aw_access is dropped.
Rem    awesley     04/20/06 - migrate from amdu101.sql to amd102.sql
Rem    awesley     07/05/05 - change display_name and plural_name to change displayname and pluralname
Rem    awesley     06/21/05 - change display name and plural name length 
Rem    dbardwel    04/25/05 - add one performance index
Rem    dbardwel    04/24/05 - 3 additional columns for refresh table cwm2$mrall_facttblkeymaps bug 3996129
Rem    cdalessi    04/08/05 - drop obsolete view
Rem    cdalessi    10/06/04 - Move validation to SYS 
Rem    cdalessi    10/04/04 - add table change 
Rem    dbardwel    09/29/04 - Add create job to olap_user and olap_dba roles.
Rem    dbardwel    09/15/04 - Drop package and public synonym for 
Rem                           dbms_aw_utilities obsolete in 10.2.
Rem                           Also make mr_refresh property value 
Rem                           column varchar2(4000).
Rem    cdalessi    08/24/04 - Make it do something
Rem    cdalessi    05/26/04 - cdalessi_txn111650
Rem    cdalessi    05/26/04 - Creation

grant select on sys.all_aws to olapsys with grant option;
grant select on sys.all_aw_prop_name to olapsys with grant option;
grant select on sys.view$ to olapsys;
grant select on sys.syn$ to olapsys;
grant create any synonym to olapsys;
grant drop any synonym to olapsys;
grant create job to OLAP_USER;
grant create job to OLAP_DBA;

alter session set current_schema = olapsys;
@@cwm2awtm.sql

grant select on XML_LOADID_SEQUENCE to OLAP_USER, OLAP_DBA;


alter table olapsys.CwM2$Dimension modify (
    displayname varchar2(90),
    pluralname varchar2(90)
); 

alter table olapsys.CwM2$Level modify (
    displayname varchar2(90),
    pluralname varchar2(90)
); 

alter table olapsys.CwM2$Hierarchy modify (
    displayname varchar2(90)
); 

alter table olapsys.CwM2$DimensionAttribute modify (
    displayname varchar2(90)
); 

alter table olapsys.CwM2$LevelAttribute modify (
    displayname varchar2(90)
); 

alter table olapsys.CwM2$Cube modify (
    displayname varchar2(90)
); 

alter table olapsys.CwM2$Measure modify (
    displayname varchar2(90)
); 

alter table olapsys.CWM2$MRFACTTBLKEYMAPS add (
    data_type varchar2(106),
    data_length number,
    data_precision number
);

@@cwm2sed2.sql

drop public synonym dbms_aw_utilities;
drop package dbms_aw_utilities;
drop public synonym cwm2_olap_installer;
drop package cwm2_olap_installer;
drop view odm_olap2_dim_hier_level_uses;
drop public synonym cwm2_olap_aw_access;
drop package cwm2_olap_aw_access;

grant select on dba_users to olapsys;
grant select on dba_roles to olapsys;
grant select on dba_role_privs to olapsys;

grant select any dictionary to olapsys;

drop view olapsys.odm_olap2_join_key_column_uses;
drop view olapsys.odm_olap2_level_key_col_uses;

@@amdu111.sql
