REM
REM Copyright (c) 2002, 2006, Oracle. All rights reserved.  
REM
REM Name
REM   olapuser.sql
REM
REM Description
REM   OLAP_USER Role grants
REM
REM Notes
REM
REM MODIFIED (MM/DD/YY)
REM   glyon   06/04/07 - Adjust roles for RDBMS 11
REM   awesley 05/02/06 - remove create public synonym privelege
REM   cdaless 12/02/04 - Adjust role creation so clean call from amdrelod.sql 
REM   dbardwe 09/29/04 - Added create job priv to olap_user role.
REM   cdaless 01/23/03 - 
REM   cdaless 01/07/03 - cdalessi_txn105752
REM   dbardwe 12/30/02 - Finalize for 9.2.0.2.1
REM   jawhite 12/30/02 - Initial script
REM
REM

Rem add olap_user role if needed
declare
  cursor apsrole is select role from dba_roles where role = 'OLAP_USER';
  apsrolename varchar2(30);
begin
  if not  apsrole%isopen then 
    open apsrole;
    fetch apsrole into apsrolename;
    if apsrole%notfound then
      execute immediate 'create role olap_user not identified';
    end if;
    close apsrole;
  end if;
end;
/

Rem grant privileges needed in RDBMS 11.  Note that we do not revoke privileges
Rem that may no longer be needed.
grant create table, create cube dimension, create cube, create measure folder, create cube build process, create view, create sequence, create job to olap_user;
