REM
REM Copyright (c) 2002, 2003, Oracle Corporation.  All rights reserved.  
REM
REM  FILE
REM   cwm2awct.pls
REM
REM  DESCRIPTION
REM   Procedure Language Specification file for PL/SQL Package
REM   DBMS_AWM_PRV
REM
REM  NOTES
REM	
REM  MODIFIED  (MM/DD/YY)
REM   mstasiew  04/24/03 - 
REM   mstasiew  01/06/03 - 
REM   mstasiew  01/06/03 - 
REM   awesley   12/17/02 -
REM   awesley   11/07/02 - rework
REM   dbardwel  08/14/02  Created.
REM


create or replace package DBMS_AWM_PRV as


  procedure Maintain_AWDimLoadParmValue(p_Action             IN     varchar2
                                       ,p_AWDimLoadParmValue IN OUT olapsys.CWM2$AWDimLoadParmValue%rowtype
                                       ,p_AWDimLoad_Name     IN OUT varchar2
                                       ,p_Dimension_Owner    IN OUT varchar2
                                       ,p_Dimension_Name     IN OUT varchar2
                                       ,p_Parameter_Name     IN OUT varchar2
                                       );

  procedure Maintain_AWDimLoad(p_Action          IN     varchar2
                              ,p_AWDimLoad       IN OUT olapsys.CWM2$AWDimLoad%rowtype
                              ,p_Dimension_Owner IN OUT varchar2
                              ,p_Dimension_Name  IN OUT varchar2
                              ,p_LoadType_Name   IN OUT varchar2
                              );

  procedure Maintain_AWDimLoadFilter(p_Action          IN     varchar2
                                    ,p_AWDimLoadFilter IN OUT olapsys.CWM2$AWDimLoadFilter%rowtype
                                    ,p_AWDimLoad_Name  IN OUT varchar2
                                    ,p_Dimension_Owner IN OUT varchar2
                                    ,p_Dimension_Name  IN OUT varchar2
                                    );

  procedure Maintain_AWCubeLoadParmValue(p_Action              IN     varchar2
                                        ,p_AWCubeLoadParmValue IN OUT olapsys.CWM2$AWCubeLoadParmValue%rowtype
                                        ,p_AWCubeLoad_Name     IN OUT varchar2
                                        ,p_Cube_Owner          IN OUT varchar2
                                        ,p_Cube_Name           IN OUT varchar2
                                        ,p_Parameter_Name      IN OUT varchar2
                                        );
 
  procedure Maintain_AWCubeLoad(p_Action varchar2
                               ,p_AWCubeLoad           IN OUT olapsys.CWM2$AWCubeLoad%rowtype
                               ,p_Cube_Owner           IN OUT varchar2
                               ,p_Cube_Name            IN OUT varchar2
                               ,p_LoadType_Name        IN OUT varchar2
                               );

  procedure Maintain_AWCubeLoadMeasure(p_Action IN varchar2
                                     ,p_AWCubeLoadMeasure IN OUT OLAPSYS.CWM2$AWCubeLoadMeasure%rowtype
                                     ,p_AWCubeLoad_name IN OUT varchar2
                                     ,p_Cube_Owner IN OUT varchar2
                                     ,p_Cube_Name IN OUT varchar2
                                     ,p_Measure_Name IN OUT varchar2
                                     ,p_TargetName IN varchar2
                                     ,p_TargetDisplayName IN varchar2
                                     ,p_TargetDescription IN varchar2
                                     );

  procedure Maintain_AWCubeLoadFilter(p_Action           IN     varchar2
                                     ,p_AWCubeLoadFilter IN OUT olapsys.CWM2$AWCubeLoadFilter%rowtype
                                     ,p_AWCubeLoad_Name  IN OUT varchar2
                                     ,p_Cube_Owner       IN OUT varchar2
                                     ,p_Cube_Name        IN OUT varchar2
                                     );
 
  procedure Maintain_AWCubeAgg(p_Action     IN     varchar2
                              ,p_AWCubeAgg  IN OUT olapsys.CWM2$AWCubeAgg%rowtype
                              ,p_Cube_Owner IN OUT varchar2
                              ,p_Cube_Name  IN OUT varchar2
                              );

 
  procedure Maintain_AWCubeAggLevel(p_Action          IN     varchar2
                                   ,p_AWCubeAggLevel  IN OUT olapsys.CWM2$AWCubeAggLevel%rowtype
                                   ,p_AWCubeAgg_name  IN OUT varchar2
                                   ,p_Cube_Owner      IN OUT varchar2
                                   ,p_Cube_Name       IN OUT varchar2
                                   ,p_Dimension_Owner IN OUT varchar2
                                   ,p_Dimension_Name  IN OUT varchar2
                                   ,p_Level_Name      IN OUT varchar2
                                   );

  procedure Maintain_AWCubeAggMeasure(p_Action           IN     varchar2
                                     ,p_AWCubeAggMeasure IN OUT olapsys.CWM2$AWCubeAggMeasure%rowtype
                                     ,p_AWCubeAgg_name   IN OUT varchar2
                                     ,p_Cube_Owner       IN OUT varchar2
                                     ,p_Cube_Name        IN OUT varchar2
                                     ,p_Measure_Name     IN OUT varchar2
                                     );


  procedure Maintain_AWComp(p_Action     IN     varchar2
                           ,p_AWComp     IN OUT olapsys.CWM2$AWCompositeSpec%rowtype
                           ,p_Cube_Owner IN OUT varchar2
                           ,p_Cube_Name  IN OUT varchar2
                           );

  procedure Maintain_AWCompMember(p_Action             IN     varchar2
                                 ,p_AWCompMember       IN OUT olapsys.CWM2$AWCompSpecMembership%rowtype
                                 ,p_AWComp_name        IN OUT varchar2
                                 ,p_Cube_Owner         IN OUT varchar2
                                 ,p_Cube_Name          IN OUT varchar2
                                 ,p_Dimension_Owner    IN OUT varchar2
                                 ,p_Dimension_Name     IN OUT varchar2
                                 ,p_Composite_Name     IN OUT varchar2
                                );


  procedure Maintain_AWCubeLoadAggPlan(p_Action            IN     varchar2
                                      ,p_AWCubeLoadAggPlan IN OUT olapsys.CWM2$AWCubeLoadAggPlan%rowtype
                                      ,p_AWCubeLoad_Name   IN OUT varchar2
                                      ,p_Cube_Owner        IN OUT varchar2
                                      ,p_Cube_Name         IN OUT varchar2
                                      ,p_AWCubeAgg_Name    IN OUT varchar2
                                      );

  procedure Maintain_AWCubeLoadCompPlan(p_Action             IN     varchar2
                                       ,p_AWCubeCompPlan     IN OUT olapsys.CWM2$AWCubeCompPlan%rowtype
                                       ,p_AWCubeLoad_Name    IN OUT varchar2
                                       ,p_Cube_Owner         IN OUT varchar2
                                       ,p_Cube_Name          IN OUT varchar2
                                       ,p_AWComp_Name        IN OUT varchar2
                                       );

 
end DBMS_AWM_PRV;

/
show errors;
