REM
REM Copyright (c) 2002, 2005, Oracle. All rights reserved.  
REM
REM  FILE
REM   cwm2awct.pls
REM
REM  DESCRIPTION
REM   Procedure Language Specification file for PL/SQL Package
REM   DBMS_AWM.
REM
REM  NOTES
REM
REM  MODIFIED  (MM/DD/YY)
REM   dbardwel  03/10/05 - Add caller argument to the AW upgrade to 10.2 procedure
REM   dbardwel  02/28/05 - Add new pl/sql specification for 10.1.0.4 -> 10.2 upgrade
REM   dbardwel  05/11/04 - Add new pl/sql spec for 10.1.0.3 metadata shadow copy
REM   dbardwel  03/22/04 - Default to using Auto Adts for 10.1.0.3 and beyond
REM   dbardwel  11/13/03 - 
REM   dbardwel  11/05/03 - 
REM   dbardwel  10/28/03 - Change a new procedure name 
REM   dbardwel  10/21/03 - Add AutoAdtMode parameter for enablers
REM   dbardwel  10/10/03 - Add default spreadsheet parameter for enablers
REM   dbardwel  08/19/03 - 
REM   mstasiew  07/01/03 - 
REM   mstasiew  06/30/03 - 
REM   dbardwel  05/22/03 - 
REM   mstasiew  04/24/03 - 
REM   mstasiew  04/07/03 - 
REM   dbardwel  02/03/03 - 
REM   dbardwel  01/31/03 - Incorporating OLAP Enabler APIs
REM   mstasiew  01/10/03 - 
REM   mstasiew  01/10/03 - 
REM   mstasiew  01/06/03 - 
REM   mstasiew  01/06/03 - 
REM   awesley   12/17/02 - 
REM   awesley   11/07/02 - rework
REM   dbardwel  08/19/02 - dbardwel_txn103971
REM   dbardwe   08/16/02 - txn013971
REM   dbardwel  08/14/02  Created.
REM


create or replace package DBMS_AWM authid current_user as

-- MAINTAIN AWDimLoad Spec  
  procedure Create_AWDimLoad_Spec(p_AWDimLoad_Spec_Name varchar2
                                 ,p_Dimension_Owner varchar2 
                                 ,p_Dimension_Name varchar2
                                 ,p_LoadType_Name varchar2
                                 );

  procedure Delete_AWDimLoad_Spec(p_AWDimLoad_Spec_Name varchar2
                                 ,p_Dimension_Owner varchar2 
                                 ,p_Dimension_Name varchar2
                                 );



  procedure Set_AWDimLoad_Spec_Name(p_AWDimLoad_Spec_Name varchar2
                                   ,p_Dimension_Owner varchar2 
                                   ,p_Dimension_Name varchar2
                                   ,p_Set_AWDimLoad_Spec_Name varchar2 
                                   );

  procedure Set_AWDimLoad_Spec_Dimension(p_AWDimLoad_Spec_Name varchar2
                                        ,p_Dimension_Owner varchar2 
                                        ,p_Dimension_Name varchar2
                                        ,p_Set_Dimension_Owner varchar2 
                                        ,p_Set_Dimension_Name varchar2
                                        );

  procedure Set_AWDimLoad_Spec_LoadType(p_AWDimLoad_Spec_Name varchar2
                                       ,p_Dimension_Owner varchar2 
                                       ,p_Dimension_Name varchar2
                                       ,p_LoadType_Name varchar2
                                       );


  procedure Add_AWDimLoad_Spec_Filter(p_AWDimLoad_Spec_Name varchar2
                                     ,p_Dimension_Owner varchar2 
                                     ,p_Dimension_Name varchar2
                                     ,p_Lookup_Table_Owner varchar2
                                     ,p_Lookup_Table_Name varchar2
                                     ,p_Where_Clause varchar2
                                     );


  procedure Delete_AWDimLoad_Spec_Filter(p_AWDimLoad_Spec_Name varchar2
                                        ,p_Dimension_Owner varchar2 
                                        ,p_Dimension_Name varchar2
                                        ,p_Lookup_Table_Owner varchar2
                                        ,p_Lookup_Table_Name varchar2
                                        );



  procedure Set_AWDimLoad_Spec_Parameter(p_AWDimLoad_Spec_Name varchar2
                                        ,p_Dimension_Owner varchar2 
                                        ,p_Dimension_Name varchar2
                                        ,p_Parameter_Name varchar2 
                                        ,p_Parameter_Value varchar2 default null
                                        );



-- MAINTAIN AWCubeLoad Spec
  procedure Create_AWCubeLoad_Spec(p_AWCubeLoad_Spec_Name varchar2
                                  ,p_Cube_Owner varchar2
                                  ,p_Cube_Name varchar2
                                  ,p_LoadType_Name varchar2
                                  );
                    

  procedure Delete_AWCubeLoad_Spec(p_AWCubeLoad_Spec_Name varchar2
                                  ,p_Cube_Owner varchar2
                                  ,p_Cube_Name varchar2
                                  );




  procedure Set_AWCubeLoad_Spec_Name(p_AWCubeLoad_Spec_Name varchar2
                                    ,p_Cube_Owner varchar2
                                    ,p_Cube_Name varchar2
                                    ,p_Set_AWCubeLoad_Spec_Name varchar2
                                    );
                    

  procedure Set_AWCubeLoad_Spec_Cube(p_AWCubeLoad_Spec_Name varchar2
                                    ,p_Cube_Owner varchar2
                                    ,p_Cube_Name varchar2
                                    ,p_Set_Cube_Owner varchar2
                                    ,p_Set_Cube_Name varchar2
                                    );
                    

  procedure Set_AWCubeLoad_Spec_LoadType(p_AWCubeLoad_Spec_Name varchar2
                                        ,p_Cube_Owner varchar2
                                        ,p_Cube_Name varchar2
                                        ,p_LoadType_Name varchar2
                                        );
                    

  procedure Add_AWCubeLoad_Spec_Filter(p_AWCubeLoad_Spec_Name varchar2
                                      ,p_Cube_Owner varchar2
                                      ,p_Cube_Name varchar2
                                      ,p_Fact_Table_Owner varchar2
                                      ,p_Fact_Table_Name varchar2
                                      ,p_Where_Clause varchar2
                                      );
                    

  procedure Delete_AWCubeLoad_Spec_Filter(p_AWCubeLoad_Spec_Name varchar2
                                         ,p_Cube_Owner varchar2
                                         ,p_Cube_Name varchar2
                                         ,p_Fact_Table_Owner varchar2
                                         ,p_Fact_Table_Name varchar2
                                         );

  procedure Add_AWCubeLoad_Spec_Measure(p_AWCubeLoad_Spec_Name varchar2
                                      ,p_Cube_Owner varchar2
                                      ,p_Cube_Name varchar2
                                      ,p_Measure_Name varchar2
                                      ,p_TargetName varchar2 default null
                                     ,p_TargetDisplayName varchar2 default null
                                     ,p_TargetDescription varchar2 default null
                                      );
                    
  procedure Delete_AWCubeLoad_Spec_Measure(p_AWCubeLoad_Spec_Name varchar2
                                         ,p_Cube_Owner varchar2
                                         ,p_Cube_Name varchar2
                                         ,p_Measure_Name varchar2
                                         );

  procedure Set_AWCubeLoad_Spec_Parameter(p_AWCubeLoad_Spec_Name varchar2
                                         ,p_Cube_Owner varchar2
                                         ,p_Cube_Name varchar2
                                         ,p_Parameter_Name varchar2 
                                         ,p_Parameter_Value varchar2 default null
                                         );

-- AW AggPlans
  procedure Create_AWCubeAgg_Spec(p_AWCubeAgg_Spec_Name varchar2
                                 ,p_Cube_Owner varchar2
                                 ,p_AW_Name varchar2
                                 ,p_Cube_Name varchar2
                                 );

  procedure Add_AWCubeAgg_Spec_Level(p_AWCubeAgg_Spec_Name varchar2
                                    ,p_Cube_Owner varchar2
                                    ,p_AW_Name varchar2
                                    ,p_Cube_Name varchar2
                                    ,p_Dimension_Name varchar2
                                    ,p_Level_Name varchar2
                                    );

  procedure Set_AWCubeAgg_Spec_Aggop(p_AWCubeAgg_Spec_Name varchar2
                                    ,p_Cube_Owner varchar2
                                    ,p_AW_Name varchar2
                                    ,p_Cube_Name varchar2
                                    ,p_Measure_Name varchar2
                                    ,p_Dimension_Name varchar2
                                    ,p_Operator varchar2
                                    );

  procedure Add_AWCubeAgg_Spec_Measure(p_AWCubeAgg_Spec_Name varchar2
                                      ,p_Cube_Owner varchar2
                                      ,p_AW_Name varchar2
                                      ,p_Cube_Name varchar2
                                      ,p_Measure_Name varchar2
                                      );

  procedure Delete_AWCubeAgg_Spec(p_AWCubeAgg_Spec_Name varchar2
                                 ,p_Cube_Owner varchar2
                                 ,p_AW_Name varchar2
                                 ,p_Cube_Name varchar2
                                 );

  procedure Delete_AWCubeAgg_Spec_Level(p_AWCubeAgg_Spec_Name varchar2
                                    ,p_Cube_Owner varchar2
                                    ,p_AW_Name varchar2
                                    ,p_Cube_Name varchar2
                                    ,p_Dimension_Name varchar2
                                    ,p_Level_Name varchar2
                                    );

  procedure Delete_AWCubeAgg_Spec_Measure(p_AWCubeAgg_Spec_Name varchar2
                                      ,p_Cube_Owner varchar2
                                      ,p_AW_Name varchar2
                                      ,p_Cube_Name varchar2
                                      ,p_Measure_Name varchar2
                                      );




-- MAINTAIN MVCubeAgg Spec
  procedure Create_MVCubeAgg_Spec(p_AWCubeAgg_Spec_Name varchar2
                                 ,p_Cube_Owner varchar2
                                 ,p_Cube_Name varchar2
                                 );
                    

  procedure Delete_MVCubeAgg_Spec(p_AWCubeAgg_Spec_Name varchar2
                                 ,p_Cube_Owner varchar2
                                 ,p_Cube_Name varchar2
                                 );



  procedure Set_MVCubeAgg_Spec_Name(p_AWCubeAgg_Spec_Name varchar2
                                   ,p_Cube_Owner varchar2
                                   ,p_Cube_Name varchar2
                                   ,p_Set_AWCubeAgg_spec_Name varchar2
                                   );
                    

  procedure Set_MVCubeAgg_Spec_Cube(p_AWCubeAgg_Spec_Name varchar2
                                   ,p_Cube_Owner varchar2
                                   ,p_Cube_Name varchar2
                                   ,p_Set_Cube_Owner varchar2
                                   ,p_Set_Cube_Name varchar2
                                   );
                    

  procedure Add_MVCubeAgg_Spec_Measure(p_AWCubeAgg_Spec_Name varchar2
                                      ,p_Cube_Owner varchar2
                                      ,p_Cube_Name varchar2
                                      ,p_Measure_Name varchar2
                                      );
                    

  procedure Delete_MVCubeAgg_Spec_Measure(p_AWCubeAgg_Spec_Name varchar2
                                         ,p_Cube_Owner varchar2
                                         ,p_Cube_Name varchar2
                                         ,p_Measure_Name varchar2
                                         );
                    

  procedure Add_MVCubeAgg_Spec_Level(p_AWCubeAgg_Spec_Name varchar2
                                    ,p_Cube_Owner varchar2
                                    ,p_Cube_Name varchar2
                                    ,p_Dimension_Owner varchar2
                                    ,p_Dimension_Name varchar2
                                    ,p_Level_Name varchar2
                                    );
                    

  procedure Delete_MVCubeAgg_Spec_Level(p_AWCubeAgg_Spec_Name varchar2
                                       ,p_Cube_Owner varchar2
                                       ,p_Cube_Name varchar2
                                       ,p_Dimension_Owner varchar2
                                       ,p_Dimension_Name varchar2
                                       ,p_Level_Name varchar2
                                       );
                    


-- MAINTAIN AWComp Spec
  procedure Create_AWComp_Spec(p_AWComp_Spec_Name varchar2
                              ,p_Cube_Owner varchar2
                              ,p_Cube_Name varchar2
                              );

  procedure Delete_AWComp_Spec(p_AWComp_Spec_Name varchar2
                              ,p_Cube_Owner varchar2
                              ,p_Cube_Name varchar2
                              );

  procedure Set_AWComp_Spec_Name(p_AWComp_Spec_Name varchar2
                                ,p_Cube_Owner varchar2
                                ,p_Cube_Name varchar2
                                ,p_Set_AWComp_Spec_Name varchar2
                                );

  procedure Set_AWComp_Spec_Cube(p_AWComp_Spec_Name varchar2
                                ,p_Cube_Owner varchar2
                                ,p_Cube_Name varchar2
                                ,p_Set_Cube_Owner varchar2
                                ,p_Set_Cube_Name varchar2
                                );



-- MAINTAIN AWComp Spec Member
  procedure Add_AWComp_Spec_Member(p_AWComp_Spec_Name varchar2
                                  ,p_Cube_Owner varchar2
                                  ,p_Cube_Name varchar2
                                  ,p_Member_Name varchar2
                                  ,p_Member_Type varchar2 -- 'DIMENSION' or 'COMPOSITE'
                                  ,p_Dimension_Owner varchar2 default null
                                  ,p_Dimension_Name varchar2 default null
                                  );

  procedure Delete_AWComp_Spec_Member(p_AWComp_Spec_Name varchar2
                                     ,p_Cube_Owner varchar2
                                     ,p_Cube_Name varchar2
                                     ,p_Member_Name varchar2
                                     );



  procedure Set_AWComp_Spec_Member_Name(p_AWComp_Spec_Name varchar2
                                       ,p_Cube_Owner varchar2
                                       ,p_Cube_Name varchar2
                                       ,p_Member_Name varchar2
                                       ,p_Set_Member_Name varchar2
                                       );

  procedure Set_AWComp_Spec_Member_Pos(p_AWComp_Spec_Name varchar2
                                      ,p_Cube_Owner varchar2
                                      ,p_Cube_Name varchar2
                                      ,p_Member_Name varchar2
                                      ,p_Member_Posistion number
                                      );

  procedure Set_AWComp_Spec_Member_Seg(p_AWComp_Spec_Name varchar2
                                      ,p_Cube_Owner varchar2
                                      ,p_Cube_Name varchar2
                                      ,p_Member_Name varchar2
                                      ,p_Member_Segwidth number default null
                                       );


  /* AWComp Spec Como Members must be add in order */
  procedure Add_AWComp_Spec_Comp_Member(p_AWComp_Spec_Name varchar2
                                       ,p_Cube_Owner varchar2
                                       ,p_Cube_Name varchar2
                                       ,p_Member_Name varchar2
                                       ,p_Nested_Member_Name varchar2
                                       ,p_Nested_Member_Type varchar2 -- 'DIMENSION' or 'COMPOSITE'
                                       ,p_Dimension_Owner varchar2 default null
                                       ,p_Dimension_Name varchar2 default null
                                       );



  procedure Add_MVCubeLoad_Spec_Agg(p_AWCubeLoad_Spec_Name varchar2
                                   ,p_Cube_Owner varchar2
                                   ,p_Cube_Name varchar2
                                   ,p_AWCubeAgg_Spec_Name varchar2
                                   );

  procedure Delete_MVCubeLoad_Spec_Agg(p_AWCubeLoad_Spec_Name varchar2
                                      ,p_Cube_Owner varchar2
                                      ,p_Cube_Name varchar2
                                      ,p_AWCubeAgg_Spec_Name varchar2
                                      );
                   
  procedure Add_AWCubeLoad_Spec_Comp(p_AWCubeLoad_Spec_Name varchar2
                                    ,p_Cube_Owner varchar2
                                    ,p_Cube_Name varchar2
                                    ,p_AWComp_Spec_Name varchar2
                                    );

  procedure Delete_AWCubeLoad_Spec_Comp(p_AWCubeLoad_Spec_Name varchar2
                                       ,p_Cube_Owner varchar2
                                       ,p_Cube_Name varchar2
                                       ,p_AWComp_Spec_Name varchar2
                                       );


  procedure Create_AWDimension(p_Source_Dimension_Owner varchar2
                              ,p_Source_Dimension_Name varchar2
                              ,p_AW_Owner varchar2
                              ,p_AW_Name varchar2
                              ,p_Target_Dimension_Name varchar2 default null
                              ,p_SkipChecks varchar2 default null
                              );


  procedure Refresh_AWDimension(p_AW_Owner varchar2
                               ,p_AW_Name varchar2
                               ,p_Target_Dimension_Name varchar2
                               ,p_AWDimLoad_Spec_Name varchar2 default null
                               );



  procedure Create_AWCube(p_Source_Cube_Owner varchar2
                         ,p_Source_Cube_Name varchar2
                         ,p_AW_Owner varchar2
                         ,p_AW_Name varchar2
                         ,p_Target_Cube_Name varchar2 default null
                         ,p_SkipChecks varchar2 default null
                         );


  procedure Refresh_AWCube(p_AW_Owner varchar2
                          ,p_AW_Name varchar2
                          ,p_Target_Cube_Name varchar2
                          ,p_AWCubeLoad_Spec_Name varchar2 default null
                          );

  procedure Aggregate_AWCube(p_AW_Owner varchar2
                          ,p_AW_Name varchar2
                          ,p_Target_Cube_Name varchar2
                          ,p_AWCubeAgg_Spec_Name varchar2
                          );


--
-- OLAP Enabler APIs
--  Supports both AWM Integration and standalone script
--  generation.
--

  procedure create_awdimension_access(p_AW_Owner varchar2,
                                      p_AW_Name varchar2,
                                      p_Target_Dimension_Name varchar2,
                                      p_Access_Type varchar2,
                                      p_Script_Directory varchar2,
                                      p_Script_Name varchar2,
                                      p_OpenMode varchar2,
                                      p_Caller varchar2 default null,
                                      p_SpreadsheetMode varchar2 default 'YES',
                                      p_AutoAdtMode varchar2 default 'YES');


  procedure create_awdimension_access(p_runid number,
                                      p_AW_Owner varchar2,
                                      p_AW_Name varchar2,
                                      p_Target_Dimension_Name varchar2,
                                      p_Access_Type varchar2,
                                      p_SpreadsheetMode varchar2 default 'YES',
                                      p_AutoAdtMode varchar2 default 'YES');


  procedure create_awcube_access(p_AW_Owner varchar2,
                                 p_AW_Name varchar2,
                                 p_Target_Cube_Name varchar2,
                                 p_Access_Type varchar2,
                                 p_Script_Directory varchar2,
                                 p_Script_Name varchar2,
                                 p_OpenMode varchar2,
                                 p_Caller varchar2 default null,
                                 p_SpreadsheetMode varchar2 default 'YES',
                                 p_AutoAdtMode varchar2 default 'YES');


  procedure create_awcube_access(p_runid number,
                                 p_AW_Owner varchar2,
                                 p_AW_Name varchar2,
                                 p_Target_Cube_Name varchar2,
                                 p_Access_Type varchar2,
                                 p_SpreadsheetMode varchar2 default 'YES',
                                 p_AutoAdtMode varchar2 default 'YES');



  procedure delete_awdimension_access(p_AW_Owner varchar2,
                                      p_AW_Name varchar2,
                                      p_Target_Dimension_Name varchar2,
                                      p_Access_Type varchar2,
                                      p_Script_Directory varchar2,
                                      p_Script_Name varchar2,
                                      p_OpenMode varchar2);


  procedure delete_awdimension_access(p_runid number,
                                      p_AW_Owner varchar2,
                                      p_AW_Name varchar2,
                                      p_Target_Dim_Name varchar2,
                                      p_Access_Type varchar2,
                                      p_caller varchar2 default null);


  procedure delete_awcube_access(p_AW_Owner varchar2,
                                 p_AW_Name varchar2,
                                 p_Target_Cube_Name varchar2,
                                 p_Access_Type varchar2,
                                 p_Script_Directory varchar2,
                                 p_Script_Name varchar2,
                                 p_OpenMode varchar2);


  procedure delete_awcube_access(p_runid number,
                                 p_AW_Owner varchar2,
                                 p_AW_Name varchar2,
                                 p_Target_Cube_Name varchar2,
                                 p_Access_Type varchar2,
                                 p_caller varchar2 default null);


  procedure set_awdimension_view_name(p_AWOwner varchar2,
                                      p_AWName varchar2,
                                      p_DimName varchar2,
                                      p_HierName varchar2,
                                      p_UserViewName varchar2);

  procedure set_awcube_view_name(p_AWOwner varchar2,
                                 p_AWName varchar2,
                                 p_CubeName varchar2,
                                 p_HierComboNum number,
                                 p_UserViewName varchar2);


  procedure delete_all_aw_access(p_runid number,
                                 p_AWOwner varchar2,
                                 p_AWName varchar2);



  procedure create_awdimension_access_full(p_runid number,
                                           p_AW_Owner varchar2,
                                           p_AW_Name varchar2,
                                           p_Target_Dimension_Name varchar2,
                                           p_Access_Type varchar2,
                                           p_SpreadsheetMode varchar2 default 'YES',
                                           p_AutoAdtMode varchar2 default 'YES');

  procedure create_awcube_access_full(p_runid number,
                                      p_AW_Owner varchar2,
                                      p_AW_Name varchar2,
                                      p_Target_Cube_Name varchar2,
                                      p_Access_Type varchar2,
                                      p_SpreadsheetMode varchar2 default 'YES',
                                      p_AutoAdtMode varchar2 default 'YES');


  procedure delete_awdimension_access_all(p_runid number,
                                          p_AW_Owner varchar2,
                                          p_AW_Name varchar2,
                                          p_Target_Dim_Name varchar2,
                                          p_Access_Type varchar2);

  procedure delete_awcube_access_all(p_runid number,
                                     p_AW_Owner varchar2,
                                     p_AW_Name varchar2,
                                     p_Target_Cube_Name varchar2,
                                     p_Access_Type varchar2);


  procedure refresh_awdimension_view_name(p_AW_Owner varchar2,
                                          p_AW_Name varchar2,
                                          p_DimName varchar2);

  procedure refresh_awcube_view_name(p_AW_Owner varchar2,
                                     p_AW_Name varchar2,
                                     p_CubeName varchar2);
                              
  procedure create_dynamic_aw_access(p_AW_Owner varchar2,
                                     p_AW_Name varchar2);

  procedure upgrade_aw_to_10_2(p_AW_Owner   varchar2,
                               p_AW_Name    varchar2,
                               p_AWM_Caller varchar2 default 'NO');

  procedure create_schedule_job(p_JobName varchar2,
                                p_JobAction varchar2,
                                p_NumberOfArgs number,
                                p_StartTime timestamp,
                                p_Comments varchar2);

end DBMS_AWM;

/

show errors;

