Rem
Rem cwm2clfy.pls
Rem
Rem Copyright (c) 2000, 2003, Oracle Corporation.  All rights reserved.  
Rem
Rem    NAME
Rem      cwm2clfy.pls - Package definition for new classification package 
Rem
Rem    DESCRIPTION
Rem      This package provides a way to more generically set cwm1 or cwm2
Rem      classification information. This package has been added
Rem      to support the requirements of 10g for ODBO-related
Rem      classification metadata.
Rem
Rem    NOTES
Rem      This API is a highly denormalized API for registering additional
Rem      ODBO-related metadata for currently existing and valid cwm1 or cwm2
Rem      metadata. Think of this as an extension mechanism API.
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    dbardwel    09/30/03 - Change default on parameter value so I can
Rem                           better audit what the user passes for error checking
Rem    mstasiew    09/25/03 - mstasiew_txn108712
Rem    dbardwel    09/17/03 - Add rest of the procedure specs 
Rem    dbardwel    09/16/03 - updates to API definition
Rem    dbardwel    09/08/03 - created for 10g ODBO classification support 
Rem

create or replace package cwm2_olap_classify as

  procedure add_entity_descriptor_use(p_DescName varchar2,
                                      p_EntityType varchar2,
                                      p_EntityOwner varchar2,
                                      p_EntityName varchar2,
                                      p_EntityChildName varchar2 default null,
                                      p_EntitySecondaryChildName varchar2 default null,
                                      p_ParameterName varchar2 default null,
                                      p_ParameterValue varchar2 default '<null>');


  procedure add_entity_denseindicator_use(p_Owner varchar2,
                                          p_CubeName varchar2,
                                          p_DimensionOwner varchar2,
                                          p_DimensionName varchar2,
                                          p_DenseIndicator varchar2);


  procedure add_entity_cardinality_use(p_Owner varchar2,
                                       p_DimensionName varchar2,
                                       p_HierarchyName varchar2,
                                       p_LevelName varchar2,
                                       p_EstCardinality number);


  procedure add_entity_defaultmember_use(p_Owner varchar2,
                                         p_DimensionName varchar2,
                                         p_HierarchyName varchar2,
                                         p_DefaultMember varchar2,
                                         p_DefaultMemberLevel varchar2,
                                         p_Position number default null);


  procedure add_entity_factjoin_use(p_Owner varchar2,
                                    p_CubeName varchar2,
                                    p_DimensionOwner varchar2,
                                    p_DimensionName varchar2,
                                    p_HierarchyName varchar2,
                                    p_DimensionTblOwner varchar2,
                                    p_DimensionTblName varchar2,
                                    p_DimensionColName varchar2,
                                    p_Position number default null);


  procedure remove_entity_descriptor_use(p_DescName varchar2,
                                         p_EntityType varchar2,
                                         p_EntityOwner varchar2,
                                         p_EntityName varchar2,
                                         p_EntityChildName varchar2 default null,
                                         p_EntitySecondaryChildName varchar2 default null);



end cwm2_olap_classify;
/

show errors;

