--
-- $Header: cwm2mgr.pls 27-jan-2006.11:15:14 awesley Exp $
--
-- cwm2mgr.pls
--
-- Copyright (c) Oracle Corporation 2001. All Rights Reserved.
--
--   NAME
--     cwm2mgr.pls cwm2_olap_manager
--
--   DESCRIPTION
--     cwm2 api manager.
--
--   RETURNS
--
--   NOTES
--     
--
--   MODIFIED   (MM/DD/YY)
--   awesley     08/30/02 - add Log_Note_Forced and Log_Message_Forced bug 4349465
--   awesley     11/06/01 - awesley_txn100587
--   awesley     11/05/01 - Creation
--

create or replace package cwm2_olap_manager as

  procedure Set_Echo_On;

  procedure Set_Echo_Off;

  procedure Begin_Log(p_Directory varchar2
                     ,p_File varchar2
                     ,p_Append varchar2 default 'NO');  

  procedure End_Log;  

  procedure Log_Note(p_Message varchar2 default null
	            );

  procedure Log_Note_Forced(p_Message varchar2 default null
	                   );

  procedure Log_Message(p_Message_Name varchar2
                       ,p_Insert_Text1 varchar2 default null
                       ,p_Insert_Text2 varchar2 default null
                       ,p_Insert_Text3 varchar2 default null
                       ,p_Insert_Text4 varchar2 default null
                       ,p_Insert_Text5 varchar2 default null
                       );

  procedure Log_Message_Forced(p_Message_Name varchar2
                              ,p_Insert_Text1 varchar2 default null
                              ,p_Insert_Text2 varchar2 default null
                              ,p_Insert_Text3 varchar2 default null
                              ,p_Insert_Text4 varchar2 default null
                              ,p_Insert_Text5 varchar2 default null
                              );

  procedure Log_Raw_Messages;

end cwm2_olap_manager;
/  

show errors;
