--
-- $Header: cwm2mrsc.pls 24-sep-2002.13:52:37 mstasiew Exp $
--
-- cwm2mrsc.pls
--
-- Copyright (c) Oracle Corporation 2002. All Rights Reserved.
--
--   NAME
--     cwm2mrsc.pls - Package definition public interface file for 
--                    populating olap_session_objects table
--
--   DESCRIPTION
--     <short description of component this file declares/defines>
--
--   RETURNS
--
--   NOTES
--     <other useful comments, qualifications, etc.>
--
--   MODIFIED   (MM/DD/YY)
--   mstasiew    09/24/02 - mstasiew_txn104178
--   dbardwel    07/24/02 - Creation
--



-- Top level package to populate metadata reader
-- olap_session_objects table
-- Note: In order to make this all work, this top-level procedure
--       needs to run under the current user permissions.
create or replace package cwm2_olap_mr_security_init authid current_user as

procedure Init_MR_Session_Object_Table;

end cwm2_olap_mr_security_init;
/
show errors;



-- This package will have olapsys credentials to populate the
-- olapsys.olap_session_objects table.
--
create or replace package cwm2_olap_mr_session_pop as

procedure pop_mr_session(full_dim_privs varchar2, full_cube_privs varchar2);

end cwm2_olap_mr_session_pop;
/
show errors;



-- Lower-level package to determine if the current user has special
-- privileges i.e. SELECT ANY TABLE privilege
create or replace package cwm2_olap_mr_check_privs authid current_user as

procedure check_current_user_privs(objectmode varchar2, result in out varchar2);

end cwm2_olap_mr_check_privs;
/
show errors;

